/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.sim;

import com.wm.lang.ns.NSNode;
import com.wm.lang.schema.Validator;
import com.wm.lang.schema.sim.Expression;
import com.wm.lang.schema.sim.Simulator;
import com.wm.lang.xml.Node;
import com.wm.util.Values;

public class ValidateExp
extends Expression {
    static final String HELP_STRING = "Validates a values | node object in the PipeLine using a record | schema in the Namespace\n\nSyntax is \nvalidate object-name NSName [-ignorecontent] [-maxerrors #] [-verbose] [-t]\n\n\tobject-name = name of the object to be validated\n\tNSName = name of the record or schema in the Namespace that\n\t\tcontains validatable information\n\t-ignorecontent = ignores content during validation\n\t-maxerrors # = specify maximum number of acceptable errors\n\t-verbose = turn on verbose mode\n\t\t(default is 1)\n\t-t = measure time taken for validation\n";
    static final String OPTIONAL_IGNORE_CONTENT = "-ignorecontent";
    static final String OPTIONAL_MAXIMUM_ERRORS = "-maxerrors";
    static final String OPTIONAL_MEASURE_TIME = "-t";
    static final String OPTIONAL_VERBOSE = "-verbose";
    static final String IS_VALID = "isValid";
    static final int NODE_SCHEMA = 20;

    public ValidateExp(Simulator simulator) {
        super(simulator);
        this._help = HELP_STRING;
        this._minimumTokens = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpret(String[] context) {
        if (context.length < this._minimumTokens) {
            this.usage();
            return;
        }
        Object object = this._simulator.getPipeLineObject(context[1]);
        if (object == null) {
            this._simulator.write("Error: PipeLine object \"" + context[1] + "\" not found\n");
            return;
        }
        NSNode nsnode = this._simulator.getNamespaceObject(context[2]);
        if (nsnode == null && !(object instanceof Node)) {
            this._simulator.write("Error: Namespace object \"" + context[2] + "\" not found\n");
            return;
        }
        Validator validator = Validator.create(object, nsnode);
        if (validator == null) {
            this._simulator.write("Error: Today, Integration Server does not support this type of validation\n");
            return;
        }
        validator.setNamespace(this._simulator.getNamespace());
        Values result = null;
        boolean measureTime = false;
        long startTime = 0L;
        long endTime = 0L;
        boolean maxErrorsSpecified = false;
        if (context.length > this._minimumTokens) {
            for (int index = 3; index < context.length; ++index) {
                if (context[index].equals(OPTIONAL_IGNORE_CONTENT)) {
                    validator.setIgnoreContent(true);
                } else if (context[index].equals(OPTIONAL_MAXIMUM_ERRORS)) {
                    maxErrorsSpecified = true;
                } else if (context[index].equals(OPTIONAL_MEASURE_TIME)) {
                    measureTime = true;
                } else if (context[index].equals(OPTIONAL_VERBOSE)) {
                    validator.setVerbose(true);
                }
                if (!maxErrorsSpecified || index + 1 >= context.length) continue;
                String number = context[index + 1];
                try {
                    int maxErrors = Integer.parseInt(number);
                    validator.setMaximumErrors(maxErrors);
                    ++index;
                    continue;
                }
                catch (NumberFormatException ne) {
                    continue;
                }
                finally {
                    maxErrorsSpecified = false;
                }
            }
        }
        if (measureTime) {
            startTime = System.currentTimeMillis();
        }
        try {
            result = Values.use(validator.validate());
        }
        catch (Exception ex) {
            this._simulator.writeln("Unable to validate .. 'cos");
            ex.printStackTrace();
            return;
        }
        if (measureTime) {
            endTime = System.currentTimeMillis();
        }
        this._simulator.putPipeLine("result", result);
        this._simulator.getPipeLine().copyFrom(result);
        if (result.getBoolean(IS_VALID)) {
            this._simulator.write("Validation successful\n");
        } else {
            this._simulator.write("Validation unsuccessful\n");
        }
        if (measureTime) {
            this._simulator.write("Time taken = " + (endTime - startTime) + " (ms)\n");
        }
        this._simulator.write("Use \"print values result\" to view complete results\n");
    }
}

