/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.sim;

import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.sim.DNamespace;
import com.wm.lang.schema.sim.Expression;
import com.wm.lang.schema.sim.Expressions;
import com.wm.util.EncUtil;
import com.wm.util.Values;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class Simulator {
    Namespace _namespace = DNamespace.current();
    Values _pipeline = new Values();
    Expressions _expressions = Expression.createExpressions(this);
    StringTokenizer _tokenizer;
    Vector _history = new Vector(100);
    Hashtable _stacks = new Hashtable();
    String _homeDirectory;
    BufferedReader _in = new BufferedReader(new InputStreamReader(System.in));
    BufferedWriter _out = new BufferedWriter(new OutputStreamWriter(System.out));
    boolean _shutdown = false;
    static final String PROMPT = "Simulator\\>";
    static final String BANNER = "\nIntergation Server's Validation Simulator\nwebMethods, USA\n\n";
    static final int HISTORY_SIZE = 100;
    static final char PERCENT = '%';
    static final String OPTIONAL_HOME_DIRECTORY = "-h";
    static final String BOOTSTRAP_DIRECTORY = "-b";
    static final String[] BOOTSTRAP_STATEMENTS = new String[]{"load schema packages\\WmPublic\\ns\\pub\\schema\\w3c\\structures\\node.ndf", "load schema packages\\WmPublic\\ns\\pub\\schema\\w3c\\datatypes\\node.ndf", "load schema packages\\WmPublic\\ns\\pub\\schema\\w3c\\xml\\node.ndf", "load schema packages\\WmPublic\\ns\\pub\\schema\\w3c\\oct_2000\\structures\\node.ndf", "load schema packages\\WmPublic\\ns\\pub\\schema\\w3c\\oct_2000\\datatypes\\node.ndf", "load schema packages\\WmPublic\\ns\\pub\\schema\\w3c\\april_2000\\structures\\node.ndf", "load schema packages\\WmPublic\\ns\\pub\\schema\\w3c\\april_2000\\datatypes\\node.ndf"};

    public void run() {
        this.write(BANNER);
        while (!this._shutdown) {
            String input = this.waitForInput();
            this.interpret(input);
        }
        this.shutdown();
    }

    NSRecord getRecord(String name) {
        NSNode node = this._namespace.getNode(NSName.create(name));
        if (node != null && node.getNodeTypeObj().equals(NSRecord.TYPE)) {
            return (NSRecord)node;
        }
        return null;
    }

    Values getValues(String name) {
        return this._pipeline.getValues(name);
    }

    Object getPipeLineObject(String name) {
        return this._pipeline.get(name);
    }

    NSNode getNamespaceObject(String name) {
        return this._namespace.getNode(NSName.create(name));
    }

    void removeNamespaceObject(String name) {
        try {
            this._namespace.deleteNode(this.getNamespaceObject(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void putPipeLine(String key, Object value) {
        this._pipeline.put(key, value);
    }

    Expression getExpression(String name) {
        return this._expressions.getExpression(name);
    }

    Namespace getNamespace() {
        return this._namespace;
    }

    Values getPipeLine() {
        return this._pipeline;
    }

    void putStack(String key, Stack stack) {
        this._stacks.put(key, stack);
    }

    Stack getStack(String key) {
        return (Stack)this._stacks.get(key);
    }

    void removeStack(String key) {
        this._stacks.remove(key);
    }

    String waitForInput() {
        String input;
        try {
            this.write(PROMPT);
            input = this._in.readLine();
        }
        catch (IOException e) {
            return null;
        }
        return input;
    }

    String[] tokenize(String input) {
        this._tokenizer = new StringTokenizer(input, " ");
        String[] tokens = new String[this._tokenizer.countTokens()];
        for (int index = 0; index < tokens.length && this._tokenizer.hasMoreTokens(); ++index) {
            tokens[index] = this._tokenizer.nextToken();
        }
        return tokens;
    }

    void interpret(String input) {
        this.interpret(this.tokenize(input));
    }

    void interpret(String[] context) {
        if (context != null && context.length > 0) {
            if (!this._expressions.interpret(context)) {
                this.write("Unrecognized command\n");
            } else {
                this.addToHistory(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(String filename, String[] args) {
        BufferedReader in = null;
        try {
            String input;
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(new File(this.getHomeDirectory(), filename)), EncUtil.getFileEncoding());
            in = new BufferedReader(isr);
            while ((input = in.readLine()) != null) {
                input = this.substitute(input, args);
                this.interpret(input);
            }
        }
        catch (IOException e) {
            this.write("Error occurred: while reading from file - " + filename + "\n");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ein) {}
        }
    }

    void write(String output) {
        try {
            this._out.write(output);
            this._out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void writeln(String output) {
        this.write(output + '\n');
    }

    void writeNewLine() {
        try {
            this._out.newLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void writeToFile(String filename, String output) {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.getHomeDirectory(), filename)), EncUtil.getFileEncoding());
            out.write(output);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (IOException e) {
            this.write("Error occurred: while writing to file - " + filename + "\n");
        }
    }

    void setShutdown() {
        this._shutdown = true;
    }

    void shutdown() {
        this.write("Shutting down ... ");
        this.writeNewLine();
    }

    void cleanUp() {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this._in.close();
        this._out.close();
    }

    void addToHistory(String[] command) {
        if (this._history.size() == 100) {
            this._history.removeElementAt(0);
        }
        String str = new String();
        for (int index = 0; index < command.length; ++index) {
            str = str + command[index] + " ";
        }
        str = str.trim() + "\n";
        this._history.addElement(str);
    }

    String getHistory() {
        StringBuffer bf = new StringBuffer();
        for (int index = 0; index < this._history.size(); ++index) {
            bf = bf.append((String)this._history.elementAt(index));
        }
        return bf.toString();
    }

    String getHomeDirectory() {
        return this._homeDirectory;
    }

    void setHomeDirectory(String homeDirectory) {
        this._homeDirectory = homeDirectory;
    }

    String substitute(String str, String[] args) {
        if (args == null) {
            return str;
        }
        if (str == null) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        int size = str.length();
        for (int i = 0; i < size; ++i) {
            char ch = str.charAt(i);
            if (ch == '%' && i + 1 < size) {
                int argID;
                if ((argID = Character.digit(str.charAt(++i), 10)) <= 0 || argID > args.length) continue;
                sb.append(args[argID - 1]);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            String scriptFile = null;
            String homeDirectory = null;
            String bootstrapDirectory = null;
            boolean homeDirectorySpecified = false;
            boolean bootstrapDirectorySpecified = false;
            boolean passedScriptFile = false;
            Vector<String> arguments = null;
            if (args.length > 0) {
                for (int index = 0; index < args.length; ++index) {
                    if (passedScriptFile) {
                        if (arguments == null) {
                            arguments = new Vector<String>();
                        }
                        arguments.addElement(args[index]);
                    } else if (args[index].equals(OPTIONAL_HOME_DIRECTORY)) {
                        homeDirectorySpecified = true;
                    } else if (args[index].equals(BOOTSTRAP_DIRECTORY)) {
                        bootstrapDirectorySpecified = true;
                    } else {
                        scriptFile = args[index];
                        passedScriptFile = true;
                    }
                    if (homeDirectorySpecified && index + 1 < args.length) {
                        homeDirectory = args[index + 1];
                        ++index;
                        homeDirectorySpecified = false;
                    }
                    if (!bootstrapDirectorySpecified || index + 1 >= args.length) continue;
                    bootstrapDirectory = args[index + 1];
                    ++index;
                    bootstrapDirectorySpecified = false;
                }
            }
            if (homeDirectorySpecified || bootstrapDirectorySpecified || bootstrapDirectory == null) {
                System.out.println("Usage: java com.wm.lang.schema.sim.Simulator -b <serverDirectory> [-h <homeDirectory>] [script file]");
                System.out.println("\t serverDirectory = d:\\webMethods\\server, server directory");
                System.out.println("\t homeDirectory = user home directory");
                System.out.println("\t script file = simulator script file name");
                System.exit(0);
            }
            Simulator sim = new Simulator();
            if (bootstrapDirectory != null) {
                sim.setHomeDirectory(bootstrapDirectory);
            } else {
                sim.setHomeDirectory(homeDirectory);
            }
            for (int i = 0; i < BOOTSTRAP_STATEMENTS.length; ++i) {
                sim.interpret(BOOTSTRAP_STATEMENTS[i]);
            }
            sim.setHomeDirectory(homeDirectory);
            if (scriptFile != null) {
                Object[] scriptArgs = null;
                if (arguments != null) {
                    scriptArgs = new String[arguments.size()];
                    arguments.copyInto(scriptArgs);
                }
                sim.run(scriptFile, (String[])scriptArgs);
            } else {
                sim.run();
            }
            System.exit(200);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(500);
        }
    }
}

