/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.sim;

import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.schema.SchemaRegistry;
import com.wm.lang.schema.sim.Expression;
import com.wm.lang.schema.sim.Simulator;
import com.wm.lang.xml.Document;
import com.wm.util.Values;

public class PrintExp
extends Expression {
    static final String HELP_STRING = "Prints a record object | values object | node object | schema object | contents of pipeline | contents of schema registry | history of commands to the console | file\n\nSyntax is\nprint object-type name [filename]\n\nobject-type may be one of:\n\n\trecord\n\tvalues\n\tnode\n\tschema\n\tpipeline\n\tregistry\n\thistory\n\nname has one of the following values:\n\n\tname = NSName (namespace) if object-type=record\n\tname = Key (pipeline) if object-type=values\n\tname = Key (pipeline) if object-type=node\n\tname = NSName (namespace) if object-type=schema\n\tname = Not required if object-type=pipeline\n\tname = Not required if object-type=registry\n\tname = Not required if object-type=history\n\nfilename is optional, if not specified then the output is re-directed to console\n";

    public PrintExp(Simulator simulator) {
        super(simulator);
        this._help = HELP_STRING;
        this._minimumTokens = 2;
    }

    public void interpret(String[] context) {
        if (context.length < this._minimumTokens) {
            this.usage();
            return;
        }
        String modifier = context[1].toLowerCase();
        if (context.length > this._minimumTokens) {
            if (modifier.equals("record")) {
                this.printRecord(context);
            } else if (modifier.equals("values")) {
                this.printValues(context);
            } else if (modifier.equals("node")) {
                this.printNode(context);
            } else if (modifier.equals("schema")) {
                this.printSchema(context);
            } else if (modifier.equals("pipeline")) {
                this.printPipeline(context);
            } else if (modifier.equals("registry")) {
                this.printRegistry(context);
            } else if (modifier.equals("history")) {
                this.printHistory(context);
            } else {
                this.usage();
            }
        } else if (modifier.equals("pipeline")) {
            this.printPipeline(context);
        } else if (modifier.equals("registry")) {
            this.printRegistry(context);
        } else if (modifier.equals("history")) {
            this.printHistory(context);
        } else {
            this.usage();
        }
    }

    void printRecord(String[] context) {
        NSRecord nsr = this._simulator.getRecord(context[2]);
        if (nsr != null) {
            if (context.length > this._minimumTokens + 1) {
                this._simulator.writeToFile(context[3], nsr.toString());
            } else {
                this._simulator.write(nsr.toString() + "\n");
            }
        } else {
            this._simulator.write("Error: record \"" + context[2] + "\" not found\n");
        }
    }

    void printValues(String[] context) {
        Object o;
        Values val = this._simulator.getValues(context[2]);
        if (val == null && (o = this._simulator.getPipeLineObject(context[2])) instanceof Values[]) {
            val = new Values();
            val.put(context[2], o);
        }
        if (val != null) {
            StringBuffer sb = new StringBuffer();
            this.appendReport(sb, 0, val);
            if (context.length > this._minimumTokens + 1) {
                this._simulator.writeToFile(context[3], sb.toString());
            } else {
                this._simulator.write(sb.toString() + "\n");
            }
        } else {
            this._simulator.write("Error: values \"" + context[2] + "\" not found\n");
        }
    }

    void printNode(String[] context) {
        block6: {
            Object o = this._simulator.getPipeLineObject(context[2]);
            if (o == null) {
                this._simulator.write("Error: node \"" + context[2] + "\" not found\n");
                return;
            }
            if (o instanceof Document) {
                StringBuffer sb = new StringBuffer();
                Document doc = (Document)o;
                try {
                    doc.appendGeneratedMarkup(sb);
                    if (context.length > this._minimumTokens + 1) {
                        this._simulator.writeToFile(context[3], sb.toString());
                        break block6;
                    }
                    this._simulator.writeln(sb.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                this._simulator.writeln("Error: \"" + context[2] + "\" is not a node");
            }
        }
    }

    void printSchema(String[] context) {
        NSSchema nss = (NSSchema)this._simulator.getNamespaceObject(context[2]);
        if (nss != null) {
            if (context.length > this._minimumTokens + 1) {
                this._simulator.writeToFile(context[3], nss.toString());
            } else {
                this._simulator.write(nss.toString() + "\n");
            }
        } else {
            this._simulator.write("Error: schema \"" + context[2] + "\" not found\n");
        }
    }

    void printHistory(String[] context) {
        if (context.length > this._minimumTokens) {
            this._simulator.writeToFile(context[2], this._simulator.getHistory());
        } else {
            this._simulator.write(this._simulator.getHistory());
        }
    }

    void printRegistry(String[] context) {
        this.print(context, SchemaRegistry.current().toString());
    }

    void printPipeline(String[] context) {
        StringBuffer sb = new StringBuffer();
        this.appendReport(sb, 0, this._simulator.getPipeLine());
        this.print(context, sb.toString());
    }

    void print(String[] context, String output) {
        if (context.length > this._minimumTokens) {
            this._simulator.writeToFile(context[2], output);
        } else {
            this._simulator.write(output);
        }
    }
}

