/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.sim;

import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.sim.Expression;
import com.wm.lang.schema.sim.Simulator;
import com.wm.lang.xml.Document;
import com.wm.util.Values;
import com.wm.util.coder.XMLCoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class LoadExp
extends Expression {
    static final String HELP_STRING = "Loads a record object into the Namespace | Loads a values object into the PipeLine | Loads a node object into the PipeLine | Loads a schema into the Namespace\n\nSyntax is\nload object-type name filename\n\nobject-type may be one of:\n\n\trecord\n\tvalues\n\tnode\n\tschema\n\nname may be one of:\n\n\tname = Not required if object-type=record\n\tname = Key (pipeline) if object-type=values\n\tname = Key (pipeline) if object-type=node\n\tname = Not requiried if object-type=schema\n\nfilename = a valid file name\n";

    public LoadExp(Simulator simulator) {
        super(simulator);
        this._help = HELP_STRING;
        this._minimumTokens = 3;
    }

    public void interpret(String[] context) {
        if (context.length == 1) {
            this.usage();
            return;
        }
        String modifier = context[1].toLowerCase();
        if (modifier.equals("record")) {
            this.loadRecord(context);
        } else if (modifier.equals("values")) {
            this.loadValues(context);
        } else if (modifier.equals("node")) {
            this.loadNode(context);
        } else if (modifier.equals("schema")) {
            this.loadSchema(context);
        } else {
            this.usage();
        }
    }

    void loadRecord(String[] context) {
        NSRecord nsr;
        String filename = context[2];
        XMLCoder coder = new XMLCoder(true);
        try {
            File file = new File(this._simulator.getHomeDirectory(), filename);
            Values val = coder.readFromFile(file);
            Namespace ns = this._simulator.getNamespace();
            nsr = (NSRecord)NSField.create(ns, val.getValues("record"));
            if (nsr != null) {
                ns.putNode(nsr);
            } else {
                this._simulator.write("Couldn't create an NSRecord\n");
            }
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                this._simulator.write("Load error: file not found: " + filename + "\n");
            } else {
                this._simulator.write("Load error: " + e + "\n");
            }
            return;
        }
        this._simulator.write("Record '" + nsr.getNSName().getFullName() + "' loaded into the Namespace successfully\n");
    }

    void loadValues(String[] context) {
        if (context.length < 4) {
            this._simulator.write("Load error: no filename specified\n");
            return;
        }
        String name = context[2];
        String filename = context[3];
        XMLCoder coder = new XMLCoder(true);
        try {
            File file = new File(this._simulator.getHomeDirectory(), filename);
            Values val = coder.readFromFile(file);
            this._simulator.putPipeLine(name, val);
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                this._simulator.write("Load error: file not found: " + filename + "\n");
            } else {
                this._simulator.write("Load error: " + e + "\n");
            }
            return;
        }
        this._simulator.write("Values loaded into the PipeLine successfully\n");
    }

    void loadNode(String[] context) {
        if (context.length < 4) {
            this._simulator.write("Load error: no filename specified\n");
            return;
        }
        try {
            InputStream is = Document.getHostServices().getInputStream(this.qualify(context[3]));
            Document doc = new Document(is, this.qualify(context[3]), null, true, true);
            this._simulator.putPipeLine(context[2], doc);
            this._simulator.write("Loaded node, " + context[3] + ", into the PipeLine successfully\n");
        }
        catch (Exception ex) {
            if (ex instanceof FileNotFoundException) {
                this._simulator.write("Load error: file not found: " + context[3] + "\n");
            } else {
                this._simulator.write("Load error: " + ex + "\n");
            }
            ex.printStackTrace();
        }
    }

    void loadSchema(String[] context) {
        NSSchema schema;
        if (context.length < this._minimumTokens) {
            this.usage();
            return;
        }
        Values val = this.loadNDF(context);
        if (val != null && (schema = NSSchema.create(this._simulator.getNamespace(), val.getValues("schema"))) != null) {
            try {
                this._simulator.getNamespace().makeNode(schema);
                this._simulator.write(schema.getNSName().toString() + " (Schema) loaded into the Namespace successfully\n");
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this._simulator.writeln("Unable to load schema");
    }

    Values loadNDF(String[] context) {
        String filename = context[2];
        Values val = null;
        XMLCoder coder = new XMLCoder(true);
        try {
            File file = new File(this._simulator.getHomeDirectory(), filename);
            val = coder.readFromFile(file);
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                this._simulator.write("Load error: file not found: " + filename + "\n");
            } else {
                this._simulator.write("Load error: " + e + "\n");
            }
            return null;
        }
        return val;
    }
}

