/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.sim;

import com.wm.lang.schema.sim.Expression;
import com.wm.lang.schema.sim.Simulator;

public class IfExp
extends Expression {
    static final String HELP_STRING = "Performs conditional processiong\n\nSyntax is\nif variable command-t [else command-f]\n\n\t variable = name of a pipeline variable\n\t command-t = a valid simulator command\n\t command-f = a valid simulator command\n\nif variable is true command-t is executed\nif variable is false command-f is executed\n";
    static final String ELSE = "else";

    public IfExp(Simulator simulator) {
        super(simulator);
        this._minimumTokens = 3;
        this._help = HELP_STRING;
    }

    public void interpret(String[] context) {
        Object value;
        int j;
        int i;
        if (context.length < this._minimumTokens) {
            this.usage();
            return;
        }
        String variable = context[1];
        String[] commandT = null;
        String[] commandF = null;
        int startOfCommandT = 2;
        int endOfCommandT = 2;
        int startOfCommandF = -1;
        boolean evaluatesTo = false;
        for (i = 2; i < context.length; ++i) {
            if (!context[i].toLowerCase().equals(ELSE)) continue;
            startOfCommandF = i + 1;
            break;
        }
        endOfCommandT = startOfCommandF > 0 ? startOfCommandF - 2 : context.length - 1;
        commandT = new String[endOfCommandT - startOfCommandT + 1];
        i = startOfCommandT;
        for (j = 0; i <= endOfCommandT && j < commandT.length; ++i, ++j) {
            commandT[j] = context[i];
        }
        if (startOfCommandF > 0) {
            commandF = new String[context.length - startOfCommandF];
            i = startOfCommandF;
            for (j = 0; i < context.length && j < commandF.length; ++i, ++j) {
                commandF[j] = context[i];
            }
        }
        if ((value = this._simulator.getPipeLineObject(variable)) != null && (value instanceof Boolean && ((Boolean)value).booleanValue() || value instanceof String && value.toString().equals("true"))) {
            evaluatesTo = true;
        }
        if (evaluatesTo) {
            this._simulator.interpret(commandT);
        } else if (commandF != null) {
            this._simulator.interpret(commandF);
        }
    }
}

