/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.sim;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.lang.schema.sim.CreateExp;
import com.wm.lang.schema.sim.DeleteExp;
import com.wm.lang.schema.sim.Expressions;
import com.wm.lang.schema.sim.HelpExp;
import com.wm.lang.schema.sim.IfExp;
import com.wm.lang.schema.sim.LoadExp;
import com.wm.lang.schema.sim.PrintExp;
import com.wm.lang.schema.sim.ResetExp;
import com.wm.lang.schema.sim.RunExp;
import com.wm.lang.schema.sim.SetExp;
import com.wm.lang.schema.sim.ShutdownExp;
import com.wm.lang.schema.sim.Simulator;
import com.wm.lang.schema.sim.TypeExp;
import com.wm.lang.schema.sim.ValidateExp;
import java.io.File;

public abstract class Expression {
    Simulator _simulator;
    String _help;
    int _minimumTokens;
    static final String INCORRECT_SYNTAX = "Syntax of this command is incorrect\ncorrect usage is - \n\n";
    static final String HELP = "help";
    static final String LOAD = "load";
    static final String PRINT = "print";
    static final String VALIDATE = "validate";
    static final String SHUTDOWN = "shutdown";
    static final String RUN = "run";
    static final String TYPE = "type";
    static final String DELETE = "delete";
    static final String CREATE = "create";
    static final String SET = "set";
    static final String RESET = "reset";
    static final String IF = "if";
    static final String HELP_ALIAS_1 = "h";
    static final String HELP_ALIAS_2 = "?";
    static final String LOAD_ALIAS_1 = "l";
    static final String PRINT_ALIAS_1 = "p";
    static final String VALIDATE_ALIAS_1 = "v";
    static final String SHUTDOWN_ALIAS_1 = "q";
    static final String SHUTDOWN_ALIAS_2 = "s";
    static final String SHUTDOWN_ALIAS_3 = "quit";
    static final String SHUTDOWN_ALIAS_4 = "exit";
    static final String RUN_ALIAS_1 = "r";
    static final String RUN_ALIAS_2 = "execute";
    static final String TYPE_ALIAS_1 = "t";
    static final String TYPE_ALIAS_2 = "echo";
    static final String DELETE_ALIAS_1 = "d";
    static final String CREATE_ALIAS = "c";
    static final String SET_ALIAS = "s";
    static final String RECORD = "record";
    static final String VALUES = "values";
    static final String NODE = "node";
    static final String SCHEMA = "schema";
    static final String PIPELINE = "pipeline";
    static final String REGISTRY = "registry";
    static final String HISTORY = "history";
    static final String RESULT = "result";
    static final String SCRIPT = "script";

    Expression(Simulator simulator) {
        this._simulator = simulator;
    }

    public abstract void interpret(String[] var1);

    public void help() {
        this._simulator.write(this._help);
    }

    public void usage() {
        this._simulator.write(INCORRECT_SYNTAX);
        this.help();
    }

    public static Expressions createExpressions(Simulator simulator) {
        Expressions expressions = new Expressions();
        String[] help_keys = new String[]{HELP, HELP_ALIAS_1, HELP_ALIAS_2};
        expressions.put(help_keys, new HelpExp(simulator));
        String[] load_keys = new String[]{LOAD, LOAD_ALIAS_1};
        expressions.put(load_keys, new LoadExp(simulator));
        String[] print_keys = new String[]{PRINT, PRINT_ALIAS_1};
        expressions.put(print_keys, new PrintExp(simulator));
        String[] validate_keys = new String[]{VALIDATE, VALIDATE_ALIAS_1};
        expressions.put(validate_keys, new ValidateExp(simulator));
        String[] shutdown_keys = new String[]{SHUTDOWN, SHUTDOWN_ALIAS_1, "s", SHUTDOWN_ALIAS_3, SHUTDOWN_ALIAS_4};
        expressions.put(shutdown_keys, new ShutdownExp(simulator));
        String[] run_keys = new String[]{RUN, RUN_ALIAS_1, RUN_ALIAS_2};
        expressions.put(run_keys, new RunExp(simulator));
        String[] type_keys = new String[]{TYPE, TYPE_ALIAS_1, TYPE_ALIAS_2};
        expressions.put(type_keys, new TypeExp(simulator));
        String[] delete_keys = new String[]{DELETE, DELETE_ALIAS_1};
        expressions.put(delete_keys, new DeleteExp(simulator));
        String[] create_keys = new String[]{CREATE, CREATE_ALIAS};
        expressions.put(create_keys, new CreateExp(simulator));
        String[] set_keys = new String[]{SET, "s"};
        expressions.put(set_keys, new SetExp(simulator));
        String[] reset_keys = new String[]{RESET};
        expressions.put(reset_keys, new ResetExp(simulator));
        String[] if_keys = new String[]{IF};
        expressions.put(if_keys, new IfExp(simulator));
        return expressions;
    }

    void appendReport(StringBuffer sb, int indent, IData data) {
        IDataCursor cursor = data.getCursor();
        while (cursor.next()) {
            String key = cursor.getKey();
            Object value = cursor.getValue();
            if (value == null) {
                this.appendKey(sb, indent, key + " = null\n");
                continue;
            }
            if (value instanceof Object[]) {
                int i;
                if (value instanceof IData[]) {
                    IData[] dataArray = (IData[])value;
                    for (i = 0; i < dataArray.length; ++i) {
                        this.appendKey(sb, indent, key + '[' + i + ']' + '\n');
                        this.appendReport(sb, indent + 2, dataArray[i]);
                    }
                    continue;
                }
                if (value instanceof String[]) {
                    String[] stringArray = (String[])value;
                    this.appendKey(sb, indent, key + " = {");
                    for (i = 0; i < stringArray.length; ++i) {
                        sb.append(stringArray[i]);
                        if (i + 1 >= stringArray.length) continue;
                        sb.append(", ");
                    }
                    sb.append("}\n");
                    continue;
                }
                Object[] objectArray = (Object[])value;
                this.appendKey(sb, indent, key + " = *object[], size=" + objectArray.length + '\n');
                continue;
            }
            if (value instanceof IData) {
                this.appendKey(sb, indent, key + " = \n");
                this.appendReport(sb, indent + 2, (IData)value);
                continue;
            }
            if (value instanceof String) {
                String string = (String)value;
                this.appendKey(sb, indent, key + " = " + string + "\n");
                continue;
            }
            this.appendKey(sb, indent, key + " = " + value.toString() + " (" + value.getClass() + ")\n");
        }
    }

    void appendKey(StringBuffer sb, int indent, String key) {
        char[] charArray = new char[indent];
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = 32;
        }
        sb.append(charArray);
        sb.append(key);
    }

    String qualify(String filename) {
        File f = new File(this._simulator.getHomeDirectory(), filename);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        return filename;
    }
}

