/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.sim;

import com.wm.lang.schema.sim.Expression;
import com.wm.lang.schema.sim.Simulator;
import java.util.Stack;

public class DeleteExp
extends Expression {
    static final String HELP_STRING = "Deletes a record object from the Namespace | values object from the PipeLine | node object from the PipeLine | schema from the Namespace\n\nSyntax is\nDelete object-type name\n\nobject-type may be one of:\n\n\trecord\n\tvalues\n\tnode\n\tschema\n\nname may be one of:\n\n\tname = NSName (namespace) if object-type=record\n\tname = Key (pipeline) if object-type=values\n\tname = Key (pipeline) if object-type=node\n\tname = NSName (namespace) if object-type=schema\n";

    public DeleteExp(Simulator simulator) {
        super(simulator);
        this._help = HELP_STRING;
        this._minimumTokens = 3;
    }

    public void interpret(String[] context) {
        if (context.length < this._minimumTokens) {
            this.usage();
            return;
        }
        String modifier = context[1].toLowerCase();
        if (modifier.equals("record")) {
            this.deleteRecord(context);
        } else if (modifier.equals("values")) {
            this.deleteValues(context);
        } else if (modifier.equals("node")) {
            this.deleteNode(context);
        } else if (modifier.equals("schema")) {
            this.deleteSchema(context);
        } else {
            this.usage();
        }
    }

    void deleteRecord(String[] context) {
        this._simulator.writeln("Not implemented");
    }

    void deleteValues(String[] context) {
        this._simulator.writeln("Not implemented");
    }

    void deleteNode(String[] context) {
        this._simulator.writeln("Not implemented");
    }

    void deleteSchema(String[] context) {
        Stack stack = this._simulator.getStack(context[2]);
        if (stack != null) {
            Object[] names = new String[stack.size()];
            stack.copyInto(names);
            for (int i = 0; i < names.length; ++i) {
                this._simulator.removeNamespaceObject((String)names[i]);
                this._simulator.writeln("Deleted - " + (String)names[i] + " successfully");
            }
            this._simulator.removeStack(context[2]);
        } else {
            this._simulator.removeNamespaceObject(context[2]);
            this._simulator.writeln("Deleted - " + context[2] + " successfully");
        }
    }
}

