/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.sim;

import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.schema.gen.DTDCompiler;
import com.wm.lang.schema.sim.Expression;
import com.wm.lang.schema.sim.Simulator;
import com.wm.lang.schema.sim.XMLFilter;
import com.wm.lang.schema.xsd.XSDCompiler;
import com.wm.lang.schema.xsd.XSDSource;
import com.wm.lang.schema.xsd.XSDSourceBuilder;
import com.wm.lang.xml.DTD;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.Name;
import com.wm.util.Values;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Date;
import java.util.Locale;
import java.util.Stack;

public class CreateExp
extends Expression {
    static final String HELP_STRING = "Creates a schema or record from XSD or DTD\n\nSyntax is \ncreate schema NSName -dtd url [-verbose] [-t]\ncreate record NSName -xsd url [-verbose] [-t]\n\n\tNSName = name of the record or schema to be created\n\t-verbose = spits out verbose description\n\t-t = measure time taken for creation\n";
    static final String DTD = "-dtd";
    static final String XSD = "-xsd";
    static final Name CASE = Name.create("case");
    static final Name EDI_CASE = Name.create("edi-case");
    static final String OPTIONAL_VERBOSE = "-verbose";
    static final String OPTIONAL_MEASURE_TIME = "-t";
    static final String OPTIONAL_SAMPLING_RATE = "-s";
    static final String BANNER = "Script created by the Simulator on ";
    static final char END_OF_LINE = '\n';
    static final char NEW_LINE = '\n';
    static final String SET_OUTCOME = "set outcome";
    static final String CREATE_SCHEMA_PREFIX = "create schema ";
    static final String CREATE_SCHEMA_SUFFIX = " -t";
    static final String LOAD_NODE = "load node $node ";
    static final String VALIDATE_NODE_PREFIX = "validate $node ";
    static final String VALIDATE_NODE_SUFFIX = " -maxerrors -1 -t";
    static final String INTER_DECISION_1 = "if isValid type PASSED rOuNd TrIp PrOcCeSsInG else reset outcome";
    static final String INTER_DECISION_2 = "if isValid type ----------------------------- else print values errors";
    static final String DELETE_SCHEMA = "delete schema ";
    static final String FINAL_DECISION_1 = "if outcome type ____________________ else type ____________________";
    static final String FINAL_DECISION_2 = "if outcome type PASSED PASSED PASSED else type FAILED FAILED FAILED";
    static final String FINAL_DECISION_3 = "if outcome type ____________________ else type ____________________";
    static final String SCRIPT_XSD = " -xsd ..\\script.xsd";
    static final String SCRIPT_XSD_OPT1 = " -xsd ";
    static final String WORKSPACE = "workspace:";
    static final String SCRIPT_SCHEMA = "workspace:script";
    static final FilenameFilter FILTER = new XMLFilter();
    static final String INTER_DECISION_3 = "if isSuccessful type PASSED rOuNd TrIp PrOcCeSsInG else reset outcome";
    static final String INTER_DECISION_4 = "if isSuccessful type ----------------------------- else print values errors";

    public CreateExp(Simulator simulator) {
        super(simulator);
        this._help = HELP_STRING;
        this._minimumTokens = 4;
    }

    public void interpret(String[] context) {
        if (context.length >= this._minimumTokens) {
            String modifier = context[1].toLowerCase();
            if (modifier.equals("record") && context.length >= this._minimumTokens + 1) {
                this.createRecord(context);
            } else if (modifier.equals("schema") && context.length >= this._minimumTokens + 1) {
                this.createSchema(context);
            } else if (modifier.equals("script")) {
                this.createScript(context);
            } else {
                this.usage();
            }
        } else {
            this.usage();
        }
    }

    void createRecord(String[] context) {
        this._simulator.writeln("Create record is not implemented");
    }

    void createSchema(String[] context) {
        String qualifier = context[3].toLowerCase();
        boolean verbose = false;
        boolean measureTime = false;
        long startTime = 0L;
        if (context.length > this._minimumTokens) {
            for (int i = this._minimumTokens; i < context.length; ++i) {
                if (context[i].equals(OPTIONAL_VERBOSE)) {
                    verbose = true;
                    continue;
                }
                if (!context[i].equals(OPTIONAL_MEASURE_TIME)) continue;
                measureTime = true;
            }
        }
        try {
            Values results;
            if (measureTime) {
                startTime = System.currentTimeMillis();
            }
            String url = this.qualify(context[4]);
            if (qualifier.equals(DTD)) {
                InputStream is = Document.getHostServices().getInputStream(url);
                Document document = new Document(is, url, null, true);
                DTD dtd = document.getDTD();
                if (measureTime) {
                    startTime = System.currentTimeMillis();
                }
                results = DTDCompiler.compile(this._simulator.getNamespace(), null, NSName.create(context[2]), null, dtd.getString(false), false, true);
            } else if (qualifier.equals(XSD)) {
                XSDSource[] XSDSourceArray = (XSDSource[])XSDSourceBuilder.build(url);
                results = XSDCompiler.compile(this._simulator.getNamespace(), null, NSName.create(context[2]), XSDSourceArray, false, verbose, true, Locale.getDefault());
            } else {
                this.usage();
                return;
            }
            if (measureTime) {
                long finishTime = System.currentTimeMillis();
                this._simulator.writeln("Creation time is " + (finishTime - startTime) + "ms");
            }
            boolean successful = results.getBoolean("isSuccessful");
            this._simulator.putPipeLine("isSuccessful", new Boolean(true));
            if (successful) {
                this.finish(context, results);
            } else {
                this.report(context, results);
            }
        }
        catch (Exception ex) {
            this._simulator.writeln("FAILED to create schema using - " + context[4]);
            ex.printStackTrace();
        }
    }

    void finish(String[] context, Values results) {
        NSSchema[] schemas = (NSSchema[])results.get("schemaArray");
        if (schemas != null) {
            Stack<String> stack = new Stack<String>();
            for (int i = 0; i < schemas.length; ++i) {
                stack.push(schemas[i].getNSName().toString());
            }
            this._simulator.putStack(context[2], stack);
        }
        this._simulator.writeln("Created schema from " + context[4] + " successfully");
    }

    void report(String[] context, Values results) {
        this._simulator.writeln("Failed to create schema from " + context[4]);
        StringBuffer sb = new StringBuffer();
        this.appendReport(sb, 0, results);
        this._simulator.writeln(sb.toString());
    }

    void createScript(String[] context) {
        String iFile = context[2];
        String oFile = context[3];
        String[] cmds = new String[]{"create schema workspace:script -xsd ..\\script.xsd -t", LOAD_NODE + iFile, "validate $node workspace:script -maxerrors -1 -t", "delete schema workspace:script"};
        for (int i = 0; i < cmds.length - 1; ++i) {
            this._simulator.interpret(cmds[i]);
        }
        Document doc = (Document)this._simulator.getPipeLineObject("$node");
        if (!this._simulator.getNamespace().nodeExists(NSName.create(SCRIPT_SCHEMA)) || !((String)this._simulator.getPipeLineObject("isValid")).equals("true") || doc == null) {
            this._simulator.interpret(cmds[cmds.length - 1]);
            return;
        }
        this._simulator.writeln("Creating script ... ");
        this._simulator.interpret(cmds[cmds.length - 1]);
        try {
            ElementNode node = (ElementNode)doc.getFirstElement();
            StringBuffer sb = new StringBuffer();
            sb.append(BANNER + new Date().toString() + '\n');
            sb.append('\n');
            sb.append('\n');
            sb.append("set outcome\n");
            sb.append('\n');
            sb.append('\n');
            for (Node testcase = node.getFirstChildWm(); testcase != null; testcase = testcase.getNextSiblingWm()) {
                if (testcase.getNodeType() != 1) continue;
                if (testcase.getLocalNameWm() == CASE) {
                    this.processCase(testcase, sb);
                    continue;
                }
                if (testcase.getLocalNameWm() == EDI_CASE) {
                    int samplingRate = 1;
                    if (context.length >= this._minimumTokens + 2 && context[4].equals(OPTIONAL_SAMPLING_RATE)) {
                        try {
                            samplingRate = Integer.parseInt(context[5]);
                        }
                        catch (Exception ex) {
                            this._simulator.writeln("Error processing Sampling Rate");
                        }
                    }
                    this.processEDICase(testcase, sb, samplingRate);
                    continue;
                }
                this.processUnknownCase(testcase, sb);
            }
            sb.append("if outcome type ____________________ else type ____________________\n");
            sb.append("if outcome type PASSED PASSED PASSED else type FAILED FAILED FAILED\n");
            sb.append("if outcome type ____________________ else type ____________________\n");
            this._simulator.writeToFile(oFile, sb.toString());
        }
        catch (Exception ex) {
            this._simulator.writeln("Unable to create a script file");
            ex.printStackTrace();
            return;
        }
    }

    void processCase(Node testcase, StringBuffer sb) throws WMDocumentException {
        String name = null;
        String B2BName = null;
        String type = null;
        String schema = null;
        String instanceDirectory = null;
        int i = 0;
        block6: for (Node item = testcase.getFirstChildWm(); item != null; item = item.getNextSiblingWm()) {
            if (item.getNodeType() != 1) continue;
            switch (i) {
                case 0: {
                    name = item.getText();
                    ++i;
                    continue block6;
                }
                case 1: {
                    type = item.getText();
                    ++i;
                    continue block6;
                }
                case 2: {
                    schema = item.getText();
                    ++i;
                    continue block6;
                }
                case 3: {
                    instanceDirectory = item.getText();
                    ++i;
                }
            }
        }
        File file = new File(this._simulator.getHomeDirectory(), instanceDirectory);
        if (file.isDirectory()) {
            String[] xmlFiles = file.list(FILTER);
            if (xmlFiles != null && xmlFiles.length > 0) {
                B2BName = WORKSPACE + name;
                sb.append(CREATE_SCHEMA_PREFIX + B2BName + ' ' + (type.equals("xsd") ? XSD : DTD) + ' ' + schema + CREATE_SCHEMA_SUFFIX + '\n');
                sb.append('\n');
                for (i = 0; i < xmlFiles.length; ++i) {
                    sb.append(LOAD_NODE + file.getPath() + File.separatorChar + xmlFiles[i] + '\n');
                    sb.append(VALIDATE_NODE_PREFIX + B2BName + VALIDATE_NODE_SUFFIX + '\n');
                    sb.append("if isValid type PASSED rOuNd TrIp PrOcCeSsInG else reset outcome\n");
                    sb.append("if isValid type ----------------------------- else print values errors\n");
                }
                sb.append('\n');
                sb.append(DELETE_SCHEMA + B2BName + '\n');
                sb.append('\n');
                sb.append('\n');
            }
        } else {
            this._simulator.writeln("Unable to use this test case - " + name);
        }
    }

    void processEDICase(Node testcase, StringBuffer sb, int samplingRate) throws WMDocumentException {
        String name = null;
        String B2BName = null;
        String type = null;
        String schema = null;
        int i = 0;
        block5: for (Node item = testcase.getFirstChildWm(); item != null; item = item.getNextSiblingWm()) {
            if (item.getNodeType() != 1) continue;
            switch (i) {
                case 0: {
                    name = item.getText();
                    ++i;
                    continue block5;
                }
                case 1: {
                    type = item.getText();
                    ++i;
                    continue block5;
                }
                case 2: {
                    schema = item.getText();
                    ++i;
                }
            }
        }
        B2BName = WORKSPACE + name;
        File file = new File(this._simulator.getHomeDirectory(), schema);
        if (file.isDirectory()) {
            this.walk(file.getPath(), B2BName, type, sb, new Stack(), samplingRate);
        } else {
            this._simulator.writeln("Unable to use this test case - " + name);
        }
    }

    void walk(String schemaDirectory, String B2BName, String type, StringBuffer sb, Stack stack, int samplingRate) {
        String[] xsdFiles;
        File file = new File(schemaDirectory);
        if (file.isDirectory() && (xsdFiles = file.list()) != null && xsdFiles.length > 0) {
            for (int i = 0; i < xsdFiles.length; ++i) {
                String schema = file.getPath() + File.separatorChar + xsdFiles[i];
                File child = new File(schema);
                if (child.isFile()) {
                    stack.push(schema);
                    if (stack.size() != samplingRate) continue;
                    int sample = samplingRate == 1 ? 0 : (int)(Math.random() * (double)samplingRate);
                    schema = (String)stack.elementAt(sample);
                    sb.append(CREATE_SCHEMA_PREFIX + B2BName + ' ' + (type.equals("xsd") ? XSD : DTD) + ' ' + schema + CREATE_SCHEMA_SUFFIX + '\n');
                    sb.append('\n');
                    sb.append("if isSuccessful type PASSED rOuNd TrIp PrOcCeSsInG else reset outcome\n");
                    sb.append("if isSuccessful type ----------------------------- else print values errors\n");
                    sb.append('\n');
                    sb.append(DELETE_SCHEMA + B2BName + '\n');
                    sb.append('\n');
                    sb.append('\n');
                    stack.removeAllElements();
                    continue;
                }
                this.walk(schema, B2BName, type, sb, stack, samplingRate);
            }
        }
    }

    void processUnknownCase(Node testcase, StringBuffer sb) throws WMDocumentException {
    }
}

