/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.gen;

import com.wm.lang.schema.Any;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.TNSException;
import com.wm.lang.schema.WmAttribute;
import com.wm.lang.schema.WmComplexType;
import com.wm.lang.schema.WmElement;
import com.wm.lang.schema.gen.CompilerWorkspace;
import com.wm.lang.schema.gen.QNameExp;
import com.wm.lang.schema.gen.resources.GenMessageBundle;
import com.wm.lang.xml.ElementDef;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import java.util.Vector;

class ElementDefExp
extends QNameExp {
    ElementDefExp() {
        super(1);
    }

    void translate(Object definition, CompilerWorkspace workspace) {
        super.translate(definition, workspace);
        Schema schema = workspace.retrieveSchema();
        if (schema == null) {
            this.cleanup(workspace);
            return;
        }
        ElementDef def = (ElementDef)definition;
        ComplexType type = null;
        try {
            switch (def.getContentType()) {
                case 2: {
                    break;
                }
                case 1: {
                    Any anyModel = (Any)Model.create(0, -1, 6);
                    anyModel.setProcessContents(1);
                    workspace.model = anyModel;
                    break;
                }
                case 0: {
                    workspace.model = Model.create(0, 1, 7);
                    break;
                }
            }
        }
        catch (WMDocumentException wmde) {
            workspace.addWarningWithNS(def.getLocalName().toString(), "DTDC-003", new LocalizedMessage(GenMessageBundle.class, GenMessageBundle.MESSAGE_INCORRECT_CONTENTSPEC, "", wmde.getLocalizedMessage(workspace.locale)));
            this.cleanup(workspace);
            return;
        }
        type = this.createComplexType(workspace.attributes, workspace.elementRefs, workspace.model);
        WmElement elem = new WmElement(def.getLocalName().toString());
        if (type != null) {
            elem.setType(type);
        }
        try {
            schema.put(elem);
        }
        catch (TNSException tns) {
            workspace.addWarningWithNS(elem.getName(), "DTDC-005", new LocalizedMessage(GenMessageBundle.class, GenMessageBundle.MESSAGE_NAME_COLLISION, "", tns.getDetailedMessage()));
        }
        workspace.elementsToBeDefined.remove(QName.create(workspace.currentNS, def.getLocalName().toString()));
        this.cleanup(workspace);
    }

    private ComplexType createComplexType(Vector attributes, Vector elementRefs, Model model) {
        WmComplexType type = null;
        if (model.getType() != 4 || attributes.size() != 0 || elementRefs.size() != 0) {
            int i;
            type = new WmComplexType();
            type.setModel(model);
            int size = attributes.size();
            for (i = 0; i < size; ++i) {
                type.addAttribute((WmAttribute)attributes.elementAt(i));
            }
            size = elementRefs.size();
            for (i = 0; i < size; ++i) {
                type.addElement((WmElement)elementRefs.elementAt(i));
            }
        }
        return type;
    }

    private void cleanup(CompilerWorkspace workspace) {
        workspace.defaultNS = null;
        workspace.attributes.removeAllElements();
        workspace.elementRefs.removeAllElements();
        workspace.model = null;
    }
}

