/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.gen;

import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.ComplexModel;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.SchemaRegistry;
import com.wm.lang.schema.gen.CompilerWorkspace;
import com.wm.lang.schema.gen.Expression;
import com.wm.lang.schema.gen.resources.GenMessageBundle;
import com.wm.lang.schema.util.Iterator;
import com.wm.lang.xml.AttributeDef;
import com.wm.lang.xml.ContentParticle;
import com.wm.lang.xml.ContentParticleName;
import com.wm.lang.xml.ContentParticleSet;
import com.wm.lang.xml.DTD;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementDef;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.XmlUtil;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Values;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class DTDCompiler {
    static Expression[] _expressions;

    public static final NSSchema[] compileIntoTransientSchemas(Namespace ns, String url) throws WMDocumentException, IOException, Exception {
        Values result = DTDCompiler.compile(ns, null, null, null, DTDCompiler.constructDTDUsingURL(url), true, true);
        boolean successful = result.getBoolean("isSuccessful");
        if (successful) {
            return (NSSchema[])result.get("schemaArray");
        }
        throw new Exception(DTDCompiler.format(result));
    }

    private static final String format(Values values) {
        Values[] warnings;
        String key;
        Enumeration keys;
        boolean result;
        StringBuffer sb = new StringBuffer();
        String message = values.getString("message");
        if (message != null) {
            sb.append(values.getString("message"));
            sb.append('\n');
        }
        if (result = values.containsKey("isValid") ? values.getBoolean("isValid") : values.getBoolean("isSuccessful")) {
            sb.append("SUCCESSFUL ------- \n");
        } else {
            sb.append("FAILED --------- \n");
        }
        Values[] errors = values.getValuesArray("errors");
        if (errors != null) {
            for (int i = 0; i < errors.length; ++i) {
                sb.append("ERROR[" + i + "]\n");
                Values error = errors[i];
                keys = error.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    sb.append("\t" + key + ": " + error.get(key) + '\n');
                }
                sb.append('\n');
            }
        }
        if ((warnings = values.getValuesArray("warnings")) != null) {
            for (int i = 0; i < warnings.length; ++i) {
                sb.append("WARNINGS [" + i + "]\n");
                Values warning = warnings[i];
                keys = warning.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    sb.append("\t" + key + ": " + warning.get(key) + '\n');
                }
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static final Values compile(Namespace ns, NSPackage pkg, NSName name, String targetNS, String dtdString) throws IOException, WMDocumentException {
        return DTDCompiler.compile(ns, pkg, name, targetNS, dtdString, Locale.getDefault());
    }

    public static final Values compile(Namespace ns, NSPackage pkg, NSName name, String targetNS, String dtdString, Locale locale) throws IOException, WMDocumentException {
        return DTDCompiler.compile(ns, pkg, name, targetNS, dtdString, false, false, locale);
    }

    public static final Values compile(Namespace ns, NSPackage pkg, NSName name, String targetNS, String dtdString, boolean isTransient, boolean returnSchemas) throws IOException, WMDocumentException {
        return DTDCompiler.compile(ns, pkg, name, targetNS, dtdString, isTransient, returnSchemas, Locale.getDefault());
    }

    public static final Values compile(Namespace ns, NSPackage pkg, NSName name, String targetNS, String dtdString, boolean isTransient, boolean returnSchemas, Locale locale) throws IOException, WMDocumentException {
        DTD dtd = DTDCompiler.constructDTD(dtdString);
        return DTDCompiler.compile(ns, pkg, name, targetNS, dtd, isTransient, returnSchemas, locale);
    }

    public static final Values compileUsingURL(Namespace ns, NSPackage pkg, NSName name, String targetNS, String url) throws IOException, WMDocumentException {
        return DTDCompiler.compile(ns, pkg, name, targetNS, url, Locale.getDefault());
    }

    public static final Values compileUsingURL(Namespace ns, NSPackage pkg, NSName name, String targetNS, String url, Locale locale) throws IOException, WMDocumentException {
        DTD dtd = DTDCompiler.constructDTDUsingURL(url);
        return DTDCompiler.compile(ns, pkg, name, targetNS, dtd, false, false, locale);
    }

    private static final Values compile(Namespace ns, NSPackage pkg, NSName name, String targetNS, DTD dtd, boolean isTransient, boolean returnSchemas) throws IOException, WMDocumentException {
        return DTDCompiler.compile(ns, pkg, name, targetNS, dtd, isTransient, returnSchemas, Locale.getDefault());
    }

    private static final Values compile(Namespace ns, NSPackage pkg, NSName name, String targetNS, DTD dtd, boolean isTransient, boolean returnSchemas, Locale locale) throws IOException, WMDocumentException {
        CompilerWorkspace workspace = new CompilerWorkspace();
        workspace.ns = ns;
        workspace.pkg = pkg;
        workspace.b2bQName = name;
        workspace.targetNS = targetNS;
        workspace.createTransientSchemas = isTransient;
        workspace.returnSchemas = returnSchemas;
        workspace.locale = locale;
        DTDCompiler.collectNSDecls(dtd, workspace);
        DTDCompiler.generateSchema(dtd, workspace);
        workspace.createSchemaArray();
        workspace.cleanupURISchemaPairs();
        if (!workspace.createTransientSchemas) {
            DTDCompiler.formalize(ns, workspace.uriSchemaPairs.elements());
        }
        return workspace.packageResults();
    }

    static final DTD constructDTDUsingURL(String url) throws IOException, WMDocumentException {
        Document document = XmlUtil.urlToDocument(url);
        return document.getDTD();
    }

    static final DTD constructDTD(String dtdString) throws IOException, WMDocumentException {
        Document document = new Document(dtdString, null, null, true, true);
        return document.getDTD();
    }

    static final void collectNSDecls(DTD dtd, CompilerWorkspace workspace) {
        Enumeration eDefs = dtd.getElementDefs();
        if (eDefs == null) {
            return;
        }
        while (eDefs.hasMoreElements()) {
            Enumeration aDefs;
            ElementDef elementDef = (ElementDef)eDefs.nextElement();
            if (elementDef == null || (aDefs = elementDef.getAttributeDefs()) == null) continue;
            while (aDefs.hasMoreElements()) {
                AttributeDef attributeDef = (AttributeDef)aDefs.nextElement();
                if (attributeDef == null) continue;
                DTDCompiler.getExpression(DTDCompiler.getDefinitionType(attributeDef)).collectNSDecls(attributeDef, workspace);
            }
        }
    }

    static final void generateSchema(DTD dtd, CompilerWorkspace workspace) throws IOException, WMDocumentException {
        Enumeration eDefs = dtd.getElementDefs();
        if (eDefs == null) {
            workspace.addError(null, "DTDC-001", new LocalizedMessage(GenMessageBundle.class, GenMessageBundle.MESSAGE_EMPTY_DTD, ""));
            return;
        }
        while (eDefs.hasMoreElements()) {
            Expression expression;
            Object elementDef = eDefs.nextElement();
            if (elementDef == null) continue;
            Enumeration aDefs = ((ElementDef)elementDef).getAttributeDefs();
            if (aDefs != null) {
                while (aDefs.hasMoreElements()) {
                    AttributeDef attributeDef = (AttributeDef)aDefs.nextElement();
                    if (attributeDef == null) continue;
                    expression = DTDCompiler.getExpression(DTDCompiler.getDefinitionType(attributeDef));
                    expression.translate(attributeDef, workspace);
                }
            }
            ContentParticle contentParticle = ((ElementDef)elementDef).getContentParticle();
            DTDCompiler.processContentParticle(contentParticle, workspace);
            expression = DTDCompiler.getExpression(DTDCompiler.getDefinitionType(elementDef));
            expression.translate(elementDef, workspace);
        }
        DTDCompiler.checkForMissingDefinitions(workspace);
    }

    static final void processContentParticle(ContentParticle particle, CompilerWorkspace workspace) {
        if (particle == null) {
            workspace.model = null;
            return;
        }
        Vector<Model> models = null;
        int particleType = particle.getType();
        if (particleType != 0) {
            models = new Vector<Model>();
            Enumeration children = ((ContentParticleSet)particle).getChildren().elements();
            if (children != null) {
                while (children.hasMoreElements()) {
                    DTDCompiler.processContentParticle((ContentParticle)children.nextElement(), workspace);
                    models.addElement(workspace.model);
                }
            }
        }
        Expression expression = DTDCompiler.getExpression(DTDCompiler.getDefinitionType(particle));
        expression.translate(particle, workspace);
        if (particleType != 0) {
            ComplexModel cModel = (ComplexModel)workspace.model;
            int size = models.size();
            for (int i = 0; i < size; ++i) {
                cModel.addModel((Model)models.elementAt(i));
            }
            models.removeAllElements();
            models = null;
        }
    }

    static final void checkForMissingDefinitions(CompilerWorkspace workspace) {
        if (workspace.elementsToBeDefined.size() == 0) {
            return;
        }
        Iterator iterator = workspace.elementsToBeDefined.iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            String xmlns = qName.getNamespace();
            if (xmlns != null && (xmlns == null || NSSchema.containsInTargetNamespace(workspace.ns, xmlns, qName.getNCName(), 1))) continue;
            workspace.addWarningWithNS(qName, "DTDC-004", new LocalizedMessage(GenMessageBundle.class, GenMessageBundle.MESSAGE_EMPTY_DTD, ""));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final void formalize(Namespace ns, Enumeration schemas) {
        while (schemas.hasMoreElements()) {
            boolean successful;
            NSSchema aSchema = (NSSchema)schemas.nextElement();
            try {
                successful = ns.registerSchema(aSchema);
                if (successful) {
                    // empty if block
                }
            }
            catch (NSException nse) {
                // empty catch block
            }
            if (successful = SchemaRegistry.register(aSchema)) continue;
        }
        return;
    }

    static final Expression[] getExpressions() {
        if (_expressions == null) {
            _expressions = Expression.createExpressions();
        }
        return _expressions;
    }

    static final Expression getExpression(int expressionType) {
        Expression[] expressions = DTDCompiler.getExpressions();
        if (expressionType >= 0 && expressionType < expressions.length) {
            return expressions[expressionType];
        }
        return null;
    }

    static final int getDefinitionType(Object definition) {
        if (definition == null) {
            return 5;
        }
        if (definition instanceof AttributeDef) {
            AttributeDef attrDef = (AttributeDef)definition;
            Name prefix = attrDef.getNSPrefix();
            Name localName = attrDef.getLocalName();
            if (prefix != null && prefix.equals(Expression.KEY_XMLNS) || localName != null && localName.equals(Expression.KEY_XMLNS)) {
                return 3;
            }
            return 2;
        }
        if (definition instanceof ContentParticle) {
            if (definition instanceof ContentParticleName) {
                return 4;
            }
            return 0;
        }
        if (definition instanceof ElementDef) {
            return 1;
        }
        return 5;
    }
}

