/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.gen;

import com.wm.data.IData;
import com.wm.data.IDataFactory;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.TNSException;
import com.wm.lang.schema.util.HashSet;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import com.wm.util.Showable;
import com.wm.util.Values;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

class CompilerWorkspace {
    String targetNS;
    NSName b2bQName;
    Namespace ns;
    NSPackage pkg;
    boolean createTransientSchemas;
    boolean returnSchemas;
    Locale locale;
    Hashtable prefixURIPairs = new Hashtable(11);
    String defaultNS;
    Vector attributes;
    Vector elementRefs;
    HashSet elementsToBeDefined;
    Hashtable uriSchemaPairs;
    Model model;
    boolean hasPrefix;
    String currentPrefix;
    String currentNS;
    private Vector _errors;
    private Vector _warnings;
    static final String NULL_TARGETNS = "$$NULL";
    static final String NODE_PREFIX = "_";
    Schema[] _schemaArray = null;

    CompilerWorkspace() {
        this.prefixURIPairs.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.attributes = new Vector(10);
        this.elementRefs = new Vector(10);
        this.elementsToBeDefined = new HashSet(50);
        this.uriSchemaPairs = new Hashtable(11);
        this._errors = new Vector(10);
        this._warnings = new Vector(10);
    }

    void addError(String identifier, String errorCode, String errorMessage) {
        Values error = new Values(4);
        error.put("identifier", identifier);
        error.put("errorCode", errorCode);
        error.put("errorMessage", errorMessage);
        this._errors.addElement(error);
    }

    void addErrorWithNS(String localName, String errorCode, String errorMessage) {
        String uri;
        String string = uri = this.currentNS != null ? this.currentNS : this.targetNS;
        if (uri != null) {
            this.addError("{" + uri + "} " + localName, errorCode, errorMessage);
        } else {
            this.addError(localName, errorCode, errorMessage);
        }
    }

    void addErrorWithNS(QName qName, String errorCode, String errorMessage) {
        String uri = qName.getNamespace();
        if (uri == null) {
            this.addError(qName.getNCName(), errorCode, errorMessage);
        } else {
            this.addError("{" + uri + "} " + qName.getNCName(), errorCode, errorMessage);
        }
    }

    void addError(String identifier, String errorCode, LocalizedMessage errorMessage) {
        Values error = new Values(4);
        error.put("identifier", identifier);
        error.put("errorCode", errorCode);
        error.put("errorMessage", errorMessage.getLocalizedMessage(this.locale));
        this._errors.addElement(error);
    }

    void addErrorWithNS(String localName, String errorCode, LocalizedMessage errorMessage) {
        String uri;
        String string = uri = this.currentNS != null ? this.currentNS : this.targetNS;
        if (uri != null) {
            this.addError("{" + uri + "} " + localName, errorCode, errorMessage);
        } else {
            this.addError(localName, errorCode, errorMessage);
        }
    }

    void addErrorWithNS(QName qName, String errorCode, LocalizedMessage errorMessage) {
        String uri = qName.getNamespace();
        if (uri == null) {
            this.addError(qName.getNCName(), errorCode, errorMessage);
        } else {
            this.addError("{" + uri + "} " + qName.getNCName(), errorCode, errorMessage);
        }
    }

    Values[] getErrors() {
        int size = this._errors.size();
        if (size > 0) {
            Object[] vArray = new Values[size];
            this._errors.copyInto(vArray);
            return vArray;
        }
        return null;
    }

    void addWarning(String identifier, String warningCode, String warningMessage) {
        Values warning = new Values(4);
        warning.put("identifier", identifier);
        warning.put("warningCode", warningCode);
        warning.put("warningMessage", warningMessage);
        this._warnings.addElement(warning);
    }

    void addWarningWithNS(String localName, String warningCode, String warningMessage) {
        String uri;
        String string = uri = this.currentNS != null ? this.currentNS : this.targetNS;
        if (uri != null) {
            this.addWarning("{" + uri + "} " + localName, warningCode, warningMessage);
        } else {
            this.addWarning(localName, warningCode, warningMessage);
        }
    }

    void addWarningWithNS(QName qName, String warningCode, String warningMessage) {
        String uri = qName.getNamespace();
        if (uri == null) {
            this.addWarning(qName.getNCName(), warningCode, warningMessage);
        } else {
            this.addWarning("{" + uri + "} " + qName.getNCName(), warningCode, warningMessage);
        }
    }

    void addWarning(String identifier, String warningCode, LocalizedMessage warningMessage) {
        Values warning = new Values(4);
        warning.put("identifier", identifier);
        warning.put("warningCode", warningCode);
        warning.put("warningMessage", warningMessage.getLocalizedMessage(this.locale));
        this._warnings.addElement(warning);
    }

    void addWarningWithNS(String localName, String warningCode, LocalizedMessage warningMessage) {
        String uri;
        String string = uri = this.currentNS != null ? this.currentNS : this.targetNS;
        if (uri != null) {
            this.addWarning("{" + uri + "} " + localName, warningCode, warningMessage);
        } else {
            this.addWarning(localName, warningCode, warningMessage);
        }
    }

    void addWarningWithNS(QName qName, String warningCode, LocalizedMessage warningMessage) {
        String uri = qName.getNamespace();
        if (uri == null) {
            this.addWarning(qName.getNCName(), warningCode, warningMessage);
        } else {
            this.addWarning("{" + uri + "} " + qName.getNCName(), warningCode, warningMessage);
        }
    }

    Values[] getWarnings() {
        int size = this._warnings.size();
        if (size > 0) {
            Object[] vArray = new Values[size];
            this._warnings.copyInto(vArray);
            return vArray;
        }
        return null;
    }

    Schema retrieveSchema() {
        String namespace = !this.hasPrefix ? (this.defaultNS != null ? this.defaultNS : (this.targetNS != null ? this.targetNS : NULL_TARGETNS)) : this.currentNS;
        if (namespace == null) {
            return null;
        }
        Schema schema = (Schema)this.uriSchemaPairs.get(namespace);
        if (schema == null) {
            schema = this.createTransientSchemas ? NSSchema.createTransientSchema(this.ns, this.pkg, this.computeName(this.currentPrefix, namespace)) : NSSchema.create(this.ns, this.pkg, this.computeName(this.currentPrefix, namespace));
            try {
                if (!namespace.equals(NULL_TARGETNS)) {
                    schema.setTargetNamespace(namespace);
                }
            }
            catch (TNSException tns) {
                return null;
            }
            this.uriSchemaPairs.put(namespace, schema);
        }
        return schema;
    }

    private NSName computeName(String prefix, String namespace) {
        if (this.b2bQName == null) {
            return null;
        }
        if (namespace.equals(NULL_TARGETNS) || this.targetNS != null && namespace.equals(this.targetNS)) {
            return this.b2bQName;
        }
        if (prefix != null) {
            return NSName.create(this.b2bQName.toString() + NODE_PREFIX + prefix);
        }
        return NSName.create(this.b2bQName.toString());
    }

    Values packageResults() {
        Values result = new Values(4);
        result.put("isSuccessful", new Boolean(this._errors.size() <= 0).toString());
        result.put("warnings", this.getWarnings());
        result.put("errors", this.getErrors());
        if (this.returnSchemas) {
            result.put("schemaArray", this.createSchemaArray());
        }
        return result;
    }

    boolean targetExistsInSchemas(QName qName) {
        Schema schema;
        String namespace = qName.getNamespace();
        if (namespace == null) {
            namespace = this.defaultNS != null ? this.defaultNS : (this.targetNS != null ? this.targetNS : NULL_TARGETNS);
        }
        if ((schema = (Schema)this.uriSchemaPairs.get(namespace)) != null) {
            return schema.containsElement(qName.getNCName());
        }
        return false;
    }

    private Values[] createSchemaView() {
        Enumeration enumvar = this.uriSchemaPairs.elements();
        int size = this.uriSchemaPairs.size();
        if (size < 1) {
            return null;
        }
        Values[] valuesArray = new Values[size];
        int i = 0;
        while (enumvar.hasMoreElements()) {
            Schema schema = (Schema)enumvar.nextElement();
            valuesArray[i] = ((Showable)((Object)schema)).getView();
            ++i;
        }
        return valuesArray;
    }

    public Schema[] createSchemaArray() {
        if (this._schemaArray != null) {
            return this._schemaArray;
        }
        IData uriReferencePrefixPairs = this.createURIReferencePrefixPairs();
        Enumeration enumvar = this.uriSchemaPairs.elements();
        int size = this.uriSchemaPairs.size();
        if (size < 1) {
            return null;
        }
        NSSchema[] schemaArray = new NSSchema[size];
        int i = 0;
        while (enumvar.hasMoreElements()) {
            schemaArray[i] = (NSSchema)enumvar.nextElement();
            schemaArray[i++].setURIReferencePrefixPairs(uriReferencePrefixPairs);
        }
        this._schemaArray = schemaArray;
        return this._schemaArray;
    }

    private IData createURIReferencePrefixPairs() {
        if (this.prefixURIPairs.size() < 1) {
            return null;
        }
        Object[][] table = new Object[this.prefixURIPairs.size()][2];
        Enumeration prefixes = this.prefixURIPairs.keys();
        int i = 0;
        while (prefixes.hasMoreElements()) {
            Object prefix = prefixes.nextElement();
            table[i][0] = this.prefixURIPairs.get(prefix);
            table[i++][1] = prefix;
        }
        return IDataFactory.create(table);
    }

    void cleanupURISchemaPairs() {
        int size = this.uriSchemaPairs.size();
        if (size < 1) {
            return;
        }
        Enumeration enumvar = this.uriSchemaPairs.keys();
        Vector<String> tobeRemoved = new Vector<String>();
        while (enumvar.hasMoreElements()) {
            String targetNS = (String)enumvar.nextElement();
            Schema schema = (Schema)this.uriSchemaPairs.get(targetNS);
            if (!schema.isEmpty()) continue;
            tobeRemoved.addElement(targetNS);
        }
        size = tobeRemoved.size();
        for (int i = 0; i < size; ++i) {
            this.uriSchemaPairs.remove(tobeRemoved.elementAt(i));
        }
    }
}

