/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.gen;

import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.WmAttribute;
import com.wm.lang.schema.datatypev2.Constraint;
import com.wm.lang.schema.datatypev2.Datatype;
import com.wm.lang.schema.datatypev2.DatatypeRef;
import com.wm.lang.schema.gen.CompilerWorkspace;
import com.wm.lang.schema.gen.QNameExp;
import com.wm.lang.xml.AttributeDef;
import com.wm.util.List;

class AttributeDefExp
extends QNameExp {
    AttributeDefExp() {
        super(2);
    }

    void translate(Object definition, CompilerWorkspace workspace) {
        super.translate(definition, workspace);
        AttributeDef def = (AttributeDef)definition;
        WmAttribute attr = null;
        if (workspace.hasPrefix) {
            attr = new WmAttribute(def.getLocalName().toString());
            if (def.isFixed()) {
                attr.setRequired(true);
                attr.setFixedValue(def.getDefaultValue());
            } else {
                attr.setRequired(def.isRequired());
                attr.setDefaultValue(def.getDefaultValue());
            }
            attr.setNamespaceURI(workspace.currentNS);
            attr.setType(this.createSimpleType(def, workspace));
        } else {
            SimpleType st = this.createSimpleType(def, workspace);
            String value = def.getDefaultValue();
            attr = def.isFixed() ? new WmAttribute(def.getLocalName().toString(), true, null, value, (ContentType)st) : new WmAttribute(def.getLocalName().toString(), def.isRequired(), value, null, (ContentType)st);
        }
        workspace.attributes.addElement(attr);
    }

    private SimpleType createSimpleType(AttributeDef definition, CompilerWorkspace workspace) {
        Datatype st = null;
        if (definition.getType().equals(AttributeDef.TYPE_ENUMERATION)) {
            try {
                st = Datatype.create("string");
                List list = definition.getValidValues();
                int size = list.size();
                if (list != null) {
                    Object[] enumvar = new String[size];
                    list.copyInto(enumvar);
                    Constraint con = Constraint.create(4, (String[])enumvar, false);
                    Constraint[] cs = new Constraint[]{con};
                    st.setConstraints(cs, workspace.locale);
                }
            }
            catch (Exception ex) {}
        } else {
            st = new DatatypeRef("http://www.w3.org/2001/XMLSchema", "string");
        }
        return st;
    }
}

