/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2.facet;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.schema.datatypev2.cv.CanonicalValue;
import com.wm.lang.schema.datatypev2.cv.VDecimal;
import com.wm.lang.schema.datatypev2.facet.Facet;
import com.wm.util.Values;

public class FFractionDigits
extends Facet {
    VDecimal _cValue = null;
    boolean _isFixed = false;
    public static final String FACET_FRACTION_DIGITS_CVALUE = "FacetFDCValue";

    public void setFacetValue(String facetRep, int pType) {
        try {
            this._cValue = (VDecimal)CanonicalValue.createCanonicalValue(4, facetRep);
        }
        catch (NSException nSException) {
            // empty catch block
        }
    }

    public boolean validate(String lexicalRep, CanonicalValue cValue) {
        boolean valid = false;
        if (this._cValue == null) {
            return false;
        }
        if (cValue.fractionDigits() <= this._cValue.getIntValue()) {
            valid = true;
        }
        return valid;
    }

    public void setFixed(boolean fix) {
        this._isFixed = fix;
    }

    public boolean isFixed() {
        return this._isFixed;
    }

    public CanonicalValue getValue() {
        return this._cValue;
    }

    public void setValues(Values value) {
        this._isFixed = value.getBoolean("facetFixed");
        Values temp = (Values)value.get(FACET_FRACTION_DIGITS_CVALUE);
        if (temp != null) {
            VDecimal vd = new VDecimal();
            vd.setValues(temp);
            this._cValue = vd;
        }
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{FACET_FRACTION_DIGITS_CVALUE, this._cValue.getValues()}, {"facetFixed", this._isFixed ? "true" : "false"}};
        return new Values(o);
    }

    public void setFromData(IData value) {
        IDataCursor ic = value.getCursor();
        this._isFixed = ic.first("facetFixed") ? IDataUtil.getBoolean(ic) : false;
        IData temp = (IData)IDataUtil.get(ic, FACET_FRACTION_DIGITS_CVALUE);
        if (temp != null) {
            VDecimal vd = new VDecimal();
            vd.setFromData(temp);
            this._cValue = vd;
        }
        ic.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{FACET_FRACTION_DIGITS_CVALUE, this._cValue.getAsData()}, {"facetFixed", this._isFixed ? "true" : "false"}};
        return IDataFactory.create(o);
    }
}

