/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2.cv.gc;

import com.wm.lang.ns.NSException;
import com.wm.lang.schema.datatypev2.PlugableRegex;
import com.wm.lang.schema.datatypev2.cv.gc.CalendarValue;
import com.wm.lang.schema.datatypev2.resources.DatatypeMessageBundle;
import com.wm.util.Values;

public class VgYear
extends CalendarValue {
    static final String[] strPatterns = new String[]{"(-)?[0-9]*\\d{4}(Z)?", "(-)?[0-9]*\\d{4}((\\+|-)((0[0-9])|(1[0-1])):([0-5][0-9]))?", "(-)?[0-9]*\\d{4}((\\+|-)(12:00))?"};
    PlugableRegex _pattern = PlugableRegex.create(0, strPatterns);

    public int getType() {
        return 10;
    }

    Values toFieldValues(String s) throws NSException {
        if (s == null) {
            return null;
        }
        Values fields = new Values();
        int indexZ = s.indexOf(90);
        int indexColon = s.indexOf(58);
        boolean neg = false;
        String temp = null;
        String year = null;
        if (s.startsWith("-")) {
            neg = true;
            temp = s.substring(1);
        } else {
            temp = s;
        }
        if (indexZ != -1) {
            fields.put("dateIsUTC", "true");
            year = temp.substring(0, indexZ);
            if (Integer.parseInt(year) == 0) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.YEAR_ZERO_NOT_ALLOWED, "");
            }
            if (neg) {
                fields.put("dateyear", "-" + year);
            } else {
                fields.put("dateyear", year);
            }
        } else if (indexColon != -1) {
            year = temp.substring(0, indexColon - 3);
            if (Integer.parseInt(year) == 0) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.YEAR_ZERO_NOT_ALLOWED, "");
            }
            if (neg) {
                fields.put("dateyear", "-" + year);
            } else {
                fields.put("dateyear", year);
            }
            fields.put("dateTimeZone", temp.substring(indexColon - 3, indexColon + 3));
        } else {
            if (Integer.parseInt(s) == 0) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.YEAR_ZERO_NOT_ALLOWED, "");
            }
            fields.put("dateyear", s);
        }
        return fields;
    }

    PlugableRegex getPattern() {
        return this._pattern;
    }
}

