/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2.cv.gc;

import com.wm.lang.ns.NSException;
import com.wm.lang.schema.datatypev2.Datatype2Keys;
import com.wm.lang.schema.datatypev2.PlugableRegex;
import com.wm.lang.schema.datatypev2.cv.CanonicalValue;
import com.wm.lang.schema.datatypev2.cv.gc.VDuration;
import com.wm.lang.schema.datatypev2.resources.DatatypeMessageBundle;
import com.wm.util.Values;
import java.util.GregorianCalendar;

public abstract class CalendarValue
extends CanonicalValue
implements Datatype2Keys {
    Values _value = null;
    String _lexRep = null;
    static final int NOT_A_YEAR = -5000;
    static final int INDETERMINATE = 5000;
    static final String[] fieldKeys = new String[]{"dateyear", "dateMonth", "dateDay", "dateHour", "dateMinute", "dateSecond"};
    private static final GregorianCalendar calendar = new GregorianCalendar();
    private static final int[] monthToMaxDays = new int[]{0, 31, -1, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public void setCanonicalValue(String lexRep) throws NSException {
        if (this.checkPattern(lexRep)) {
            try {
                this._value = this.toFieldValues(lexRep);
                boolean valid = this.isValid(this._value);
                if (!valid) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, "");
                }
                this._lexRep = lexRep;
            }
            catch (NSException e) {
                throw new NSException(e.toString());
            }
        } else {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_MATCH_PATTERN_MSG, "");
        }
    }

    public boolean greaterThan(CanonicalValue cValue) {
        if (cValue != null && this._value != null && cValue.toString() != null) {
            try {
                Values value = this.toFieldValues(cValue.toString());
                if (CalendarValue.compareTo(this._value, value) == 1) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean lessThan(CanonicalValue cValue) {
        if (cValue != null && this._value != null && cValue.toString() != null) {
            try {
                Values value = this.toFieldValues(cValue.toString());
                if (CalendarValue.compareTo(this._value, value) == -1) {
                    return true;
                }
            }
            catch (NSException e) {
                return false;
            }
        }
        return false;
    }

    public boolean greaterThanOrEqualTo(CanonicalValue cValue) {
        if (cValue != null && this._value != null && cValue.toString() != null) {
            try {
                Values value = this.toFieldValues(cValue.toString());
                int result = CalendarValue.compareTo(this._value, value);
                if (result == 1 || result == 0) {
                    return true;
                }
            }
            catch (NSException e) {
                return false;
            }
        }
        return false;
    }

    public boolean lessThanOrEqualTo(CanonicalValue cValue) {
        if (cValue != null && this._value != null && cValue.toString() != null) {
            try {
                Values value = this.toFieldValues(cValue.toString());
                int result = CalendarValue.compareTo(this._value, value);
                if (result == -1 || result == 0) {
                    return true;
                }
            }
            catch (NSException e) {
                return false;
            }
        }
        return false;
    }

    public boolean equals(CanonicalValue cValue) {
        if (cValue != null && this._value != null && cValue.toString() != null) {
            try {
                Values value = this.toFieldValues(cValue.toString());
                if (CalendarValue.compareTo(this._value, value) == 0) {
                    return true;
                }
            }
            catch (NSException e) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        return this._lexRep;
    }

    abstract Values toFieldValues(String var1) throws NSException;

    abstract PlugableRegex getPattern();

    public boolean checkPattern(String s) throws NSException {
        PlugableRegex pattern = this.getPattern();
        if (pattern != null) {
            return pattern.match(s);
        }
        return false;
    }

    protected static int compareTo(Values a, Values b) throws NSException {
        Values p = (Values)a.clone();
        Values q = (Values)b.clone();
        try {
            p = CalendarValue.normalize(p);
            q = CalendarValue.normalize(q);
        }
        catch (NSException e) {
            throw new NSException(e.toString());
        }
        boolean pIsUtc = p.getBoolean("dateIsUTC");
        boolean qIsUtc = q.getBoolean("dateIsUTC");
        if (pIsUtc && qIsUtc || !pIsUtc && !qIsUtc) {
            return CalendarValue.fieldCompare(p, q);
        }
        if (pIsUtc && !qIsUtc) {
            Values qClone = q;
            qClone.put("dateTimeZone", "-14:00");
            qClone = CalendarValue.normalize(qClone);
            int j = CalendarValue.fieldCompare(p, qClone);
            if (j == 1) {
                return j;
            }
            qClone.put("dateTimeZone", "14:00");
            qClone = CalendarValue.normalize(qClone);
            j = CalendarValue.fieldCompare(p, qClone);
            if (j == -1) {
                return j;
            }
            return 5000;
        }
        if (!pIsUtc && qIsUtc) {
            Values pClone = p;
            pClone.put("dateTimeZone", "-14:00");
            pClone = CalendarValue.normalize(pClone);
            int j = CalendarValue.fieldCompare(pClone, q);
            if (j == -1) {
                return j;
            }
            pClone.put("dateTimeZone", "14:00");
            pClone = CalendarValue.normalize(pClone);
            j = CalendarValue.fieldCompare(pClone, q);
            if (j == 1) {
                return j;
            }
            return 5000;
        }
        return 5000;
    }

    private static int fieldCompare(Values p, Values q) throws NSException {
        for (int i = 0; i < fieldKeys.length; ++i) {
            if (p.get(fieldKeys[i]) == null && q.get(fieldKeys[i]) == null) continue;
            if (p.get(fieldKeys[i]) == null && q.get(fieldKeys[i]) != null || p.get(fieldKeys[i]) != null && q.get(fieldKeys[i]) == null) {
                return 5000;
            }
            if (i != 5) {
                if (p.getInt(fieldKeys[i]) - q.getInt(fieldKeys[i]) < 0) {
                    return -1;
                }
                if (p.getInt(fieldKeys[i]) - q.getInt(fieldKeys[i]) <= 0) continue;
                return 1;
            }
            try {
                Double d = new Double(p.getString(fieldKeys[i]));
                double dp = d;
                d = new Double(q.getString(fieldKeys[i]));
                double dq = d;
                if (dp - dq > 0.0) {
                    return 1;
                }
                if (!(dp - dq < 0.0)) continue;
                return -1;
            }
            catch (Exception e) {
                throw new NSException(e.toString());
            }
        }
        return 0;
    }

    protected static Values normalize(Values dateFields) throws NSException {
        if (dateFields == null || dateFields.getBoolean("dateIsUTC") || dateFields.get("dateTimeZone") == null) {
            return dateFields;
        }
        String tz = (String)dateFields.get("dateTimeZone");
        boolean neg = false;
        if (tz.startsWith("-")) {
            neg = true;
        }
        int index = tz.indexOf(58);
        Values timeZone = new Values();
        try {
            int min = Integer.parseInt(tz.substring(index + 1, index + 3));
            int h = Integer.parseInt(tz.substring(index - 2, index));
            if (!neg) {
                h *= -1;
            }
            timeZone.put("dateHour", h);
            timeZone.put("dateMinute", min);
        }
        catch (NumberFormatException e) {
            throw new NSException("invalid timeZone value");
        }
        dateFields.remove("dateTimeZone");
        Values normalizedValue = CalendarValue.addDurationToDateTime(dateFields, timeZone);
        normalizedValue.put("dateIsUTC", "true");
        return normalizedValue;
    }

    private static int fQuotient(double a, double b) {
        Double d = new Double(Math.floor(a / b));
        int i = d.intValue();
        return i;
    }

    private static int fQuotient(double a, double low, double high) {
        double l = low;
        double h = high;
        if (l > h) {
            l = high;
            h = low;
        }
        return CalendarValue.fQuotient(a - l, h - l);
    }

    private static double modulo(double a, double b) {
        double m = a - (double)CalendarValue.fQuotient(a, b) * b;
        return m;
    }

    private static double modulo(double a, double low, double high) {
        double l = low;
        double h = high;
        if (l > h) {
            l = high;
            h = low;
        }
        double m = CalendarValue.modulo(a - l, h - l) + l;
        return m;
    }

    private static int maxDayInMonthFor(int yearValue, int monthValue) {
        double M = CalendarValue.modulo(monthValue, 1.0, 13.0);
        int Y = yearValue + CalendarValue.fQuotient(monthValue, 1.0, 13.0);
        if (M == 1.0 || M == 3.0 || M == 5.0 || M == 7.0 || M == 8.0 || M == 10.0 || M == 12.0) {
            return 31;
        }
        if (M == 4.0 || M == 6.0) {
            return 30;
        }
        if (M == 2.0 && CalendarValue.modulo(Y, 400.0) == 0.0 || CalendarValue.modulo(Y, 100.0) != 0.0 && CalendarValue.modulo(Y, 4.0) == 0.0) {
            return 29;
        }
        return 28;
    }

    static Values addDurationToDateTime(Values dateTime, Values duration) {
        boolean hasMonth = false;
        boolean hasYear = false;
        boolean hasZone = false;
        boolean hasSeconds = false;
        boolean hasMinutes = false;
        boolean hasHours = false;
        boolean hasDays = false;
        boolean isUTC = false;
        int sMonth = dateTime.getInt("dateMonth", -1);
        if (sMonth != -1) {
            hasMonth = true;
        } else {
            sMonth = 1;
        }
        int dMonth = duration.getInt("dateMonth", 0);
        double temp = sMonth + dMonth;
        double dValue = CalendarValue.modulo(temp, 1.0, 13.0);
        Double d = new Double(dValue);
        int eMonth = d.intValue();
        int carry = CalendarValue.fQuotient(temp, 1.0, 13.0);
        int sYear = dateTime.getInt("dateyear", -5000);
        int dYear = duration.getInt("dateyear", 0);
        if (sYear != -5000) {
            hasYear = true;
        } else {
            sYear = 0;
        }
        int eYear = sYear + dYear + carry;
        String eZone = dateTime.getString("dateTimeZone");
        double sSecond = 0.0;
        String t = dateTime.getString("dateSecond");
        if (t != null) {
            try {
                Double dd = new Double(t);
                sSecond = dd;
                hasSeconds = true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        t = duration.getString("dateSecond");
        double dSecond = 0.0;
        if (t != null) {
            try {
                Double dd = new Double(t);
                dSecond = dd;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        temp = sSecond + dSecond;
        double eSecond = CalendarValue.modulo(temp, 60.0);
        carry = CalendarValue.fQuotient(temp, 60.0);
        int sMinute = dateTime.getInt("dateMinute", -1);
        if (sMinute != -1) {
            hasMinutes = true;
        } else {
            sMinute = 0;
        }
        int dMinute = duration.getInt("dateMinute", 0);
        temp = sMinute + dMinute + carry;
        int eMinute = new Double(CalendarValue.modulo(temp, 60.0)).intValue();
        carry = CalendarValue.fQuotient(temp, 60.0);
        int sHour = dateTime.getInt("dateHour", -1);
        if (sHour != -1) {
            hasHours = true;
        } else {
            sHour = 0;
        }
        int dHour = duration.getInt("dateHour", 0);
        temp = sHour + dHour + carry;
        int eHour = new Double(CalendarValue.modulo(temp, 24.0)).intValue();
        carry = CalendarValue.fQuotient(temp, 24.0);
        int sDay = dateTime.getInt("dateDay", -1);
        if (sDay != -1) {
            hasDays = true;
        } else {
            sDay = 0;
        }
        int dDay = duration.getInt("dateDay", 0);
        int maxDay = CalendarValue.maxDayInMonthFor(eYear, eMonth);
        int nMaxDay = CalendarValue.maxDayInMonthFor(eYear, eMonth - 1);
        int tempDays = -1;
        tempDays = sDay > maxDay ? maxDay : (sDay < 1 ? 1 : sDay);
        int eDay = tempDays + dDay + carry;
        while (true) {
            if (eDay < 1) {
                eDay += nMaxDay;
                carry = -1;
            } else {
                if (eDay <= maxDay) break;
                eDay -= maxDay;
                carry = 1;
            }
            temp = eMonth + carry;
            eMonth = new Double(CalendarValue.modulo(temp, 1.0, 13.0)).intValue();
            maxDay = CalendarValue.maxDayInMonthFor(eYear += CalendarValue.fQuotient(temp, 1.0, 13.0), eMonth);
            nMaxDay = CalendarValue.maxDayInMonthFor(eYear, eMonth - 1);
        }
        Values finalDateTime = new Values();
        if (hasYear) {
            finalDateTime.put("dateyear", eYear);
        }
        if (hasMonth) {
            finalDateTime.put("dateMonth", eMonth);
        }
        if (hasDays) {
            finalDateTime.put("dateDay", eDay);
        }
        if (hasHours) {
            finalDateTime.put("dateHour", eHour);
        }
        if (hasMinutes) {
            finalDateTime.put("dateMinute", eMinute);
        }
        if (hasSeconds) {
            finalDateTime.put("dateSecond", Double.toString(eSecond));
        }
        if (hasZone) {
            finalDateTime.put("dateTimeZone", eZone);
        }
        return finalDateTime;
    }

    public static void report(Values result, Values result2) {
        System.out.println(result.get("dateyear") + " " + result2.get("dateyear"));
        System.out.println(result.get("dateMonth") + " " + result2.get("dateMonth"));
        System.out.println(result.get("dateDay") + " " + result2.get("dateDay"));
        System.out.println(result.get("dateHour") + " " + result2.get("dateHour"));
        System.out.println(result.get("dateMinute") + " " + result2.get("dateMinute"));
        System.out.println(result.get("dateSecond") + " " + result2.get("dateSecond"));
        System.out.println(result.getBoolean("dateIsUTC") + " " + result2.get("dateIsUTC"));
    }

    private boolean isValid(Values calendarValue) {
        int maxDays;
        int month;
        if (this.getType() == 5) {
            return true;
        }
        String d = calendarValue.getString("dateDay");
        String m = calendarValue.getString("dateMonth");
        if (d == null || m == null) {
            return true;
        }
        int day = Integer.parseInt(d);
        if (day < 0) {
            day *= -1;
        }
        if ((month = Integer.parseInt(m)) < 0) {
            month *= -1;
        }
        if ((maxDays = monthToMaxDays[month]) != -1) {
            return day <= maxDays;
        }
        if (day <= 29) {
            String y = calendarValue.getString("dateyear");
            if (y == null) {
                return true;
            }
            int year = Integer.parseInt(y);
            if (calendar.isLeapYear(year)) {
                return true;
            }
            if (day <= 28) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            VDuration dt = new VDuration();
            dt.setCanonicalValue("P1Y0M2DT30M");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

