/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2.cv;

import com.wm.lang.ns.NSException;
import com.wm.lang.schema.datatypev2.cv.CanonicalValue;
import com.wm.lang.schema.datatypev2.resources.DatatypeMessageBundle;

public class VFloat
extends CanonicalValue {
    float _cValue;

    public void setCanonicalValue(String lexRep) throws NSException {
        try {
            this._cValue = this.strToFloat(lexRep);
        }
        catch (NumberFormatException e) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, "");
        }
    }

    public boolean equals(CanonicalValue cValue) {
        if (cValue != null && cValue.toString() != null) {
            try {
                float fValue = this.strToFloat(cValue.toString());
                if (fValue == this._cValue) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean greaterThan(CanonicalValue cValue) {
        if (cValue != null && cValue.toString() != null) {
            try {
                float fValue = this.strToFloat(cValue.toString());
                if (this._cValue > fValue) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean lessThan(CanonicalValue cValue) {
        if (cValue != null && cValue.toString() != null) {
            try {
                float fValue = this.strToFloat(cValue.toString());
                if (this._cValue < fValue) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean greaterThanOrEqualTo(CanonicalValue cValue) {
        if (cValue != null && cValue.toString() != null) {
            try {
                float fValue = this.strToFloat(cValue.toString());
                if (this._cValue >= fValue) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean lessThanOrEqualTo(CanonicalValue cValue) {
        if (cValue != null && cValue.toString() != null) {
            try {
                float fValue = this.strToFloat(cValue.toString());
                if (this._cValue <= fValue) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        String cValStr = Float.toString(this._cValue);
        if (cValStr.equals("Infinity")) {
            return "INF";
        }
        if (cValStr.equals("-Infinity")) {
            return "-INF";
        }
        return cValStr;
    }

    public float strToFloat(String numStr) throws NumberFormatException {
        if (numStr.equals("INF")) {
            return Float.POSITIVE_INFINITY;
        }
        if (numStr.equals("-INF")) {
            return Float.NEGATIVE_INFINITY;
        }
        if (numStr.equals("NaN")) {
            return Float.NaN;
        }
        return Float.valueOf(numStr).floatValue();
    }

    public int getType() {
        return 2;
    }
}

