/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2.cv;

import com.wm.lang.ns.NSException;
import com.wm.lang.schema.datatypev2.cv.CanonicalValue;
import com.wm.lang.schema.datatypev2.resources.DatatypeMessageBundle;

public class VDouble
extends CanonicalValue {
    double _cValue;

    public void setCanonicalValue(String lexRep) throws NSException {
        try {
            this._cValue = this.strToDouble(lexRep);
        }
        catch (NumberFormatException e) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, "");
        }
    }

    public boolean equals(CanonicalValue cValue) {
        if (cValue != null && cValue.toString() != null) {
            try {
                double fValue = this.strToDouble(cValue.toString());
                if (fValue == this._cValue) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean greaterThan(CanonicalValue cValue) {
        if (cValue != null && cValue.toString() != null) {
            try {
                double fValue = this.strToDouble(cValue.toString());
                if (this._cValue > fValue) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean lessThan(CanonicalValue cValue) {
        if (cValue != null && cValue.toString() != null) {
            try {
                double fValue = this.strToDouble(cValue.toString());
                if (this._cValue < fValue) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean greaterThanOrEqualTo(CanonicalValue cValue) {
        if (cValue != null && cValue.toString() != null) {
            try {
                double fValue = this.strToDouble(cValue.toString());
                if (this._cValue >= fValue) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean lessThanOrEqualTo(CanonicalValue cValue) {
        if (cValue != null && cValue.toString() != null) {
            try {
                double fValue = this.strToDouble(cValue.toString());
                if (this._cValue <= fValue) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        String cValStr = Double.toString(this._cValue);
        if (cValStr.equals("Infinity")) {
            return "INF";
        }
        if (cValStr.equals("-Infinity")) {
            return "-INF";
        }
        return cValStr;
    }

    public double strToDouble(String numStr) throws NumberFormatException {
        if (numStr.equals("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (numStr.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (numStr.equals("NaN")) {
            return Double.NaN;
        }
        return Double.valueOf(numStr);
    }

    public int getType() {
        return 3;
    }
}

