/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2.cv;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.schema.datatypev2.DTUtil;
import com.wm.lang.schema.datatypev2.cv.CanonicalValue;
import com.wm.lang.schema.datatypev2.resources.DatatypeMessageBundle;
import com.wm.util.Values;
import java.math.BigDecimal;

public class VDecimal
extends CanonicalValue {
    BigDecimal _value = null;
    public static final String CANONICAL_DECIMAL_VALUE = "cDecimalValue";

    public void setCanonicalValue(String lexRep) throws NSException {
        try {
            this._value = new BigDecimal(lexRep);
        }
        catch (Exception e) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, "");
        }
    }

    public int totalDigits() {
        return DTUtil.getDigitCount(this._value);
    }

    public int fractionDigits() {
        if (this._value != null) {
            return this._value.scale();
        }
        return -1;
    }

    public boolean greaterThan(CanonicalValue cValue) {
        if (cValue != null && this._value != null && cValue.toString() != null) {
            try {
                BigDecimal deValue = new BigDecimal(cValue.toString());
                if (this._value.compareTo(deValue) > 0) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean lessThan(CanonicalValue cValue) {
        if (cValue != null && this._value != null && cValue.toString() != null) {
            try {
                BigDecimal deValue = new BigDecimal(cValue.toString());
                if (this._value.compareTo(deValue) < 0) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean greaterThanOrEqualTo(CanonicalValue cValue) {
        if (cValue != null && this._value != null && cValue.toString() != null) {
            try {
                BigDecimal deValue = new BigDecimal(cValue.toString());
                if (this._value.compareTo(deValue) >= 0) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean lessThanOrEqualTo(CanonicalValue cValue) {
        if (cValue != null && this._value != null && cValue.toString() != null) {
            try {
                BigDecimal deValue = new BigDecimal(cValue.toString());
                if (this._value.compareTo(deValue) <= 0) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean equals(CanonicalValue cValue) {
        if (cValue != null && this._value != null && cValue.toString() != null) {
            try {
                BigDecimal deValue = new BigDecimal(cValue.toString());
                if (this._value.compareTo(deValue) == 0) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public int getType() {
        return 4;
    }

    public String toString() {
        if (this._value == null) {
            return null;
        }
        return this._value.toString();
    }

    public int getIntValue() {
        if (this._value == null) {
            return -1;
        }
        return this._value.intValue();
    }

    public void setValues(Values value) {
        String temp = value.getString(CANONICAL_DECIMAL_VALUE);
        if (temp != null) {
            try {
                this._value = new BigDecimal(temp);
            }
            catch (NumberFormatException e) {
                this._value = null;
            }
        }
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{CANONICAL_DECIMAL_VALUE, this._value != null ? this._value.toString() : null}};
        return new Values(o);
    }

    public void setFromData(IData value) {
        IDataCursor ic = value.getCursor();
        String temp = (String)IDataUtil.get(ic, CANONICAL_DECIMAL_VALUE);
        ic.destroy();
        if (temp != null) {
            try {
                this._value = new BigDecimal(temp);
            }
            catch (NumberFormatException e) {
                this._value = null;
            }
        }
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{CANONICAL_DECIMAL_VALUE, this._value != null ? this._value.toString() : null}};
        return IDataFactory.create(o);
    }

    public static void main(String[] args) {
        VDecimal vd = new VDecimal();
        try {
            vd.setCanonicalValue(" ");
            vd.setCanonicalValue("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

