/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2.cv;

import com.wm.lang.ns.NSException;
import com.wm.lang.schema.datatypev2.DTUtil;
import com.wm.lang.schema.datatypev2.PlugableRegex;
import com.wm.lang.schema.datatypev2.cv.CanonicalValue;
import com.wm.lang.schema.datatypev2.resources.DatatypeMessageBundle;

public class VBase64Binary
extends CanonicalValue {
    String _value = null;
    static final String[] strPatterns = new String[]{"[0-9a-zA-Z+/\\s]*(\\s)?=?(\\s)?=?(\\s)?"};
    PlugableRegex _pattern = PlugableRegex.create(0, strPatterns);

    public void setCanonicalValue(String lexRep) throws NSException {
        if (lexRep != null) {
            String s = DTUtil.squeeze(lexRep);
            if (this.checkPattern(lexRep) && s.length() % 4 == 0) {
                this._value = lexRep;
            } else {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_MATCH_PATTERN_MSG, "");
            }
        }
    }

    public boolean equals(CanonicalValue cValue) {
        if (cValue == null || this._value == null) {
            return false;
        }
        return this._value.equals(cValue.toString());
    }

    public int size() {
        if (this._value != null) {
            String s = this._value.replace('=', ' ');
            s = DTUtil.squeeze(s);
            return s.length() * 3 / 4;
        }
        return -1;
    }

    public String toString() {
        return this._value;
    }

    public boolean checkPattern(String s) throws NSException {
        if (this._pattern != null) {
            return this._pattern.match(s);
        }
        return false;
    }

    public int getType() {
        return 15;
    }

    public static void main(String[] args) {
        try {
            VBase64Binary vb = new VBase64Binary();
            vb.setCanonicalValue("ab    == ");
            System.out.println(vb.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

