/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.W3CKeys;
import com.wm.lang.schema.datatypev2.Constraint;
import com.wm.lang.schema.datatypev2.Datatype;
import com.wm.lang.schema.datatypev2.Datatype2Keys;
import com.wm.lang.schema.datatypev2.InterDatatype;
import com.wm.lang.schema.datatypev2.cv.CanonicalValue;
import com.wm.lang.schema.datatypev2.facet.FEnumeration;
import com.wm.lang.schema.datatypev2.facet.FPattern;
import com.wm.lang.schema.datatypev2.facet.Facet;
import com.wm.lang.schema.datatypev2.resources.DatatypeMessageBundle;
import com.wm.lang.schema.dummyWorkSpace;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import com.wm.util.Values;
import com.wm.xsd.graph.XSNode;
import com.wm.xsd.graph.XSNonTerminal;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;

public class WmUnion
extends InterDatatype
implements Datatype2Keys,
XSNonTerminal {
    int[] _invalidFacetKeys = new int[]{0, 1, 2, 5, 6, 7, 8, 9, 10, 11};
    NSRecord _nsRecord = null;

    public WmUnion(QName[] targetNames) {
        super(targetNames, 4);
    }

    public WmUnion(Datatype[] targetTypes) {
        super(targetTypes);
        this._internalType = 4;
    }

    public WmUnion() {
        this((QName[])null);
    }

    public int[] getNumValidKeys() {
        return null;
    }

    public int[] getNumInValidKeys() {
        return this._invalidFacetKeys;
    }

    public void setFacets(IData facets) {
    }

    public void setFacets(IData facets, Locale locale) throws NSException {
    }

    public void setConstraints(Constraint[] cArray, Locale locale) throws NSException {
        FEnumeration[] enumvar = null;
        FPattern pattern = null;
        String s = null;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        Datatype datatype = null;
        int len = this.size();
        boolean hasBase = true;
        for (int j = 0; j < cArray.length; ++j) {
            int type = cArray[j].getFacetType();
            if (type == 4 || type == 3) continue;
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.SHOULD_NOT_HAVE_THIS_FACET, "");
        }
        block11: for (int i = 0; i < cArray.length; ++i) {
            int facetType = cArray[i].getFacetType();
            String[] temp = cArray[i].getValue();
            if (temp == null) continue;
            Object facet = null;
            switch (facetType) {
                case 3: {
                    try {
                        pattern = (FPattern)Facet.create("pattern");
                        pattern.setFacetValue(temp, -1);
                    }
                    catch (NSException e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    }
                    continue block11;
                }
                case 4: {
                    try {
                        enumvar = new FEnumeration[temp.length];
                        CanonicalValue cValue = null;
                        for (int j = 0; j < temp.length; ++j) {
                            s = temp[j];
                            for (int k = 0; k < len; ++k) {
                                datatype = (Datatype)this.getDataType(k);
                                boolean bl = hasBase = datatype != null && datatype.getBase() != null;
                                if (!hasBase) break;
                                if (datatype == null) continue;
                                try {
                                    cValue = CanonicalValue.createCanonicalValue(datatype.getPrimitiveType(), s);
                                }
                                catch (NSException e) {
                                    // empty catch block
                                }
                                if (cValue == null) continue;
                                FEnumeration fe = (FEnumeration)Facet.create("enumeration");
                                fe.setFacetValue(s, datatype.getPrimitiveType());
                                enumvar[j] = fe;
                                break;
                            }
                            if (cValue != null || !hasBase) continue;
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM, "", s));
                        }
                        continue block11;
                    }
                    catch (NSException e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    }
                }
            }
        }
        if (errors.size() == 0) {
            this._pattern = pattern;
            this._enum = enumvar;
        } else {
            WmUnion.throwNSException(errors, locale);
        }
    }

    public Constraint[] getConstraints() {
        Vector<Constraint> holder = new Vector<Constraint>();
        Constraint temp = null;
        String[] tArray = null;
        CanonicalValue cValue = null;
        if (this._enum != null) {
            tArray = new String[this._enum.length];
            for (int i = 0; i < this._enum.length; ++i) {
                cValue = this._enum[i].getValue();
                tArray[i] = cValue != null ? cValue.toString() : null;
            }
            temp = Constraint.create(4, tArray, false);
            holder.addElement(temp);
        }
        if (this._pattern != null) {
            tArray = this._pattern.getStringPatterns();
            temp = Constraint.create(3, tArray, false);
            holder.addElement(temp);
        }
        Constraint[] cArray = new Constraint[holder.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (Constraint)holder.elementAt(i);
        }
        return cArray;
    }

    public NSRecord getFacetsMetadata() {
        if (this._nsRecord == null) {
            this._nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            this._nsRecord.addField(nsf);
            nsf = new NSField(null, "pattern", 1, 1);
            this._nsRecord.addField(nsf);
        }
        return this._nsRecord;
    }

    public boolean validate(String s, Object context) {
        dummyWorkSpace dContext;
        boolean valid = true;
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._pattern != null && !this._pattern.validate(s, null)) {
            workspace.addError("DT-012", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_MATCH_PATTERN_MSG, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        Datatype datatype = null;
        int len = this.size();
        boolean isValid = false;
        for (int i = 0; !(i >= len || (datatype = (Datatype)this.getDataType(i)) != null && (isValid = datatype.validate(s, dContext = new dummyWorkSpace()))); ++i) {
        }
        if (!isValid) {
            valid = false;
            workspace.addError("DT-Union002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        CanonicalValue cValue = null;
        CanonicalValue temp = null;
        boolean enumValid = false;
        int type = -1;
        if (this._enum != null) {
            for (int i = 0; i < this._enum.length; ++i) {
                FEnumeration f = this._enum[i];
                if (f != null) {
                    temp = f.getValue();
                    if (temp != null) {
                        type = temp.getType();
                        try {
                            cValue = CanonicalValue.createCanonicalValue(type, s);
                        }
                        catch (NSException e) {
                            // empty catch block
                        }
                    }
                    if (cValue != null) {
                        enumValid = f.validate(s, cValue);
                    }
                }
                if (!enumValid) continue;
                return enumValid;
            }
            valid = false;
            workspace.addError("ERR001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
        }
        return valid;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"internalType", "union"}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        super.setValues(val);
    }

    public IData getAsData() {
        IData val = super.getAsData();
        IDataCursor ic = val.getCursor();
        ic.insertAfter("internalType", "union");
        ic.destroy();
        return val;
    }

    public void setFromData(IData val) {
        super.setFromData(val);
    }

    public String getName() {
        if (this._ncName != null && this._ncName.length() > 0) {
            return this._ncName;
        }
        return this.getSourceName();
    }

    public boolean isProxy() {
        return false;
    }

    public int getPrimitiveType() {
        return -1;
    }

    public String[] getPrimitiveNames() {
        Datatype datatype = null;
        int len = this.size();
        if (len == 0) {
            return null;
        }
        String[] pTypeNames = new String[len];
        for (int i = 0; i < len; ++i) {
            datatype = (Datatype)this.getDataType(i);
            if (datatype == null) continue;
            pTypeNames[i] = datatype.getPrimitiveName();
        }
        return pTypeNames;
    }

    public QName[] getPrimitiveQNames() {
        Datatype datatype = null;
        int len = this.size();
        if (len == 0) {
            return null;
        }
        QName[] qNames = new QName[len];
        for (int i = 0; i < len; ++i) {
            datatype = (Datatype)this.getDataType(i);
            if (datatype == null) continue;
            qNames[i] = datatype.getPrimitiveQName();
        }
        return qNames;
    }

    public Datatype[] getMemberTypes() {
        Datatype datatype = null;
        int len = this.size();
        if (len == 0) {
            return null;
        }
        Datatype[] memberTypes = new Datatype[len];
        for (int i = 0; i < len; ++i) {
            memberTypes[i] = datatype = (Datatype)this.getDataType(i);
        }
        return memberTypes;
    }

    public boolean isUnionType() {
        return true;
    }

    public XSNode[] edges() {
        ArrayList<W3CKeys> c = new ArrayList<W3CKeys>();
        Datatype baseType = this.getBase();
        if (baseType != null && !baseType.isProxy()) {
            c.add(baseType);
        }
        int len = this.size();
        for (int j = 0; j < len; ++j) {
            Datatype memberType = (Datatype)this.getDataType(j);
            if (memberType == null) continue;
            QName memberTypeQName = memberType.getQName();
            c.add(memberType);
        }
        Constraint[] constraints = this.getConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            c.add(constraints[i]);
        }
        XSNode[] edges = new XSNode[c.size()];
        c.toArray(edges);
        return edges;
    }
}

