/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2;

import com.wm.data.IData;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.W3CKeys;
import com.wm.lang.schema.datatypev2.Constraint;
import com.wm.lang.schema.datatypev2.DTUtil;
import com.wm.lang.schema.datatypev2.Datatype;
import com.wm.lang.schema.datatypev2.Datatype2Keys;
import com.wm.lang.schema.datatypev2.InterDatatype;
import com.wm.lang.schema.datatypev2.cv.CanonicalValue;
import com.wm.lang.schema.datatypev2.cv.VDecimal;
import com.wm.lang.schema.datatypev2.cv.VList;
import com.wm.lang.schema.datatypev2.facet.FEnumeration;
import com.wm.lang.schema.datatypev2.facet.FLength;
import com.wm.lang.schema.datatypev2.facet.FMaxLength;
import com.wm.lang.schema.datatypev2.facet.FMinLength;
import com.wm.lang.schema.datatypev2.facet.Facet;
import com.wm.lang.schema.datatypev2.resources.DatatypeMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import com.wm.util.Values;
import com.wm.xsd.graph.XSNode;
import com.wm.xsd.graph.XSNonTerminal;
import com.wm.xsd.util.BuiltInSimpleTypes;
import java.util.ArrayList;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class WmList
extends InterDatatype
implements Datatype2Keys,
XSNonTerminal {
    int[] _invalidFacetKeys = new int[]{5, 6, 7, 8, 9, 10};
    int[] _nFacetKeys = new int[]{0, 1, 2};
    NSRecord _nsRecord = null;

    public WmList(QName targetName) {
        super(targetName, 3);
    }

    public WmList(Datatype targetType) {
        super(targetType);
        this._internalType = 3;
    }

    public WmList() {
        this((QName)null);
    }

    public WmList(String targetNS, String ncName) {
        this(QName.create(targetNS, ncName));
    }

    public int[] getNumValidKeys() {
        return this._nFacetKeys;
    }

    public int[] getNumInValidKeys() {
        return this._invalidFacetKeys;
    }

    public void setFacets(IData facets) {
    }

    public void setFacets(Values facets) {
    }

    public Constraint[] getConstraints() {
        Vector<Constraint> holder = new Vector<Constraint>();
        Constraint temp = null;
        String[] tArray = null;
        CanonicalValue cValue = null;
        if (this._enum != null) {
            tArray = new String[this._enum.length];
            for (int i = 0; i < this._enum.length; ++i) {
                cValue = this._enum[i].getValue();
                tArray[i] = cValue != null ? cValue.toString() : null;
            }
            temp = Constraint.create(4, tArray, false);
            holder.addElement(temp);
        }
        if (this._length != null) {
            tArray = new String[1];
            cValue = this._length.getValue();
            if (cValue != null) {
                tArray[0] = cValue.toString();
                temp = Constraint.create(0, tArray, this._length.isFixed());
                holder.addElement(temp);
            }
        }
        if (this._minLength != null) {
            tArray = new String[1];
            cValue = this._minLength.getValue();
            if (cValue != null) {
                tArray[0] = cValue.toString();
                temp = Constraint.create(1, tArray, this._minLength.isFixed());
                holder.addElement(temp);
            }
        }
        if (this._maxLength != null) {
            tArray = new String[1];
            cValue = this._maxLength.getValue();
            if (cValue != null) {
                tArray[0] = cValue.toString();
                temp = Constraint.create(2, tArray, this._maxLength.isFixed());
                holder.addElement(temp);
            }
        }
        Constraint[] cArray = new Constraint[holder.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (Constraint)holder.elementAt(i);
        }
        return cArray;
    }

    public void setConstraints(Constraint[] cArray, Locale locale) throws NSException {
        FLength length = null;
        FMinLength minLength = null;
        FMaxLength maxLength = null;
        FEnumeration[] enumvar = null;
        boolean foundLength = false;
        boolean foundMaxLength = false;
        boolean foundMinLength = false;
        VDecimal len = null;
        VDecimal minLen = null;
        VDecimal maxLen = null;
        String s = null;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        int pType = this.getPrimitiveType();
        for (int i = 0; i < this._invalidFacetKeys.length; ++i) {
            for (int j = 0; j < cArray.length; ++j) {
                int type = cArray[j].getFacetType();
                if (type != this._invalidFacetKeys[i]) continue;
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.SHOULD_NOT_HAVE_THIS_FACET, "");
            }
        }
        Datatype baseType = this.getBase();
        block17: for (int i = 0; i < cArray.length; ++i) {
            int facetType = cArray[i].getFacetType();
            String[] temp = cArray[i].getValue();
            ElementNode eNode = cArray[i].getElementNode();
            if (temp == null) continue;
            Object facet = null;
            switch (facetType) {
                case 0: {
                    foundLength = true;
                    try {
                        len = new VDecimal();
                        len.setCanonicalValue(temp[0]);
                        if (baseType == null) {
                            length = (FLength)Facet.create("length");
                            length.setFacetValue(temp[0], pType);
                            continue block17;
                        }
                        if (baseType._length != null) {
                            if (!baseType._length.isFixed()) continue block17;
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LENGTH_BASE_IS_FIXED, ""));
                            continue block17;
                        }
                        if (this.checkLengthBoundary(baseType, len)) {
                            length = (FLength)Facet.create("length");
                            length.setFacetValue(temp[0], pType);
                            continue block17;
                        }
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LENGTH_OUT_OF_BOUNDARY, ""));
                    }
                    catch (Exception e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    }
                    continue block17;
                }
                case 1: {
                    foundMinLength = true;
                    try {
                        minLen = new VDecimal();
                        minLen.setCanonicalValue(temp[0]);
                        if (baseType == null) {
                            minLength = (FMinLength)Facet.create("minLength");
                            minLength.setFacetValue(temp[0], pType);
                            continue block17;
                        }
                        if (baseType._minLength != null) {
                            if (!baseType._minLength.isFixed()) continue block17;
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MIN_LENGTH_BASE_IS_FIXED, ""));
                            continue block17;
                        }
                        if (this.checkLengthBoundary(baseType, minLen)) {
                            minLength = (FMinLength)Facet.create("minLength");
                            minLength.setFacetValue(temp[0], pType);
                            continue block17;
                        }
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MIN_LENGTH_OUT_OF_BOUNDARY, ""));
                    }
                    catch (Exception e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    }
                    continue block17;
                }
                case 2: {
                    foundMaxLength = true;
                    try {
                        maxLen = new VDecimal();
                        maxLen.setCanonicalValue(temp[0]);
                        if (baseType == null) {
                            maxLength = (FMaxLength)Facet.create("maxLength");
                            maxLength.setFacetValue(temp[0], pType);
                            continue block17;
                        }
                        if (baseType._maxLength != null) {
                            if (!baseType._maxLength.isFixed()) continue block17;
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAX_LENGTH_BASE_IS_FIXED, ""));
                            continue block17;
                        }
                        if (this.checkLengthBoundary(baseType, maxLen)) {
                            maxLength = (FMaxLength)Facet.create("maxLength");
                            maxLength.setFacetValue(temp[0], pType);
                            continue block17;
                        }
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAX_LENGTH_OUT_OF_BOUNDARY, ""));
                    }
                    catch (Exception e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    }
                    continue block17;
                }
                case 4: {
                    try {
                        enumvar = new FEnumeration[temp.length];
                        int itemType = this.getPrimitiveType();
                        for (int j = 0; j < temp.length; ++j) {
                            StringTokenizer st = new StringTokenizer(temp[j]);
                            int elen = st.countTokens();
                            if (len != null && len.getIntValue() != elen) {
                                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LIST_ENUM_NOT_EQUAL_LENGTH, ""));
                            }
                            if (minLen != null && minLen.getIntValue() > elen) {
                                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LIST_ENUM_SHORTER_THAN_LENGTH, ""));
                            }
                            if (maxLen != null && maxLen.getIntValue() < elen) {
                                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LIST_ENUM_LONGER_THAN_LENGTH, ""));
                            }
                            if (errors.size() != 0) continue block17;
                            if (itemType == -1) {
                                itemType = 0;
                            }
                            while (st.hasMoreTokens()) {
                                s = st.nextToken();
                                CanonicalValue.createCanonicalValue(itemType, s, eNode);
                            }
                            FEnumeration fe = (FEnumeration)Facet.create("enumeration");
                            fe.setFacetValue(temp[j], itemType, eNode, null, true);
                            enumvar[j] = fe;
                        }
                        continue block17;
                    }
                    catch (NoSuchElementException e) {
                        throw new NSException(e.toString());
                    }
                    catch (NSException e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    }
                }
            }
        }
        if (errors.size() == 0) {
            this._length = length;
            this._minLength = minLength;
            this._maxLength = maxLength;
            this._enum = enumvar;
        } else {
            WmList.throwNSException(errors, locale);
        }
    }

    public NSRecord getFacetsMetadata() {
        SimpleType datatype = this.getDatatype();
        if (this._nsRecord == null) {
            this._nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            this._nsRecord.addField(nsf);
            nsf = new NSField(null, "length", 1, 0);
            this._nsRecord.addField(nsf);
            nsf = new NSField(null, "minLength", 1, 0);
            this._nsRecord.addField(nsf);
            nsf = new NSField(null, "maxLength", 1, 0);
            this._nsRecord.addField(nsf);
        }
        return this._nsRecord;
    }

    public boolean validate(String inValue, Object context) {
        VList cValue = null;
        String s = inValue;
        s = DTUtil.handleWhiteSpace(s, 1);
        boolean valid = true;
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        StringTokenizer st = new StringTokenizer(s);
        int length = st.countTokens();
        Datatype datatype = (Datatype)this.getDatatype();
        if (datatype == null) {
            valid = false;
            workspace.addError("DT-List004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LIST_NO_DATATYPE_DEFINATION_MSG, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        boolean isValid = false;
        try {
            cValue = new VList();
            cValue.setCanonicalValue(s, datatype.getPrimitiveType());
        }
        catch (NSException e) {
            // empty catch block
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._length != null) {
            if (!this._length.validate(s, cValue)) {
                valid = false;
                workspace.addError("DT-List005", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_EQUAL_LENGTH, ""));
            }
        } else {
            if (this._minLength != null && !this._minLength.validate(s, cValue)) {
                valid = false;
                workspace.addError("DT-List002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.SHORTER_THAN_LENGTH, ""));
            }
            if (workspace.isCompleted()) {
                return valid;
            }
            if (this._maxLength != null && !this._maxLength.validate(s, cValue)) {
                valid = false;
                workspace.addError("DT-List003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LONGER_THAN_LENGTH, ""));
            }
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._enum != null) {
            for (int i = 0; i < this._enum.length; ++i) {
                int pType;
                int type;
                VList vlist;
                CanonicalValue[] cArray;
                FEnumeration f = this._enum[i];
                if (f != null && f.getValue() != null && (cArray = (vlist = (VList)f.getValue()).getValueArray()) != null && cArray.length != 0 && (type = cArray[0].getType()) != (pType = datatype.getPrimitiveType())) {
                    String svalue = f.getValue().toString();
                    ElementNode eNode = f.getValue().getElementNode();
                    try {
                        f = (FEnumeration)Facet.create("enumeration");
                        f.setFacetValue(svalue, pType, eNode, null, true);
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                if (f != null) {
                    valid = f.validate(s, cValue);
                }
                if (!valid) continue;
                return valid;
            }
            workspace.addError("ERR001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
            return valid;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        return valid;
    }

    public String getName() {
        if (this._ncName != null && this._ncName.length() > 0) {
            return this._ncName;
        }
        return this.getSourceName();
    }

    public boolean isProxy() {
        return false;
    }

    public int getPrimitiveType() {
        Datatype datatype = (Datatype)this.getDatatype();
        if (datatype != null) {
            return datatype.getPrimitiveType();
        }
        return -1;
    }

    public QName getItemTypeName() {
        Datatype datatype = (Datatype)this.getDatatype();
        if (datatype != null) {
            return datatype.getQName();
        }
        return null;
    }

    public boolean isListType() {
        return true;
    }

    public XSNode[] edges() {
        Datatype itemType;
        ArrayList<W3CKeys> c = new ArrayList<W3CKeys>();
        Datatype baseType = this.getBase();
        if (baseType != null && !baseType.isProxy()) {
            c.add(baseType);
        }
        if ((itemType = (Datatype)this.getDatatype()) != null && !itemType.isProxy()) {
            QName qname = itemType.getQName();
            if (qname != null && !BuiltInSimpleTypes.isBuiltIn(qname)) {
                c.add(itemType);
            }
            if (qname == null) {
                c.add(itemType);
            }
        }
        Constraint[] constraints = this.getConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            c.add(constraints[i]);
        }
        XSNode[] edges = new XSNode[c.size()];
        c.toArray(edges);
        return edges;
    }
}

