/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2;

import com.wm.lang.schema.PatternMatcherPool;
import com.wm.lang.schema.PooledPatternMatcher;
import com.wm.lang.schema.datatypev2.PlugableRegex;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;

public class PerlRegex
extends PlugableRegex {
    public String[] _strPatterns;
    private static ThreadLocal<PatternCompiler> tlocal = new ThreadLocal<PatternCompiler>(){

        @Override
        protected PatternCompiler initialValue() {
            return new Perl5Compiler();
        }
    };
    public Pattern[] _patterns = null;

    public static PerlRegex create(String[] strPatterns) {
        return new PerlRegex(strPatterns);
    }

    public static PerlRegex create(String strPattern) {
        if (strPattern == null) {
            return null;
        }
        String[] strPatterns = new String[]{strPattern};
        return new PerlRegex(strPatterns);
    }

    private PerlRegex(String[] strPatterns) {
        this();
        this.setPatterns(strPatterns);
    }

    private PerlRegex() {
    }

    public void setPatterns(String[] strPatterns) {
        if (strPatterns != null) {
            this._patterns = new Pattern[strPatterns.length];
            this._strPatterns = strPatterns;
            for (int i = 0; i < strPatterns.length; ++i) {
                if (strPatterns[i].length() <= 0) continue;
                try {
                    this._patterns[i] = PerlRegex.getPatternCompiler().compile(strPatterns[i]);
                    continue;
                }
                catch (MalformedPatternException mpe) {
                    this._patterns[i] = null;
                }
            }
        }
    }

    public String[] getStrPatterns() {
        return this._strPatterns;
    }

    public boolean match(String s) {
        if (this._patterns != null) {
            boolean valid = this._patterns.length == 0;
            PooledPatternMatcher ppm = (PooledPatternMatcher)PatternMatcherPool.current().allocate();
            PatternMatcher matcher = ppm.getPatternMatcher();
            for (int i = 0; i < this._patterns.length; ++i) {
                if (this._patterns[i] == null || !matcher.matches(s, this._patterns[i])) continue;
                valid = true;
                break;
            }
            ppm.poolReturn();
            return valid;
        }
        return true;
    }

    private static PatternCompiler getPatternCompiler() {
        return tlocal.get();
    }
}

