/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SchemaRegistry;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.datatypev2.Datatype;
import com.wm.util.Destroyable;
import com.wm.util.QName;
import com.wm.util.Values;

public abstract class InterDatatype
extends Datatype {
    QName[] _targetNames;
    SimpleType[] _targets;
    SimpleType[] _targetTypes;
    boolean _useAnonyType;
    NSName _targetOwnerNSName;
    public static final String KEY_DTR_TARGETNAMES = "targetNames";
    public static final String KEY_DTR_TARGETTYPES = "targetTypes";
    public static final String KEY_DTR_TARGET_OWNER_NSNAME = "targetOwnerNSName";
    public static final String KEY_DTR_TARGET = "targetName";

    protected InterDatatype(QName targetName, int internalType) {
        this._internalType = internalType;
        this._targetNames = new QName[1];
        this._targetNames[0] = targetName;
        this._targetTypes = null;
        this._useAnonyType = false;
        this._targets = new SimpleType[1];
    }

    protected InterDatatype(QName[] targetNames, int internalType) {
        this._internalType = internalType;
        this._targetNames = targetNames;
        this._targetTypes = null;
        this._useAnonyType = false;
        this._targets = targetNames != null ? new SimpleType[targetNames.length] : null;
    }

    protected InterDatatype(SimpleType targetType) {
        this._targetTypes = new SimpleType[1];
        this._targetTypes[0] = targetType;
        this._useAnonyType = true;
    }

    protected InterDatatype(SimpleType[] targetTypes) {
        this._targetTypes = targetTypes;
        this._useAnonyType = true;
    }

    InterDatatype(IData values) {
        this.setFromData(values);
    }

    InterDatatype(Values values) {
        this.setValues(values);
    }

    InterDatatype() {
    }

    protected int size() {
        if (this._useAnonyType) {
            if (this._targetTypes != null) {
                return this._targetTypes.length;
            }
            return -1;
        }
        if (this._targetNames != null) {
            return this._targetNames.length;
        }
        return -1;
    }

    SimpleType getDataType(int index) throws ArrayIndexOutOfBoundsException {
        if (this._useAnonyType) {
            return this._targetTypes[index];
        }
        return this.getDT(index);
    }

    SimpleType getDatatype() {
        if (this._useAnonyType) {
            return this._targetTypes[0];
        }
        return this.getDT(0);
    }

    SimpleType getDT(int index) {
        block5: {
            block6: {
                block7: {
                    if (this._targets[index] != null && ((Destroyable)((Object)this._targets[index])).isDestroyed()) {
                        this._targets[index] = null;
                    }
                    if (this._targets[index] != null) break block5;
                    if (this._owner == null && !this.isNamespaceAvailable()) {
                        return null;
                    }
                    if (this._targetNames[index].getNamespace() != null) break block6;
                    if (this._targetOwnerNSName != null) break block7;
                    if (this._owner == null) {
                        return null;
                    }
                    SimpleType target = this._owner.getSimpleType(this._targetNames[index].getNCName());
                    if (target == null) break block5;
                    this._targets[index] = target;
                    break block5;
                }
                this._targets[index] = this.retrieve(this._targetOwnerNSName, this._targetNames[index].getNCName());
                break block5;
            }
            NSName[] qnames = SchemaRegistry.resolve(this._targetNames[index].getNamespace());
            if (qnames != null) {
                for (int i = 0; i < qnames.length; ++i) {
                    Schema schema;
                    SimpleType target;
                    NSNode node = this.getNamespace().getNode(qnames[i]);
                    if (node == null || !node.getNodeTypeObj().equals(NSSchema.TYPE) || (target = (schema = (Schema)((Object)node)).getSimpleType(this._targetNames[index].getNCName())) == null) continue;
                    this._targets[index] = target;
                    break;
                }
            }
        }
        return this._targets[index];
    }

    private SimpleType retrieve(NSName name, String ncName) {
        NSNode node = this.getNamespace().getNode(name);
        if (node != null && node.getNodeTypeObj().equals(NSSchema.TYPE)) {
            Schema schema = (Schema)((Object)node);
            return schema.getSimpleType(ncName);
        }
        return null;
    }

    public void setOwner(Schema owner) {
        Datatype base;
        super.setOwner(owner);
        if (this._targetTypes != null) {
            for (int i = 0; i < this._targetTypes.length; ++i) {
                this._targetTypes[i].setOwner(owner);
            }
        }
        if ((base = this.getBase()) != null) {
            base.setOwner(owner);
        }
    }

    public void setNamespace(Namespace ns) {
        super.setNamespace(ns);
        if (this._targetTypes != null) {
            for (int i = 0; i < this._targetTypes.length; ++i) {
                this._targetTypes[i].setNamespace(ns);
            }
        } else {
            Datatype base = this.getBase();
            if (base != null) {
                base.setNamespace(ns);
            }
        }
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_DTR_TARGETNAMES, InterDatatype.toArray(this._targetNames)}, {KEY_DTR_TARGETTYPES, InterDatatype.toArray(this._targetTypes)}, {KEY_DTR_TARGET_OWNER_NSNAME, this._targetOwnerNSName}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        Object[] inArray;
        super.setValues(val);
        String in = val.getString(KEY_DTR_TARGET_OWNER_NSNAME);
        if (in != null) {
            this._targetOwnerNSName = NSName.create(in);
        }
        if ((inArray = (Object[])val.get(KEY_DTR_TARGETNAMES)) != null) {
            if (this._targetNames == null) {
                this._targetNames = new QName[inArray.length];
            }
            for (int i = 0; i < inArray.length; ++i) {
                this._targetNames[i] = QName.create((Values)inArray[i]);
            }
        } else {
            this._targetNames = null;
        }
        Values targetValue = val.getValues(KEY_DTR_TARGET);
        if (this._targetNames == null && targetValue != null) {
            this._targetNames = new QName[1];
            this._targetNames[0] = QName.create(targetValue);
        }
        if ((inArray = (Object[])val.get(KEY_DTR_TARGETTYPES)) != null) {
            if (this._targetTypes == null) {
                this._targetTypes = new Datatype[inArray.length];
            }
            try {
                for (int i = 0; i < inArray.length; ++i) {
                    this._targetTypes[i] = Datatype.create((Values)inArray[i]);
                }
            }
            catch (NSException e) {}
        } else {
            this._targetTypes = null;
        }
        if (this._targetTypes != null) {
            this._useAnonyType = true;
        } else if (this._targetNames != null) {
            this._useAnonyType = false;
            this._targets = new SimpleType[this._targetNames.length];
        }
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{KEY_DTR_TARGETNAMES, InterDatatype.toIDataArray(this._targetNames)}, {KEY_DTR_TARGETTYPES, InterDatatype.toIDataArray(this._targetTypes)}, {KEY_DTR_TARGET_OWNER_NSNAME, this._targetOwnerNSName}};
        IData val = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    public void setFromData(IData val) {
        Object[] inArray;
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        String in = IDataUtil.getString(ic, KEY_DTR_TARGET_OWNER_NSNAME);
        if (in != null) {
            this._targetOwnerNSName = NSName.create(in);
        }
        if ((inArray = (Object[])IDataUtil.get(ic, KEY_DTR_TARGETNAMES)) != null) {
            if (this._targetNames == null) {
                this._targetNames = new QName[inArray.length];
            }
            for (int i = 0; i < inArray.length; ++i) {
                this._targetNames[i] = QName.create((IData)inArray[i]);
            }
        } else {
            this._targetNames = null;
        }
        IData targetValue = (IData)IDataUtil.get(ic, KEY_DTR_TARGET);
        if (this._targetNames == null && targetValue != null) {
            this._targetNames = new QName[1];
            this._targetNames[0] = QName.create(targetValue);
        }
        if ((inArray = (Object[])IDataUtil.get(ic, KEY_DTR_TARGETTYPES)) != null) {
            if (this._targetTypes == null) {
                this._targetTypes = new Datatype[inArray.length];
            }
            try {
                for (int i = 0; i < inArray.length; ++i) {
                    this._targetTypes[i] = Datatype.create((IData)inArray[i]);
                }
            }
            catch (NSException e) {}
        } else {
            this._targetTypes = null;
        }
        if (this._targetTypes != null) {
            this._useAnonyType = true;
        } else if (this._targetNames != null) {
            this._useAnonyType = false;
            this._targets = new SimpleType[this._targetNames.length];
        }
        ic.destroy();
    }

    private static final Values[] toArray(SimpleType[] dtArray) {
        if (dtArray == null) {
            return null;
        }
        int len = dtArray.length;
        Values[] valArray = new Values[len];
        for (int i = 0; i < len; ++i) {
            valArray[i] = dtArray[i].getValues();
        }
        return valArray;
    }

    private static final Values[] toArray(QName[] qnArray) {
        if (qnArray == null) {
            return null;
        }
        int len = qnArray.length;
        Values[] valArray = new Values[len];
        for (int i = 0; i < len; ++i) {
            valArray[i] = qnArray[i].getValues();
        }
        return valArray;
    }

    private static final IData[] toIDataArray(SimpleType[] dtArray) {
        if (dtArray == null) {
            return null;
        }
        int len = dtArray.length;
        IData[] valArray = new IData[len];
        for (int i = 0; i < len; ++i) {
            valArray[i] = dtArray[i].getAsData();
        }
        return valArray;
    }

    private static final IData[] toIDataArray(QName[] qnArray) {
        if (qnArray == null) {
            return null;
        }
        int len = qnArray.length;
        IData[] valArray = new IData[len];
        for (int i = 0; i < len; ++i) {
            valArray[i] = qnArray[i].getAsData();
        }
        return valArray;
    }

    public boolean equals(String s1, String s2) {
        Datatype dt = (Datatype)this.getDatatype();
        if (dt == null) {
            return false;
        }
        return dt.equals(s1, s2);
    }

    public NSName getTargetOwnerName() {
        return this._targetOwnerNSName;
    }

    public void setTargetOwnerName(NSName name) {
        this._targetOwnerNSName = name;
    }
}

