/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.Keys;
import com.wm.lang.schema.NodeWorkspace;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.W3CKeys;
import com.wm.lang.schema.datatypev2.Constraint;
import com.wm.lang.schema.datatypev2.DTUtil;
import com.wm.lang.schema.datatypev2.Datatype2Keys;
import com.wm.lang.schema.datatypev2.DatatypeRef;
import com.wm.lang.schema.datatypev2.Errors;
import com.wm.lang.schema.datatypev2.WmList;
import com.wm.lang.schema.datatypev2.WmUnion;
import com.wm.lang.schema.datatypev2.cv.CanonicalValue;
import com.wm.lang.schema.datatypev2.cv.VDecimal;
import com.wm.lang.schema.datatypev2.facet.FEnumeration;
import com.wm.lang.schema.datatypev2.facet.FFractionDigits;
import com.wm.lang.schema.datatypev2.facet.FLength;
import com.wm.lang.schema.datatypev2.facet.FMaxExclusive;
import com.wm.lang.schema.datatypev2.facet.FMaxInclusive;
import com.wm.lang.schema.datatypev2.facet.FMaxLength;
import com.wm.lang.schema.datatypev2.facet.FMinExclusive;
import com.wm.lang.schema.datatypev2.facet.FMinInclusive;
import com.wm.lang.schema.datatypev2.facet.FMinLength;
import com.wm.lang.schema.datatypev2.facet.FPattern;
import com.wm.lang.schema.datatypev2.facet.FTotalDigits;
import com.wm.lang.schema.datatypev2.facet.FWhiteSpace;
import com.wm.lang.schema.datatypev2.facet.Facet;
import com.wm.lang.schema.datatypev2.resources.DatatypeMessageBundle;
import com.wm.lang.schema.util.Entry;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.util.Iterator;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.util.Destroyable;
import com.wm.util.IntEnum;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.sort.Sortable;
import com.wm.xsd.graph.XSNode;
import com.wm.xsd.graph.XSNonTerminal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public abstract class Datatype
implements SimpleType,
Errors,
W3CKeys,
Keys,
Datatype2Keys,
Entry,
Destroyable,
ValuesCodable,
Sortable,
XSNonTerminal {
    private static NSRecord _nsRecord = null;
    private int _type;
    FLength _length = null;
    FMinLength _minLength = null;
    FMaxLength _maxLength = null;
    FTotalDigits _totalDigits = null;
    FFractionDigits _fractionDigits = null;
    FWhiteSpace _whiteSpace = null;
    FMinInclusive _minI = null;
    FMinExclusive _minE = null;
    FMaxInclusive _maxI = null;
    FMaxExclusive _maxE = null;
    FEnumeration[] _enum = null;
    FPattern _pattern = null;
    String _name;
    QName _baseName;
    Datatype _base;
    String _version = "dtVersion2";
    boolean _isExpanded;
    private static String[] _typeNames = new String[]{"string", "boolean", "decimal", "float", "double", "duration", "dateTime", "time", "date", "gYearMonth", "gMonth", "gYear", "gMonthDay", "gDay", "hexBinary", "base64Binary", "QName", "NOTATION", "anyURI", "urSimpleType", "anySimpleType", "list", "union"};
    private static String[] _classNames = new String[]{"com.wm.lang.schema.datatypev2.WmString", "com.wm.lang.schema.datatypev2.WmBoolean", "com.wm.lang.schema.datatypev2.WmDecimal", "com.wm.lang.schema.datatypev2.WmFloat", "com.wm.lang.schema.datatypev2.WmDouble", "com.wm.lang.schema.datatypev2.gcType.WmDuration", "com.wm.lang.schema.datatypev2.gcType.WmDateTime", "com.wm.lang.schema.datatypev2.gcType.WmTime", "com.wm.lang.schema.datatypev2.gcType.WmDate", "com.wm.lang.schema.datatypev2.gcType.WmgYearMonth", "com.wm.lang.schema.datatypev2.gcType.WmgMonth", "com.wm.lang.schema.datatypev2.gcType.WmgYear", "com.wm.lang.schema.datatypev2.gcType.WmgMonthDay", "com.wm.lang.schema.datatypev2.gcType.WmgDay", "com.wm.lang.schema.datatypev2.WmHexBinary", "com.wm.lang.schema.datatypev2.WmBase64Binary", "com.wm.lang.schema.datatypev2.WmQName", "com.wm.lang.schema.datatypev2.WmNotation", "com.wm.lang.schema.datatypev2.WmAnyUri", "com.wm.lang.schema.datatypev2.WmString", "com.wm.lang.schema.datatypev2.WmString", "com.wm.lang.schema.datatypev2.WmList", "com.wm.lang.schema.datatypev2.WmUnion"};
    private int _typeIndex;
    String _ncName;
    int _internalType;
    Schema _owner;
    static final int DATATYPE_INSTANCE = 1;
    static final int DATATYPE_REFERENCE = 2;
    static final int DATATYPE_LIST = 3;
    static final int DATATYPE_UNION = 4;
    static final int DATATYPE_UNKNOWN = 10;
    static final IntEnum internalTypeEnum = new IntEnum(0);
    public static final String KEY_DT_CLASS = "ct_class";
    public static final String KEY_DT_INTERNALTYPE = "internalType";
    public static final String KEY_DT_CONTENTTYPE = "contentType";
    public static final String KEY_DT_IS_EXPANDED = "isExpanded";
    boolean _isDestroyed = false;
    static final String VALUE_DT_CONTENTTYPE = "simple";
    HashSet _typeHeirarchy;
    boolean _isAbstract;
    public static final String KEY_DT_PARENT_ANCESTORS_HEIRARCHY = "parent-ancestors";
    Namespace _ns;
    boolean _namespaceIsAvailable;
    private static String[] primitiveTypeNames;

    public String getVersion() {
        return "dtVersion2";
    }

    public void setFacets(IData facets) throws NSException {
    }

    public void setFacets(IData facets, Locale locale) throws NSException {
    }

    public IData getFacets() {
        return null;
    }

    public Constraint[] getConstraints() {
        Vector<Constraint> holder = new Vector<Constraint>();
        Constraint temp = null;
        String[] tArray = null;
        QName[] qnArray = null;
        CanonicalValue cValue = null;
        Object eNode = null;
        boolean hasQNameType = false;
        if (this._enum != null) {
            tArray = new String[this._enum.length];
            qnArray = new QName[this._enum.length];
            for (int i = 0; i < this._enum.length; ++i) {
                cValue = this._enum[i].getValue();
                if (cValue != null) {
                    tArray[i] = cValue.toString();
                    if (cValue == null || cValue.getType() != 17 && cValue.getType() != 18) continue;
                    qnArray[i] = cValue.getQName();
                    hasQNameType = true;
                    continue;
                }
                tArray[i] = null;
            }
            temp = hasQNameType ? Constraint.create(4, tArray, false, qnArray) : Constraint.create(4, tArray, false);
            holder.addElement(temp);
        }
        if (this._pattern != null) {
            tArray = this._pattern.getStringPatterns();
            temp = Constraint.create(3, tArray, false);
            holder.addElement(temp);
        }
        if (this._length != null) {
            tArray = new String[1];
            cValue = this._length.getValue();
            if (cValue != null) {
                tArray[0] = cValue.toString();
                temp = Constraint.create(0, tArray, this._length.isFixed());
                holder.addElement(temp);
            }
        }
        if (this._minLength != null) {
            tArray = new String[1];
            cValue = this._minLength.getValue();
            if (cValue != null) {
                tArray[0] = cValue.toString();
                temp = Constraint.create(1, tArray, this._minLength.isFixed());
                holder.addElement(temp);
            }
        }
        if (this._maxLength != null) {
            tArray = new String[1];
            cValue = this._maxLength.getValue();
            if (cValue != null) {
                tArray[0] = cValue.toString();
                temp = Constraint.create(2, tArray, this._maxLength.isFixed());
                holder.addElement(temp);
            }
        }
        if (this._totalDigits != null) {
            tArray = new String[1];
            cValue = this._totalDigits.getValue();
            if (cValue != null) {
                tArray[0] = cValue.toString();
                temp = Constraint.create(9, tArray, this._totalDigits.isFixed());
                holder.addElement(temp);
            }
        }
        if (this._fractionDigits != null) {
            tArray = new String[1];
            cValue = this._fractionDigits.getValue();
            if (cValue != null) {
                tArray[0] = cValue.toString();
                temp = Constraint.create(10, tArray, this._fractionDigits.isFixed());
                holder.addElement(temp);
            }
        }
        if (this._minI != null) {
            tArray = new String[1];
            cValue = this._minI.getValue();
            if (cValue != null) {
                tArray[0] = cValue.toString();
                temp = Constraint.create(5, tArray, this._minI.isFixed());
                holder.addElement(temp);
            }
        }
        if (this._minE != null) {
            tArray = new String[1];
            cValue = this._minE.getValue();
            if (cValue != null) {
                tArray[0] = cValue.toString();
                temp = Constraint.create(6, tArray, this._minE.isFixed());
                holder.addElement(temp);
            }
        }
        if (this._maxI != null) {
            tArray = new String[1];
            cValue = this._maxI.getValue();
            if (cValue != null) {
                tArray[0] = cValue.toString();
                temp = Constraint.create(7, tArray, this._maxI.isFixed());
                holder.addElement(temp);
            }
        }
        if (this._maxE != null) {
            tArray = new String[1];
            cValue = this._maxE.getValue();
            if (cValue != null) {
                tArray[0] = cValue.toString();
                temp = Constraint.create(8, tArray, this._maxE.isFixed());
                holder.addElement(temp);
            }
        }
        if (this._whiteSpace != null) {
            tArray = new String[1];
            cValue = this._whiteSpace.getValue();
            if (cValue != null) {
                tArray[0] = cValue.toString();
                temp = Constraint.create(11, tArray, this._whiteSpace.isFixed());
                holder.addElement(temp);
            }
        }
        Constraint[] cArray = new Constraint[holder.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (Constraint)holder.elementAt(i);
        }
        return cArray;
    }

    public void setConstraints(Constraint[] constraints) throws NSException {
        this.setConstraints(constraints, Locale.getDefault());
    }

    public void setConstraints(Constraint[] cArray, Locale locale) throws NSException {
        boolean f;
        boolean b;
        int i;
        if (cArray == null) {
            return;
        }
        FLength length = null;
        FMinLength minLength = null;
        FMaxLength maxLength = null;
        FTotalDigits totalDigits = null;
        FFractionDigits fractionDigits = null;
        FWhiteSpace whiteSpace = null;
        FMinInclusive minI = null;
        FMinExclusive minE = null;
        FMaxInclusive maxI = null;
        FMaxExclusive maxE = null;
        FEnumeration[] enumvar = null;
        FPattern pattern = null;
        CanonicalValue vMinI = null;
        CanonicalValue vMinE = null;
        CanonicalValue vMaxI = null;
        CanonicalValue vMaxE = null;
        CanonicalValue pvminI = null;
        CanonicalValue pvminE = null;
        CanonicalValue pvmaxI = null;
        CanonicalValue pvmaxE = null;
        VDecimal len = null;
        VDecimal minLen = null;
        VDecimal maxLen = null;
        VDecimal td = null;
        VDecimal fd = null;
        boolean foundLen = false;
        boolean foundMinLen = false;
        boolean foundMaxLen = false;
        boolean foundMinI = false;
        boolean foundMinE = false;
        boolean foundMaxI = false;
        boolean foundMaxE = false;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        int pType = this.getPrimitiveType();
        String[] enumArray = null;
        QName[] enumQNameArray = null;
        ElementNode enumEnode = null;
        int[] inValidKeys = this.getNumInValidKeys();
        if (inValidKeys != null) {
            for (i = 0; i < inValidKeys.length; ++i) {
                for (int j = 0; j < cArray.length; ++j) {
                    int type = cArray[j].getFacetType();
                    if (type != inValidKeys[i]) continue;
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.SHOULD_NOT_HAVE_THIS_FACET, "");
                }
            }
        }
        block40: for (i = 0; i < cArray.length; ++i) {
            int facetType = cArray[i].getFacetType();
            String[] temp = cArray[i].getValue();
            ElementNode eNode = cArray[i].getElementNode();
            QName[] tempQNarray = cArray[i].getQNameArray();
            boolean fixed = cArray[i].getFixed();
            if (temp == null) continue;
            Object facet = null;
            switch (facetType) {
                case 0: {
                    foundLen = true;
                    try {
                        if (!DTUtil.isNonNegInteger(temp[0])) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_LENGTH, ""));
                        }
                        len = new VDecimal();
                        len.setCanonicalValue(temp[0]);
                        if (this._base == null) {
                            length = (FLength)Facet.create("length");
                            length.setFacetValue(temp[0], pType);
                            length.setFixed(fixed);
                            continue block40;
                        }
                        if (this._base._length != null) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LENGTH_BASE_EXISTS, ""));
                        }
                        if (this.checkLengthBoundary(this._base, len)) {
                            length = (FLength)Facet.create("length");
                            length.setFacetValue(temp[0], pType);
                            length.setFixed(fixed);
                            continue block40;
                        }
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LENGTH_OUT_OF_BOUNDARY, ""));
                    }
                    catch (Exception e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_LENGTH, ""));
                    }
                    continue block40;
                }
                case 1: {
                    foundMinLen = true;
                    try {
                        if (!DTUtil.isNonNegInteger(temp[0])) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_LENGTH, ""));
                        }
                        minLen = new VDecimal();
                        minLen.setCanonicalValue(temp[0]);
                        if (this._base == null) {
                            minLength = (FMinLength)Facet.create("minLength");
                            minLength.setFacetValue(temp[0], pType);
                            minLength.setFixed(fixed);
                            continue block40;
                        }
                        if (this._base._length != null) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LEN_BASE_MIN_CANNOT_CO_EXIST, ""));
                        }
                        if (this._base._minLength != null && this._base._minLength.isFixed() && !minLen.equals(this._base._minLength.getValue())) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MIN_LENGTH_BASE_IS_FIXED, ""));
                        }
                        if (this.checkLengthBoundary(this._base, minLen)) {
                            minLength = (FMinLength)Facet.create("minLength");
                            minLength.setFacetValue(temp[0], pType);
                            minLength.setFixed(fixed);
                            continue block40;
                        }
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MIN_LENGTH_OUT_OF_BOUNDARY, ""));
                    }
                    catch (Exception e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_LENGTH, ""));
                    }
                    continue block40;
                }
                case 2: {
                    foundMaxLen = true;
                    try {
                        if (!DTUtil.isNonNegInteger(temp[0])) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_LENGTH, ""));
                        }
                        maxLen = new VDecimal();
                        maxLen.setCanonicalValue(temp[0]);
                        if (this._base == null) {
                            maxLength = (FMaxLength)Facet.create("maxLength");
                            maxLength.setFacetValue(temp[0], pType);
                            maxLength.setFixed(fixed);
                            continue block40;
                        }
                        if (this._base._length != null) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LEN_BASE_MAX_CANNOT_CO_EXIST, ""));
                        }
                        if (this._base._maxLength != null && this._base._maxLength.isFixed() && !maxLen.equals(this._base._maxLength.getValue())) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAX_LENGTH_BASE_IS_FIXED, ""));
                        }
                        if (this.checkLengthBoundary(this._base, maxLen)) {
                            maxLength = (FMaxLength)Facet.create("maxLength");
                            maxLength.setFacetValue(temp[0], pType);
                            maxLength.setFixed(fixed);
                            continue block40;
                        }
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAX_LENGTH_OUT_OF_BOUNDARY, ""));
                    }
                    catch (Exception e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_LENGTH, ""));
                    }
                    continue block40;
                }
                case 9: {
                    try {
                        if (!DTUtil.isPosInteger(temp[0])) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_TOTAL_DIGIT, ""));
                        }
                        td = new VDecimal();
                        td.setCanonicalValue(temp[0]);
                        if (this._base == null) {
                            totalDigits = (FTotalDigits)Facet.create("totalDigits");
                            totalDigits.setFacetValue(temp[0], pType);
                            totalDigits.setFixed(fixed);
                            continue block40;
                        }
                        if (this._base._totalDigits != null) {
                            if (this._base._totalDigits.isFixed() && !td.equals(this._base._totalDigits.getValue())) {
                                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.TOTAL_DIGIT_BASE_IS_FIXED, ""));
                                continue block40;
                            }
                            VDecimal btd = (VDecimal)this._base._totalDigits.getValue();
                            if (btd != null && td.greaterThan(btd)) {
                                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.TOTAL_DIGIT_OUT_OF_BOUNDARY, ""));
                                continue block40;
                            }
                            totalDigits = (FTotalDigits)Facet.create("totalDigits");
                            totalDigits.setFacetValue(temp[0], pType);
                            totalDigits.setFixed(fixed);
                            continue block40;
                        }
                        totalDigits = (FTotalDigits)Facet.create("totalDigits");
                        totalDigits.setFacetValue(temp[0], pType);
                        totalDigits.setFixed(fixed);
                    }
                    catch (Exception e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_TOTAL_DIGIT, ""));
                    }
                    continue block40;
                }
                case 10: {
                    try {
                        if (!DTUtil.isNonNegInteger(temp[0])) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_FRACTION_DIGIT, ""));
                        }
                        fd = new VDecimal();
                        fd.setCanonicalValue(temp[0]);
                        if (this._base == null) {
                            fractionDigits = (FFractionDigits)Facet.create("fractionDigits");
                            fractionDigits.setFacetValue(temp[0], pType);
                            fractionDigits.setFixed(fixed);
                            continue block40;
                        }
                        if (this._base._fractionDigits != null) {
                            if (this._base._fractionDigits.isFixed() && !fd.equals(this._base._fractionDigits.getValue())) {
                                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.FRACTION_DIGIT_BASE_IS_FIXED, ""));
                                continue block40;
                            }
                            VDecimal bfd = (VDecimal)this._base._fractionDigits.getValue();
                            if (bfd != null && fd.greaterThan(bfd)) {
                                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.FRACTION_DIGIT_OUT_OF_BOUNDARY, ""));
                                continue block40;
                            }
                            fractionDigits = (FFractionDigits)Facet.create("fractionDigits");
                            fractionDigits.setFacetValue(temp[0], pType);
                            fractionDigits.setFixed(fixed);
                            continue block40;
                        }
                        fractionDigits = (FFractionDigits)Facet.create("fractionDigits");
                        fractionDigits.setFacetValue(temp[0], pType);
                        fractionDigits.setFixed(fixed);
                    }
                    catch (Exception e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_FRACTION_DIGIT, ""));
                    }
                    continue block40;
                }
                case 5: {
                    foundMinI = true;
                    try {
                        if (this._base == null) {
                            minI = (FMinInclusive)Facet.create("minInclusive");
                            minI.setFacetValue(temp[0], pType, eNode);
                            minI.setFixed(fixed);
                            continue block40;
                        }
                        vMinI = CanonicalValue.createCanonicalValue(this._base.getPrimitiveType(), temp[0], eNode);
                        if (this._base._minI != null) {
                            if (this._base._minI.isFixed() && !vMinI.equals(this._base._minI.getValue())) {
                                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MINI_BASE_IS_FIXED, ""));
                                continue block40;
                            }
                            minI = (FMinInclusive)Facet.create("minInclusive");
                            minI.setFacetValue(temp[0], pType, eNode);
                            minI.setFixed(fixed);
                            continue block40;
                        }
                        minI = (FMinInclusive)Facet.create("minInclusive");
                        minI.setFacetValue(temp[0], pType, eNode);
                        minI.setFixed(fixed);
                    }
                    catch (NSException e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    }
                    continue block40;
                }
                case 6: {
                    foundMinE = true;
                    try {
                        if (this._base == null) {
                            minE = (FMinExclusive)Facet.create("minExclusive");
                            minE.setFacetValue(temp[0], pType, eNode);
                            minE.setFixed(fixed);
                            continue block40;
                        }
                        vMinE = CanonicalValue.createCanonicalValue(this._base.getPrimitiveType(), temp[0], eNode);
                        if (this._base._minE != null) {
                            if (this._base._minE.isFixed() && !vMinE.equals(this._base._minE.getValue())) {
                                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MINE_BASE_IS_FIXED, ""));
                                continue block40;
                            }
                            minE = (FMinExclusive)Facet.create("minExclusive");
                            minE.setFacetValue(temp[0], pType, eNode);
                            minE.setFixed(fixed);
                            continue block40;
                        }
                        minE = (FMinExclusive)Facet.create("minExclusive");
                        minE.setFacetValue(temp[0], pType, eNode);
                        minE.setFixed(fixed);
                    }
                    catch (NSException e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    }
                    continue block40;
                }
                case 7: {
                    foundMaxI = true;
                    try {
                        if (this._base == null) {
                            maxI = (FMaxInclusive)Facet.create("maxInclusive");
                            maxI.setFacetValue(temp[0], pType, eNode);
                            maxI.setFixed(fixed);
                            continue block40;
                        }
                        vMaxI = CanonicalValue.createCanonicalValue(this._base.getPrimitiveType(), temp[0]);
                        if (this._base._maxI != null) {
                            if (this._base._maxI.isFixed() && !vMaxI.equals(this._base._maxI.getValue())) {
                                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_BASE_IS_FIXED, ""));
                                continue block40;
                            }
                            maxI = (FMaxInclusive)Facet.create("maxInclusive");
                            maxI.setFacetValue(temp[0], pType, eNode);
                            maxI.setFixed(fixed);
                            continue block40;
                        }
                        maxI = (FMaxInclusive)Facet.create("maxInclusive");
                        maxI.setFacetValue(temp[0], pType, eNode);
                        maxI.setFixed(fixed);
                    }
                    catch (NSException e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    }
                    continue block40;
                }
                case 8: {
                    foundMaxE = true;
                    try {
                        if (this._base == null) {
                            maxE = (FMaxExclusive)Facet.create("maxExclusive");
                            maxE.setFacetValue(temp[0], pType, eNode);
                            maxE.setFixed(fixed);
                            continue block40;
                        }
                        vMaxE = CanonicalValue.createCanonicalValue(this._base.getPrimitiveType(), temp[0]);
                        if (this._base._maxE != null) {
                            if (this._base._maxE.isFixed() && !vMaxE.equals(this._base._maxE.getValue())) {
                                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_BASE_IS_FIXED, ""));
                                continue block40;
                            }
                            maxE = (FMaxExclusive)Facet.create("maxExclusive");
                            maxE.setFacetValue(temp[0], pType, eNode);
                            maxE.setFixed(fixed);
                            continue block40;
                        }
                        maxE = (FMaxExclusive)Facet.create("maxExclusive");
                        maxE.setFacetValue(temp[0], pType, eNode);
                        maxE.setFixed(fixed);
                    }
                    catch (NSException e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    }
                    continue block40;
                }
                case 11: {
                    try {
                        VDecimal ws = new VDecimal();
                        String wsValue = null;
                        wsValue = temp[0].equals("collapse") ? Integer.toString(1) : (temp[0].equals("replace") ? Integer.toString(2) : (temp[0].equals("preserve") ? Integer.toString(3) : temp[0]));
                        ws.setCanonicalValue(wsValue);
                        if (this._base == null) {
                            whiteSpace = (FWhiteSpace)Facet.create("whiteSpace");
                            whiteSpace.setFacetValue(wsValue, pType);
                            whiteSpace.setFixed(fixed);
                            continue block40;
                        }
                        if (this._base._whiteSpace != null) {
                            VDecimal bws = (VDecimal)this._base._whiteSpace.getValue();
                            if (this._base._whiteSpace.isFixed() && !ws.equals(bws)) {
                                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.WHITE_SPACE_BASE_IS_FIXED, ""));
                                continue block40;
                            }
                            if (bws != null && ws.greaterThan(bws)) {
                                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.WHITE_SPACE_OUT_OF_BOUNDARY, ""));
                                continue block40;
                            }
                            whiteSpace = (FWhiteSpace)Facet.create("whiteSpace");
                            whiteSpace.setFacetValue(wsValue, pType);
                            whiteSpace.setFixed(fixed);
                            continue block40;
                        }
                        whiteSpace = (FWhiteSpace)Facet.create("whiteSpace");
                        whiteSpace.setFacetValue(wsValue, pType);
                        whiteSpace.setFixed(fixed);
                    }
                    catch (Exception e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    }
                    continue block40;
                }
                case 4: {
                    enumArray = temp;
                    enumEnode = eNode;
                    enumQNameArray = tempQNarray;
                    continue block40;
                }
                case 3: {
                    try {
                        pattern = (FPattern)Facet.create("pattern");
                        pattern.setFacetValue(temp, pType);
                    }
                    catch (NSException e) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    }
                    continue block40;
                }
                default: {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_FACET_TYPE, ""));
                }
            }
        }
        if (foundLen && (foundMinLen || foundMaxLen)) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LEN_CANNOT_CO_EXIST, ""));
        }
        if (foundMinI && foundMinE) {
            Object[] sa = new String[]{"minInclusive", "minExclusive"};
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.CANNOT_CO_EXIST, "", sa));
        }
        if (foundMaxI && foundMaxE) {
            Object[] sa = new String[]{"maxInclusive", "maxExclusive"};
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.CANNOT_CO_EXIST, "", sa));
        }
        if (minLen != null && maxLen != null && maxLen.lessThan(minLen)) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXLENGTH_LESS_THAN_MIN, ""));
        }
        if (td != null && fd != null && td.lessThan(fd)) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.TOTAL_D_LESS_THAN_FRACTION_D, ""));
        }
        if (this._base != null) {
            if (this._base._minI != null) {
                pvminI = this._base._minI.getValue();
            }
            if (this._base._minE != null) {
                pvminE = this._base._minE.getValue();
            }
            if (this._base._maxI != null) {
                pvmaxI = this._base._maxI.getValue();
            }
            if (this._base._maxE != null) {
                pvmaxE = this._base._maxE.getValue();
            }
        }
        if (vMinI != null) {
            boolean d;
            if (vMaxI != null && vMaxI.lessThan(vMinI)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINI, ""));
            }
            if (vMaxE != null && vMaxE.lessThan(vMinI)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINI, ""));
            }
            boolean a = pvminI != null && vMinI.lessThan(pvminI);
            b = pvmaxI != null && vMinI.greaterThan(pvmaxI);
            boolean c = pvminE != null && vMinI.lessThanOrEqualTo(pvminE);
            boolean bl = d = pvmaxE != null && vMinI.greaterThanOrEqualTo(pvmaxE);
            if (a || b || c || d) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MINI_OUT_OF_BOUNDARY, ""));
            }
            boolean e = totalDigits != null && !totalDigits.validate(null, vMinI);
            boolean bl2 = f = fractionDigits != null && !fractionDigits.validate(null, vMinI);
            if (e || f) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_I, ""));
            }
        }
        if (vMinE != null) {
            boolean d;
            if (vMaxI != null && vMaxI.lessThan(vMinE)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINE, ""));
            }
            if (vMaxE != null && vMaxE.lessThan(vMinE)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINE, ""));
            }
            boolean a = pvminI != null && vMinE.lessThan(pvminI);
            b = pvmaxI != null && vMinE.greaterThan(pvmaxI);
            boolean c = pvminE != null && vMinE.lessThan(pvminE);
            boolean bl = d = pvmaxE != null && vMinE.greaterThanOrEqualTo(pvmaxE);
            if (a || b || c || d) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MINE_OUT_OF_BOUNDARY, ""));
            }
            boolean e = totalDigits != null && !totalDigits.validate(null, vMinE);
            boolean bl3 = f = fractionDigits != null && !fractionDigits.validate(null, vMinE);
            if (e || f) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_E, ""));
            }
        }
        if (vMaxI != null) {
            boolean d;
            boolean a = pvminI != null && vMaxI.lessThan(pvminI);
            b = pvmaxI != null && vMaxI.greaterThan(pvmaxI);
            boolean c = pvminE != null && vMaxI.lessThanOrEqualTo(pvminE);
            boolean bl = d = pvmaxE != null && vMaxI.greaterThanOrEqualTo(pvmaxE);
            if (a || b || c || d) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_OUT_OF_BOUNDARY, ""));
            }
            boolean e = totalDigits != null && !totalDigits.validate(null, vMaxI);
            boolean bl4 = f = fractionDigits != null && !fractionDigits.validate(null, vMaxI);
            if (e || f) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_I, ""));
            }
        }
        if (vMaxE != null) {
            boolean d;
            boolean a = pvminI != null && vMaxE.lessThanOrEqualTo(pvminI);
            b = pvmaxI != null && vMaxE.greaterThan(pvmaxI);
            boolean c = pvminE != null && vMaxE.lessThanOrEqualTo(pvminE);
            boolean bl = d = pvmaxE != null && vMaxE.greaterThan(pvmaxE);
            if (a || b || c || d) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_OUT_OF_BOUNDARY, ""));
            }
            boolean e = totalDigits != null && !totalDigits.validate(null, vMaxE);
            boolean bl5 = f = fractionDigits != null && !fractionDigits.validate(null, vMaxE);
            if (e || f) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_E, ""));
            }
        }
        if (enumArray != null) {
            try {
                CanonicalValue cValue = null;
                enumvar = new FEnumeration[enumArray.length];
                String tempS = null;
                QName tempQ = null;
                for (int j = 0; j < enumArray.length; ++j) {
                    FEnumeration fe;
                    tempS = enumArray[j];
                    tempQ = enumQNameArray != null ? enumQNameArray[j] : null;
                    cValue = CanonicalValue.createCanonicalValue(pType, tempS, enumEnode, tempQ);
                    if (cValue == null) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM, "", enumArray[j]));
                        break;
                    }
                    if (length != null && !length.validate(enumArray[j], cValue)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_NOT_EQUAL_LENGTH, "", enumArray[j]));
                        break;
                    }
                    if (minLength != null && !minLength.validate(enumArray[j], cValue)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_SHORTER_THAN_LENGTH, "", enumArray[j]));
                        break;
                    }
                    if (maxLength != null && !maxLength.validate(enumArray[j], cValue)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_LONGER_THAN_LENGTH, "", enumArray[j]));
                        break;
                    }
                    if (totalDigits != null && !totalDigits.validate(enumArray[j], cValue)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_INVALID_TOTAL_DIGIT, "", enumArray[j]));
                        break;
                    }
                    if (fractionDigits != null && !fractionDigits.validate(enumArray[j], cValue)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_INVALID_FRACTION_DIGIT, "", enumArray[j]));
                        break;
                    }
                    if (minI != null && !minI.validate(enumArray[j], cValue)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumArray[j]));
                        break;
                    }
                    if (minE != null && !minE.validate(enumArray[j], cValue)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumArray[j]));
                        break;
                    }
                    if (maxI != null && !maxI.validate(enumArray[j], cValue)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumArray[j]));
                        break;
                    }
                    if (maxE != null && !maxE.validate(enumArray[j], cValue)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumArray[j]));
                        break;
                    }
                    if (pattern != null && !pattern.validate(enumArray[j], cValue)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_NOT_MATCH_PATTERN, "", enumArray[j]));
                        break;
                    }
                    if (this._base == null) {
                        fe = (FEnumeration)Facet.create("enumeration");
                        fe.setFacetValue(enumArray[j], pType, enumEnode, tempQ);
                        enumvar[j] = fe;
                        continue;
                    }
                    CanonicalValue.createCanonicalValue(this._base.getPrimitiveType(), enumArray[j], enumEnode, tempQ);
                    fe = (FEnumeration)Facet.create("enumeration");
                    fe.setFacetValue(enumArray[j], pType, enumEnode, tempQ);
                    enumvar[j] = fe;
                }
            }
            catch (NSException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
            }
        }
        if (errors.size() == 0) {
            this._length = length;
            this._minLength = minLength;
            this._maxLength = maxLength;
            this._totalDigits = totalDigits;
            this._fractionDigits = fractionDigits;
            this._whiteSpace = whiteSpace;
            this._minI = minI;
            this._minE = minE;
            this._maxI = maxI;
            this._maxE = maxE;
            this._enum = enumvar;
            this._pattern = pattern;
        } else {
            Datatype.throwNSException(errors, locale);
        }
    }

    public IData getFixedFacets() {
        if (this._base == null) {
            this._base = (Datatype)this.deepClone();
            this._base._typeHeirarchy = null;
        }
        return this._base.getFacets();
    }

    public void setFixedFacets(IData facets) throws NSException {
        if (this._base != null) {
            this._base.setFacets(facets);
        }
    }

    public Constraint[] getBaseConstraints() {
        if (this._base == null) {
            this._base = (Datatype)this.deepClone();
            this._base._typeHeirarchy = null;
        }
        return this._base.getConstraints();
    }

    public void setBaseConstraints(Constraint[] constraints) throws NSException {
        if (this._base != null) {
            this._base.setConstraints(constraints);
        }
    }

    public static final SimpleType deriveFrom(SimpleType datatype) throws NSException {
        int type;
        int i;
        Datatype customizedObject = (Datatype)datatype.deepClone();
        Constraint[] baseFacets = customizedObject.getBaseConstraints();
        Constraint[] facets = customizedObject.getConstraints();
        Object childEnum = null;
        Object finalEnum = null;
        Constraint childPattern = null;
        Constraint finalPattern = null;
        boolean foundLen = false;
        boolean foundMinLen = false;
        boolean foundMaxLen = false;
        boolean foundMinI = false;
        boolean foundMinE = false;
        boolean foundMaxI = false;
        boolean foundMaxE = false;
        boolean foundTD = false;
        boolean foundFD = false;
        boolean foundEnum = false;
        boolean foundBaseEnum = false;
        boolean foundPattern = false;
        boolean foundBasePattern = false;
        boolean foundWS = false;
        Vector<Constraint> bholder = new Vector<Constraint>();
        if (facets == null) {
            return customizedObject;
        }
        block26: for (i = 0; i < facets.length; ++i) {
            type = -1;
            if (facets[i] == null) continue;
            type = facets[i].getFacetType();
            if (type == 3) {
                foundPattern = true;
                childPattern = facets[i];
                continue;
            }
            bholder.addElement(facets[i]);
            switch (type) {
                case 4: {
                    foundEnum = true;
                    continue block26;
                }
                case 0: {
                    foundLen = true;
                    continue block26;
                }
                case 1: {
                    foundMinLen = true;
                    continue block26;
                }
                case 2: {
                    foundMaxLen = true;
                    continue block26;
                }
                case 9: {
                    foundTD = true;
                    continue block26;
                }
                case 10: {
                    foundFD = true;
                    continue block26;
                }
                case 5: {
                    foundMinI = true;
                    continue block26;
                }
                case 6: {
                    foundMinE = true;
                    continue block26;
                }
                case 7: {
                    foundMaxI = true;
                    continue block26;
                }
                case 8: {
                    foundMaxE = true;
                    continue block26;
                }
                case 11: {
                    foundWS = true;
                }
            }
        }
        if (baseFacets != null) {
            block27: for (i = 0; i < baseFacets.length; ++i) {
                type = -1;
                if (baseFacets[i] == null) continue;
                type = baseFacets[i].getFacetType();
                if (type == 3) {
                    foundBasePattern = true;
                    String[] childValue = foundPattern ? childPattern.getValue() : null;
                    String[] baseValue = baseFacets[i].getValue();
                    if (childValue != null) {
                        if (baseValue == null) {
                            finalPattern = childPattern;
                        } else {
                            int alen = childValue.length + baseValue.length;
                            String[] tArray = new String[alen];
                            System.arraycopy(childValue, 0, tArray, 0, childValue.length);
                            System.arraycopy(baseValue, 0, tArray, childValue.length + 1, baseValue.length);
                            finalPattern = Constraint.create(3, tArray, false);
                        }
                    } else {
                        finalPattern = baseFacets[i];
                    }
                    bholder.addElement(finalPattern);
                    continue;
                }
                switch (type) {
                    case 0: {
                        if (foundLen || foundMinLen || foundMaxLen) continue block27;
                        bholder.addElement(baseFacets[i]);
                        continue block27;
                    }
                    case 1: {
                        if (foundMinLen || foundLen) continue block27;
                        bholder.addElement(baseFacets[i]);
                        continue block27;
                    }
                    case 2: {
                        if (foundLen || foundMaxLen) continue block27;
                        bholder.addElement(baseFacets[i]);
                        continue block27;
                    }
                    case 9: {
                        if (foundTD) continue block27;
                        bholder.addElement(baseFacets[i]);
                        continue block27;
                    }
                    case 10: {
                        if (foundFD) continue block27;
                        bholder.addElement(baseFacets[i]);
                        continue block27;
                    }
                    case 5: {
                        if (foundMinI || foundMinE) continue block27;
                        bholder.addElement(baseFacets[i]);
                        continue block27;
                    }
                    case 6: {
                        if (foundMinE || foundMinI) continue block27;
                        bholder.addElement(baseFacets[i]);
                        continue block27;
                    }
                    case 7: {
                        if (foundMaxI || foundMaxE) continue block27;
                        bholder.addElement(baseFacets[i]);
                        continue block27;
                    }
                    case 8: {
                        if (foundMaxE || foundMaxI) continue block27;
                        bholder.addElement(baseFacets[i]);
                        continue block27;
                    }
                    case 11: {
                        if (foundWS) continue block27;
                        bholder.addElement(baseFacets[i]);
                        continue block27;
                    }
                    case 4: {
                        if (foundEnum) continue block27;
                        bholder.addElement(baseFacets[i]);
                    }
                }
            }
            if (foundPattern && !foundBasePattern) {
                bholder.addElement(childPattern);
            }
        }
        Constraint[] cumtomizedFacets = new Constraint[bholder.size()];
        Constraint[] emptyFacets = new Constraint[]{};
        for (int i2 = 0; i2 < bholder.size(); ++i2) {
            cumtomizedFacets[i2] = (Constraint)bholder.elementAt(i2);
        }
        customizedObject.setBaseConstraints(cumtomizedFacets);
        customizedObject.setConstraints(emptyFacets);
        return customizedObject;
    }

    public abstract int[] getNumValidKeys();

    public abstract int[] getNumInValidKeys();

    public abstract NSRecord getFacetsMetadata();

    public String getSourceName() {
        return _typeNames[this._typeIndex];
    }

    public String getTypeName() {
        return null;
    }

    public String getName() {
        if (this._ncName != null && this._ncName.length() > 0) {
            return this._ncName;
        }
        return this.getSourceName();
    }

    public int getType() {
        return 1;
    }

    public Datatype getBase() {
        return this._base;
    }

    public boolean isProxy() {
        return false;
    }

    public Schema getOwner() {
        return this._owner;
    }

    public void setName(String ncName) {
        this._ncName = ncName;
    }

    public void setOwner(Schema owner) {
        this._owner = owner;
    }

    public boolean validate(String inString, Object context) {
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        int pType = this.getPrimitiveType();
        if (pType == 17 || pType == 18) {
            if (workspace.getWorkspaceType() == 1) {
                return true;
            }
        }
        if (this._base != null && !this._base.validate(inString, context)) {
            return false;
        }
        String s = inString;
        int ws = -1;
        VDecimal vd = null;
        if (this._whiteSpace != null) {
            try {
                vd = (VDecimal)this._whiteSpace.getValue();
                if (vd != null) {
                    ws = vd.getIntValue();
                }
            }
            catch (Exception e) {
                workspace.addError("DT-013", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_WHITE_SPACE_VALUE, ""));
            }
        } else if (this._base != null && this._base._whiteSpace != null) {
            try {
                vd = (VDecimal)this._base._whiteSpace.getValue();
                if (vd != null) {
                    ws = vd.getIntValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ws == -1 && pType != 0) {
            ws = 1;
        }
        if (ws != -1) {
            s = DTUtil.handleWhiteSpace(s, ws);
        }
        boolean valid = true;
        if (this._pattern != null && !this._pattern.validate(s, null)) {
            workspace.addError("DT-012", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_MATCH_PATTERN_MSG, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        CanonicalValue cValue = null;
        ElementNodeBase eNode = null;
        if (pType == 17 || pType == 18) {
            if (workspace.getWorkspaceType() == 2) {
                eNode = ((NodeWorkspace)workspace).getCurrentNode();
            }
        }
        try {
            cValue = CanonicalValue.createCanonicalValue(pType, s, eNode);
        }
        catch (Exception e) {
            workspace.addError("DT-001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
            return false;
        }
        if (cValue == null) {
            workspace.addError("DT-001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
            return false;
        }
        if (this._enum != null) {
            for (int i = 0; i < this._enum.length; ++i) {
                FEnumeration f = this._enum[i];
                if (f != null) {
                    valid = f.validate(s, cValue);
                }
                if (!valid) continue;
                return valid;
            }
            workspace.addError("DT-002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
            return valid;
        }
        if (this._length != null && !(valid = this._length.validate(s, cValue))) {
            workspace.addError("DT-003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_EQUAL_LENGTH, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._minLength != null && !(valid = this._minLength.validate(s, cValue))) {
            workspace.addError("DT-004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.SHORTER_THAN_LENGTH, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._maxLength != null && !(valid = this._maxLength.validate(s, cValue))) {
            workspace.addError("DT-005", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LONGER_THAN_LENGTH, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._totalDigits != null && !(valid = this._totalDigits.validate(s, cValue))) {
            workspace.addError("DT-006", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.EXCEEDS_TOTAL_DIGIT, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._fractionDigits != null && !(valid = this._fractionDigits.validate(s, cValue))) {
            workspace.addError("DT-007", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.EXCEEDS_FRACTION_DIGIT, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._minI != null && !(valid = this._minI.validate(s, cValue))) {
            workspace.addError("DT-008", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN_I, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._minE != null && !(valid = this._minE.validate(s, cValue))) {
            workspace.addError("DT-009", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN_E, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._maxI != null && !(valid = this._maxI.validate(s, cValue))) {
            workspace.addError("DT-010", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX_I, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._maxE != null && !(valid = this._maxE.validate(s, cValue))) {
            workspace.addError("DT-011", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX_E, ""));
        }
        return valid;
    }

    public static Datatype create(String type) throws NSException {
        int index;
        Datatype ret = null;
        int size = _typeNames.length;
        for (index = 0; index < size && !type.equals(_typeNames[index]); ++index) {
        }
        if (index == size) {
            throw new NSException("Unknown content type: " + type);
        }
        try {
            Class<?> clazz = Class.forName(_classNames[index]);
            ret = (Datatype)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new NSException(e.toString());
        }
        catch (SecurityException e) {
            throw new NSException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new NSException(e.toString());
        }
        catch (InstantiationException e) {
            throw new NSException(e.toString());
        }
        ret._typeIndex = index;
        ret._internalType = type.equalsIgnoreCase("list") ? 3 : (type.equalsIgnoreCase("union") ? 4 : 1);
        return ret;
    }

    public static Datatype createDatatype(Values val) throws NSException {
        return Datatype.createDatatype((IData)val);
    }

    public static Datatype createDatatype(IData val) throws NSException {
        int index;
        Datatype ret = null;
        IDataCursor ic = val.getCursor();
        String clazzName = IDataUtil.getString(ic, KEY_DT_CLASS);
        if (clazzName == null) {
            return null;
        }
        int size = _classNames.length;
        for (index = 0; index < size && !clazzName.equals(_classNames[index]); ++index) {
        }
        if (index == size) {
            throw new NSException("Unknown content type class: " + clazzName);
        }
        try {
            Class<?> clazz = Class.forName(clazzName);
            ret = (Datatype)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new NSException(e.toString());
        }
        catch (SecurityException e) {
            throw new NSException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new NSException(e.toString());
        }
        catch (InstantiationException e) {
            throw new NSException(e.toString());
        }
        ret._typeIndex = index;
        ret.setFromData(val);
        ic.destroy();
        return ret;
    }

    public static final Datatype create(Values values) throws NSException {
        return Datatype.create((IData)values);
    }

    public static final Datatype create(IData values) throws NSException {
        IDataCursor ic = values.getCursor();
        int internalType = internalTypeEnum.getInt(IDataUtil.getString(ic, KEY_DT_INTERNALTYPE), 10);
        ic.destroy();
        switch (internalType) {
            case 1: {
                return Datatype.createDatatype(values);
            }
            case 2: {
                return new DatatypeRef(values);
            }
            case 3: {
                WmList wl = new WmList();
                wl.setFromData(values);
                return wl;
            }
            case 4: {
                WmUnion wu = new WmUnion();
                wu.setFromData(values);
                return wu;
            }
        }
        return null;
    }

    public void setValues(Values val) {
        Object[] in;
        Values[] tempArray;
        Values temp = null;
        temp = (Values)val.get("length");
        if (temp != null) {
            this._length = new FLength();
            this._length.setValues(temp);
        }
        if ((temp = (Values)val.get("minLength")) != null) {
            this._minLength = new FMinLength();
            this._minLength.setValues(temp);
        }
        if ((temp = (Values)val.get("maxLength")) != null) {
            this._maxLength = new FMaxLength();
            this._maxLength.setValues(temp);
        }
        if ((temp = (Values)val.get("totalDigits")) != null) {
            this._totalDigits = new FTotalDigits();
            this._totalDigits.setValues(temp);
        }
        if ((temp = (Values)val.get("fractionDigits")) != null) {
            this._fractionDigits = new FFractionDigits();
            this._fractionDigits.setValues(temp);
        }
        if ((temp = (Values)val.get("whiteSpace")) != null) {
            this._whiteSpace = new FWhiteSpace();
            this._whiteSpace.setValues(temp);
        }
        if ((temp = (Values)val.get("minInclusive")) != null) {
            this._minI = new FMinInclusive();
            this._minI.setValues(temp);
        }
        if ((temp = (Values)val.get("minExclusive")) != null) {
            this._minE = new FMinExclusive();
            this._minE.setValues(temp);
        }
        if ((temp = (Values)val.get("maxInclusive")) != null) {
            this._maxI = new FMaxInclusive();
            this._maxI.setValues(temp);
        }
        if ((temp = (Values)val.get("maxExclusive")) != null) {
            this._maxE = new FMaxExclusive();
            this._maxE.setValues(temp);
        }
        if ((temp = (Values)val.get("pattern")) != null) {
            this._pattern = new FPattern();
            this._pattern.setValues(temp);
        }
        if ((tempArray = (Values[])val.get("enumeration")) != null) {
            this._enum = new FEnumeration[tempArray.length];
            for (int i = 0; i < tempArray.length; ++i) {
                FEnumeration fe = new FEnumeration();
                if (tempArray[i] != null) {
                    fe.setValues(tempArray[i]);
                    this._enum[i] = fe;
                    continue;
                }
                this._enum[i] = null;
            }
        }
        this._ncName = val.getString("name");
        this._internalType = internalTypeEnum.getInt(val.getString(KEY_DT_INTERNALTYPE), 10);
        Object values = val.get("baseType");
        if (values != null && values instanceof Values) {
            try {
                this._base = Datatype.create((Values)values);
            }
            catch (NSException e) {}
        } else {
            this._base = null;
        }
        if ((in = (Object[])val.get(KEY_DT_PARENT_ANCESTORS_HEIRARCHY)) != null) {
            if (this._typeHeirarchy == null) {
                this._typeHeirarchy = new HashSet();
            }
            for (int i = 0; i < in.length; ++i) {
                this._typeHeirarchy.add(QName.create((Values)in[i]));
            }
        } else {
            this._typeHeirarchy = null;
        }
        this._isAbstract = val.getBoolean("abstract");
        this._isExpanded = val.getBoolean(KEY_DT_IS_EXPANDED);
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", Datatype.facetsToValueArray(this._enum)}, {"pattern", this._pattern != null ? this._pattern.getValues() : null}, {"minInclusive", this._minI != null ? this._minI.getValues() : null}, {"minExclusive", this._minE != null ? this._minE.getValues() : null}, {"maxInclusive", this._maxI != null ? this._maxI.getValues() : null}, {"maxExclusive", this._maxE != null ? this._maxE.getValues() : null}, {"totalDigits", this._totalDigits != null ? this._totalDigits.getValues() : null}, {"fractionDigits", this._fractionDigits != null ? this._fractionDigits.getValues() : null}, {"length", this._length != null ? this._length.getValues() : null}, {"minLength", this._minLength != null ? this._minLength.getValues() : null}, {"maxLength", this._maxLength != null ? this._maxLength.getValues() : null}, {"whiteSpace", this._whiteSpace != null ? this._whiteSpace.getValues() : null}, {KEY_DT_CONTENTTYPE, Integer.toString(1)}, {KEY_DT_INTERNALTYPE, internalTypeEnum.getString(this._internalType, "unknown")}, {KEY_DT_CLASS, this._internalType == 1 ? _classNames[this._typeIndex] : null}, {"name", this._ncName}, {KEY_DT_PARENT_ANCESTORS_HEIRARCHY, Datatype.toArray(this._typeHeirarchy)}, {"abstract", this._isAbstract ? "true" : null}, {"baseType", this._base != null ? this._base.getValues() : null}, {"dataTypeVersion", this._version}, {KEY_DT_IS_EXPANDED, this._isExpanded ? "true" : null}};
        return new Values(o);
    }

    public void setFromData(IData val) {
        String isExpanded;
        Object[] in;
        IData[] tempArray;
        IData temp = null;
        IDataCursor ic = val.getCursor();
        temp = (IData)IDataUtil.get(ic, "length");
        if (temp != null) {
            this._length = new FLength();
            this._length.setFromData(temp);
        }
        if ((temp = (IData)IDataUtil.get(ic, "minLength")) != null) {
            this._minLength = new FMinLength();
            this._minLength.setFromData(temp);
        }
        if ((temp = (IData)IDataUtil.get(ic, "maxLength")) != null) {
            this._maxLength = new FMaxLength();
            this._maxLength.setFromData(temp);
        }
        if ((temp = (IData)IDataUtil.get(ic, "totalDigits")) != null) {
            this._totalDigits = new FTotalDigits();
            this._totalDigits.setFromData(temp);
        }
        if ((temp = (IData)IDataUtil.get(ic, "fractionDigits")) != null) {
            this._fractionDigits = new FFractionDigits();
            this._fractionDigits.setFromData(temp);
        }
        if ((temp = (IData)IDataUtil.get(ic, "whiteSpace")) != null) {
            this._whiteSpace = new FWhiteSpace();
            this._whiteSpace.setFromData(temp);
        }
        if ((temp = (IData)IDataUtil.get(ic, "minInclusive")) != null) {
            this._minI = new FMinInclusive();
            this._minI.setFromData(temp);
        }
        if ((temp = (IData)IDataUtil.get(ic, "minExclusive")) != null) {
            this._minE = new FMinExclusive();
            this._minE.setFromData(temp);
        }
        if ((temp = (IData)IDataUtil.get(ic, "maxInclusive")) != null) {
            this._maxI = new FMaxInclusive();
            this._maxI.setFromData(temp);
        }
        if ((temp = (IData)IDataUtil.get(ic, "maxExclusive")) != null) {
            this._maxE = new FMaxExclusive();
            this._maxE.setFromData(temp);
        }
        if ((temp = (IData)IDataUtil.get(ic, "pattern")) != null) {
            this._pattern = new FPattern();
            this._pattern.setFromData(temp);
        }
        if ((tempArray = (IData[])IDataUtil.get(ic, "enumeration")) != null) {
            this._enum = new FEnumeration[tempArray.length];
            for (int i = 0; i < tempArray.length; ++i) {
                FEnumeration fe = new FEnumeration();
                if (tempArray[i] != null) {
                    fe.setFromData(tempArray[i]);
                    this._enum[i] = fe;
                    continue;
                }
                this._enum[i] = null;
            }
        }
        this._ncName = IDataUtil.getString(ic, "name");
        this._internalType = internalTypeEnum.getInt(IDataUtil.getString(ic, KEY_DT_INTERNALTYPE), 10);
        Object values = IDataUtil.get(ic, "baseType");
        if (values != null && values instanceof IData) {
            try {
                this._base = Datatype.create((IData)values);
            }
            catch (NSException e) {}
        } else {
            this._base = null;
        }
        if ((in = (Object[])IDataUtil.get(ic, KEY_DT_PARENT_ANCESTORS_HEIRARCHY)) != null) {
            if (this._typeHeirarchy == null) {
                this._typeHeirarchy = new HashSet();
            }
            for (int i = 0; i < in.length; ++i) {
                this._typeHeirarchy.add(QName.create((IData)in[i]));
            }
        } else {
            this._typeHeirarchy = null;
        }
        this._isAbstract = false;
        if (ic.first("abstract")) {
            this._isAbstract = IDataUtil.getBoolean(ic);
        }
        this._isExpanded = (isExpanded = IDataUtil.getString(ic, KEY_DT_IS_EXPANDED)) != null && isExpanded.equalsIgnoreCase("true");
        ic.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"enumeration", Datatype.facetsToValueArray(this._enum)}, {"pattern", this._pattern != null ? this._pattern.getAsData() : null}, {"minInclusive", this._minI != null ? this._minI.getValues() : null}, {"minExclusive", this._minE != null ? this._minE.getValues() : null}, {"maxInclusive", this._maxI != null ? this._maxI.getValues() : null}, {"maxExclusive", this._maxE != null ? this._maxE.getValues() : null}, {"totalDigits", this._totalDigits != null ? this._totalDigits.getValues() : null}, {"fractionDigits", this._fractionDigits != null ? this._fractionDigits.getValues() : null}, {"length", this._length != null ? this._length.getValues() : null}, {"minLength", this._minLength != null ? this._minLength.getValues() : null}, {"maxLength", this._maxLength != null ? this._maxLength.getValues() : null}, {"whiteSpace", this._whiteSpace != null ? this._whiteSpace.getValues() : null}, {KEY_DT_CONTENTTYPE, Integer.toString(1)}, {KEY_DT_INTERNALTYPE, internalTypeEnum.getString(this._internalType, "unknown")}, {KEY_DT_CLASS, this._internalType == 1 ? _classNames[this._typeIndex] : null}, {"name", this._ncName}, {KEY_DT_PARENT_ANCESTORS_HEIRARCHY, Datatype.toArray(this._typeHeirarchy)}, {"abstract", this._isAbstract ? "true" : null}, {"baseType", this._base != null ? this._base.getValues() : null}, {"dataTypeVersion", this._version}, {KEY_DT_IS_EXPANDED, this._isExpanded ? "true" : null}};
        return new Values(o);
    }

    public void addTo(Hashtable ht) {
        if (this.getName() != null && this.getName().length() > 0) {
            ht.put(this.getName(), this);
        }
    }

    public boolean isDestroyed() {
        return this._isDestroyed;
    }

    public void setDestroyed() {
        this._isDestroyed = true;
    }

    public void setTypeHeirarchy(HashSet typeHeirarchy) {
        this._typeHeirarchy = typeHeirarchy;
    }

    public void setAbstract(boolean isAbstract) {
        this._isAbstract = isAbstract;
    }

    public HashSet getTypeHeirarchy() {
        return this._typeHeirarchy;
    }

    public boolean isAbstract() {
        return this._isAbstract;
    }

    public boolean isValidlyDerivedFrom(QName name) {
        if (this._typeHeirarchy == null) {
            return false;
        }
        return this._typeHeirarchy.contains(name);
    }

    public boolean validate(String data, Object node, Object context, String baseLocationPath) {
        return this.validate(data, context);
    }

    public Object deepClone() {
        Values values = this.getValues();
        Datatype clone = null;
        String type = null;
        String className = this.getClass().getName();
        int size = _classNames.length;
        for (int index = 0; index < size; ++index) {
            if (!className.equals(_classNames[index])) continue;
            type = _typeNames[index];
            break;
        }
        try {
            clone = Datatype.create(type);
            clone.setValues(values);
        }
        catch (NSException e) {
            // empty catch block
        }
        return clone;
    }

    private static final Values[] vectorToArray(Vector vec) {
        if (vec == null) {
            return null;
        }
        Values[] valArray = new Values[vec.size()];
        Enumeration enumvar = vec.elements();
        int i = 0;
        while (enumvar.hasMoreElements()) {
            valArray[i] = ((ValuesCodable)enumvar.nextElement()).getValues();
            ++i;
        }
        return valArray;
    }

    static final Values[] facetsToValueArray(Facet[] facets) {
        if (facets == null) {
            return null;
        }
        Values[] valArray = new Values[facets.length];
        for (int i = 0; i < facets.length; ++i) {
            valArray[i] = facets[i].getValues();
        }
        return valArray;
    }

    private static final Values[] toArray(HashSet set) {
        if (set == null) {
            return null;
        }
        Values[] valArray = new Values[set.size()];
        Iterator it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            valArray[i] = ((ValuesCodable)it.next()).getValues();
            ++i;
        }
        return valArray;
    }

    public void setNamespace(Namespace ns) {
        this._ns = ns;
        this._namespaceIsAvailable = this._ns != null;
    }

    protected boolean isNamespaceAvailable() {
        return this._namespaceIsAvailable;
    }

    protected Namespace getNamespace() {
        if (this.isNamespaceAvailable()) {
            return this._ns;
        }
        return this._owner.getNamespace();
    }

    public static Datatype create(Namespace ns, String type) throws NSException {
        Datatype dt = Datatype.create(type);
        if (dt != null) {
            dt.setNamespace(ns);
        }
        return dt;
    }

    public static final Datatype create(Namespace ns, IData values) throws NSException {
        Datatype dt = Datatype.create(values);
        if (dt != null) {
            dt.setNamespace(ns);
        }
        return dt;
    }

    public static final Datatype create(Namespace ns, QName targetName) {
        DatatypeRef dt = new DatatypeRef(targetName);
        ((Datatype)dt).setNamespace(ns);
        return dt;
    }

    public int compare(Sortable compareTo, boolean reverse, int column) {
        if (compareTo instanceof TypeDef) {
            return this.getName().toLowerCase().compareTo(((TypeDef)compareTo).getName().toLowerCase());
        }
        return 0;
    }

    public abstract boolean equals(String var1, String var2);

    public static void throwNSException(Vector errors, Locale locale) throws NSException {
        StringBuffer sb = new StringBuffer();
        int size = errors.size();
        for (int i = 0; i < size; ++i) {
            sb.append(((LocalizedMessage)errors.elementAt(i)).getLocalizedMessage(locale));
            sb.append('\n');
        }
        throw new NSException(sb.toString());
    }

    boolean checkLengthBoundary(Datatype baseType, VDecimal lenValue) {
        if (baseType == null) {
            return true;
        }
        if (lenValue == null) {
            return false;
        }
        boolean withinBoundary = true;
        VDecimal minL = null;
        VDecimal maxL = null;
        try {
            if (baseType._minLength != null) {
                minL = (VDecimal)baseType._minLength.getValue();
            }
            if (baseType._maxLength != null) {
                maxL = (VDecimal)baseType._maxLength.getValue();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (minL != null && lenValue.lessThan(minL)) {
            withinBoundary = false;
        }
        if (maxL != null && lenValue.greaterThan(maxL)) {
            withinBoundary = false;
        }
        return withinBoundary;
    }

    private boolean checkBoundary() {
        return false;
    }

    public boolean targetExists() {
        return true;
    }

    public QName getQName() {
        if (this._ncName == null) {
            return null;
        }
        if (this.getOwner() == null) {
            return QName.create(null, this._ncName);
        }
        return QName.create(this.getOwner().getTargetNamespace(), this._ncName);
    }

    public abstract int getPrimitiveType();

    public String getPrimitiveName() {
        int type = this.getPrimitiveType();
        if (type != -1 && type < primitiveTypeNames.length) {
            return primitiveTypeNames[type];
        }
        return null;
    }

    public boolean isUnionType() {
        return false;
    }

    public boolean isListType() {
        return false;
    }

    public QName getPrimitiveQName() {
        String name = this.getPrimitiveName();
        QName qName = null;
        if (name != null) {
            qName = QName.create("http://www.w3.org/2001/XMLSchema", name);
        }
        return qName;
    }

    public QName[] getPrimitiveQNames() {
        QName qName = this.getPrimitiveQName();
        if (qName == null) {
            return null;
        }
        QName[] qnArray = new QName[]{qName};
        return qnArray;
    }

    public static void main(String[] args) {
        Datatype st = null;
        try {
            st = Datatype.create("integer");
        }
        catch (Exception ex) {
            // empty catch block
        }
        SimpleType stclone = (SimpleType)st.deepClone();
        System.out.println(st);
        System.out.println("------");
        System.out.println(stclone);
    }

    public void setExpanded(boolean isExpanded) {
        this._isExpanded = isExpanded;
    }

    public boolean isExpanded() {
        return this._isExpanded;
    }

    public NSName getTargetOwnerName() {
        return null;
    }

    public void setTargetOwnerName(NSName name) {
    }

    public XSNode[] edges() {
        ArrayList<W3CKeys> c = new ArrayList<W3CKeys>();
        Datatype baseType = this.getBase();
        if (baseType != null) {
            c.add(baseType);
        }
        Constraint[] constraints = this.getConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            c.add(constraints[i]);
        }
        XSNode[] edges = new XSNode[c.size()];
        c.toArray(edges);
        return edges;
    }

    public boolean isTerminal() {
        return false;
    }

    static {
        internalTypeEnum.addInt("instance", 1);
        internalTypeEnum.addInt("reference", 2);
        internalTypeEnum.addInt("list", 3);
        internalTypeEnum.addInt("union", 4);
        internalTypeEnum.addInt("unknown", 10);
        primitiveTypeNames = new String[]{"string", "boolean", "float", "double", "decimal", "duration", "dateTime", "time", "date", "gYearMonth", "gYear", "gMonthDay", "gDay", "gMonth", "hexBinary", "base64Binary", "anyURI", "QName", "NOTATION"};
    }
}

