/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2;

import com.wm.lang.schema.datatypev2.Errors;
import java.math.BigDecimal;

public class DTUtil
implements Errors {
    static final int WHITE_SPACE_PRESERVE_INT = 3;
    static final int WHITE_SPACE_REPLACE_INT = 2;
    static final int WHITE_SPACE_COLLAPSE_INT = 1;

    public static int getDigitCount(BigDecimal bd) {
        if (bd == null) {
            return -1;
        }
        String s = bd.toString();
        boolean afterPoint = false;
        int digits = 0;
        int iz = 0;
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) {
                ++digits;
                if (!afterPoint) continue;
                if (c == '0') {
                    ++iz;
                    continue;
                }
                iz = 0;
                continue;
            }
            if (c != '.') continue;
            afterPoint = true;
        }
        return digits - iz;
    }

    public static String replace(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        char[] ca = new char[length];
        s.getChars(0, length, ca, 0);
        char ch = '\u0000';
        boolean valueChanged = false;
        for (int i = 0; i < ca.length; ++i) {
            ch = ca[i];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    ca[i] = 32;
                    valueChanged = true;
                }
            }
        }
        if (valueChanged) {
            return new String(ca);
        }
        return s;
    }

    public static String collapse(String s) {
        String cs = DTUtil.replace(s);
        int length = cs.length();
        StringBuffer sb = new StringBuffer(length);
        char ch = '\u0000';
        boolean prevWasSpace = false;
        boolean valueChanged = false;
        block3: for (int i = 0; i < length; ++i) {
            char prevCh = ch;
            ch = cs.charAt(i);
            switch (ch) {
                case ' ': {
                    if (prevWasSpace) continue block3;
                    prevWasSpace = true;
                    sb.append(' ');
                    valueChanged = true;
                    continue block3;
                }
                default: {
                    prevWasSpace = false;
                    sb.append(ch);
                }
            }
        }
        if (valueChanged) {
            return sb.toString().trim();
        }
        return cs;
    }

    public static String handleWhiteSpace(String s, int wsType) {
        if (s == null) {
            return null;
        }
        String hs = null;
        hs = wsType == 2 ? DTUtil.replace(s) : (wsType == 1 ? DTUtil.collapse(s) : s);
        return hs;
    }

    public static String squeeze(String s) {
        String cs = DTUtil.replace(s);
        int length = cs.length();
        StringBuffer sb = new StringBuffer(length);
        char ch = '\u0000';
        block3: for (int i = 0; i < length; ++i) {
            ch = cs.charAt(i);
            switch (ch) {
                case ' ': {
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString().trim();
    }

    public static boolean isNonNegInteger(String lexRep) {
        try {
            int i = Integer.parseInt(lexRep);
            return i >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isPosInteger(String lexRep) {
        try {
            int i = Integer.parseInt(lexRep);
            return i > 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

