/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatypev2;

import com.wm.data.FixedData;
import com.wm.data.MBoolean;
import com.wm.data.MInteger;
import com.wm.lang.schema.W3CKeys;
import com.wm.lang.schema.datatypev2.Datatype2Keys;
import com.wm.lang.xml.ElementNode;
import com.wm.util.QName;
import com.wm.xsd.graph.XSNode;

public class Constraint
extends FixedData
implements Datatype2Keys,
W3CKeys,
XSNode {
    private int VALUE = this.nextID();
    private int FIXED = this.nextID();
    private int FACET_TYPE = this.nextID();
    private int ELEMENT_NODE = this.nextID();
    private int QNAME_ARRAY = this.nextID();
    static String[] _facetNames = new String[]{"length", "minLength", "maxLength", "pattern", "enumeration", "minInclusive", "minExclusive", "maxInclusive", "maxExclusive", "totalDigits", "fractionDigits", "whiteSpace"};
    static int[] _facetTypes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    static final int TYPE_UNKNOWN = -1;

    static final Object[][] s_constraint() {
        return new Object[][]{{"facetType", null}, {"value", null}, {"fixed", null}, {"elementNode", null}, {"qNameArray", null}};
    }

    public static Constraint create() {
        return new Constraint();
    }

    public Constraint() {
        super(Constraint.s_constraint());
    }

    private Constraint(int type, String[] value, boolean isFixed, ElementNode node, QName[] qnArray) {
        this();
        this.setFacetType(type);
        this.setValue(value);
        this.setFixed(isFixed);
        this.setElementNode(node);
        this.setQNameArray(qnArray);
    }

    public static Constraint create(String stype, String[] value, boolean isFixed) {
        int index = -1;
        for (int i = 0; i < _facetNames.length; ++i) {
            if (!_facetNames[i].equals(stype)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            int type = _facetTypes[index];
            return new Constraint(type, value, isFixed, null, null);
        }
        return null;
    }

    public static Constraint create(int type, String[] value, boolean isFixed) {
        return new Constraint(type, value, isFixed, null, null);
    }

    public static Constraint create(int type, String[] value, boolean isFixed, ElementNode enode) {
        return new Constraint(type, value, isFixed, enode, null);
    }

    public static Constraint create(int type, String[] value, boolean isFixed, QName[] qnArray) {
        return new Constraint(type, value, isFixed, null, qnArray);
    }

    public int getFacetType() {
        MInteger i = (MInteger)this.get(this.FACET_TYPE);
        if (i != null) {
            return i.intValue();
        }
        return -1;
    }

    public String[] getValue() {
        return (String[])this.get(this.VALUE);
    }

    public boolean getFixed() {
        MBoolean b = (MBoolean)this.get(this.FIXED);
        if (b != null) {
            return b.booleanValue();
        }
        return false;
    }

    public String getName() {
        int ft = this.getFacetType();
        for (int i = 0; i < _facetTypes.length; ++i) {
            if (ft != _facetTypes[i]) continue;
            return _facetNames[i];
        }
        return null;
    }

    public ElementNode getElementNode() {
        return (ElementNode)this.get(this.ELEMENT_NODE);
    }

    public QName[] getQNameArray() {
        return (QName[])this.get(this.QNAME_ARRAY);
    }

    void setFacetType(int type) {
        this.set(this.FACET_TYPE, (Object)new MInteger(type));
    }

    public void setValue(String[] m) {
        this.set(this.VALUE, (Object)m);
    }

    public void setValue(String s) {
        String[] sa = new String[]{s};
        this.setValue(sa);
    }

    public void setFixed(boolean isFixed) {
        this.set(this.FIXED, (Object)new MBoolean(isFixed));
    }

    public void setElementNode(ElementNode eNode) {
        this.set(this.ELEMENT_NODE, (Object)eNode);
    }

    public void setQNameArray(QName[] qnArray) {
        this.set(this.QNAME_ARRAY, (Object)qnArray);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getFacetType() + "\n\n");
        sb.append(this.getName() + "\n\n");
        sb.append(this.getValue() + "\n\n");
        sb.append(this.getFixed() + "\n\n");
        return sb.toString();
    }

    public boolean isTerminal() {
        return true;
    }
}

