/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;

public class WmUriReference
extends Datatype
implements Errors,
ValuesCodable {
    int _length = -1;
    int _minLength = -1;
    int _maxLength = -1;
    String[] _enum;
    private static NSRecord _nsRecord = null;

    public int getLength() {
        return this._length;
    }

    public int getMinLength() {
        return this._minLength;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public String[] getEnumeration() {
        return this._enum;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public void setMinLength(int minLength) {
        this._minLength = minLength;
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    public void setEnumeration(String[] sa) {
        this._enum = sa;
    }

    public NSRecord getFacetsMetadata() {
        if (_nsRecord == null) {
            String[] tf = new String[]{"true", "false"};
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "length", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minLength", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxLength", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "pattern", 1, 1);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    public IData getFacets() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"length", this._length > -1 ? Integer.toString(this._length) : null}, {"minLength", this._minLength > -1 ? Integer.toString(this._minLength) : null}, {"maxLength", this._maxLength > -1 ? Integer.toString(this._maxLength) : null}};
        IData val = super.getFacets();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacets(IData facets, Locale locale) throws NSException {
        int length = -1;
        int maxLength = -1;
        int minLength = -1;
        Pattern[] patterns = null;
        boolean foundLength = false;
        boolean foundMaxLength = false;
        boolean foundMinLength = false;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        super.setFacets(facets, locale);
        IDataCursor ic = facets.getCursor();
        String data = IDataUtil.getString(ic, "length");
        try {
            if (data != null) {
                length = Integer.parseInt(data);
                if (length > -1) {
                    foundLength = true;
                } else if (length < -1) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_LENGTH, ""));
                }
            }
        }
        catch (NumberFormatException e) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_LENGTH, ""));
        }
        data = IDataUtil.getString(ic, "minLength");
        try {
            if (data != null) {
                minLength = Integer.parseInt(data);
                if (minLength > -1) {
                    foundMinLength = true;
                } else if (minLength < 0) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_LENGTH, ""));
                }
            }
        }
        catch (NumberFormatException e) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_LENGTH, ""));
        }
        data = IDataUtil.getString(ic, "maxLength");
        try {
            if (data != null) {
                maxLength = Integer.parseInt(data);
                if (maxLength > -1) {
                    foundMaxLength = true;
                } else if (maxLength < -1) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_LENGTH, ""));
                }
            }
        }
        catch (NumberFormatException e) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_LENGTH, ""));
        }
        if (foundLength && (foundMinLength || foundMaxLength)) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_FIX_AND_VAR, ""));
        }
        if (foundMaxLength && maxLength < minLength) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXLENGTH_LESS_THAN_MIN, ""));
        }
        String[] enumeration = (String[])IDataUtil.get(ic, "enumeration");
        String[] strPatterns = (String[])IDataUtil.get(ic, "pattern");
        if (strPatterns != null) {
            patterns = new Pattern[strPatterns.length];
            for (int i = 0; i < strPatterns.length; ++i) {
                if (strPatterns[i].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        patterns[i] = _compiler.compile(strPatterns[i]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_REGEX, "", strPatterns[i]));
                }
            }
        }
        if (enumeration != null) {
            int len = enumeration.length;
            for (int i = 0; i < len; ++i) {
                String s = enumeration[i];
                int enumlength = s.length();
                if (length > -1) {
                    if (enumlength != length) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_NOT_EQUAL_LENGTH, "", s));
                    }
                } else {
                    if (enumlength < minLength) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_SHORTER_THAN_LENGTH, "", s));
                    }
                    if (maxLength > -1 && enumlength > maxLength) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_LONGER_THAN_LENGTH, "", s));
                    }
                }
                if (WmUriReference.checkEnumPattern(s, patterns)) continue;
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_NOT_MATCH_PATTERN, "", s));
            }
        }
        ic.destroy();
        if (errors.size() == 0) {
            this._length = length;
            this._minLength = minLength;
            this._maxLength = maxLength;
            this._enum = enumeration;
            this._strPatterns = strPatterns;
            this._patterns = patterns;
        } else {
            WmUriReference.throwNSException(errors, locale);
        }
    }

    public boolean validate(String s, Object context) {
        s = WmUriReference.handleWhiteSpace(s, 3);
        boolean valid = true;
        valid = super.validate(s, context);
        if (!valid) {
            return false;
        }
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        if (this._enum != null) {
            for (int i = 0; i < this._enum.length; ++i) {
                if (!s.equals(this._enum[i])) continue;
                return valid;
            }
            valid = false;
            workspace.addError("DT-Uri001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
            return valid;
        }
        int length = -1;
        if (s != null) {
            length = s.length();
        }
        if (this._length > -1) {
            if (this._length != length) {
                valid = false;
                workspace.addError("DT-Uri004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_EQUAL_LENGTH, ""));
            }
        } else {
            if (this._minLength > -1 && length < this._minLength) {
                valid = false;
                workspace.addError("DT-Uri002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.SHORTER_THAN_LENGTH, ""));
            }
            if (workspace.isCompleted()) {
                return valid;
            }
            if (this._maxLength > -1 && length > this._maxLength) {
                valid = false;
                workspace.addError("DT-Uri003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LONGER_THAN_LENGTH, ""));
            }
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (!this.checkPattern(s, workspace)) {
            valid = false;
        }
        return valid;
    }

    public void setValues(Values val) {
        super.setValues(val);
        this._enum = (String[])val.get("enumeration");
        this._length = val.getInt("length", -1);
        this._minLength = val.getInt("minLength", 0);
        this._maxLength = val.getInt("maxLength", -1);
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"length", Integer.toString(this._length)}, {"minLength", Integer.toString(this._minLength)}, {"maxLength", Integer.toString(this._maxLength)}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setFromData(IData val) {
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        this._enum = (String[])IDataUtil.get(ic, "enumeration");
        this._length = IDataUtil.getInt(ic, "length", -1);
        this._minLength = IDataUtil.getInt(ic, "minLength", 0);
        this._maxLength = IDataUtil.getInt(ic, "maxLength", -1);
        ic.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"length", Integer.toString(this._length)}, {"minLength", Integer.toString(this._minLength)}, {"maxLength", Integer.toString(this._maxLength)}};
        IData val = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    public Values getView() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"length", Integer.toString(this._length)}, {"minLength", Integer.toString(this._minLength)}, {"maxLength", Integer.toString(this._maxLength)}};
        return super.getView().copyFrom(new Values(o));
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }
}

