/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.InterDatatype;
import com.wm.lang.schema.datatype.LegacyFacet;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.lang.schema.dummyWorkSpace;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import com.wm.util.Values;
import com.wm.xsd.graph.XSNode;
import com.wm.xsd.graph.XSNonTerminal;
import com.wm.xsd.util.BuiltInSimpleTypes;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;

public class WmUnion
extends InterDatatype
implements Errors,
XSNonTerminal {
    String[] _enum;
    NSRecord _nsRecord = null;

    public WmUnion(QName[] targetNames) {
        super(targetNames, 4);
    }

    public WmUnion(Datatype[] targetTypes) {
        super(targetTypes);
        this._internalType = 4;
    }

    public WmUnion() {
        this((QName[])null);
    }

    WmUnion(IData values) {
        this.setFromData(values);
        this._internalType = 4;
    }

    WmUnion(Values values) {
        this.setValues(values);
        this._internalType = 4;
    }

    public IData getFacets() {
        IData val = super.getFacets();
        IDataCursor ic = val.getCursor();
        ic.insertAfter("enumeration", this._enum);
        ic.destroy();
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacets(IData facets, Locale locale) throws NSException {
        String[] enumeration;
        String[] strPatterns = null;
        Pattern[] patterns = null;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        super.setFacets(facets, locale);
        IDataCursor ic = facets.getCursor();
        strPatterns = (String[])IDataUtil.get(ic, "pattern");
        if (strPatterns != null) {
            patterns = new Pattern[strPatterns.length];
            for (int i = 0; i < strPatterns.length; ++i) {
                if (strPatterns[i].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        patterns[i] = _compiler.compile(strPatterns[i]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_REGEX, "", strPatterns[i]));
                }
            }
        }
        if ((enumeration = (String[])IDataUtil.get(ic, "enumeration")) != null) {
            String s = null;
            boolean valid = false;
            dummyWorkSpace context = new dummyWorkSpace();
            Datatype datatype = null;
            int len = this.size();
            boolean hasBase = true;
            for (int j = 0; j < enumeration.length; ++j) {
                s = enumeration[j];
                for (int i = 0; i < len; ++i) {
                    datatype = this.getDataType(i);
                    boolean bl = hasBase = datatype.getBase() != null;
                    if (!hasBase || datatype != null && (valid = datatype.validate(s, context))) break;
                }
                if (valid || !hasBase) continue;
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM, "", s));
            }
        }
        if (errors.size() == 0) {
            this._enum = enumeration;
            this._strPatterns = strPatterns;
        } else {
            WmUnion.throwNSException(errors, locale);
        }
        ic.destroy();
    }

    public NSRecord getFacetsMetadata() {
        if (this._nsRecord == null) {
            this._nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            this._nsRecord.addField(nsf);
            nsf = new NSField(null, "pattern", 1, 1);
            this._nsRecord.addField(nsf);
        }
        return this._nsRecord;
    }

    public boolean validate(String s, Object context) {
        dummyWorkSpace dContext;
        int i;
        boolean valid = true;
        valid = super.validate(s, context);
        if (!valid) {
            return false;
        }
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        Datatype datatype = null;
        int len = this.size();
        boolean isValid = false;
        for (i = 0; !(i >= len || (datatype = this.getDataType(i)) != null && (isValid = datatype.validate(s, dContext = new dummyWorkSpace()))); ++i) {
        }
        if (!isValid) {
            valid = false;
            workspace.addError("DT-Union002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (!this.checkPattern(s, workspace)) {
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._enum != null) {
            datatype = null;
            for (i = 0; i < len; ++i) {
                datatype = this.getDataType(i);
                if (datatype == null || !datatype.validate(s, dContext = new dummyWorkSpace())) continue;
                for (int j = 0; j < this._enum.length; ++j) {
                    if (!datatype.validate(this._enum[j], dContext) || !datatype.equals(s, this._enum[j])) continue;
                    return valid;
                }
            }
            valid = false;
            workspace.addError("DT-Union001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
            return valid;
        }
        return valid;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"internalType", "union"}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        super.setValues(val);
        this._enum = (String[])val.get("enumeration");
    }

    public IData getAsData() {
        IData val = super.getAsData();
        IDataCursor ic = val.getCursor();
        ic.insertAfter("enumeration", this._enum);
        ic.insertAfter("internalType", "union");
        ic.destroy();
        return val;
    }

    public void setFromData(IData val) {
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        this._enum = (String[])IDataUtil.get(ic, "enumeration");
        ic.destroy();
    }

    public Values getView() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}};
        return super.getView().copyFrom(new Values(o));
    }

    public String getName() {
        if (this._ncName != null && this._ncName.length() > 0) {
            return this._ncName;
        }
        return this.getSourceName();
    }

    public boolean isProxy() {
        return false;
    }

    public boolean isUnionType() {
        return true;
    }

    public XSNode[] edges() {
        ArrayList<XSNode> c = new ArrayList<XSNode>();
        IData facets = this.getFacets();
        String[] keys = this.getFacetKeys();
        Datatype baseType = this.getBase();
        if (baseType != null && !baseType.isProxy()) {
            c.add(baseType);
        }
        int len = this.size();
        for (int j = 0; j < len; ++j) {
            Datatype memberType = this.getDataType(j);
            if (memberType == null) continue;
            QName memberTypeQName = memberType.getQName();
            if (memberTypeQName != null && BuiltInSimpleTypes.isBuiltIn(memberTypeQName)) {
                c.add(memberType);
            }
            if (memberTypeQName != null) continue;
            c.add(memberType);
        }
        IDataCursor fc = facets.getCursor();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Object value = IDataUtil.get(fc, keys[i]);
            c.add(new LegacyFacet(key, value));
        }
        XSNode[] edges = new XSNode[c.size()];
        c.toArray(edges);
        return edges;
    }
}

