/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.lang.schema.dummyWorkSpace;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;

public class WmTimePeriod
extends Datatype
implements Errors,
ValuesCodable {
    String _duration;
    String _period = "P0Y";
    String[] _enum;
    String _minInclusive;
    String _minExclusive;
    String _maxInclusive;
    String _maxExclusive;
    GregorianCalendar _lmaxInclusive;
    GregorianCalendar _lmaxExclusive;
    GregorianCalendar _lminInclusive;
    GregorianCalendar _lminExclusive;
    private static NSRecord _nsRecord = null;

    public String getDuration() {
        return this._duration;
    }

    public String[] getEnumeration() {
        return this._enum;
    }

    public String getMaxInclusive() {
        return this._maxInclusive;
    }

    public String getMaxExclusive() {
        return this._maxExclusive;
    }

    public String getMinInclusive() {
        return this._minInclusive;
    }

    public String getMinExclusive() {
        return this._minExclusive;
    }

    public GregorianCalendar getlMaxInclusive() {
        return this._lmaxInclusive;
    }

    public GregorianCalendar getlMaxExclusive() {
        return this._lmaxExclusive;
    }

    public GregorianCalendar getlMinInclusive() {
        return this._lminInclusive;
    }

    public GregorianCalendar getlMinExclusive() {
        return this._lminExclusive;
    }

    public void setDuration(String duration) {
        this._duration = duration;
    }

    public void setEnumeration(String[] sa) {
        this._enum = sa;
    }

    public void setMaxInclusive(String maxInclusive) {
        this._maxInclusive = maxInclusive;
    }

    public void setMaxExclusive(String maxExclusive) {
        this._maxExclusive = maxExclusive;
    }

    public void setMinInclusive(String minInclusive) {
        this._minInclusive = minInclusive;
    }

    public void setMinExclusive(String minExclusive) {
        this._minExclusive = minExclusive;
    }

    public void setlMaxInclusive(GregorianCalendar lmaxInclusive) {
        this._lmaxInclusive = lmaxInclusive;
    }

    public void setlMaxExclusive(GregorianCalendar lmaxExclusive) {
        this._lmaxExclusive = lmaxExclusive;
    }

    public void setlMinInclusive(GregorianCalendar lminInclusive) {
        this._lminInclusive = lminInclusive;
    }

    public void setlMinExclusive(GregorianCalendar lminExclusive) {
        this._lminExclusive = lminExclusive;
    }

    public NSRecord getFacetsMetadata() {
        if (_nsRecord == null) {
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "duration", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "period", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "enumeration", 1, 1);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "pattern", 1, 1);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    public IData getFacets() {
        IData val = super.getFacets();
        IDataCursor ic = val.getCursor();
        ic.insertAfter("enumeration", this._enum);
        ic.insertAfter("duration", this._duration);
        ic.insertAfter("period", this._period);
        ic.insertAfter("minInclusive", this._minInclusive);
        ic.insertAfter("minExclusive", this._minExclusive);
        ic.insertAfter("maxInclusive", this._maxInclusive);
        ic.insertAfter("maxExclusive", this._maxExclusive);
        ic.destroy();
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacets(IData facets, Locale locale) throws NSException {
        int i;
        GregorianCalendar maxInclusive = null;
        GregorianCalendar maxExclusive = null;
        GregorianCalendar minInclusive = null;
        GregorianCalendar minExclusive = null;
        Pattern[] patterns = null;
        boolean foundMinI = false;
        boolean foundMaxI = false;
        boolean foundMinE = false;
        boolean foundMaxE = false;
        Vector<Object> errors = new Vector<Object>();
        GregorianCalendar value = null;
        super.setFacets(facets, locale);
        IDataCursor ic = facets.getCursor();
        String duration = IDataUtil.getString(ic, "duration");
        String period = IDataUtil.getString(ic, "period");
        if (period != null && !period.equals("P0Y")) {
            errors.addElement("period value is fixed, you can't modify it ");
        }
        String minI = IDataUtil.getString(ic, "minInclusive");
        String minE = IDataUtil.getString(ic, "minExclusive");
        String maxI = IDataUtil.getString(ic, "maxInclusive");
        String maxE = IDataUtil.getString(ic, "maxExclusive");
        if (minI != null) {
            foundMinI = true;
            try {
                minInclusive = WmTimePeriod.convertToGClender(minI);
            }
            catch (NSException e) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_I_WITH_SUB, "", e.toString());
            }
            if (minE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MINI_AND_MINE, ""));
            }
        } else {
            try {
                if (minE != null) {
                    foundMinE = true;
                    minExclusive = WmTimePeriod.convertToGClender(minE);
                }
            }
            catch (NSException e) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_E_WITH_SUB, "", e.toString());
            }
        }
        if (maxI != null) {
            foundMaxI = true;
            try {
                maxInclusive = WmTimePeriod.convertToGClender(maxI);
            }
            catch (NSException e) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_I_WITH_SUB, "", e.toString());
            }
            if (maxE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MAXI_AND_MAXE, ""));
            }
        } else {
            try {
                if (maxE != null) {
                    foundMaxE = true;
                    maxExclusive = WmTimePeriod.convertToGClender(maxE);
                }
            }
            catch (NSException e) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_E_WITH_SUB, "", e.toString());
            }
        }
        if (foundMaxI) {
            if (foundMinI && maxInclusive != null && minInclusive != null && maxInclusive.before(minInclusive)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINI, ""));
            }
            if (foundMinE && maxInclusive != null && minExclusive != null && maxInclusive.before(minExclusive)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINE, ""));
            }
        }
        if (foundMaxE) {
            if (foundMinI && maxExclusive != null && minInclusive != null && maxExclusive.before(minInclusive)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINI, ""));
            }
            if (foundMinE && maxExclusive != null && minExclusive != null && maxExclusive.before(minExclusive)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINE, ""));
            }
        }
        String[] enumvar = (String[])IDataUtil.get(ic, "enumeration");
        String[] strPatterns = (String[])IDataUtil.get(ic, "pattern");
        if (strPatterns != null) {
            patterns = new Pattern[strPatterns.length];
            for (i = 0; i < strPatterns.length; ++i) {
                if (strPatterns[i].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        patterns[i] = _compiler.compile(strPatterns[i]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_REGEX, "", strPatterns[i]));
                }
            }
        }
        if (enumvar != null) {
            for (i = 0; i < enumvar.length; ++i) {
                String enumerationItem = enumvar[i];
                try {
                    value = WmTimePeriod.convertToGClender(enumerationItem);
                }
                catch (NSException e) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM, "", enumerationItem));
                }
                if (foundMaxI) {
                    if (foundMinI) {
                        if (value.before(minInclusive) || value.after(maxInclusive)) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumerationItem));
                        }
                    } else if (foundMinE && (value.before(minExclusive) || value.equals(minExclusive) || value.after(maxInclusive))) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumerationItem));
                    }
                } else if (foundMaxE) {
                    if (foundMinI) {
                        if (value.before(minInclusive) || value.after(maxExclusive) || value.equals(maxExclusive)) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumerationItem));
                        }
                    } else if (foundMinE && (value.before(minExclusive) || value.equals(minExclusive) || value.after(maxExclusive) || value.equals(maxExclusive))) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumerationItem));
                    }
                }
                if (!WmTimePeriod.checkEnumPattern(enumerationItem, patterns)) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_NOT_MATCH_PATTERN, "", enumerationItem));
                }
                enumvar[i] = enumerationItem;
            }
        }
        ic.destroy();
        if (errors.size() == 0) {
            this._duration = duration;
            this._minInclusive = minI;
            this._minExclusive = minE;
            this._maxInclusive = maxI;
            this._maxExclusive = maxE;
            this._lmaxInclusive = maxInclusive;
            this._lmaxExclusive = maxExclusive;
            this._lminInclusive = minInclusive;
            this._lminExclusive = minExclusive;
            this._enum = enumvar;
            this._strPatterns = strPatterns;
            this._patterns = patterns;
        } else {
            WmTimePeriod.throwNSException(errors, locale);
        }
    }

    public boolean validate(String s, Object context) {
        GregorianCalendar value;
        s = WmTimePeriod.handleWhiteSpace(s, 3);
        boolean valid = true;
        valid = super.validate(s, context);
        if (!valid) {
            return false;
        }
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        if (this._enum != null) {
            for (int i = 0; i < this._enum.length; ++i) {
                if (!s.equals(this._enum[i])) continue;
                return valid;
            }
            valid = false;
            workspace.addError("DT-TimePeriod002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
            return valid;
        }
        try {
            value = WmTimePeriod.convertToGClender(s);
        }
        catch (Exception e) {
            valid = false;
            workspace.addError("DT-TimePeriod001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
            return valid;
        }
        if (this._minInclusive != null && value.before(this._lminInclusive)) {
            workspace.addError("DT-TimePeriod003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._minExclusive != null && (value.before(this._lminExclusive) || value.equals(this._lminExclusive))) {
            workspace.addError("DT-TimePeriod003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._maxInclusive != null && value.after(this._lmaxInclusive)) {
            workspace.addError("DT-TimePeriod004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._maxExclusive != null && (value.after(this._lmaxExclusive) || value.equals(this._lmaxExclusive))) {
            workspace.addError("DT-TimePeriod004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (!this.checkPattern(s, workspace)) {
            valid = false;
        }
        return valid;
    }

    public void setValues(Values val) {
        String s = null;
        super.setValues(val);
        String[] sa = null;
        sa = (String[])val.get("enumeration");
        if (sa != null) {
            this._enum = sa;
        }
        if ((s = val.getString("duration")) != null) {
            this._duration = s;
        }
        this._minInclusive = val.getString("minInclusive");
        this._minExclusive = val.getString("minExclusive");
        this._maxInclusive = val.getString("maxInclusive");
        this._maxExclusive = val.getString("maxExclusive");
        if (this._minInclusive != null) {
            try {
                this._lminInclusive = WmTimePeriod.convertToGClender(this._minInclusive);
            }
            catch (Exception e) {
                this._lminInclusive = null;
            }
        }
        if (this._minExclusive != null) {
            try {
                this._lminExclusive = WmTimePeriod.convertToGClender(this._minExclusive);
            }
            catch (Exception e) {
                this._lminExclusive = null;
            }
        }
        if (this._maxInclusive != null) {
            try {
                this._lmaxInclusive = WmTimePeriod.convertToGClender(this._maxInclusive);
            }
            catch (Exception e) {
                this._lmaxInclusive = null;
            }
        }
        if (this._maxExclusive != null) {
            try {
                this._lmaxExclusive = WmTimePeriod.convertToGClender(this._maxExclusive);
            }
            catch (Exception e) {
                this._lmaxExclusive = null;
            }
        }
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"duration", this._duration}, {"period", this._period}, {"minInclusive", this._minInclusive}, {"minExclusive", this._minExclusive}, {"maxInclusive", this._maxInclusive}, {"maxExclusive", this._maxExclusive}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setFromData(IData val) {
        String s = null;
        super.setFromData(val);
        String[] sa = null;
        IDataCursor ic = val.getCursor();
        sa = (String[])IDataUtil.get(ic, "enumeration");
        if (sa != null) {
            this._enum = sa;
        }
        if ((s = IDataUtil.getString(ic, "duration")) != null) {
            this._duration = s;
        }
        this._minInclusive = IDataUtil.getString(ic, "minInclusive");
        this._minExclusive = IDataUtil.getString(ic, "minExclusive");
        this._maxInclusive = IDataUtil.getString(ic, "maxInclusive");
        this._maxExclusive = IDataUtil.getString(ic, "maxExclusive");
        ic.destroy();
        if (this._minInclusive != null) {
            try {
                this._lminInclusive = WmTimePeriod.convertToGClender(this._minInclusive);
            }
            catch (Exception e) {
                this._lminInclusive = null;
            }
        }
        if (this._minExclusive != null) {
            try {
                this._lminExclusive = WmTimePeriod.convertToGClender(this._minExclusive);
            }
            catch (Exception e) {
                this._lminExclusive = null;
            }
        }
        if (this._maxInclusive != null) {
            try {
                this._lmaxInclusive = WmTimePeriod.convertToGClender(this._maxInclusive);
            }
            catch (Exception e) {
                this._lmaxInclusive = null;
            }
        }
        if (this._maxExclusive != null) {
            try {
                this._lmaxExclusive = WmTimePeriod.convertToGClender(this._maxExclusive);
            }
            catch (Exception e) {
                this._lmaxExclusive = null;
            }
        }
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"duration", this._duration}, {"period", this._period}, {"minInclusive", this._minInclusive}, {"minExclusive", this._minExclusive}, {"maxInclusive", this._maxInclusive}, {"maxExclusive", this._maxExclusive}};
        IData val = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        try {
            GregorianCalendar b1 = WmTimePeriod.convertToGClender(s1);
            GregorianCalendar b2 = WmTimePeriod.convertToGClender(s2);
            return b1.equals(b2);
        }
        catch (NSException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        WmTimePeriod wtp = new WmTimePeriod();
        Object[][] o = new Object[][]{{"duration", "P0Y1M"}, {"minInclusive", "1999-05-01"}, {"minExclusive", null}, {"maxInclusive", null}, {"maxExclusive", "2022-03"}};
        Values val = new Values(o);
        try {
            wtp.setFacets(val);
        }
        catch (NSException e) {
            e.printStackTrace();
        }
        dummyWorkSpace context = new dummyWorkSpace();
        boolean pass = wtp.validate("-2034-05-12", context);
        System.out.println(pass);
    }
}

