/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.lang.schema.dummyWorkSpace;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;

public class WmTimeDuration
extends Datatype
implements Errors,
ValuesCodable {
    private static final long secOfyear = 31536000L;
    private static final long secOfMon = 2592000L;
    private static final long secOfDay = 86400L;
    private static final long secOfHour = 3600L;
    String[] _enum;
    double _minInclusive;
    double _minExclusive;
    double _maxInclusive;
    double _maxExclusive;
    String _sminInclusive;
    String _sminExclusive;
    String _smaxInclusive;
    String _smaxExclusive;
    boolean _initialized = false;
    boolean _foundMinI = false;
    boolean _foundMinE = false;
    boolean _foundMaxI = false;
    boolean _foundMaxE = false;
    private static NSRecord _nsRecord = null;

    public String[] getEnumeration() {
        return this._enum;
    }

    public double getMaxInclusive() {
        return this._maxInclusive;
    }

    public double getMaxExclusive() {
        return this._maxExclusive;
    }

    public double getMinInclusive() {
        return this._minInclusive;
    }

    public double getMinExclusive() {
        return this._minExclusive;
    }

    public void setEnumeration(String[] sa) {
        this._enum = sa;
    }

    public void setMaxInclusive(double maxInclusive) {
        this._maxInclusive = maxInclusive;
    }

    public void setMaxExclusive(double maxExclusive) {
        this._maxExclusive = maxExclusive;
    }

    public void setMinInclusive(double minInclusive) {
        this._minInclusive = minInclusive;
    }

    public void setMinExclusive(double minExclusive) {
        this._minExclusive = minExclusive;
    }

    public NSRecord getFacetsMetadata() {
        if (_nsRecord == null) {
            String[] tf = new String[]{"true", "false"};
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "pattern", 1, 1);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    public IData getFacets() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"minInclusive", this._initialized && this._foundMinI ? this._sminInclusive : null}, {"minExclusive", this._initialized && this._foundMinE ? this._sminExclusive : null}, {"maxInclusive", this._initialized && this._foundMaxI ? this._smaxInclusive : null}, {"maxExclusive", this._initialized && this._foundMaxE ? this._smaxExclusive : null}};
        IData val = super.getFacets();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacets(IData facets, Locale locale) throws NSException {
        double maxInclusive = Double.MAX_VALUE;
        double maxExclusive = Double.MAX_VALUE;
        double minInclusive = Double.MIN_VALUE;
        double minExclusive = Double.MIN_VALUE;
        Pattern[] patterns = null;
        boolean foundMinI = false;
        boolean foundMaxI = false;
        boolean foundMinE = false;
        boolean foundMaxE = false;
        Vector<Object> errors = new Vector<Object>();
        double value = Double.MIN_VALUE;
        super.setFacets(facets, locale);
        this._initialized = true;
        IDataCursor ic = facets.getCursor();
        String minI = IDataUtil.getString(ic, "minInclusive");
        String minE = IDataUtil.getString(ic, "minExclusive");
        String maxI = IDataUtil.getString(ic, "maxInclusive");
        String maxE = IDataUtil.getString(ic, "maxExclusive");
        if (minI != null) {
            foundMinI = true;
            try {
                minInclusive = WmTimeDuration.convertToSeconds(minI);
            }
            catch (NSException e) {
                errors.addElement(e.toString());
            }
            if (minE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MINI_AND_MINE, ""));
            }
        } else {
            try {
                if (minE != null) {
                    foundMinE = true;
                    minExclusive = WmTimeDuration.convertToSeconds(minE);
                }
            }
            catch (NSException e) {
                errors.addElement(e.toString());
            }
        }
        if (maxI != null) {
            foundMaxI = true;
            try {
                maxInclusive = WmTimeDuration.convertToSeconds(maxI);
            }
            catch (NSException e) {
                errors.addElement(e.toString());
            }
            if (maxE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MAXI_AND_MAXE, ""));
            }
        } else {
            try {
                if (maxE != null) {
                    foundMaxE = true;
                    maxExclusive = WmTimeDuration.convertToSeconds(maxE);
                }
            }
            catch (NSException e) {
                errors.addElement(e.toString());
            }
        }
        if (foundMaxI) {
            if (foundMinI && maxInclusive < minInclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINI, ""));
            }
            if (foundMinE && maxInclusive < minExclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINE, ""));
            }
        }
        if (foundMaxE) {
            if (foundMinI && maxExclusive < minInclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINI, ""));
            }
            if (foundMinE && maxExclusive < minExclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINE, ""));
            }
        }
        String[] enumvar = (String[])IDataUtil.get(ic, "enumeration");
        String[] strPatterns = (String[])IDataUtil.get(ic, "pattern");
        if (strPatterns != null) {
            patterns = new Pattern[strPatterns.length];
            for (int i = 0; i < strPatterns.length; ++i) {
                if (strPatterns[i].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        patterns[i] = _compiler.compile(strPatterns[i]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_REGEX, "", strPatterns[i]));
                }
            }
        }
        if (enumvar != null) {
            for (int i = 0; i < enumvar.length; ++i) {
                String enumerationItem = enumvar[i];
                try {
                    value = WmTimeDuration.convertToSeconds(enumerationItem);
                }
                catch (NSException e) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM, "", enumerationItem));
                }
                if (foundMaxI) {
                    if (foundMinI) {
                        if (value < minInclusive || value > maxInclusive) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumerationItem));
                        }
                    } else if (foundMinE && (value <= minExclusive || value > maxInclusive)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumerationItem));
                    }
                } else if (foundMaxE) {
                    if (foundMinI) {
                        if (value < minInclusive || value >= maxExclusive) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumerationItem));
                        }
                    } else if (foundMinE && (value <= minExclusive || value >= maxExclusive)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumerationItem));
                    }
                }
                if (!WmTimeDuration.checkEnumPattern(enumerationItem, patterns)) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_NOT_MATCH_PATTERN, "", enumerationItem));
                }
                enumvar[i] = enumerationItem;
            }
        }
        ic.destroy();
        if (errors.size() == 0) {
            if (foundMinI) {
                this._minInclusive = minInclusive;
                this._sminInclusive = minI;
            }
            if (foundMinE) {
                this._minExclusive = minExclusive;
                this._sminExclusive = minE;
            }
            if (foundMaxI) {
                this._maxInclusive = maxInclusive;
                this._smaxInclusive = maxI;
            }
            if (foundMaxE) {
                this._maxExclusive = maxExclusive;
                this._smaxExclusive = maxE;
            }
            this._enum = enumvar;
            this._strPatterns = strPatterns;
            this._patterns = patterns;
            this._foundMinI = foundMinI;
            this._foundMinE = foundMinE;
            this._foundMaxI = foundMaxI;
            this._foundMaxE = foundMaxE;
        } else {
            WmTimeDuration.throwNSException(errors, locale);
        }
    }

    public boolean validate(String s, Object context) {
        double value;
        s = WmTimeDuration.handleWhiteSpace(s, 3);
        boolean valid = true;
        valid = super.validate(s, context);
        if (!valid) {
            return false;
        }
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        try {
            value = WmTimeDuration.convertToSeconds(s);
        }
        catch (NSException e) {
            valid = false;
            workspace.addError("DT-TimeDuration004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
            return valid;
        }
        if (this._enum != null) {
            for (int i = 0; i < this._enum.length; ++i) {
                if (!s.equals(this._enum[i])) continue;
                return valid;
            }
            valid = false;
            workspace.addError("DT-TimeDuration001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
            return valid;
        }
        if (this._sminInclusive != null && value < this._minInclusive) {
            workspace.addError("DT-TimeDuration002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._sminExclusive != null && value <= this._minExclusive) {
            workspace.addError("DT-TimeDuration002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._smaxInclusive != null && value > this._maxInclusive) {
            workspace.addError("DT-TimeDuration003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._smaxExclusive != null && value >= this._maxExclusive) {
            workspace.addError("DT-TimeDuration003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (!this.checkPattern(s, workspace)) {
            valid = false;
        }
        return valid;
    }

    public void setValues(Values val) {
        String s = null;
        super.setValues(val);
        String[] sa = null;
        sa = (String[])val.get("enumeration");
        if (sa != null) {
            this._enum = sa;
        }
        this._foundMinI = val.getBoolean("foundMinI");
        this._foundMinE = val.getBoolean("foundMinE");
        this._foundMaxI = val.getBoolean("foundMaxI");
        this._foundMaxE = val.getBoolean("foundMaxE");
        this._initialized = val.getBoolean("initialized");
        try {
            this._sminInclusive = s = val.getString("minInclusive");
            if (s != null) {
                this._minInclusive = WmTimeDuration.convertToSeconds(s);
            }
        }
        catch (NSException e) {
            this._sminInclusive = null;
        }
        try {
            this._sminExclusive = s = val.getString("minExclusive");
            if (s != null) {
                this._minExclusive = WmTimeDuration.convertToSeconds(s);
            }
        }
        catch (NSException e) {
            this._sminExclusive = null;
        }
        try {
            this._smaxInclusive = s = val.getString("maxInclusive");
            if (s != null) {
                this._maxInclusive = WmTimeDuration.convertToSeconds(s);
            }
        }
        catch (NSException e) {
            this._smaxInclusive = null;
        }
        try {
            this._smaxExclusive = s = val.getString("maxExclusive");
            if (s != null) {
                this._maxExclusive = WmTimeDuration.convertToSeconds(s);
            }
        }
        catch (NSException e) {
            this._smaxExclusive = null;
        }
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"foundMinI", new Boolean(this._foundMinI).toString()}, {"foundMinE", new Boolean(this._foundMinE).toString()}, {"foundMaxI", new Boolean(this._foundMaxI).toString()}, {"foundMaxE", new Boolean(this._foundMaxE).toString()}, {"initialized", new Boolean(this._initialized).toString()}, {"minInclusive", this._initialized && this._foundMinI ? this._sminInclusive : null}, {"minExclusive", this._initialized && this._foundMinE ? this._sminExclusive : null}, {"maxInclusive", this._initialized && this._foundMaxI ? this._smaxInclusive : null}, {"maxExclusive", this._initialized && this._foundMaxE ? this._smaxExclusive : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setFromData(IData data) {
        String s = null;
        super.setFromData(data);
        IDataCursor idc = data.getCursor();
        if (idc.first("enumeration")) {
            this._enum = IDataUtil.getStringArray(idc);
        }
        this._foundMinI = IDataUtil.getBoolean(idc, "foundMinI");
        this._foundMinE = IDataUtil.getBoolean(idc, "foundMinE");
        this._foundMaxI = IDataUtil.getBoolean(idc, "foundMaxI");
        this._foundMaxE = IDataUtil.getBoolean(idc, "foundMaxE");
        this._initialized = IDataUtil.getBoolean(idc, "initialized");
        try {
            this._sminInclusive = s = IDataUtil.getString(idc, "minInclusive");
            if (s != null) {
                this._minInclusive = WmTimeDuration.convertToSeconds(s);
            }
        }
        catch (NSException e) {
            this._sminInclusive = null;
        }
        try {
            this._sminExclusive = s = IDataUtil.getString(idc, "minExclusive");
            if (s != null) {
                this._minExclusive = WmTimeDuration.convertToSeconds(s);
            }
        }
        catch (NSException e) {
            this._sminExclusive = null;
        }
        try {
            this._smaxInclusive = s = IDataUtil.getString(idc, "maxInclusive");
            if (s != null) {
                this._maxInclusive = WmTimeDuration.convertToSeconds(s);
            }
        }
        catch (NSException e) {
            this._smaxInclusive = null;
        }
        try {
            this._smaxExclusive = s = IDataUtil.getString(idc, "maxExclusive");
            if (s != null) {
                this._maxExclusive = WmTimeDuration.convertToSeconds(s);
            }
        }
        catch (NSException e) {
            this._smaxExclusive = null;
        }
        idc.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"foundMinI", new Boolean(this._foundMinI).toString()}, {"foundMinE", new Boolean(this._foundMinE).toString()}, {"foundMaxI", new Boolean(this._foundMaxI).toString()}, {"foundMaxE", new Boolean(this._foundMaxE).toString()}, {"initialized", new Boolean(this._initialized).toString()}, {"minInclusive", this._initialized && this._foundMinI ? this._sminInclusive : null}, {"minExclusive", this._initialized && this._foundMinE ? this._sminExclusive : null}, {"maxInclusive", this._initialized && this._foundMaxI ? this._smaxInclusive : null}, {"minExclusive", this._initialized && this._foundMaxE ? this._smaxExclusive : null}};
        IData data = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), data);
        return data;
    }

    public Values getView() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"foundMinI", new Boolean(this._foundMinI).toString()}, {"foundMinE", new Boolean(this._foundMinE).toString()}, {"foundMaxI", new Boolean(this._foundMaxI).toString()}, {"foundMaxE", new Boolean(this._foundMaxE).toString()}, {"initialized", new Boolean(this._initialized).toString()}, {"minInclusive", this._initialized && this._foundMinI ? this._sminInclusive : null}, {"minExclusive", this._initialized && this._foundMinE ? this._sminExclusive : null}, {"maxInclusive", this._initialized && this._foundMaxI ? this._smaxInclusive : null}, {"minExclusive", this._initialized && this._foundMaxE ? this._smaxExclusive : null}};
        return super.getView().copyFrom(new Values(o));
    }

    static final double[] convertToSecondsArray(String[] isoArray) {
        double[] seca = null;
        if (isoArray == null) {
            return null;
        }
        seca = new double[isoArray.length];
        for (int index = 0; index < isoArray.length; ++index) {
            try {
                seca[index] = WmTimeDuration.convertToSeconds(isoArray[index]);
                continue;
            }
            catch (NSException nSException) {
                // empty catch block
            }
        }
        return seca;
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        try {
            double b1 = WmTimeDuration.convertToSeconds(s1);
            double b2 = WmTimeDuration.convertToSeconds(s2);
            if (b1 == b2) {
                return true;
            }
        }
        catch (NSException e) {
            return false;
        }
        return false;
    }

    public static void main(String[] args) {
        WmTimeDuration wr = new WmTimeDuration();
        Object[][] o = new Object[][]{{"duration", "P0Y1M"}, {"period", "P0Y2M"}, {"minInclusive", null}, {"minExclusive", null}, {"maxInclusive", "P1Y"}, {"maxExclusive", null}};
        Values val = new Values(o);
        try {
            wr.setFacets(val);
            dummyWorkSpace context = new dummyWorkSpace();
            wr.validate("P2Y", context);
        }
        catch (NSException e) {
            e.printStackTrace();
        }
    }
}

