/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;

public class WmTime
extends Datatype
implements Errors,
ValuesCodable {
    String[] _enum;
    String _duration = "P0Y";
    String _period = "PT24H";
    String _minInclusive;
    String _minExclusive;
    String _maxInclusive;
    String _maxExclusive;
    double _lmaxInclusive;
    double _lmaxExclusive;
    double _lminInclusive;
    double _lminExclusive;
    private static NSRecord _nsRecord = null;

    public String[] getEnumeration() {
        return this._enum;
    }

    public String getMaxInclusive() {
        return this._maxInclusive;
    }

    public String getMaxExclusive() {
        return this._maxExclusive;
    }

    public String getMinInclusive() {
        return this._minInclusive;
    }

    public String getMinExclusive() {
        return this._minExclusive;
    }

    public double getlMaxInclusive() {
        return this._lmaxInclusive;
    }

    public double getlMaxExclusive() {
        return this._lmaxExclusive;
    }

    public double getlMinInclusive() {
        return this._lminInclusive;
    }

    public double getlMinExclusive() {
        return this._lminExclusive;
    }

    public void setEnumeration(String[] sa) {
        this._enum = sa;
    }

    public void setMaxInclusive(String maxInclusive) {
        this._maxInclusive = maxInclusive;
    }

    public void setMaxExclusive(String maxExclusive) {
        this._maxExclusive = maxExclusive;
    }

    public void setMinInclusive(String minInclusive) {
        this._minInclusive = minInclusive;
    }

    public void setMinExclusive(String minExclusive) {
        this._minExclusive = minExclusive;
    }

    public void setlMaxInclusive(double lmaxInclusive) {
        this._lmaxInclusive = lmaxInclusive;
    }

    public void setlMaxExclusive(double lmaxExclusive) {
        this._lmaxExclusive = lmaxExclusive;
    }

    public void setlMinInclusive(double lminInclusive) {
        this._lminInclusive = lminInclusive;
    }

    public void setlMinExclusive(double lminExclusive) {
        this._lminExclusive = lminExclusive;
    }

    public NSRecord getFacetsMetadata() {
        if (_nsRecord == null) {
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "duration", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "period", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "pattern", 1, 1);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    public IData getFacets() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"duration", this._duration}, {"period", this._period}, {"minInclusive", this._minInclusive}, {"minExclusive", this._minExclusive}, {"maxInclusive", this._maxInclusive}, {"maxExclusive", this._maxExclusive}};
        IData val = super.getFacets();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacets(IData facets, Locale locale) throws NSException {
        String period;
        double maxInclusive = Double.MAX_VALUE;
        double maxExclusive = Double.MAX_VALUE;
        double minInclusive = Double.MIN_VALUE;
        double minExclusive = Double.MIN_VALUE;
        double value = Double.MIN_VALUE;
        Pattern[] patterns = null;
        boolean foundMinI = false;
        boolean foundMaxI = false;
        boolean foundMinE = false;
        boolean foundMaxE = false;
        Vector<Object> errors = new Vector<Object>();
        super.setFacets(facets, locale);
        IDataCursor ic = facets.getCursor();
        String duration = IDataUtil.getString(ic, "duration");
        if (duration != null && !duration.equals("P0Y")) {
            errors.addElement("duration value is fixed, you can't modify it ");
        }
        if ((period = IDataUtil.getString(ic, "period")) != null && !period.equals("PT24H")) {
            errors.addElement("period value is fixed, you can't modify it ");
        }
        String minI = IDataUtil.getString(ic, "minInclusive");
        String minE = IDataUtil.getString(ic, "minExclusive");
        String maxI = IDataUtil.getString(ic, "maxInclusive");
        String maxE = IDataUtil.getString(ic, "maxExclusive");
        if (minI != null) {
            foundMinI = true;
            try {
                minInclusive = WmTime.convertTimeToSeconds(minI);
            }
            catch (NSException e) {
                errors.addElement(e);
            }
            if (minE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MINI_AND_MINE, ""));
            }
        } else {
            try {
                if (minE != null) {
                    foundMinE = true;
                    minExclusive = WmTime.convertTimeToSeconds(minE);
                }
            }
            catch (NSException e) {
                errors.addElement(e);
            }
        }
        if (maxI != null) {
            foundMaxI = true;
            try {
                maxInclusive = WmTime.convertTimeToSeconds(maxI);
            }
            catch (NSException e) {
                errors.addElement(e);
            }
            if (maxE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MAXI_AND_MAXE, ""));
            }
        } else {
            try {
                if (maxE != null) {
                    foundMaxE = true;
                    maxExclusive = WmTime.convertTimeToSeconds(maxE);
                }
            }
            catch (NSException e) {
                errors.addElement(e);
            }
        }
        if (foundMaxI) {
            if (foundMinI && maxInclusive < minInclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINI, ""));
            }
            if (foundMinE && maxInclusive <= minExclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINE, ""));
            }
        }
        if (foundMaxE) {
            if (foundMinI && maxExclusive < minInclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINI, ""));
            }
            if (foundMinE && maxExclusive <= minExclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINE, ""));
            }
        }
        String[] enumvar = (String[])IDataUtil.get(ic, "enumeration");
        String[] strPatterns = (String[])IDataUtil.get(ic, "pattern");
        if (strPatterns != null) {
            patterns = new Pattern[strPatterns.length];
            for (int i = 0; i < strPatterns.length; ++i) {
                if (strPatterns[i].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        patterns[i] = _compiler.compile(strPatterns[i]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_REGEX, "", strPatterns[i]));
                }
            }
        }
        if (enumvar != null) {
            for (int i = 0; i < enumvar.length; ++i) {
                String enumerationItem = enumvar[i];
                try {
                    value = WmTime.convertTimeToSeconds(enumerationItem);
                }
                catch (NSException e) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM, "", enumerationItem));
                }
                if (foundMaxI) {
                    if (foundMinI) {
                        if (value < minInclusive || value > maxInclusive) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumerationItem));
                        }
                    } else if (foundMinE && (value <= minExclusive || value > maxInclusive)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumerationItem));
                    }
                } else if (foundMaxE) {
                    if (foundMinI) {
                        if (value < minInclusive || value >= maxExclusive) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumerationItem));
                        }
                    } else if (foundMinE && (value <= minExclusive || value >= maxExclusive)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", enumerationItem));
                    }
                }
                if (!WmTime.checkEnumPattern(enumerationItem, patterns)) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_NOT_MATCH_PATTERN, "", enumerationItem));
                }
                enumvar[i] = enumerationItem;
            }
        }
        ic.destroy();
        if (errors.size() == 0) {
            this._minInclusive = minI;
            this._minExclusive = minE;
            this._maxInclusive = maxI;
            this._maxExclusive = maxE;
            this._lmaxInclusive = maxInclusive;
            this._lmaxExclusive = maxExclusive;
            this._lminInclusive = minInclusive;
            this._lminExclusive = minExclusive;
            this._enum = enumvar;
            this._strPatterns = strPatterns;
            this._patterns = patterns;
        } else {
            WmTime.throwNSException(errors, locale);
        }
    }

    public boolean validate(String s, Object context) {
        double value;
        s = WmTime.handleWhiteSpace(s, 3);
        boolean valid = true;
        valid = super.validate(s, context);
        if (!valid) {
            return false;
        }
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        if (this._enum != null) {
            for (int i = 0; i < this._enum.length; ++i) {
                if (!s.equals(this._enum[i])) continue;
                return valid;
            }
            valid = false;
            workspace.addError("DT-Time001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
            return valid;
        }
        try {
            value = WmTime.convertTimeToSeconds(s);
        }
        catch (Exception e) {
            valid = false;
            workspace.addError("DT-Time004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
            return valid;
        }
        if (this._minInclusive != null && value < this._lminInclusive) {
            workspace.addError("DT-Time002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._minExclusive != null && value <= this._lminExclusive) {
            workspace.addError("DT-Time002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._maxInclusive != null && value > this._lmaxInclusive) {
            workspace.addError("DT-Time003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._maxExclusive != null && value >= this._lmaxExclusive) {
            workspace.addError("DT-Time003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (!this.checkPattern(s, workspace)) {
            valid = false;
        }
        return valid;
    }

    public void setValues(Values val) {
        Object s = null;
        super.setValues(val);
        String[] sa = null;
        sa = (String[])val.get("enumeration");
        if (sa != null) {
            this._enum = sa;
        }
        this._minInclusive = val.getString("minInclusive");
        this._minExclusive = val.getString("minExclusive");
        this._maxInclusive = val.getString("maxInclusive");
        this._maxExclusive = val.getString("maxExclusive");
        if (this._minInclusive != null) {
            try {
                this._lminInclusive = WmTime.convertTimeToSeconds(this._minInclusive);
            }
            catch (Exception e) {
                this._lminInclusive = Double.MIN_VALUE;
            }
        }
        if (this._minExclusive != null) {
            try {
                this._lminExclusive = WmTime.convertTimeToSeconds(this._minExclusive);
            }
            catch (Exception e) {
                this._lminExclusive = Double.MIN_VALUE;
            }
        }
        if (this._maxInclusive != null) {
            try {
                this._lmaxInclusive = WmTime.convertTimeToSeconds(this._maxInclusive);
            }
            catch (Exception e) {
                this._lmaxInclusive = Double.MAX_VALUE;
            }
        }
        if (this._maxExclusive != null) {
            try {
                this._lmaxExclusive = WmTime.convertTimeToSeconds(this._maxExclusive);
            }
            catch (Exception e) {
                this._lmaxExclusive = Double.MAX_VALUE;
            }
        }
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"duration", this._duration}, {"period", this._period}, {"minInclusive", this._minInclusive}, {"minExclusive", this._minExclusive}, {"maxInclusive", this._maxInclusive}, {"maxExclusive", this._maxExclusive}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setFromData(IData val) {
        Object s = null;
        super.setFromData(val);
        String[] sa = null;
        IDataCursor ic = val.getCursor();
        sa = (String[])IDataUtil.get(ic, "enumeration");
        if (sa != null) {
            this._enum = sa;
        }
        this._minInclusive = IDataUtil.getString(ic, "minInclusive");
        this._minExclusive = IDataUtil.getString(ic, "minExclusive");
        this._maxInclusive = IDataUtil.getString(ic, "maxInclusive");
        this._maxExclusive = IDataUtil.getString(ic, "maxExclusive");
        ic.destroy();
        if (this._minInclusive != null) {
            try {
                this._lminInclusive = WmTime.convertTimeToSeconds(this._minInclusive);
            }
            catch (Exception e) {
                this._lminInclusive = Double.MIN_VALUE;
            }
        }
        if (this._minExclusive != null) {
            try {
                this._lminExclusive = WmTime.convertTimeToSeconds(this._minExclusive);
            }
            catch (Exception e) {
                this._lminExclusive = Double.MIN_VALUE;
            }
        }
        if (this._maxInclusive != null) {
            try {
                this._lmaxInclusive = WmTime.convertTimeToSeconds(this._maxInclusive);
            }
            catch (Exception e) {
                this._lmaxInclusive = Double.MAX_VALUE;
            }
        }
        if (this._maxExclusive != null) {
            try {
                this._lmaxExclusive = WmTime.convertTimeToSeconds(this._maxExclusive);
            }
            catch (Exception e) {
                this._lmaxExclusive = Double.MAX_VALUE;
            }
        }
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"duration", this._duration}, {"period", this._period}, {"minInclusive", this._minInclusive}, {"minExclusive", this._minExclusive}, {"maxInclusive", this._maxInclusive}, {"maxExclusive", this._maxExclusive}};
        IData val = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    static final double convertTimeToSeconds(String s) throws NSException {
        double seconds;
        String originS = s;
        int hour = -1;
        int min = -1;
        int addhour = -1;
        int addmin = -1;
        boolean negative = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c == '-' || c == '+' || c == ':') continue;
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_CHAR, "");
        }
        int firstCol = s.indexOf(58);
        int secondCol = -1;
        if (firstCol != 2) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_FORMAT, "");
        }
        secondCol = s.indexOf(58, firstCol + 1);
        if (secondCol != firstCol + 3) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_FORMAT, "");
        }
        try {
            hour = Integer.parseInt(s.substring(0, firstCol));
        }
        catch (NumberFormatException e) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, "");
        }
        if (hour < 0 || hour > 24) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_FORMAT, "");
        }
        try {
            min = Integer.parseInt(s.substring(firstCol + 1, secondCol));
        }
        catch (NumberFormatException e) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, "");
        }
        if (min < 0 || min > 60) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_FORMAT, "");
        }
        try {
            Double second = new Double(s.substring(secondCol + 1, secondCol + 3));
            seconds = second;
            if (seconds < 0.0 || seconds > 60.0) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_FORMAT, "");
            }
        }
        catch (NumberFormatException e) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, "");
        }
        seconds = (double)(hour * 3600 + min * 60) + seconds;
        int indexMinus = s.indexOf(45);
        int indexPlus = s.indexOf(43);
        if (indexMinus != -1) {
            try {
                addhour = Integer.parseInt(s.substring(indexMinus + 1, indexMinus + 3));
            }
            catch (NumberFormatException e) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, "");
            }
            try {
                addmin = Integer.parseInt(s.substring(indexMinus + 4));
            }
            catch (NumberFormatException e) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, "");
            }
            seconds -= (double)(addhour * 3600 + addmin * 60);
        }
        if (indexPlus != -1) {
            try {
                addhour = Integer.parseInt(s.substring(indexPlus + 1, indexPlus + 3));
            }
            catch (NumberFormatException e) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, "");
            }
            try {
                addmin = Integer.parseInt(s.substring(indexPlus + 4));
            }
            catch (NumberFormatException e) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, "");
            }
            seconds += (double)(addhour * 3600 + addmin * 60);
        }
        return seconds;
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        try {
            double b1 = WmTime.convertTimeToSeconds(s1);
            double b2 = WmTime.convertTimeToSeconds(s2);
            if (b1 == b2) {
                return true;
            }
        }
        catch (NSException e) {
            return false;
        }
        return false;
    }

    public static void main(String[] args) {
        WmTime wt = new WmTime();
        Object[][] o = new Object[][]{{"minInclusive", "13:20:00-05:00"}, {"minExclusive", null}, {"maxInclusive", "20:12:25"}, {"maxExclusive", null}};
        Values val = new Values(o);
        try {
            wt.setFacets(val);
        }
        catch (NSException e) {
            e.printStackTrace();
        }
    }
}

