/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.lang.schema.dummyWorkSpace;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;

public class WmString
extends Datatype
implements ValuesCodable,
Errors {
    private static final String ERR001 = "DT-STR001";
    private static final String MSG001 = "No matching choice value";
    private static final String ERR002 = "DT-STR002";
    private static final String MSG002 = "Value is shorter than minimum length";
    private static final String ERR003 = "DT-STR003";
    private static final String MSG003 = "Value is longer than maximum length";
    private static final String ERR005 = "DT-STR005";
    private static final String MSG005 = "Length of value is not equal to specified length";
    String[] _enumeration;
    int _length = -1;
    int _minLength = -1;
    int _maxLength = -1;
    String _whiteSpace;
    private static NSRecord _nsRecord = null;

    public String[] getEnumeration() {
        return this._enumeration;
    }

    public void setEnumeration(String[] sa) {
        this._enumeration = sa;
    }

    public int getMinLength() {
        return this._minLength;
    }

    public void setMinLength(int i) {
        this._minLength = i;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public void setMaxLength(int i) {
        this._maxLength = i;
    }

    public String getWhiteSpace() {
        return this._whiteSpace;
    }

    public void setWhiteSpace(String wsType) {
        this._whiteSpace = wsType;
    }

    public NSRecord getFacetsMetadata() {
        if (_nsRecord == null) {
            String[] tf = new String[]{"true", "false"};
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "length", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minLength", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxLength", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "pattern", 1, 1);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    public IData getFacets() {
        Object[][] o = new Object[][]{{"enumeration", this._enumeration}, {"length", this._length > -1 ? Integer.toString(this._length) : null}, {"minLength", this._minLength > -1 ? Integer.toString(this._minLength) : null}, {"maxLength", this._maxLength > -1 ? Integer.toString(this._maxLength) : null}, {"whiteSpace", this._whiteSpace}};
        IData val = super.getFacets();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacets(IData facets, Locale locale) throws NSException {
        String whiteSpace;
        int length = -1;
        int maxLength = -1;
        int minLength = -1;
        Pattern[] patterns = null;
        boolean foundLength = false;
        boolean foundMaxLength = false;
        boolean foundMinLength = false;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        super.setFacets(facets, locale);
        IDataCursor ic = facets.getCursor();
        String data = IDataUtil.getString(ic, "length");
        try {
            if (data != null) {
                length = Integer.parseInt(data);
                if (length > -1) {
                    foundLength = true;
                } else if (length < -1) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_LENGTH, ""));
                }
            }
        }
        catch (NumberFormatException e) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_LENGTH, ""));
        }
        data = IDataUtil.getString(ic, "minLength");
        try {
            if (data != null) {
                minLength = Integer.parseInt(data);
                if (minLength > -1) {
                    foundMinLength = true;
                } else if (minLength < 0) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_LENGTH, ""));
                }
            }
        }
        catch (NumberFormatException e) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_LENGTH, ""));
        }
        data = IDataUtil.getString(ic, "maxLength");
        try {
            if (data != null) {
                maxLength = Integer.parseInt(data);
                if (maxLength > -1) {
                    foundMaxLength = true;
                } else if (maxLength < -1) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_LENGTH, ""));
                }
            }
        }
        catch (NumberFormatException e) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_LENGTH, ""));
        }
        if (foundLength && (foundMinLength || foundMaxLength)) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_FIX_AND_VAR, ""));
        }
        if (foundMaxLength && maxLength < minLength) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXLENGTH_LESS_THAN_MIN, ""));
        }
        if ((whiteSpace = IDataUtil.getString(ic, "whiteSpace")) == null) {
            whiteSpace = "none";
        }
        String[] enumeration = (String[])IDataUtil.get(ic, "enumeration");
        String[] strPatterns = (String[])IDataUtil.get(ic, "pattern");
        ic.destroy();
        if (strPatterns != null) {
            patterns = new Pattern[strPatterns.length];
            for (int i = 0; i < strPatterns.length; ++i) {
                if (strPatterns[i].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        patterns[i] = _compiler.compile(strPatterns[i]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_REGEX, "", strPatterns[i]));
                }
            }
        }
        if (enumeration != null) {
            int len = enumeration.length;
            for (int i = 0; i < len; ++i) {
                String s = enumeration[i];
                int enumlength = s.length();
                if (length > -1) {
                    if (enumlength != length) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_NOT_EQUAL_LENGTH, "", s));
                    }
                } else {
                    if (enumlength < minLength) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_SHORTER_THAN_LENGTH, "", s));
                    }
                    if (maxLength > -1 && enumlength > maxLength) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_LONGER_THAN_LENGTH, "", s));
                    }
                }
                if (WmString.checkEnumPattern(s, patterns)) continue;
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_NOT_MATCH_PATTERN, "", s));
            }
        }
        if (errors.size() == 0) {
            this._length = length;
            this._minLength = minLength;
            this._maxLength = maxLength;
            this._whiteSpace = whiteSpace;
            this._enumeration = enumeration;
            this._strPatterns = strPatterns;
            this._patterns = patterns;
        } else {
            WmString.throwNSException(errors, locale);
        }
    }

    public boolean validate(String s, Object context) {
        int wsType = -1;
        if (this._whiteSpace != null) {
            if (this._whiteSpace.equals("replace")) {
                wsType = 2;
            } else if (this._whiteSpace.equals("collapse")) {
                wsType = 3;
            } else if (this._whiteSpace.equals("preserve")) {
                wsType = 1;
            }
        }
        if (wsType != -1) {
            s = WmString.handleWhiteSpace(s, wsType);
        }
        boolean valid = true;
        valid = super.validate(s, context);
        if (!valid) {
            return false;
        }
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        if (this._enumeration != null) {
            for (int i = 0; i < this._enumeration.length; ++i) {
                if (!s.equals(this._enumeration[i])) continue;
                return valid;
            }
            valid = false;
            workspace.addError(ERR001, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
            return valid;
        }
        int length = -1;
        if (s != null) {
            length = s.length();
        }
        if (this._length > -1) {
            if (this._length != length) {
                valid = false;
                workspace.addError(ERR005, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_EQUAL_LENGTH, ""));
            }
        } else {
            if (this._minLength > -1 && length < this._minLength) {
                valid = false;
                workspace.addError(ERR002, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.SHORTER_THAN_LENGTH, ""));
            }
            if (workspace.isCompleted()) {
                return valid;
            }
            if (this._maxLength > -1 && length > this._maxLength) {
                valid = false;
                workspace.addError(ERR003, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LONGER_THAN_LENGTH, ""));
            }
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (!this.checkPattern(s, workspace)) {
            valid = false;
        }
        return valid;
    }

    public void setValues(Values val) {
        if (val.get("enum") != null || val.get("max_length") != null || val.get("min_length") != null || val.get("pattern") != null) {
            WmString.migrate(val);
        }
        super.setValues(val);
        this._enumeration = (String[])val.get("enumeration");
        this._length = val.getInt("length", -1);
        this._minLength = val.getInt("minLength", -1);
        this._maxLength = val.getInt("maxLength", -1);
        this._whiteSpace = val.getString("whiteSpace");
    }

    private static final void migrate(IData val) {
        String[] oldDataArray;
        String s;
        IDataCursor icv = val.getCursor();
        Object unknown = IDataUtil.get(icv, "pattern");
        if (unknown instanceof String && (s = (String)unknown).length() > 0) {
            if (!s.startsWith(".*")) {
                s = ".*" + s + ".*";
            }
            oldDataArray = new String[]{s};
            IDataUtil.put(icv, "pattern", oldDataArray);
        }
        oldDataArray = (String[])IDataUtil.get(icv, "enum");
        IDataUtil.put(icv, "enumeration", oldDataArray);
        String oldData = IDataUtil.getString(icv, "max_length");
        IDataUtil.put(icv, "maxLength", oldData);
        oldData = IDataUtil.getString(icv, "min_length");
        IDataUtil.put(icv, "minLength", oldData);
        icv.destroy();
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", this._enumeration}, {"length", this._length > -1 ? Integer.toString(this._length) : null}, {"minLength", this._minLength > -1 ? Integer.toString(this._minLength) : null}, {"maxLength", this._maxLength > -1 ? Integer.toString(this._maxLength) : null}, {"whiteSpace", this._whiteSpace}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setFromData(IData val) {
        IDataCursor ic = val.getCursor();
        if (ic.first("enum") || ic.first("max_length") || ic.first("min_length") || ic.first("pattern")) {
            WmString.migrate(val);
        }
        super.setFromData(val);
        this._enumeration = (String[])IDataUtil.get(ic, "enumeration");
        this._length = IDataUtil.getInt(ic, "length", -1);
        this._minLength = IDataUtil.getInt(ic, "minLength", -1);
        this._maxLength = IDataUtil.getInt(ic, "maxLength", -1);
        this._whiteSpace = IDataUtil.getString(ic, "whiteSpace");
        ic.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"enumeration", this._enumeration}, {"length", this._length > -1 ? Integer.toString(this._length) : null}, {"minLength", this._minLength > -1 ? Integer.toString(this._minLength) : null}, {"maxLength", this._maxLength > -1 ? Integer.toString(this._maxLength) : null}, {"whiteSpace", this._whiteSpace}};
        IData val = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    public Values getView() {
        Object[][] o = new Object[][]{{"enumeration", this._enumeration}, {"length", Integer.toString(this._length)}, {"minLength", Integer.toString(this._minLength)}, {"maxLength", Integer.toString(this._maxLength)}, {"whiteSpace", this._whiteSpace}};
        return super.getView().copyFrom(new Values(o));
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static void main(String[] args) {
        Datatype st = null;
        try {
            st = Datatype.create("string");
        }
        catch (NSException e) {
            e.printStackTrace();
        }
        IData facet = st.getFacets();
        System.out.println("first toString " + facet.toString());
        IDataCursor ic = facet.getCursor();
        IDataUtil.put(ic, "whiteSpace", "collapse");
        IDataUtil.put(ic, "length", "5");
        ic.destroy();
        System.out.println(facet.toString());
        try {
            st.setFacets(facet);
        }
        catch (NSException e) {
            e.printStackTrace();
        }
        Values value = st.getValues();
        System.out.println("value toString " + value.toString());
        System.out.println("aftervalue toString " + value.toString());
        dummyWorkSpace dummy = new dummyWorkSpace();
        char[] ca = new char[]{'\t', '\t', 'a', '\r', 'b', '\n', 'c'};
        String s = new String(ca);
        st.validate(s, dummy);
    }
}

