/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Locale;
import java.util.Vector;

public class WmReal
extends Datatype
implements ValuesCodable {
    private static final double MIN_VALUE = -1.7976931348623157E308;
    private static final String ERR001 = "DT-REAL001";
    private static final String MES001 = "No matching choice value";
    private static final String ERR002 = "DT-REAL002";
    private static final String MES002 = "Value is not a real number";
    private static final String ERR003 = "DT-REAL003";
    private static final String MES003 = "Value is less than minimum";
    private static final String ERR004 = "DT-REAL004";
    private static final String MES004 = "Value is greater than maximum";
    private static final String VALID_RANGE = "(Valid range is from -1.7976931348623157E308 to 1.7976931348623157E308)";
    private static final String OUT_OF_RANGE = "Out of range";
    public static final String KEY_ENUM = "enum";
    public static final String KEY_MIN = "minimum";
    public static final String KEY_MAX = "maximum";
    double[] _enum = null;
    double _min = -1.7976931348623157E308;
    double _max = Double.MAX_VALUE;
    private static NSRecord _nsRecord = null;

    public double[] getEnum() {
        return this._enum;
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public void setEnum(double[] enumvar) {
        this._enum = enumvar;
    }

    public void setMin(double min) {
        this._min = min;
    }

    public void setMax(double max) {
        this._max = max;
    }

    public NSRecord getFacetsMetadata() {
        if (_nsRecord == null) {
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, KEY_ENUM, 1, 1);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, KEY_MIN, 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, KEY_MAX, 1, 0);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    public IData getFacets() {
        Object[][] o = new Object[][]{{KEY_ENUM, this.convertToStringArray(this._enum)}, {KEY_MIN, Double.toString(this._min)}, {KEY_MAX, Double.toString(this._max)}};
        IData val = IDataFactory.create(o);
        return val;
    }

    public void setFacets(IData facets, Locale locale) throws NSException {
        String str;
        double dEnumItem = 0.0;
        double max = Double.MAX_VALUE;
        double min = -1.7976931348623157E308;
        double[] dEnum = null;
        Object[] oArray = new Object[]{new Double(min), new Double(max)};
        IDataCursor ic = facets.getCursor();
        try {
            str = IDataUtil.getString(ic, KEY_MIN);
            if (str != null) {
                min = Double.valueOf(str);
            }
            if (Double.isInfinite(min)) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.REAL_MIN_OUT_OF_RANGE, "", oArray);
            }
        }
        catch (NumberFormatException e) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.REAL_INVALID_MIN, "");
        }
        try {
            str = IDataUtil.getString(ic, KEY_MAX);
            if (str != null) {
                max = Double.valueOf(str);
            }
            if (Double.isInfinite(max)) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.REAL_MAX_OUT_OF_RANGE, "", oArray);
            }
        }
        catch (NumberFormatException e) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.REAL_INVALID_MAX, "");
        }
        if (max < min) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.REAL_MAX_LESS_THAN_MIN, "");
        }
        String[] strEnum = (String[])IDataUtil.get(ic, KEY_ENUM);
        ic.destroy();
        if (strEnum != null) {
            dEnum = new double[strEnum.length];
            for (int index = 0; index < strEnum.length; ++index) {
                String strEnumItem = strEnum[index];
                try {
                    dEnumItem = Double.valueOf(strEnumItem);
                }
                catch (NumberFormatException e) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_NOT_CONFORM_TYPE, "", strEnumItem);
                }
                if (dEnumItem < min || dEnumItem > max) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", strEnumItem);
                }
                dEnum[index] = dEnumItem;
            }
        }
        this._enum = (double[])(strEnum != null ? dEnum : null);
        this._min = min;
        this._max = max;
    }

    public void setFromData(IData val) {
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        this._enum = this.convertTodoubleArray((String[])IDataUtil.get(ic, KEY_ENUM));
        try {
            this._min = Double.valueOf(IDataUtil.getString(ic, KEY_MIN));
        }
        catch (NumberFormatException e) {
            this._min = -1.7976931348623157E308;
        }
        try {
            this._max = Double.valueOf(IDataUtil.getString(ic, KEY_MAX));
        }
        catch (NumberFormatException e) {
            this._max = Double.MAX_VALUE;
        }
        ic.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{KEY_ENUM, this.convertToStringArray(this._enum)}, {KEY_MIN, Double.toString(this._min)}, {KEY_MAX, Double.toString(this._max)}};
        IData val = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    public void setValues(Values val) {
        super.setValues(val);
        this._enum = this.convertTodoubleArray(val.getStringArray(KEY_ENUM));
        try {
            this._min = Double.valueOf(val.getString(KEY_MIN));
        }
        catch (NumberFormatException e) {
            this._min = -1.7976931348623157E308;
        }
        try {
            this._max = Double.valueOf(val.getString(KEY_MAX));
        }
        catch (NumberFormatException e) {
            this._max = Double.MAX_VALUE;
        }
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_ENUM, this.convertToStringArray(this._enum)}, {KEY_MIN, Double.toString(this._min)}, {KEY_MAX, Double.toString(this._max)}};
        return super.getValues().copyFrom(new Values(o));
    }

    public boolean validate(String str, Object context) {
        double value;
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        boolean valid = true;
        try {
            value = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            valid = false;
            workspace.addError(ERR002, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
            return valid;
        }
        if (this._enum != null) {
            for (int index = 0; index < this._enum.length; ++index) {
                if (value != this._enum[index]) continue;
                return valid;
            }
            valid = false;
            workspace.addError(ERR001, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
            return valid;
        }
        if (value < this._min) {
            valid = false;
            workspace.addError(ERR003, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (value > this._max) {
            valid = false;
            workspace.addError(ERR004, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
        }
        return valid;
    }

    String[] convertToStringArray(double[] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        String[] stringArray = new String[doubleArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            stringArray[index] = Double.toString(doubleArray[index]);
        }
        return stringArray;
    }

    double[] convertTodoubleArray(String[] stringArray) {
        int index;
        if (stringArray == null) {
            return null;
        }
        Vector<Double> temp = new Vector<Double>();
        for (index = 0; index < stringArray.length; ++index) {
            try {
                temp.addElement(new Double(stringArray[index]));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        double[] doubleArray = new double[temp.size()];
        for (index = 0; index < doubleArray.length; ++index) {
            doubleArray[index] = (Double)temp.elementAt(index);
        }
        return doubleArray;
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        Double d1 = Double.valueOf(s1);
        Double d2 = Double.valueOf(s2);
        return d1.equals(d2);
    }
}

