/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.lang.schema.dummyWorkSpace;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;

public class WmLong
extends Datatype
implements Errors,
ValuesCodable {
    private static final String ERR001 = "DT-LONG001";
    private static final String MSG001 = "Value does not conform to datatype ";
    long[] _enumeration;
    long _maxInclusive;
    long _maxExclusive;
    long _minInclusive;
    long _minExclusive;
    boolean _initialized = false;
    boolean _foundMinI = false;
    boolean _foundMinE = false;
    boolean _foundMaxI = false;
    boolean _foundMaxE = false;
    private static NSRecord _nsRecord = null;

    public long[] getEnumeration() {
        return this._enumeration;
    }

    public long getMaxInclusive() {
        return this._maxInclusive;
    }

    public long getMaxExclusive() {
        return this._maxExclusive;
    }

    public long getMinInclusive() {
        return this._minInclusive;
    }

    public long getMinExclusive() {
        return this._minExclusive;
    }

    public void setEnumeration(long[] sa) {
        this._enumeration = sa;
    }

    public void setMaxInclusive(long maxInclusive) {
        this._maxInclusive = maxInclusive;
    }

    public void setMaxExclusive(long maxExclusive) {
        this._maxExclusive = maxExclusive;
    }

    public void setMinInclusive(long minInclusive) {
        this._minInclusive = minInclusive;
    }

    public void setMinExclusive(long minExclusive) {
        this._minExclusive = minExclusive;
    }

    public NSRecord getFacetsMetadata() {
        if (_nsRecord == null) {
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "pattern", 1, 1);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    public IData getFacets() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enumeration)}, {"minInclusive", this._initialized && this._foundMinI ? Long.toString(this._minInclusive) : null}, {"minExclusive", this._initialized && this._foundMinE ? Long.toString(this._minExclusive) : null}, {"maxInclusive", this._initialized && this._foundMaxI ? Long.toString(this._maxInclusive) : null}, {"maxExclusive", this._initialized && this._foundMaxE ? Long.toString(this._maxExclusive) : null}};
        IData val = super.getFacets();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacets(IData facets, Locale locale) throws NSException {
        String[] strEnum;
        String[] strPatterns;
        long maxInclusive = Long.MAX_VALUE;
        long maxExclusive = Long.MAX_VALUE;
        long minInclusive = Long.MIN_VALUE;
        long minExclusive = Long.MIN_VALUE;
        long enumerationItem = Long.MIN_VALUE;
        long[] enumeration = null;
        Pattern[] patterns = null;
        boolean initialized = false;
        boolean foundMinI = false;
        boolean foundMinE = false;
        boolean foundMaxI = false;
        boolean foundMaxE = false;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        super.setFacets(facets, locale);
        IDataCursor ic = facets.getCursor();
        initialized = ic.first("initialized") ? IDataUtil.getBoolean(ic) : false;
        String minI = IDataUtil.getString(ic, "minInclusive");
        String minE = IDataUtil.getString(ic, "minExclusive");
        String maxI = IDataUtil.getString(ic, "maxInclusive");
        String maxE = IDataUtil.getString(ic, "maxExclusive");
        if (minI != null) {
            foundMinI = true;
            initialized = true;
            try {
                minInclusive = Long.valueOf(minI);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_I, ""));
            }
            if (minE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MINI_AND_MINE, ""));
            }
        } else {
            try {
                if (minE != null) {
                    foundMinE = true;
                    initialized = true;
                    minExclusive = Long.valueOf(minE);
                }
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_E, ""));
            }
        }
        if (maxI != null) {
            foundMaxI = true;
            initialized = true;
            try {
                maxInclusive = Long.valueOf(maxI);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_I, ""));
            }
            if (maxE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MAXI_AND_MAXE, ""));
            }
        } else {
            try {
                if (maxE != null) {
                    foundMaxE = true;
                    initialized = true;
                    maxExclusive = Long.valueOf(maxE);
                }
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_E, ""));
            }
        }
        if (foundMaxI) {
            if (foundMinI && maxInclusive < minInclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINI, ""));
            }
            if (foundMinE && maxInclusive < minExclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINE, ""));
            }
        }
        if (foundMaxE) {
            if (foundMinI && maxExclusive < minInclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINI, ""));
            }
            if (foundMinE && maxExclusive < minExclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINE, ""));
            }
        }
        if ((strPatterns = (String[])IDataUtil.get(ic, "pattern")) != null) {
            patterns = new Pattern[strPatterns.length];
            for (int i = 0; i < strPatterns.length; ++i) {
                if (strPatterns[i].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        patterns[i] = _compiler.compile(strPatterns[i]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_REGEX, "", strPatterns[i]));
                }
            }
        }
        if ((strEnum = (String[])IDataUtil.get(ic, "enumeration")) != null) {
            enumeration = new long[strEnum.length];
            for (int i = 0; i < strEnum.length; ++i) {
                String strEnumItem = strEnum[i];
                try {
                    enumerationItem = Long.valueOf(strEnumItem);
                }
                catch (NumberFormatException e) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_NOT_CONFORM_TYPE, "", strEnumItem));
                }
                if (this._foundMaxI) {
                    if (this._foundMinI) {
                        if (enumerationItem < minInclusive || enumerationItem > maxInclusive) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", strEnumItem));
                        }
                    } else if (this._foundMinE && (enumerationItem <= minExclusive || enumerationItem > maxInclusive)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", strEnumItem));
                    }
                } else if (this._foundMaxE) {
                    if (this._foundMinI) {
                        if (enumerationItem < minInclusive || enumerationItem >= maxExclusive) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", strEnumItem));
                        }
                    } else if (this._foundMinE && (enumerationItem <= minExclusive || enumerationItem >= maxExclusive)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", strEnumItem));
                    }
                }
                if (!WmLong.checkEnumPattern(strEnumItem, patterns)) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_NOT_MATCH_PATTERN, "", strEnumItem));
                }
                enumeration[i] = enumerationItem;
            }
        }
        ic.destroy();
        if (errors.size() == 0) {
            if (foundMinI) {
                this._minInclusive = minInclusive;
            }
            if (foundMinE) {
                this._minExclusive = minExclusive;
            }
            if (foundMaxI) {
                this._maxInclusive = maxInclusive;
            }
            if (foundMaxE) {
                this._maxExclusive = maxExclusive;
            }
            this._enumeration = enumeration;
            this._strPatterns = strPatterns;
            this._patterns = patterns;
            this._initialized = initialized;
            this._foundMinI = foundMinI;
            this._foundMinE = foundMinE;
            this._foundMaxI = foundMaxI;
            this._foundMaxE = foundMaxE;
        } else {
            WmLong.throwNSException(errors, locale);
        }
    }

    public boolean validate(String s, Object context) {
        long value;
        s = WmLong.handleWhiteSpace(s, 3);
        boolean valid = true;
        valid = super.validate(s, context);
        if (!valid) {
            return false;
        }
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        try {
            value = Long.valueOf(s);
        }
        catch (NumberFormatException e) {
            valid = false;
            workspace.addError("DT-Long004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
            return valid;
        }
        if (this._enumeration != null) {
            for (int i = 0; i < this._enumeration.length; ++i) {
                if (value != this._enumeration[i]) continue;
                return valid;
            }
            valid = false;
            workspace.addError("DT-Long001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
            return valid;
        }
        if (this._foundMinI && value < this._minInclusive) {
            workspace.addError("DT-Long002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._foundMinE && value <= this._minExclusive) {
            workspace.addError("DT-Long002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._foundMaxI && value > this._maxInclusive) {
            workspace.addError("DT-Long003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._foundMaxE && value >= this._maxExclusive) {
            workspace.addError("DT-Long003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (!this.checkPattern(s, workspace)) {
            valid = false;
        }
        return valid;
    }

    public void setValues(Values val) {
        this._initialized = true;
        String s = null;
        super.setValues(val);
        String[] sa = (String[])val.get("enumeration");
        if (sa != null) {
            this._enumeration = this.convertTolongArray(sa);
        }
        this._foundMinI = val.getBoolean("foundMinI");
        this._foundMinE = val.getBoolean("foundMinE");
        this._foundMaxI = val.getBoolean("foundMaxI");
        this._foundMaxE = val.getBoolean("foundMaxE");
        this._initialized = val.getBoolean("initialized");
        try {
            s = val.getString("minInclusive");
            if (s != null) {
                this._minInclusive = Long.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            this._minInclusive = Long.MIN_VALUE;
        }
        try {
            s = val.getString("minExclusive");
            if (s != null) {
                this._minExclusive = Long.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            this._minExclusive = Long.MIN_VALUE;
        }
        try {
            s = val.getString("maxInclusive");
            if (s != null) {
                this._maxInclusive = Long.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            this._maxInclusive = Long.MAX_VALUE;
        }
        try {
            s = val.getString("maxExclusive");
            if (s != null) {
                this._maxExclusive = Long.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            this._maxExclusive = Long.MAX_VALUE;
        }
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enumeration)}, {"foundMinI", new Boolean(this._foundMinI).toString()}, {"foundMinE", new Boolean(this._foundMinE).toString()}, {"foundMaxI", new Boolean(this._foundMaxI).toString()}, {"foundMaxE", new Boolean(this._foundMaxE).toString()}, {"initialized", new Boolean(this._initialized).toString()}, {"minInclusive", this._initialized && this._foundMinI ? Long.toString(this._minInclusive) : null}, {"minExclusive", this._initialized && this._foundMinE ? Long.toString(this._minExclusive) : null}, {"maxInclusive", this._initialized && this._foundMaxI ? Long.toString(this._maxInclusive) : null}, {"maxExclusive", this._initialized && this._foundMaxE ? Long.toString(this._maxExclusive) : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setFromData(IData data) {
        super.setFromData(data);
        IDataCursor idc = data.getCursor();
        if (idc.first("enumeration")) {
            this._enumeration = this.convertTolongArray(IDataUtil.getStringArray(idc));
        }
        this._foundMinI = IDataUtil.getBoolean(idc, "foundMinI");
        this._foundMinE = IDataUtil.getBoolean(idc, "foundMinE");
        this._foundMaxI = IDataUtil.getBoolean(idc, "foundMaxI");
        this._foundMaxE = IDataUtil.getBoolean(idc, "foundMaxE");
        this._initialized = IDataUtil.getBoolean(idc, "initialized");
        try {
            if (idc.first("minInclusive")) {
                this._minInclusive = Long.valueOf(IDataUtil.getString(idc));
            }
        }
        catch (NumberFormatException e) {
            this._minInclusive = Long.MIN_VALUE;
        }
        try {
            if (idc.first("minExclusive")) {
                this._minExclusive = Long.valueOf(IDataUtil.getString(idc));
            }
        }
        catch (NumberFormatException e) {
            this._minExclusive = Long.MIN_VALUE;
        }
        try {
            if (idc.first("maxInclusive")) {
                this._maxInclusive = Long.valueOf(IDataUtil.getString(idc));
            }
        }
        catch (NumberFormatException e) {
            this._maxInclusive = Long.MAX_VALUE;
        }
        try {
            if (idc.first("maxExclusive")) {
                this._maxExclusive = Long.valueOf(IDataUtil.getString(idc));
            }
        }
        catch (NumberFormatException e) {
            this._maxExclusive = Long.MAX_VALUE;
        }
        idc.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enumeration)}, {"foundMinI", new Boolean(this._foundMinI).toString()}, {"foundMinE", new Boolean(this._foundMinE).toString()}, {"foundMaxI", new Boolean(this._foundMaxI).toString()}, {"foundMaxE", new Boolean(this._foundMaxE).toString()}, {"initialized", new Boolean(this._initialized).toString()}, {"minInclusive", this._initialized && this._foundMinI ? Long.toString(this._minInclusive) : null}, {"minExclusive", this._initialized && this._foundMinE ? Long.toString(this._minExclusive) : null}, {"maxInclusive", this._initialized && this._foundMaxI ? Long.toString(this._maxInclusive) : null}, {"maxExclusive", this._initialized && this._foundMaxE ? Long.toString(this._maxExclusive) : null}};
        IData data = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), data);
        return data;
    }

    public Values getView() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enumeration)}, {"foundMinI", new Boolean(this._foundMinI).toString()}, {"foundMinE", new Boolean(this._foundMinE).toString()}, {"foundMaxI", new Boolean(this._foundMaxI).toString()}, {"foundMaxE", new Boolean(this._foundMaxE).toString()}, {"initialized", new Boolean(this._initialized).toString()}, {"minInclusive", this._initialized && this._foundMinI ? Long.toString(this._minInclusive) : null}, {"minExclusive", this._initialized && this._foundMinE ? Long.toString(this._minExclusive) : null}, {"maxInclusive", this._initialized && this._foundMaxI ? Long.toString(this._maxInclusive) : null}, {"maxExclusive", this._initialized && this._foundMaxE ? Long.toString(this._maxExclusive) : null}};
        return super.getView().copyFrom(new Values(o));
    }

    String[] convertToStringArray(long[] longArray) {
        if (longArray == null) {
            return null;
        }
        String[] stringArray = new String[longArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            stringArray[index] = Long.toString(longArray[index]);
        }
        return stringArray;
    }

    long[] convertTolongArray(String[] stringArray) {
        int index;
        if (stringArray == null) {
            return null;
        }
        Vector<Long> temp = new Vector<Long>();
        for (index = 0; index < stringArray.length; ++index) {
            try {
                temp.addElement(new Long(stringArray[index]));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        long[] longArray = new long[temp.size()];
        for (index = 0; index < longArray.length; ++index) {
            longArray[index] = (Long)temp.elementAt(index);
        }
        return longArray;
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        Long d1 = Long.valueOf(s1);
        Long d2 = Long.valueOf(s2);
        return d1.equals(d2);
    }

    public static void main(String[] args) {
        WmLong wl = new WmLong();
        Object[][] o = new Object[][]{{"minInclusive", null}, {"minExclusive", null}, {"maxInclusive", Long.toString(-1015L)}, {"maxExclusive", null}};
        Values val = new Values(o);
        try {
            wl.setFacets(val);
        }
        catch (NSException e) {
            e.printStackTrace();
        }
        dummyWorkSpace context = new dummyWorkSpace();
        boolean valid = true;
        valid = wl.validate("-1025", context);
        System.out.println(valid);
    }
}

