/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.InterDatatype;
import com.wm.lang.schema.datatype.LegacyFacet;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.lang.schema.dummyWorkSpace;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import com.wm.util.Values;
import com.wm.xsd.graph.XSNode;
import com.wm.xsd.graph.XSNonTerminal;
import com.wm.xsd.util.BuiltInSimpleTypes;
import java.util.ArrayList;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class WmList
extends InterDatatype
implements Errors,
XSNonTerminal {
    int _length;
    int _minLength;
    int _maxLength;
    String[] _enum;
    NSRecord _nsRecord = null;
    public static final String KEY_DTR_TARGET = "targetName";

    public WmList(QName targetName) {
        super(targetName, 3);
        this._length = -1;
        this._minLength = -1;
        this._maxLength = -1;
    }

    public WmList(Datatype targetType) {
        super(targetType);
        this._length = -1;
        this._minLength = -1;
        this._maxLength = -1;
        this._internalType = 3;
    }

    public WmList() {
        this((QName)null);
    }

    public WmList(String targetNS, String ncName) {
        this(QName.create(targetNS, ncName));
    }

    WmList(IData values) {
        this.setFromData(values);
        this._internalType = 3;
    }

    public IData getFacets() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"length", this._length > -1 ? Integer.toString(this._length) : null}, {"minLength", this._minLength > -1 ? Integer.toString(this._minLength) : null}, {"maxLength", this._maxLength > -1 ? Integer.toString(this._maxLength) : null}};
        IData val = IDataFactory.create(o);
        return val;
    }

    public void setFacets(IData facets, Locale locale) throws NSException {
        String[] enumeration;
        int length = -1;
        int maxLength = -1;
        int minLength = -1;
        boolean foundLength = false;
        boolean foundMaxLength = false;
        boolean foundMinLength = false;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        super.setFacets(facets, locale);
        IDataCursor ic = facets.getCursor();
        String data = IDataUtil.getString(ic, "length");
        try {
            if (data != null) {
                length = Integer.parseInt(data);
                if (length > -1) {
                    foundLength = true;
                } else if (length < -1) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_LENGTH, ""));
                }
            }
        }
        catch (NumberFormatException e) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_LENGTH, ""));
        }
        data = IDataUtil.getString(ic, "minLength");
        try {
            if (data != null) {
                minLength = Integer.parseInt(data);
                if (minLength > -1) {
                    foundMinLength = true;
                } else if (minLength < 0) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_LENGTH, ""));
                }
            }
        }
        catch (NumberFormatException e) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_LENGTH, ""));
        }
        data = IDataUtil.getString(ic, "maxLength");
        try {
            if (data != null) {
                maxLength = Integer.parseInt(data);
                if (maxLength > -1) {
                    foundMaxLength = true;
                } else if (maxLength < -1) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_LENGTH, ""));
                }
            }
        }
        catch (NumberFormatException e) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_LENGTH, ""));
        }
        if (foundLength && (foundMinLength || foundMaxLength)) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_FIX_AND_VAR, ""));
        }
        if (foundMaxLength && maxLength < minLength) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXLENGTH_LESS_THAN_MIN, ""));
        }
        if ((enumeration = (String[])IDataUtil.get(ic, "enumeration")) != null) {
            int len = -1;
            String s = null;
            boolean valid = false;
            dummyWorkSpace context = new dummyWorkSpace();
            Datatype datatype = this.getDatatype();
            for (int i = 0; i < len; ++i) {
                StringTokenizer st = new StringTokenizer(enumeration[i]);
                len = st.countTokens();
                if (foundLength && length != len) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LIST_ENUM_NOT_EQUAL_LENGTH, ""));
                }
                if (foundMinLength && minLength > len) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LIST_ENUM_SHORTER_THAN_LENGTH, ""));
                }
                if (foundMaxLength && maxLength < len) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LIST_ENUM_LONGER_THAN_LENGTH, ""));
                }
                if (datatype == null || datatype.getBase() == null) continue;
                try {
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        valid = datatype.validate(s, context);
                        if (valid) continue;
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM, "", s));
                    }
                    continue;
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
        }
        if (errors.size() == 0) {
            this._length = length;
            this._minLength = minLength;
            this._maxLength = maxLength;
            this._enum = enumeration;
        } else {
            WmList.throwNSException(errors, locale);
        }
        ic.destroy();
    }

    public NSRecord getFacetsMetadata() {
        Datatype datatype = this.getDatatype();
        if (this._nsRecord == null) {
            this._nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            this._nsRecord.addField(nsf);
            nsf = new NSField(null, "length", 1, 0);
            this._nsRecord.addField(nsf);
            nsf = new NSField(null, "minLength", 1, 0);
            this._nsRecord.addField(nsf);
            nsf = new NSField(null, "maxLength", 1, 0);
            this._nsRecord.addField(nsf);
        }
        return this._nsRecord;
    }

    public boolean validate(String s, Object context) {
        s = WmList.handleWhiteSpace(s, 3);
        boolean valid = true;
        valid = super.validate(s, context);
        if (!valid) {
            return false;
        }
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        StringTokenizer st = new StringTokenizer(s);
        int length = st.countTokens();
        if (this._length > -1) {
            if (this._length != length) {
                valid = false;
                workspace.addError("DT-List005", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_EQUAL_LENGTH, ""));
            }
        } else {
            if (length < this._minLength) {
                valid = false;
                workspace.addError("DT-List002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.SHORTER_THAN_LENGTH, ""));
            }
            if (workspace.isCompleted()) {
                return valid;
            }
            if (this._maxLength > -1 && length > this._maxLength) {
                valid = false;
                workspace.addError("DT-List003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LONGER_THAN_LENGTH, ""));
            }
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        Datatype datatype = this.getDatatype();
        if (datatype == null) {
            valid = false;
            workspace.addError("DT-List004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LIST_NO_DATATYPE_DEFINATION_MSG, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        boolean isValid = false;
        try {
            while (st.hasMoreTokens()) {
                isValid = datatype.validate(st.nextToken(), context);
                if (isValid) continue;
                valid = false;
                workspace.addError("DT-List006", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        StringTokenizer stt = new StringTokenizer(s);
        String[] sArray = new String[length];
        int j = 0;
        try {
            while (st.hasMoreTokens()) {
                sArray[j] = st.nextToken();
                ++j;
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        isValid = false;
        String temp = null;
        int l = 0;
        if (this._enum != null) {
            for (int i = 0; i < this._enum.length; ++i) {
                if (s.equals(this._enum[i])) {
                    return valid;
                }
                StringTokenizer est = new StringTokenizer(this._enum[i]);
                if (sArray.length == est.countTokens()) {
                    try {
                        int k = 0;
                        l = 0;
                        while (st.hasMoreTokens() && datatype.equals(temp = st.nextToken(), sArray[k])) {
                            ++l;
                            ++k;
                        }
                    }
                    catch (NoSuchElementException e) {
                        // empty catch block
                    }
                }
                if (l != sArray.length) continue;
                return valid;
            }
            valid = false;
            workspace.addError("DT-List001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        return valid;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"length", this._length > -1 ? Integer.toString(this._length) : null}, {"minLength", this._minLength > -1 ? Integer.toString(this._minLength) : null}, {"maxLength", this._maxLength > -1 ? Integer.toString(this._maxLength) : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        super.setValues(val);
        this._enum = (String[])val.get("enumeration");
        this._length = val.getInt("length", -1);
        this._minLength = val.getInt("minLength", -1);
        this._maxLength = val.getInt("maxLength", -1);
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"length", this._length > -1 ? Integer.toString(this._length) : null}, {"minLength", this._minLength > -1 ? Integer.toString(this._minLength) : null}, {"maxLength", this._maxLength > -1 ? Integer.toString(this._maxLength) : null}};
        IData val = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    public void setFromData(IData val) {
        IDataCursor ic = val.getCursor();
        super.setFromData(val);
        this._enum = (String[])IDataUtil.get(ic, "enumeration");
        this._length = IDataUtil.getInt(ic, "length", -1);
        this._minLength = IDataUtil.getInt(ic, "minLength", -1);
        this._maxLength = IDataUtil.getInt(ic, "maxLength", -1);
        ic.destroy();
    }

    public Values getView() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"length", this._length > -1 ? Integer.toString(this._length) : null}, {"minLength", this._minLength > -1 ? Integer.toString(this._minLength) : null}, {"maxLength", this._maxLength > -1 ? Integer.toString(this._maxLength) : null}};
        return super.getView().copyFrom(new Values(o));
    }

    public String getName() {
        if (this._ncName != null && this._ncName.length() > 0) {
            return this._ncName;
        }
        return this.getSourceName();
    }

    public boolean isProxy() {
        return false;
    }

    public boolean isListType() {
        return true;
    }

    public QName getItemTypeName() {
        Datatype datatype = this.getDatatype();
        if (datatype != null) {
            return datatype.getQName();
        }
        return null;
    }

    public XSNode[] edges() {
        Datatype itemType;
        ArrayList<XSNode> c = new ArrayList<XSNode>();
        IData facets = this.getFacets();
        String[] keys = this.getFacetKeys();
        Datatype baseType = this.getBase();
        if (baseType != null && !baseType.isProxy()) {
            c.add(baseType);
        }
        if ((itemType = this.getDatatype()) != null && !itemType.isProxy()) {
            QName qName = itemType.getQName();
            if (qName != null && !BuiltInSimpleTypes.isBuiltIn(qName)) {
                c.add(itemType);
            }
            if (qName == null) {
                c.add(itemType);
            }
        }
        IDataCursor fc = facets.getCursor();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Object value = IDataUtil.get(fc, keys[i]);
            c.add(new LegacyFacet(key, value));
        }
        XSNode[] edges = new XSNode[c.size()];
        c.toArray(edges);
        return edges;
    }
}

