/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.lang.schema.dummyWorkSpace;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;

public class WmInteger
extends Datatype
implements Errors,
ValuesCodable {
    private static final String ERR001 = "DT-INTEGER001";
    private static final String MSG001 = "No matching choice value";
    private static final String ERR002 = "DT-INTEGER002";
    private static final String MSG002 = "Value does not conform to datatype ";
    private static final String ERR003 = "DT-INTEGER003";
    private static final String MSG003 = "Value is less than minimum";
    private static final String ERR004 = "DT-INTEGER004";
    private static final String MSG004 = "Value is greater than maximum";
    BigInteger[] _enum;
    BigInteger _maxInclusive;
    BigInteger _maxExclusive;
    BigInteger _minInclusive;
    BigInteger _minExclusive;
    boolean _foundMinI = false;
    boolean _foundMinE = false;
    boolean _foundMaxI = false;
    boolean _foundMaxE = false;
    private static NSRecord _nsRecord = null;

    public BigInteger[] getEnumeration() {
        return this._enum;
    }

    public BigInteger getMaxInclusive() {
        return this._maxInclusive;
    }

    public BigInteger getMaxExclusive() {
        return this._maxExclusive;
    }

    public BigInteger getMinInclusive() {
        return this._minInclusive;
    }

    public BigInteger getMinExclusive() {
        return this._minExclusive;
    }

    public void setEnumeration(BigInteger[] sa) {
        this._enum = sa;
    }

    public void setMaxInclusive(BigInteger maxInclusive) {
        this._maxInclusive = maxInclusive;
    }

    public void setMaxExclusive(BigInteger maxExclusive) {
        this._maxExclusive = maxExclusive;
    }

    public void setMinInclusive(BigInteger minInclusive) {
        this._minInclusive = minInclusive;
    }

    public void setMinExclusive(BigInteger minExclusive) {
        this._minExclusive = minExclusive;
    }

    public NSRecord getFacetsMetadata() {
        if (_nsRecord == null) {
            String[] tf = new String[]{"true", "false"};
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "pattern", 1, 1);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    public IData getFacets() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enum)}, {"minInclusive", this._minInclusive != null ? this._minInclusive.toString() : null}, {"minExclusive", this._minExclusive != null ? this._minExclusive.toString() : null}, {"maxInclusive", this._maxInclusive != null ? this._maxInclusive.toString() : null}, {"maxExclusive", this._maxExclusive != null ? this._maxExclusive.toString() : null}};
        IData val = super.getFacets();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacets(IData facets, Locale locale) throws NSException {
        String[] strPatterns;
        int i = 0;
        long max = 0L;
        long min = 0L;
        BigInteger minInclusive = null;
        BigInteger minExclusive = null;
        BigInteger maxInclusive = null;
        BigInteger maxExclusive = null;
        String minI = null;
        String minE = null;
        String maxI = null;
        String maxE = null;
        Pattern[] patterns = null;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        super.setFacets(facets, locale);
        IDataCursor ic = facets.getCursor();
        minI = IDataUtil.getString(ic, "minInclusive");
        minE = IDataUtil.getString(ic, "minExclusive");
        maxI = IDataUtil.getString(ic, "maxInclusive");
        maxE = IDataUtil.getString(ic, "maxExclusive");
        if (minI != null) {
            this._foundMinI = true;
            try {
                minInclusive = new BigInteger(minI);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_I, ""));
            }
            if (minE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MINI_AND_MINE, ""));
            }
        } else {
            try {
                if (minE != null) {
                    this._foundMinE = true;
                    minExclusive = new BigInteger(minE);
                }
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_E, ""));
            }
        }
        if (maxI != null) {
            this._foundMaxI = true;
            try {
                maxInclusive = new BigInteger(maxI);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_I, ""));
            }
            if (maxE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MAXI_AND_MAXE, ""));
            }
        } else {
            try {
                if (maxE != null) {
                    this._foundMaxE = true;
                    maxExclusive = new BigInteger(maxE);
                }
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_E, ""));
            }
        }
        if (maxInclusive != null) {
            if (minInclusive != null && maxInclusive.compareTo(minInclusive) < 0) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINI, ""));
            }
            if (minExclusive != null && maxInclusive.compareTo(minExclusive) < 0) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINE, ""));
            }
        }
        if (maxExclusive != null) {
            if (minInclusive != null && maxExclusive.compareTo(minInclusive) < 0) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINI, ""));
            }
            if (minExclusive != null && maxExclusive.compareTo(minExclusive) < 0) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINE, ""));
            }
        }
        if ((strPatterns = (String[])IDataUtil.get(ic, "pattern")) != null) {
            patterns = new Pattern[strPatterns.length];
            for (int k = 0; k < strPatterns.length; ++k) {
                if (strPatterns[k].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        patterns[k] = _compiler.compile(strPatterns[k]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_REGEX, "", strPatterns[k]));
                }
            }
        }
        String[] ss = (String[])IDataUtil.get(ic, "enumeration");
        ic.destroy();
        if (ss != null) {
            int len = ss.length;
            for (i = 0; i < len; ++i) {
                String s = ss[i];
                try {
                    BigInteger bd = new BigInteger(s);
                    if (!(minInclusive != null && bd.compareTo(minInclusive) < 0 || minExclusive != null && bd.compareTo(minExclusive) < 0 || maxInclusive != null && bd.compareTo(maxInclusive) > 0 || maxExclusive != null && bd.compareTo(maxExclusive) > 0) && WmInteger.checkEnumPattern(s, patterns)) continue;
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM, "", s));
                    continue;
                }
                catch (NumberFormatException e) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM, "", s));
                }
            }
        }
        if (errors.size() == 0) {
            this._enum = this.convertToBiArray(ss);
            this._minInclusive = minInclusive;
            this._maxInclusive = maxInclusive;
            this._minExclusive = minExclusive;
            this._maxExclusive = maxExclusive;
            this._strPatterns = strPatterns;
            this._patterns = patterns;
        } else {
            WmInteger.throwNSException(errors, locale);
        }
    }

    public boolean validate(String s, Object context) {
        boolean ret;
        block18: {
            ret = true;
            s = WmInteger.handleWhiteSpace(s, 3);
            boolean valid = true;
            valid = super.validate(s, context);
            if (!valid) {
                return false;
            }
            ValidationWorkspace workspace = (ValidationWorkspace)context;
            if (workspace == null) {
                return false;
            }
            if (this._enum != null) {
                int i;
                int len = this._enum.length;
                for (i = 0; i < len; ++i) {
                    if (!s.equals(this._enum[i].toString())) {
                        continue;
                    }
                    break block18;
                }
                if (i == len) {
                    workspace.addError(ERR001, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
                    ret = false;
                }
            } else {
                BigInteger bi;
                try {
                    bi = new BigInteger(s);
                }
                catch (NumberFormatException e) {
                    workspace.addError(ERR002, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    ret = false;
                    break block18;
                }
                if (this._minInclusive != null && bi.compareTo(this._minInclusive) < 0) {
                    workspace.addError(ERR003, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
                    ret = false;
                } else if (this._minExclusive != null && bi.compareTo(this._minExclusive) <= 0) {
                    workspace.addError(ERR003, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
                    ret = false;
                } else if (this._maxInclusive != null && bi.compareTo(this._maxInclusive) > 0) {
                    workspace.addError(ERR004, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
                    ret = false;
                } else if (this._maxExclusive != null && bi.compareTo(this._maxExclusive) >= 0) {
                    workspace.addError(ERR004, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
                    ret = false;
                } else if (!this.checkPattern(s, workspace)) {
                    ret = false;
                }
            }
        }
        return ret;
    }

    public void setValues(Values val) {
        String s = null;
        if (val.get("enum") != null || val.get("maximum") != null || val.get("minimum") != null) {
            WmInteger.migrate(val);
        }
        super.setValues(val);
        String[] sa = (String[])val.get("enumeration");
        if (sa != null) {
            this._enum = this.convertToBiArray(sa);
        }
        if ((s = val.getString("minInclusive")) != null) {
            this._minInclusive = new BigInteger(s);
        }
        if ((s = val.getString("minExclusive")) != null) {
            this._minExclusive = new BigInteger(s);
        }
        if ((s = val.getString("maxInclusive")) != null) {
            this._maxInclusive = new BigInteger(s);
        }
        if ((s = val.getString("maxExclusive")) != null) {
            this._maxExclusive = new BigInteger(s);
        }
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enum)}, {"minInclusive", this._minInclusive != null ? this._minInclusive.toString() : null}, {"minExclusive", this._minExclusive != null ? this._minExclusive.toString() : null}, {"maxInclusive", this._maxInclusive != null ? this._maxInclusive.toString() : null}, {"maxExclusive", this._maxExclusive != null ? this._maxExclusive.toString() : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setFromData(IData data) {
        IDataCursor idc = data.getCursor();
        if (IDataUtil.get(idc, "enum") != null || IDataUtil.get(idc, "maximum") != null || IDataUtil.get(idc, "minimum") != null) {
            WmInteger.migrate(data);
        }
        super.setFromData(data);
        if (idc.first("enumeration")) {
            this._enum = this.convertToBiArray(IDataUtil.getStringArray(idc));
        }
        if (idc.first("minInclusive")) {
            this._minInclusive = new BigInteger(IDataUtil.getString(idc));
        }
        if (idc.first("minExclusive")) {
            this._minExclusive = new BigInteger(IDataUtil.getString(idc));
        }
        if (idc.first("maxInclusive")) {
            this._maxInclusive = new BigInteger(IDataUtil.getString(idc));
        }
        if (idc.first("maxExclusive")) {
            this._maxExclusive = new BigInteger(IDataUtil.getString(idc));
        }
        idc.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enum)}, {"minInclusive", this._minInclusive != null ? this._minInclusive.toString() : null}, {"minExclusive", this._minExclusive != null ? this._minExclusive.toString() : null}, {"maxInclusive", this._maxInclusive != null ? this._maxInclusive.toString() : null}, {"maxExclusive", this._maxExclusive != null ? this._maxExclusive.toString() : null}};
        IData data = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), data);
        return data;
    }

    public Values getView() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enum)}, {"minInclusive", this._minInclusive != null ? this._minInclusive.toString() : null}, {"minExclusive", this._minExclusive != null ? this._minExclusive.toString() : null}, {"maxInclusive", this._maxInclusive != null ? this._maxInclusive.toString() : null}, {"maxExclusive", this._maxExclusive != null ? this._maxExclusive.toString() : null}};
        return super.getView().copyFrom(new Values(o));
    }

    private String[] convertToStringArray(BigInteger[] biArray) {
        if (biArray == null) {
            return null;
        }
        String[] stringArray = new String[biArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            stringArray[index] = biArray[index].toString();
        }
        return stringArray;
    }

    private BigInteger[] convertToBiArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        BigInteger[] biArray = new BigInteger[stringArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            try {
                biArray[index] = new BigInteger(stringArray[index]);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return biArray;
    }

    private static final void migrate(IData val) {
        IDataCursor idc = val.getCursor();
        String[] oldDataArray = (String[])IDataUtil.get(idc, "enum");
        IDataUtil.put(idc, "enumeration", oldDataArray);
        String oldData = IDataUtil.getString(idc, "maximum");
        IDataUtil.put(idc, "maxInclusive", oldData);
        oldData = IDataUtil.getString(idc, "minimum");
        IDataUtil.put(idc, "minInclusive", oldData);
        idc.destroy();
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        BigInteger b1 = new BigInteger(s1);
        BigInteger b2 = new BigInteger(s2);
        return b1.compareTo(b2) == 0;
    }

    public static void main(String[] args) {
        Datatype st = null;
        try {
            st = Datatype.create("integer");
        }
        catch (NSException e) {
            e.printStackTrace();
        }
        IData facet = st.getFacets();
        System.out.println("first toString " + facet.toString());
        IDataCursor icf = facet.getCursor();
        icf.insertAfter("maxInclusive", "0");
        icf.destroy();
        System.out.println(facet.toString());
        try {
            st.setFacets(facet);
        }
        catch (NSException e) {
            e.printStackTrace();
        }
        dummyWorkSpace context = new dummyWorkSpace();
        boolean valid = true;
        valid = st.validate("25", context);
        System.out.println(valid);
    }
}

