/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.WmLong;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;

public class WmInt
extends Datatype
implements Errors,
ValuesCodable {
    private static final String ERR001 = "DT-INT001";
    private static final String MSG001 = "Value does not conform to datatype ";
    int[] _enumeration;
    int _maxInclusive;
    int _maxExclusive;
    int _minInclusive;
    int _minExclusive;
    boolean _initialized = false;
    boolean _foundMinI = false;
    boolean _foundMinE = false;
    boolean _foundMaxI = false;
    boolean _foundMaxE = false;
    private static NSRecord _nsRecord = null;

    public int[] getEnumeration() {
        return this._enumeration;
    }

    public int getMaxInclusive() {
        return this._maxInclusive;
    }

    public int getMaxExclusive() {
        return this._maxExclusive;
    }

    public int getMinInclusive() {
        return this._minInclusive;
    }

    public int getMinExclusive() {
        return this._minExclusive;
    }

    public void setEnumeration(int[] sa) {
        this._enumeration = sa;
    }

    public void setMaxInclusive(int maxInclusive) {
        this._maxInclusive = maxInclusive;
    }

    public void setMaxExclusive(int maxExclusive) {
        this._maxExclusive = maxExclusive;
    }

    public void setMinInclusive(int minInclusive) {
        this._minInclusive = minInclusive;
    }

    public void setMinExclusive(int minExclusive) {
        this._minExclusive = minExclusive;
    }

    public NSRecord getFacetsMetadata() {
        if (_nsRecord == null) {
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "pattern", 1, 1);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    public IData getFacets() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enumeration)}, {"minInclusive", this._initialized && this._foundMinI ? Integer.toString(this._minInclusive) : null}, {"minExclusive", this._initialized && this._foundMinE ? Integer.toString(this._minExclusive) : null}, {"maxInclusive", this._initialized && this._foundMaxI ? Integer.toString(this._maxInclusive) : null}, {"maxExclusive", this._initialized && this._foundMaxE ? Integer.toString(this._maxExclusive) : null}};
        IData data = super.getFacets();
        IDataUtil.merge(IDataFactory.create(o), data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacets(IData facets, Locale locale) throws NSException {
        String[] strEnum;
        String[] strPatterns;
        int maxInclusive = Integer.MAX_VALUE;
        int maxExclusive = Integer.MAX_VALUE;
        int minInclusive = Integer.MIN_VALUE;
        int minExclusive = Integer.MIN_VALUE;
        boolean foundMinI = false;
        boolean foundMinE = false;
        boolean foundMaxI = false;
        boolean foundMaxE = false;
        int enumerationItem = Integer.MIN_VALUE;
        int[] enumeration = null;
        Pattern[] patterns = null;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        super.setFacets(facets, locale);
        IDataCursor ic = facets.getCursor();
        String minI = IDataUtil.getString(ic, "minInclusive");
        String minE = IDataUtil.getString(ic, "minExclusive");
        String maxI = IDataUtil.getString(ic, "maxInclusive");
        String maxE = IDataUtil.getString(ic, "maxExclusive");
        this._initialized = true;
        if (minI != null) {
            foundMinI = true;
            try {
                minInclusive = Integer.valueOf(minI);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_I, ""));
            }
            if (minE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MINI_AND_MINE, ""));
            }
        } else {
            try {
                if (minE != null) {
                    foundMinE = true;
                    minExclusive = Integer.valueOf(minE);
                }
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_E, ""));
            }
        }
        if (maxI != null) {
            foundMaxI = true;
            try {
                maxInclusive = Integer.valueOf(maxI);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_I, ""));
            }
            if (maxE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MAXI_AND_MAXE, ""));
            }
        } else {
            try {
                if (maxE != null) {
                    foundMaxE = true;
                    maxExclusive = Integer.valueOf(maxE);
                }
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_E, ""));
            }
        }
        if (foundMaxI) {
            if (foundMinI && maxInclusive < minInclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINI, ""));
            }
            if (foundMinE && maxInclusive < minExclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINE, ""));
            }
        }
        if (foundMaxE) {
            if (foundMinI && maxExclusive < minInclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINI, ""));
            }
            if (foundMinE && maxExclusive < minExclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINE, ""));
            }
        }
        if ((strPatterns = (String[])IDataUtil.get(ic, "pattern")) != null) {
            patterns = new Pattern[strPatterns.length];
            for (int i = 0; i < strPatterns.length; ++i) {
                if (strPatterns[i].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        patterns[i] = _compiler.compile(strPatterns[i]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_REGEX, "", strPatterns[i]));
                }
            }
        }
        if ((strEnum = (String[])IDataUtil.get(ic, "enumeration")) != null) {
            enumeration = new int[strEnum.length];
            for (int i = 0; i < strEnum.length; ++i) {
                String strEnumItem = strEnum[i];
                try {
                    enumerationItem = Integer.valueOf(strEnumItem);
                }
                catch (NumberFormatException e) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_NOT_CONFORM_TYPE, "", strEnumItem));
                }
                if (foundMaxI) {
                    if (foundMinI) {
                        if (enumerationItem < minInclusive || enumerationItem > maxInclusive) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", strEnumItem));
                        }
                    } else if (foundMinE && (enumerationItem <= minExclusive || enumerationItem > maxInclusive)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", strEnumItem));
                    }
                } else if (foundMaxE) {
                    if (foundMinI) {
                        if (enumerationItem < minInclusive || enumerationItem >= maxExclusive) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", strEnumItem));
                        }
                    } else if (foundMinE && (enumerationItem <= minExclusive || enumerationItem >= maxExclusive)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", strEnumItem));
                    }
                }
                if (!WmInt.checkEnumPattern(strEnumItem, patterns)) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_NOT_MATCH_PATTERN, "", strEnumItem));
                }
                enumeration[i] = enumerationItem;
            }
        }
        ic.destroy();
        if (errors.size() == 0) {
            if (foundMinI) {
                this._minInclusive = minInclusive;
            }
            this._foundMinI = foundMinI;
            if (foundMinE) {
                this._minExclusive = minExclusive;
            }
            this._foundMinE = foundMinE;
            if (foundMaxI) {
                this._maxInclusive = maxInclusive;
            }
            this._foundMaxI = foundMaxI;
            if (foundMaxE) {
                this._maxExclusive = maxExclusive;
            }
            this._foundMaxE = foundMaxE;
            this._enumeration = enumeration;
            this._strPatterns = strPatterns;
            this._patterns = patterns;
        } else {
            WmInt.throwNSException(errors, locale);
        }
    }

    public boolean validate(String s, Object context) {
        int value;
        s = WmInt.handleWhiteSpace(s, 3);
        boolean valid = true;
        valid = super.validate(s, context);
        if (!valid) {
            return false;
        }
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        try {
            value = Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            valid = false;
            workspace.addError("DT-Int004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
            return valid;
        }
        if (this._enumeration != null) {
            for (int i = 0; i < this._enumeration.length; ++i) {
                if (value != this._enumeration[i]) continue;
                return valid;
            }
            valid = false;
            workspace.addError("DT-Int001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
            return valid;
        }
        if (this._foundMinI && value < this._minInclusive) {
            workspace.addError("DT-Int002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._foundMinE && value <= this._minExclusive) {
            workspace.addError("DT-Int002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._foundMaxI && value > this._maxInclusive) {
            workspace.addError("DT-Int003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._foundMaxE && value >= this._maxExclusive) {
            workspace.addError("DT-Int003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (!this.checkPattern(s, workspace)) {
            valid = false;
        }
        return valid;
    }

    public void setValues(Values val) {
        String s = null;
        super.setValues(val);
        String[] sa = (String[])val.get("enumeration");
        if (sa != null) {
            this._enumeration = this.convertTointArray(sa);
        }
        this._foundMinI = val.getBoolean("foundMinI");
        this._foundMinE = val.getBoolean("foundMinE");
        this._foundMaxI = val.getBoolean("foundMaxI");
        this._foundMaxE = val.getBoolean("foundMaxE");
        this._initialized = val.getBoolean("initialized");
        try {
            s = val.getString("minInclusive");
            if (s != null) {
                this._minInclusive = Integer.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            this._minInclusive = Integer.MIN_VALUE;
        }
        try {
            s = val.getString("minExclusive");
            if (s != null) {
                this._minExclusive = Integer.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            this._minExclusive = Integer.MIN_VALUE;
        }
        try {
            s = val.getString("maxInclusive");
            if (s != null) {
                this._maxInclusive = Integer.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            this._maxInclusive = Integer.MAX_VALUE;
        }
        try {
            s = val.getString("maxExclusive");
            if (s != null) {
                this._maxExclusive = Integer.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            this._maxExclusive = Integer.MAX_VALUE;
        }
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enumeration)}, {"foundMinI", new Boolean(this._foundMinI).toString()}, {"foundMinE", new Boolean(this._foundMinE).toString()}, {"foundMaxI", new Boolean(this._foundMaxI).toString()}, {"foundMaxE", new Boolean(this._foundMaxE).toString()}, {"initialized", new Boolean(this._initialized).toString()}, {"minInclusive", this._initialized && this._foundMinI ? Integer.toString(this._minInclusive) : null}, {"minExclusive", this._initialized && this._foundMinE ? Integer.toString(this._minExclusive) : null}, {"maxInclusive", this._initialized && this._foundMaxI ? Integer.toString(this._maxInclusive) : null}, {"maxExclusive", this._initialized && this._foundMaxE ? Integer.toString(this._maxExclusive) : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setFromData(IData data) {
        super.setFromData(data);
        IDataCursor idc = data.getCursor();
        if (idc.first("enumeration")) {
            this._enumeration = this.convertTointArray(IDataUtil.getStringArray(idc));
        }
        this._foundMinI = IDataUtil.getBoolean(idc, "foundMinI");
        this._foundMinE = IDataUtil.getBoolean(idc, "foundMinE");
        this._foundMaxI = IDataUtil.getBoolean(idc, "foundMaxI");
        this._foundMaxE = IDataUtil.getBoolean(idc, "foundMaxE");
        this._initialized = IDataUtil.getBoolean(idc, "initialized");
        try {
            if (idc.first("minInclusive")) {
                this._minInclusive = Integer.valueOf(IDataUtil.getString(idc));
            }
        }
        catch (NumberFormatException e) {
            this._minInclusive = Integer.MIN_VALUE;
        }
        try {
            if (idc.first("minExclusive")) {
                this._minExclusive = Integer.valueOf(IDataUtil.getString(idc));
            }
        }
        catch (NumberFormatException e) {
            this._minExclusive = Integer.MIN_VALUE;
        }
        try {
            if (idc.first("maxInclusive")) {
                this._maxInclusive = Integer.valueOf(IDataUtil.getString(idc));
            }
        }
        catch (NumberFormatException e) {
            this._maxInclusive = Integer.MAX_VALUE;
        }
        try {
            if (idc.first("maxExclusive")) {
                this._maxExclusive = Integer.valueOf(IDataUtil.getString(idc));
            }
        }
        catch (NumberFormatException e) {
            this._maxExclusive = Integer.MAX_VALUE;
        }
        idc.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enumeration)}, {"foundMinI", new Boolean(this._foundMinI).toString()}, {"foundMinE", new Boolean(this._foundMinE).toString()}, {"foundMaxI", new Boolean(this._foundMaxI).toString()}, {"foundMaxE", new Boolean(this._foundMaxE).toString()}, {"initialized", new Boolean(this._initialized).toString()}, {"minInclusive", this._initialized && this._foundMinI ? Integer.toString(this._minInclusive) : null}, {"minExclusive", this._initialized && this._foundMinE ? Integer.toString(this._minExclusive) : null}, {"maxInclusive", this._initialized && this._foundMaxI ? Integer.toString(this._maxInclusive) : null}, {"maxExclusive", this._initialized && this._foundMaxE ? Integer.toString(this._maxExclusive) : null}};
        IData data = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), data);
        return data;
    }

    public Values getView() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enumeration)}, {"foundMinI", new Boolean(this._foundMinI).toString()}, {"foundMinE", new Boolean(this._foundMinE).toString()}, {"foundMaxI", new Boolean(this._foundMaxI).toString()}, {"foundMaxE", new Boolean(this._foundMaxE).toString()}, {"initialized", new Boolean(this._initialized).toString()}, {"minInclusive", this._initialized && this._foundMinI ? Integer.toString(this._minInclusive) : null}, {"minExclusive", this._initialized && this._foundMinE ? Integer.toString(this._minExclusive) : null}, {"maxInclusive", this._initialized && this._foundMaxI ? Integer.toString(this._maxInclusive) : null}, {"maxExclusive", this._initialized && this._foundMaxE ? Integer.toString(this._maxExclusive) : null}};
        return super.getView().copyFrom(new Values(o));
    }

    String[] convertToStringArray(int[] intArray) {
        if (intArray == null) {
            return null;
        }
        String[] stringArray = new String[intArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            stringArray[index] = Integer.toString(intArray[index]);
        }
        return stringArray;
    }

    int[] convertTointArray(String[] stringArray) {
        int index;
        if (stringArray == null) {
            return null;
        }
        Vector<Integer> temp = new Vector<Integer>();
        for (index = 0; index < stringArray.length; ++index) {
            try {
                temp.addElement(new Integer(stringArray[index]));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int[] intArray = new int[temp.size()];
        for (index = 0; index < intArray.length; ++index) {
            intArray[index] = (Integer)temp.elementAt(index);
        }
        return intArray;
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        Integer d1 = Integer.valueOf(s1);
        Integer d2 = Integer.valueOf(s2);
        return d1.equals(d2);
    }

    public static void main(String[] args) {
        SimpleType st = new WmLong();
        IData facets = IDataFactory.create();
        IDataCursor icf = facets.getCursor();
        icf.insertAfter("minInclusive", "-2147483648");
        icf.insertAfter("maxInclusive", "2147483647");
        icf.destroy();
        try {
            IData in = st.getFacets();
            System.out.println(in);
            IDataUtil.copy(in, facets);
            st.setFacets(in);
            st = Datatype.deriveFrom((Datatype)st);
            in = st.getFacets();
            System.out.println(st.getFacets());
            IDataCursor ic = in.getCursor();
            ic.insertAfter("maxExclusive", "97");
            ic.destroy();
            st.setFacets(in);
            System.out.println(st.getFacets());
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }
}

