/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;

public class WmDouble
extends Datatype
implements Errors,
ValuesCodable {
    private static final String ERR001 = "DT-Double001";
    private static final String MSG001 = "Value is not a Double number";
    double[] _enumeration;
    double _maxInclusive;
    double _maxExclusive;
    double _minInclusive;
    double _minExclusive;
    boolean _initialized = false;
    boolean _foundMinI = false;
    boolean _foundMinE = false;
    boolean _foundMaxI = false;
    boolean _foundMaxE = false;
    private static NSRecord _nsRecord = null;

    public double[] getEnumeration() {
        return this._enumeration;
    }

    public double getMaxInclusive() {
        return this._maxInclusive;
    }

    public double getMaxExclusive() {
        return this._maxExclusive;
    }

    public double getMinInclusive() {
        return this._minInclusive;
    }

    public double getMinExclusive() {
        return this._minExclusive;
    }

    public void setEnumeration(double[] sa) {
        this._enumeration = sa;
    }

    public void setMaxInclusive(double maxInclusive) {
        this._maxInclusive = maxInclusive;
    }

    public void setMaxExclusive(double maxExclusive) {
        this._maxExclusive = maxExclusive;
    }

    public void setMinInclusive(double minInclusive) {
        this._minInclusive = minInclusive;
    }

    public void setMinExclusive(double minExclusive) {
        this._minExclusive = minExclusive;
    }

    public NSRecord getFacetsMetadata() {
        if (_nsRecord == null) {
            String[] tf = new String[]{"true", "false"};
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "pattern", 1, 1);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    public IData getFacets() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enumeration)}, {"minInclusive", this._initialized && this._foundMinI ? Double.toString(this._minInclusive) : null}, {"minExclusive", this._initialized && this._foundMinE ? Double.toString(this._minExclusive) : null}, {"maxInclusive", this._initialized && this._foundMaxI ? Double.toString(this._maxInclusive) : null}, {"maxExclusive", this._initialized && this._foundMaxE ? Double.toString(this._maxExclusive) : null}};
        IData data = super.getFacets();
        IDataUtil.merge(IDataFactory.create(o), data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacets(IData facets, Locale locale) throws NSException {
        String[] strPatterns;
        double maxInclusive = Double.MAX_VALUE;
        double maxExclusive = Double.MAX_VALUE;
        double minInclusive = Double.MIN_VALUE;
        double minExclusive = Double.MIN_VALUE;
        double enumerationItem = Double.MIN_VALUE;
        double[] enumeration = null;
        Pattern[] patterns = null;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        super.setFacets(facets, locale);
        IDataCursor ic = facets.getCursor();
        String minI = IDataUtil.getString(ic, "minInclusive");
        String minE = IDataUtil.getString(ic, "minExclusive");
        String maxI = IDataUtil.getString(ic, "maxInclusive");
        String maxE = IDataUtil.getString(ic, "maxExclusive");
        this._initialized = true;
        if (minI != null) {
            this._foundMinI = true;
            try {
                minInclusive = Double.valueOf(minI);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_I, ""));
            }
            if (minE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MINI_AND_MINE, ""));
            }
        } else {
            try {
                if (minE != null) {
                    this._foundMinE = true;
                    minExclusive = Double.valueOf(minE);
                }
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_E, ""));
            }
        }
        if (maxI != null) {
            this._foundMaxI = true;
            try {
                maxInclusive = Double.valueOf(maxI);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_I, ""));
            }
            if (maxE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MAXI_AND_MAXE, ""));
            }
        } else {
            try {
                if (maxE != null) {
                    this._foundMaxE = true;
                    maxExclusive = Double.valueOf(maxE);
                }
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_E, ""));
            }
        }
        if (this._foundMaxI) {
            if (this._foundMinI && maxInclusive < minInclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINI, ""));
            }
            if (this._foundMinE && maxInclusive < minExclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINE, ""));
            }
        }
        if (this._foundMaxE) {
            if (this._foundMinI && maxExclusive < minInclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINI, ""));
            }
            if (this._foundMinE && maxExclusive < minExclusive) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINE, ""));
            }
        }
        if ((strPatterns = (String[])IDataUtil.get(ic, "pattern")) != null) {
            patterns = new Pattern[strPatterns.length];
            for (int i = 0; i < strPatterns.length; ++i) {
                if (strPatterns[i].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        patterns[i] = _compiler.compile(strPatterns[i]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_REGEX, "", strPatterns[i]));
                }
            }
        }
        String[] strEnum = (String[])IDataUtil.get(ic, "enumeration");
        ic.destroy();
        if (strEnum != null) {
            enumeration = new double[strEnum.length];
            for (int i = 0; i < strEnum.length; ++i) {
                String strEnumItem = strEnum[i];
                try {
                    enumerationItem = Double.valueOf(strEnumItem);
                }
                catch (NumberFormatException e) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_NOT_CONFORM_TYPE, "", strEnumItem));
                }
                if (this._foundMaxI) {
                    if (this._foundMinI) {
                        if (enumerationItem < minInclusive || enumerationItem > maxInclusive) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", strEnumItem));
                        }
                    } else if (this._foundMinE && (enumerationItem <= minExclusive || enumerationItem > maxInclusive)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", strEnumItem));
                    }
                } else if (this._foundMaxE) {
                    if (this._foundMinI) {
                        if (enumerationItem < minInclusive || enumerationItem >= maxExclusive) {
                            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", strEnumItem));
                        }
                    } else if (this._foundMinE && (enumerationItem <= minExclusive || enumerationItem >= maxExclusive)) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_OUT_OF_RANGE, "", strEnumItem));
                    }
                }
                if (!WmDouble.checkEnumPattern(strEnumItem, patterns)) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM_NOT_MATCH_PATTERN, "", strEnumItem));
                }
                enumeration[i] = enumerationItem;
            }
        }
        if (errors.size() == 0) {
            if (this._foundMinI) {
                this._minInclusive = minInclusive;
            }
            if (this._foundMinE) {
                this._minExclusive = minExclusive;
            }
            if (this._foundMaxI) {
                this._maxInclusive = maxInclusive;
            }
            if (this._foundMaxE) {
                this._maxExclusive = maxExclusive;
            }
            this._enumeration = enumeration;
            this._strPatterns = strPatterns;
            this._patterns = patterns;
        } else {
            WmDouble.throwNSException(errors, locale);
        }
    }

    public boolean validate(String s, Object context) {
        double value;
        s = WmDouble.handleWhiteSpace(s, 3);
        boolean valid = true;
        valid = super.validate(s, context);
        if (!valid) {
            return false;
        }
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        try {
            value = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            valid = false;
            workspace.addError("DT-Double004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
            return valid;
        }
        if (this._enumeration != null) {
            for (int i = 0; i < this._enumeration.length; ++i) {
                if (value != this._enumeration[i]) continue;
                return valid;
            }
            valid = false;
            workspace.addError(ERR001, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
            return valid;
        }
        if (this._foundMinI && value < this._minInclusive) {
            workspace.addError("DT-Double002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._foundMinE && value <= this._minExclusive) {
            workspace.addError("DT-Double002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._foundMaxI && value > this._maxInclusive) {
            workspace.addError("DT-Double003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (this._foundMaxE && value >= this._maxExclusive) {
            workspace.addError("DT-Double003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
            valid = false;
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (!this.checkPattern(s, workspace)) {
            valid = false;
        }
        return valid;
    }

    public void setValues(Values val) {
        String s = null;
        super.setValues(val);
        String[] sa = (String[])val.get("enumeration");
        if (sa != null) {
            this._enumeration = this.convertTodoubleArray(sa);
        }
        this._foundMinI = val.getBoolean("foundMinI");
        this._foundMinE = val.getBoolean("foundMinE");
        this._foundMaxI = val.getBoolean("foundMaxI");
        this._foundMaxE = val.getBoolean("foundMaxE");
        this._initialized = val.getBoolean("initialized");
        try {
            s = val.getString("minInclusive");
            if (s != null) {
                this._minInclusive = Double.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            s = val.getString("minExclusive");
            if (s != null) {
                this._minExclusive = Double.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            s = val.getString("maxInclusive");
            if (s != null) {
                this._maxInclusive = Double.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            s = val.getString("maxExclusive");
            if (s != null) {
                this._maxExclusive = Double.valueOf(s);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enumeration)}, {"foundMinI", new Boolean(this._foundMinI).toString()}, {"foundMinE", new Boolean(this._foundMinE).toString()}, {"foundMaxI", new Boolean(this._foundMaxI).toString()}, {"foundMaxE", new Boolean(this._foundMaxE).toString()}, {"initialized", new Boolean(this._initialized).toString()}, {"minInclusive", this._initialized && this._foundMinI ? Double.toString(this._minInclusive) : null}, {"minExclusive", this._initialized && this._foundMinE ? Double.toString(this._minExclusive) : null}, {"maxInclusive", this._initialized && this._foundMaxI ? Double.toString(this._maxInclusive) : null}, {"maxExclusive", this._initialized && this._foundMaxE ? Double.toString(this._maxExclusive) : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setFromData(IData data) {
        String[] sa = null;
        super.setFromData(data);
        IDataCursor idhc = data.getCursor();
        if (idhc.first("enumeration")) {
            sa = (String[])idhc.getValue();
        }
        this._enumeration = this.convertTodoubleArray(sa);
        this._foundMinI = IDataUtil.getBoolean(idhc, "foundMinI");
        this._foundMinE = IDataUtil.getBoolean(idhc, "foundMinE");
        this._foundMaxI = IDataUtil.getBoolean(idhc, "foundMaxI");
        this._foundMaxE = IDataUtil.getBoolean(idhc, "foundMaxE");
        this._initialized = IDataUtil.getBoolean(idhc, "initialized");
        try {
            this._minInclusive = idhc.first("minInclusive") ? Double.valueOf(IDataUtil.getString(idhc)) : Double.MIN_VALUE;
        }
        catch (NumberFormatException e) {
            this._minInclusive = Double.MIN_VALUE;
        }
        try {
            this._minExclusive = idhc.first("minExclusive") ? Double.valueOf(IDataUtil.getString(idhc)) : Double.MIN_VALUE;
        }
        catch (NumberFormatException e) {
            this._minExclusive = Double.MIN_VALUE;
        }
        try {
            this._maxInclusive = idhc.first("maxInclusive") ? Double.valueOf(IDataUtil.getString(idhc)) : Double.MAX_VALUE;
        }
        catch (NumberFormatException e) {
            this._maxInclusive = Double.MAX_VALUE;
        }
        try {
            this._maxExclusive = idhc.first("maxExclusive") ? Double.valueOf(IDataUtil.getString(idhc)) : Double.MAX_VALUE;
        }
        catch (NumberFormatException e) {
            this._maxExclusive = Double.MAX_VALUE;
        }
        idhc.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enumeration)}, {"foundMinI", new Boolean(this._foundMinI).toString()}, {"foundMinE", new Boolean(this._foundMinE).toString()}, {"foundMaxI", new Boolean(this._foundMaxI).toString()}, {"foundMaxE", new Boolean(this._foundMaxE).toString()}, {"initialized", new Boolean(this._initialized).toString()}, {"minInclusive", this._initialized && this._foundMinI ? Double.toString(this._minInclusive) : null}, {"minExclusive", this._initialized && this._foundMinE ? Double.toString(this._minExclusive) : null}, {"maxInclusive", this._initialized && this._foundMaxI ? Double.toString(this._maxInclusive) : null}, {"maxExclusive", this._initialized && this._foundMaxE ? Double.toString(this._maxExclusive) : null}};
        IData data = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), data);
        return data;
    }

    public Values getView() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enumeration)}, {"foundMinI", new Boolean(this._foundMinI).toString()}, {"foundMinE", new Boolean(this._foundMinE).toString()}, {"foundMaxI", new Boolean(this._foundMaxI).toString()}, {"foundMaxE", new Boolean(this._foundMaxE).toString()}, {"initialized", new Boolean(this._initialized).toString()}, {"minInclusive", this._initialized && this._foundMinI ? Double.toString(this._minInclusive) : null}, {"minExclusive", this._initialized && this._foundMinE ? Double.toString(this._minExclusive) : null}, {"maxInclusive", this._initialized && this._foundMaxI ? Double.toString(this._maxInclusive) : null}, {"maxExclusive", this._initialized && this._foundMaxE ? Double.toString(this._maxExclusive) : null}};
        return super.getView().copyFrom(new Values(o));
    }

    String[] convertToStringArray(double[] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        String[] stringArray = new String[doubleArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            stringArray[index] = Double.toString(doubleArray[index]);
        }
        return stringArray;
    }

    double[] convertTodoubleArray(String[] stringArray) {
        int index;
        if (stringArray == null) {
            return null;
        }
        Vector<Double> temp = new Vector<Double>();
        for (index = 0; index < stringArray.length; ++index) {
            try {
                temp.addElement(new Double(stringArray[index]));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        double[] doubleArray = new double[temp.size()];
        for (index = 0; index < doubleArray.length; ++index) {
            doubleArray[index] = (Double)temp.elementAt(index);
        }
        return doubleArray;
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        Double d1 = Double.valueOf(s1);
        Double d2 = Double.valueOf(s2);
        return d1.equals(d2);
    }
}

