/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;

public class WmDecimal
extends Datatype
implements Errors,
ValuesCodable {
    private static final String DFLT_MIN = "-99999999999999.9999";
    private static final String DFLT_MAX = "99999999999999.9999";
    private static final int DFLT_SCALE = -1;
    private static final int DFLT_PRECISION = -1;
    BigDecimal[] _enum;
    int _precision = -1;
    int _scale = -1;
    BigDecimal _maxInclusive;
    BigDecimal _maxExclusive;
    BigDecimal _minInclusive;
    BigDecimal _minExclusive;
    boolean _foundMinI = false;
    boolean _foundMinE = false;
    boolean _foundMaxI = false;
    boolean _foundMaxE = false;
    private static NSRecord _nsRecord = null;

    public BigDecimal[] getEnumeration() {
        return this._enum;
    }

    public int getPrecision() {
        return this._precision;
    }

    public int getScale() {
        return this._scale;
    }

    public BigDecimal getMaxInclusive() {
        return this._maxInclusive;
    }

    public BigDecimal getMaxExclusive() {
        return this._maxExclusive;
    }

    public BigDecimal getMinInclusive() {
        return this._minInclusive;
    }

    public BigDecimal getMinExclusive() {
        return this._minExclusive;
    }

    public void setEnumeration(BigDecimal[] sa) {
        this._enum = sa;
    }

    public void setPrecision(int precision) {
        this._precision = precision;
    }

    public void setScale(int scale) {
        this._scale = scale;
    }

    public void setMaxInclusive(BigDecimal maxInclusive) {
        this._maxInclusive = maxInclusive;
    }

    public void setMaxExclusive(BigDecimal maxExclusive) {
        this._maxExclusive = maxExclusive;
    }

    public void setMinInclusive(BigDecimal minInclusive) {
        this._minInclusive = minInclusive;
    }

    public void setMinExclusive(BigDecimal minExclusive) {
        this._minExclusive = minExclusive;
    }

    public NSRecord getFacetsMetadata() {
        if (_nsRecord == null) {
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxInclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxExclusive", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "precision", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "scale", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "pattern", 1, 1);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    public IData getFacets() {
        IData val = super.getFacets();
        IDataCursor ic = val.getCursor();
        ic.insertAfter("enumeration", this.convertToStringArray(this._enum));
        if (this._minInclusive != null) {
            ic.insertAfter("minInclusive", this._minInclusive.toString());
        }
        if (this._minExclusive != null) {
            ic.insertAfter("minExclusive", this._minExclusive.toString());
        }
        if (this._maxInclusive != null) {
            ic.insertAfter("maxInclusive", this._maxInclusive.toString());
        }
        if (this._maxExclusive != null) {
            ic.insertAfter("maxExclusive", this._maxExclusive.toString());
        }
        if (this._precision > -1) {
            ic.insertAfter("precision", Integer.toString(this._precision));
        }
        if (this._scale > -1) {
            ic.insertAfter("scale", Integer.toString(this._scale));
        }
        ic.destroy();
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacets(IData facets, Locale locale) throws NSException {
        String[] ss;
        String[] strPatterns;
        int i = 0;
        BigDecimal minInclusive = null;
        BigDecimal minExclusive = null;
        BigDecimal maxInclusive = null;
        BigDecimal maxExclusive = null;
        int len = -1;
        int precision = -1;
        int scale = -1;
        String minI = null;
        String minE = null;
        String maxI = null;
        String maxE = null;
        String s = null;
        Object enumvar = null;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        Pattern[] patterns = null;
        super.setFacets(facets, locale);
        IDataCursor ic = facets.getCursor();
        precision = IDataUtil.getInt(ic, "precision", -1);
        scale = IDataUtil.getInt(ic, "scale", -1);
        minI = IDataUtil.getString(ic, "minInclusive");
        minE = IDataUtil.getString(ic, "minExclusive");
        maxI = IDataUtil.getString(ic, "maxInclusive");
        maxE = IDataUtil.getString(ic, "maxExclusive");
        if (minI != null) {
            this._foundMinI = true;
            try {
                minInclusive = new BigDecimal(minI);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_I, ""));
            }
            if (minE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MINI_AND_MINE, ""));
            }
        } else {
            try {
                if (minE != null) {
                    this._foundMinE = true;
                    minExclusive = new BigDecimal(minE);
                }
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_E, ""));
            }
        }
        if (maxI != null) {
            this._foundMaxI = true;
            try {
                maxInclusive = new BigDecimal(maxI);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_I, ""));
            }
            if (maxE != null) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_MAXI_AND_MAXE, ""));
            }
        } else {
            try {
                if (maxE != null) {
                    this._foundMaxE = true;
                    maxExclusive = new BigDecimal(maxE);
                }
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_E, ""));
            }
        }
        if (maxInclusive != null) {
            if (minInclusive != null && maxInclusive.compareTo(minInclusive) < 0) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINI, ""));
            }
            if (minExclusive != null && maxInclusive.compareTo(minExclusive) < 0) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_LESS_THAN_MINE, ""));
            }
        }
        if (maxExclusive != null) {
            if (minInclusive != null && maxExclusive.compareTo(minInclusive) < 0) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINI, ""));
            }
            if (minExclusive != null && maxExclusive.compareTo(minExclusive) < 0) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_LESS_THAN_MINE, ""));
            }
        }
        if (scale > -1) {
            if (minInclusive != null && minInclusive.scale() > scale) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.EXCEEDS_SCALE_MIN_I, ""));
            }
            if (minExclusive != null && minExclusive.scale() > scale) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.EXCEEDS_SCALE_MIN_E, ""));
            }
            if (maxInclusive != null && maxInclusive.scale() > scale) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.EXCEEDS_SCALE_MAX_I, ""));
            }
            if (maxExclusive != null && maxExclusive.scale() > scale) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.EXCEEDS_SCALE_MAX_E, ""));
            }
            try {
                if (minInclusive != null) {
                    minInclusive.setScale(scale);
                }
                if (minExclusive != null) {
                    minExclusive.setScale(scale);
                }
                if (maxInclusive != null) {
                    maxInclusive.setScale(scale);
                }
                if (maxExclusive != null) {
                    maxExclusive.setScale(scale);
                }
            }
            catch (ArithmeticException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_SCALE, ""));
            }
            catch (IllegalArgumentException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_SCALE, ""));
            }
        }
        if (precision > -1) {
            if (maxInclusive != null && this.getDigitCount(maxInclusive) > precision) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.EXCEEDS_PRECISION_MAX_I, ""));
            }
            if (minInclusive != null && this.getDigitCount(minInclusive) > precision) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.EXCEEDS_PRECISION_MIN_I, ""));
            }
            if (maxExclusive != null && this.getDigitCount(maxExclusive) > precision) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.EXCEEDS_PRECISION_MAX_E, ""));
            }
            if (minExclusive != null && this.getDigitCount(minExclusive) > precision) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.EXCEEDS_PRECISION_MIN_E, ""));
            }
        }
        if ((strPatterns = (String[])IDataUtil.get(ic, "pattern")) != null) {
            patterns = new Pattern[strPatterns.length];
            for (int k = 0; k < strPatterns.length; ++k) {
                if (strPatterns[k].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        patterns[k] = _compiler.compile(strPatterns[k]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_REGEX, "", strPatterns[k]));
                }
            }
        }
        if ((ss = (String[])IDataUtil.get(ic, "enumeration")) != null) {
            len = ss.length;
            for (i = 0; i < len; ++i) {
                s = ss[i];
                try {
                    BigDecimal bd = new BigDecimal(s);
                    if (!(minInclusive != null && bd.compareTo(minInclusive) < 0 || minExclusive != null && bd.compareTo(minExclusive) <= 0 || maxInclusive != null && bd.compareTo(maxInclusive) > 0 || maxExclusive != null && bd.compareTo(maxExclusive) >= 0 || scale > -1 && bd.scale() > scale || precision > -1 && this.getDigitCount(bd) > precision) && WmDecimal.checkEnumPattern(s, patterns)) continue;
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM, "", s));
                    continue;
                }
                catch (NumberFormatException e) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_ENUM, "", s));
                }
            }
        }
        ic.destroy();
        if (errors.size() == 0) {
            this._enum = this.convertToBdArray(ss);
            this._minInclusive = minInclusive;
            this._maxInclusive = maxInclusive;
            this._minExclusive = minExclusive;
            this._maxExclusive = maxExclusive;
            this._precision = precision;
            this._scale = scale;
            this._strPatterns = strPatterns;
            this._patterns = patterns;
        } else {
            WmDecimal.throwNSException(errors, locale);
        }
    }

    public boolean validate(String s, Object context) {
        boolean ret;
        block23: {
            ret = true;
            s = WmDecimal.handleWhiteSpace(s, 3);
            boolean valid = true;
            valid = super.validate(s, context);
            if (!valid) {
                return false;
            }
            ret = super.validate(s, context);
            if (!ret) {
                return false;
            }
            ValidationWorkspace workspace = (ValidationWorkspace)context;
            if (workspace == null) {
                return false;
            }
            if (this._enum != null) {
                int i;
                int len = this._enum.length;
                for (i = 0; i < len; ++i) {
                    if (!s.equals(this._enum[i].toString())) {
                        continue;
                    }
                    break block23;
                }
                if (i == len) {
                    workspace.addError("DT-Decimal001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
                    ret = false;
                }
            } else {
                BigDecimal bd;
                try {
                    bd = new BigDecimal(s);
                }
                catch (Exception e) {
                    workspace.addError("DT-Decimal002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
                    ret = false;
                    break block23;
                }
                if (this._minInclusive != null && bd.compareTo(this._minInclusive) < 0) {
                    workspace.addError("DT-Decimal003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
                    ret = false;
                } else if (this._minExclusive != null && bd.compareTo(this._minExclusive) <= 0) {
                    workspace.addError("DT-Decimal003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LESS_THAN_MIN, ""));
                    ret = false;
                } else if (this._maxInclusive != null && bd.compareTo(this._maxInclusive) > 0) {
                    workspace.addError("DT-Decimal004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
                    ret = false;
                } else if (this._maxExclusive != null && bd.compareTo(this._maxExclusive) >= 0) {
                    workspace.addError("DT-Decimal004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.GREATER_THAN_MAX, ""));
                    ret = false;
                } else if (this._precision > -1 && this.getDigitCount(bd) > this._precision) {
                    workspace.addError("Value exceeds precision ", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.VALUE_EXCEED_PRECISION, ""));
                    ret = false;
                } else if (this._scale > -1 && bd.scale() > this._scale) {
                    workspace.addError("DT-Decimal006", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.VALUE_EXCEED_SCALE, ""));
                    ret = false;
                } else if (!this.checkPattern(s, workspace)) {
                    ret = false;
                }
            }
        }
        return ret;
    }

    public void setValues(Values val) {
        String s = null;
        if (val.get("enum") != null || val.get("maximum") != null || val.get("minimum") != null) {
            WmDecimal.migrate(val);
        }
        super.setValues(val);
        String[] sa = (String[])val.get("enumeration");
        if (sa != null) {
            this._enum = this.convertToBdArray(sa);
        }
        if ((s = val.getString("minInclusive")) != null) {
            this._minInclusive = new BigDecimal(s);
        }
        if ((s = val.getString("minExclusive")) != null) {
            this._minExclusive = new BigDecimal(s);
        }
        if ((s = val.getString("maxInclusive")) != null) {
            this._maxInclusive = new BigDecimal(s);
        }
        if ((s = val.getString("maxExclusive")) != null) {
            this._maxExclusive = new BigDecimal(s);
        }
        this._precision = val.getInt("precision", -1);
        this._scale = val.getInt("scale", -1);
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enum)}, {"minInclusive", this._minInclusive != null ? this._minInclusive.toString() : null}, {"minExclusive", this._minExclusive != null ? this._minExclusive.toString() : null}, {"maxInclusive", this._maxInclusive != null ? this._maxInclusive.toString() : null}, {"maxExclusive", this._maxExclusive != null ? this._maxExclusive.toString() : null}, {"precision", this._precision > -1 ? Integer.toString(this._precision) : null}, {"scale", this._scale > -1 ? Integer.toString(this._scale) : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setFromData(IData data) {
        IDataCursor idc = data.getCursor();
        if (IDataUtil.get(idc, "enum") != null || IDataUtil.get(idc, "maximum") != null || IDataUtil.get(idc, "minimum") != null) {
            WmDecimal.migrate(data);
        }
        super.setFromData(data);
        if (idc.first("enumeration")) {
            this._enum = this.convertToBdArray(IDataUtil.getStringArray(idc));
        }
        if (idc.first("minInclusive")) {
            this._minInclusive = new BigDecimal(IDataUtil.getString(idc));
        }
        if (idc.first("minExclusive")) {
            this._minExclusive = new BigDecimal(IDataUtil.getString(idc));
        }
        if (idc.first("maxInclusive")) {
            this._maxInclusive = new BigDecimal(IDataUtil.getString(idc));
        }
        if (idc.first("maxExclusive")) {
            this._maxExclusive = new BigDecimal(IDataUtil.getString(idc));
        }
        this._precision = IDataUtil.getInt(idc, "precision", -1);
        this._scale = IDataUtil.getInt(idc, "scale", -1);
        idc.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enum)}, {"minInclusive", this._minInclusive != null ? this._minInclusive.toString() : null}, {"minExclusive", this._minExclusive != null ? this._minExclusive.toString() : null}, {"maxInclusive", this._maxInclusive != null ? this._maxInclusive.toString() : null}, {"maxExclusive", this._maxExclusive != null ? this._maxExclusive.toString() : null}, {"precision", this._precision > -1 ? Integer.toString(this._precision) : null}, {"scale", this._scale > -1 ? Integer.toString(this._scale) : null}};
        IData data = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), data);
        return data;
    }

    public Values getView() {
        Object[][] o = new Object[][]{{"enumeration", this.convertToStringArray(this._enum)}, {"minInclusive", this._minInclusive != null ? this._minInclusive.toString() : null}, {"minExclusive", this._minExclusive != null ? this._minExclusive.toString() : null}, {"maxInclusive", this._maxInclusive != null ? this._maxInclusive.toString() : null}, {"maxExclusive", this._maxExclusive != null ? this._maxExclusive.toString() : null}, {"precision", this._precision > -1 ? Integer.toString(this._precision) : null}, {"scale", this._scale > -1 ? Integer.toString(this._scale) : null}};
        return super.getView().copyFrom(new Values(o));
    }

    private static final void migrate(Values val) {
        String[] oldDataArray = val.getStringArray("enum");
        val.put("enumeration", oldDataArray);
        String oldData = val.getString("maximum");
        val.put("maxInclusive", oldData);
        oldData = val.getString("minimum");
        val.put("minInclusive", oldData);
    }

    private static final void migrate(IData val) {
        IDataCursor idc = val.getCursor();
        String[] oldDataArray = (String[])IDataUtil.get(idc, "enum");
        IDataUtil.put(idc, "enumeration", oldDataArray);
        String oldData = IDataUtil.getString(idc, "maximum");
        IDataUtil.put(idc, "maxInclusive", oldData);
        oldData = IDataUtil.getString(idc, "minimum");
        IDataUtil.put(idc, "minInclusive", oldData);
        idc.destroy();
    }

    private int getDigitCount(BigDecimal bd) {
        String s = bd.toString();
        boolean afterPoint = false;
        int digits = 0;
        int iz = 0;
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) {
                ++digits;
                if (!afterPoint) continue;
                if (c == '0') {
                    ++iz;
                    continue;
                }
                iz = 0;
                continue;
            }
            if (c != '.') continue;
            afterPoint = true;
        }
        return digits - iz;
    }

    private String[] convertToStringArray(BigDecimal[] bdArray) {
        if (bdArray == null) {
            return null;
        }
        String[] stringArray = new String[bdArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            stringArray[index] = bdArray[index].toString();
        }
        return stringArray;
    }

    private BigDecimal[] convertToBdArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        BigDecimal[] bdArray = new BigDecimal[stringArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            try {
                bdArray[index] = new BigDecimal(stringArray[index]);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return bdArray;
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        BigDecimal b1 = new BigDecimal(s1);
        BigDecimal b2 = new BigDecimal(s2);
        return b1.compareTo(b2) == 0;
    }
}

