/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;

public class WmBoolean
extends Datatype
implements Errors,
ValuesCodable {
    private static NSRecord _nsRecord = null;

    public NSRecord getFacetsMetadata() {
        if (_nsRecord == null) {
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "pattern", 1, 1);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    public IData getFacets() {
        return super.getFacets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacets(IData facets, Locale locale) throws NSException {
        super.setFacets(facets, locale);
        Pattern[] patterns = null;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        IDataCursor ic = facets.getCursor();
        String[] strPatterns = (String[])IDataUtil.get(ic, "pattern");
        ic.destroy();
        if (strPatterns != null) {
            patterns = new Pattern[strPatterns.length];
            for (int i = 0; i < strPatterns.length; ++i) {
                if (strPatterns[i].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        patterns[i] = _compiler.compile(strPatterns[i]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_REGEX, "", strPatterns[i]));
                }
            }
        }
        if (errors.size() == 0) {
            this._strPatterns = strPatterns;
            this._patterns = patterns;
        } else {
            WmBoolean.throwNSException(errors, locale);
        }
    }

    public boolean validate(String s, Object context) {
        s = WmBoolean.handleWhiteSpace(s, 3);
        boolean valid = true;
        valid = super.validate(s, context);
        if (!valid) {
            return false;
        }
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        if (!(s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false") || s.equalsIgnoreCase("0") || s.equalsIgnoreCase("1"))) {
            valid = false;
            workspace.addError("DT-Boolean001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_VALUE, ""));
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        if (!this.checkPattern(s, workspace)) {
            valid = false;
        }
        return valid;
    }

    public void setValues(Values val) {
        super.setValues(val);
    }

    public Values getValues() {
        return super.getValues();
    }

    public void setFromData(IData val) {
        super.setFromData(val);
    }

    public IData getAsData() {
        return super.getAsData();
    }

    public Values getView() {
        return super.getView();
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.equalsIgnoreCase("true") || s1.equalsIgnoreCase("1")) {
            return s2.equalsIgnoreCase("true") || s2.equalsIgnoreCase("1");
        }
        if (s1.equalsIgnoreCase("false") || s1.equalsIgnoreCase("0")) {
            return s2.equalsIgnoreCase("false") || s2.equalsIgnoreCase("0");
        }
        return false;
    }
}

