/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.Pattern;

public class WmBinary
extends Datatype
implements Errors,
ValuesCodable {
    public static final int HEX_ENCODING = 0;
    public static final int BASE64_ENCODING = 1;
    public static final String HEX = "Hex";
    public static final String BASE64 = "Base64";
    int _encoding = -1;
    int _length = -1;
    int _minLength = -1;
    int _maxLength = -1;
    String[] _enum;
    private static NSRecord _nsRecord = null;

    public String getEncodingString() {
        if (this._encoding == 0) {
            return HEX;
        }
        if (this._encoding == 1) {
            return BASE64;
        }
        return null;
    }

    public int getEncoding() {
        return this._encoding;
    }

    public int getLength() {
        return this._length;
    }

    public int getMinLength() {
        return this._minLength;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public String[] getEnumeration() {
        return this._enum;
    }

    public void setEncoding(int encoding) {
        this._encoding = encoding;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public void setMinLength(int minLength) {
        this._minLength = minLength;
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    public void setEnumeration(String[] sa) {
        this._enum = sa;
    }

    public NSRecord getFacetsMetadata() {
        if (_nsRecord == null) {
            String[] tf = new String[]{"true", "false"};
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "enumeration", 1, 1);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "encoding", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "length", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "minLength", 1, 0);
            _nsRecord.addField(nsf);
            nsf = new NSField(null, "maxLength", 1, 0);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    public IData getFacets() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"encoding", this._encoding == 0 ? HEX : (this._encoding == 1 ? BASE64 : null)}, {"length", this._length > -1 ? Integer.toString(this._length) : null}, {"minLength", this._minLength > -1 ? Integer.toString(this._minLength) : null}, {"maxLength", this._maxLength > -1 ? Integer.toString(this._maxLength) : null}};
        IData val = super.getFacets();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    public void setFacets(IData facets, Locale locale) throws NSException {
        String[] enumeration;
        super.setFacets(facets, locale);
        int length = -1;
        int maxLength = -1;
        int minLength = -1;
        int encoding = -1;
        Pattern[] patterns = null;
        boolean foundLength = false;
        boolean foundMaxLength = false;
        boolean foundMinLength = false;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        IDataCursor ic = facets.getCursor();
        String data = IDataUtil.getString(ic, "length");
        try {
            if (data != null) {
                length = Integer.parseInt(data);
                if (length > -1) {
                    foundLength = true;
                } else if (length < -1) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_LENGTH, ""));
                }
            }
        }
        catch (NumberFormatException e) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_LENGTH, ""));
        }
        data = IDataUtil.getString(ic, "minLength");
        try {
            if (data != null) {
                minLength = Integer.parseInt(data);
                if (minLength > -1) {
                    foundMinLength = true;
                } else if (minLength < 0) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_LENGTH, ""));
                }
            }
        }
        catch (NumberFormatException e) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_LENGTH, ""));
        }
        data = IDataUtil.getString(ic, "maxLength");
        try {
            if (data != null) {
                maxLength = Integer.parseInt(data);
                if (maxLength > -1) {
                    foundMaxLength = true;
                } else if (maxLength < -1) {
                    errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_LENGTH, ""));
                }
            }
        }
        catch (NumberFormatException e) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_LENGTH, ""));
        }
        if (foundLength && (foundMinLength || foundMaxLength)) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_BOTH_FIX_AND_VAR, ""));
        }
        if (foundMaxLength && maxLength < minLength) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXLENGTH_LESS_THAN_MIN, ""));
        }
        if ((data = IDataUtil.getString(ic, "encoding")) != null) {
            if (data.equalsIgnoreCase(HEX)) {
                encoding = 0;
            } else if (data.equalsIgnoreCase(BASE64)) {
                encoding = 1;
            } else {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.HEX_OR_BASE, ""));
            }
        }
        if ((enumeration = (String[])IDataUtil.get(ic, "enumeration")) != null) {
            int len = enumeration.length;
            for (int i = 0; i < len; ++i) {
                String s = enumeration[i];
                int enumlength = s.length() * 2;
                if (length > -1) {
                    if (enumlength != length) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_NOT_EQUAL_LENGTH, "", s));
                    }
                } else {
                    if (enumlength < minLength) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_SHORTER_THAN_LENGTH, "", s));
                    }
                    if (maxLength > -1 && enumlength > maxLength) {
                        errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_LONGER_THAN_LENGTH, "", s));
                    }
                }
                if (WmBinary.checkEnumPattern(s, patterns)) continue;
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_NOT_MATCH_PATTERN, "", s));
            }
        }
        ic.destroy();
        if (errors.size() == 0) {
            this._length = length;
            this._minLength = minLength;
            this._maxLength = maxLength;
            this._encoding = encoding;
            this._enum = enumeration;
            this._patterns = patterns;
        } else {
            WmBinary.throwNSException(errors, locale);
        }
    }

    public boolean validate(String s, Object context) {
        s = WmBinary.handleWhiteSpace(s, 3);
        boolean valid = true;
        valid = super.validate(s, context);
        if (!valid) {
            return false;
        }
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        if (workspace == null) {
            return false;
        }
        if (this._enum != null) {
            for (int i = 0; i < this._enum.length; ++i) {
                if (!s.equals(this._enum[i])) continue;
                return valid;
            }
            valid = false;
            workspace.addError("DT-Binary001", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NO_MATCH_CHOICE, ""));
            return valid;
        }
        int length = -1;
        if (s != null) {
            length = s.length() * 2;
        }
        if (this._length > -1) {
            if (this._length != length) {
                valid = false;
                workspace.addError("DT-Binary004", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_EQUAL_LENGTH, ""));
            }
        } else {
            if (this._minLength > -1 && length < this._minLength) {
                valid = false;
                workspace.addError("DT-Binary002", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.SHORTER_THAN_LENGTH, ""));
            }
            if (workspace.isCompleted()) {
                return valid;
            }
            if (this._maxLength > -1 && length > this._maxLength) {
                valid = false;
                workspace.addError("DT-Binary003", new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LONGER_THAN_LENGTH, ""));
            }
        }
        if (workspace.isCompleted()) {
            return valid;
        }
        return valid;
    }

    public void setValues(Values val) {
        super.setValues(val);
        this._enum = (String[])val.get("enumeration");
        String encodingString = val.getString("encoding");
        this._encoding = encodingString != null ? (encodingString.equals(HEX) ? 0 : (encodingString.equals(BASE64) ? 1 : -1)) : -1;
        this._length = val.getInt("length", -1);
        this._minLength = val.getInt("minLength", -1);
        this._maxLength = val.getInt("maxLength", -1);
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"encoding", this._encoding == 0 ? HEX : (this._encoding == 1 ? BASE64 : null)}, {"length", this._length > -1 ? Integer.toString(this._length) : null}, {"minLength", this._minLength > -1 ? Integer.toString(this._minLength) : null}, {"maxLength", this._maxLength > -1 ? Integer.toString(this._maxLength) : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setFromData(IData val) {
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        this._enum = (String[])IDataUtil.get(ic, "enumeration");
        String encodingString = IDataUtil.getString(ic, "encoding");
        this._encoding = encodingString != null ? (encodingString.equals(HEX) ? 0 : (encodingString.equals(BASE64) ? 1 : -1)) : -1;
        this._length = IDataUtil.getInt(ic, "length", -1);
        this._minLength = IDataUtil.getInt(ic, "minLength", -1);
        this._maxLength = IDataUtil.getInt(ic, "maxLength", -1);
        ic.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"encoding", this._encoding == 0 ? HEX : (this._encoding == 1 ? BASE64 : null)}, {"length", this._length > -1 ? Integer.toString(this._length) : null}, {"minLength", this._minLength > -1 ? Integer.toString(this._minLength) : null}, {"maxLength", this._maxLength > -1 ? Integer.toString(this._maxLength) : null}};
        IData val = super.getAsData();
        IDataUtil.merge(IDataFactory.create(o), val);
        return val;
    }

    public Values getView() {
        Object[][] o = new Object[][]{{"enumeration", this._enum}, {"encoding", this._encoding == 0 ? HEX : (this._encoding == 1 ? BASE64 : null)}, {"length", this._length > -1 ? Integer.toString(this._length) : null}, {"minLength", this._minLength > -1 ? Integer.toString(this._minLength) : null}, {"maxLength", this._maxLength > -1 ? Integer.toString(this._maxLength) : null}};
        return super.getView().copyFrom(new Values(o));
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static void main(String[] args) {
        WmBinary wr = new WmBinary();
        Object[][] o = new Object[][]{{"encoding", null}, {"length", "6"}, {"minLength", null}, {"maxLength", null}};
        Values val = new Values(o);
        try {
            wr.setFacets(val);
        }
        catch (NSException e) {
            e.printStackTrace();
        }
    }
}

