/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.NodeWorkspace;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.Util;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.W3CKeys;
import com.wm.lang.schema.WmComplexType;
import com.wm.lang.schema.WmComplexTypeRef;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.InterDatatype;
import com.wm.lang.schema.datatypev2.Constraint;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.xml.ElementNode;
import com.wm.util.QName;
import com.wm.util.Values;
import java.util.Locale;

public class DatatypeRef
extends InterDatatype {
    public DatatypeRef(QName targetName) {
        super(targetName, 2);
    }

    public DatatypeRef(String targetNS, String ncName) {
        this(QName.create(targetNS, ncName));
    }

    DatatypeRef(IData values) {
        this.setFromData(values);
    }

    DatatypeRef(Values values) {
        this.setFromData(values);
    }

    public Constraint[] getConstraints() {
        return null;
    }

    public void setConstraints(Constraint[] constraints) {
    }

    public void setConstraints(Constraint[] constraints, Locale locale) {
    }

    public IData getFacets() {
        Datatype datatype = this.getDatatype();
        return datatype != null ? datatype.getFacets() : null;
    }

    public void setFacets(IData facets) throws NSException {
    }

    public void setFacets(IData facets, Locale locale) throws NSException {
    }

    public NSRecord getFacetsMetadata() {
        Datatype datatype = this.getDatatype();
        return datatype != null ? this.getDatatype().getFacetsMetadata() : null;
    }

    public QName[] getPrimitiveQNames() {
        return null;
    }

    public boolean validate(String data, Object context) {
        Datatype datatype = this.getDatatype();
        if (datatype != null) {
            return datatype.validate(data, context);
        }
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        workspace.addError("DT-100", "Unable to locate type definition");
        return false;
    }

    public String getTypeName() {
        Datatype datatype = this.getDatatype();
        return datatype != null ? this.getDatatype().getTypeName() : null;
    }

    public String getName() {
        Datatype datatype = this.getDatatype();
        return datatype != null ? this.getDatatype().getName() : this._targetNames[0].getNCName();
    }

    public String getSourceName() {
        Datatype datatype = this.getDatatype();
        return datatype != null ? this.getDatatype().getSourceName() : null;
    }

    public QName getTargetName() {
        return this._targetNames[0];
    }

    void setTargetOwnerNSName(NSName name) {
        this._targetOwnerNSName = name;
    }

    public boolean isProxy() {
        return true;
    }

    public NSName getTargetOwnerNSName() {
        if (this._targetOwnerNSName != null) {
            return this._targetOwnerNSName;
        }
        if (this._owner != null) {
            return ((NSNode)((Object)this._owner)).getNSName();
        }
        return null;
    }

    public QName getQName() {
        return this.getTargetName();
    }

    public boolean targetExists() {
        return this.getDatatype() != null;
    }

    public boolean isValidlyDerivedFrom(QName name) {
        Datatype datatype = this.getDatatype();
        return datatype != null ? datatype.isValidlyDerivedFrom(name) : false;
    }

    public boolean validate(String data, Object node, Object context, String baseLocationPath) {
        ElementNode eNode = (ElementNode)node;
        ValidationWorkspace workspace = (ValidationWorkspace)context;
        String typeRef = Util.retrieveXSIType(eNode);
        if (typeRef == null) {
            return this.validate(data, context);
        }
        QName typeName = null;
        try {
            typeName = QName.computeQName(typeRef, eNode);
        }
        catch (Exception ex) {
            workspace.addError("NV-013", "Unable to resolve QName: " + typeRef);
            return false;
        }
        QName thisName = this.getTargetName();
        if (thisName.equals(typeName)) {
            return this.validate(data, context);
        }
        W3CKeys typeDef = new DatatypeRef(typeName);
        typeDef.setOwner(this._owner);
        if (!((DatatypeRef)typeDef).targetExists()) {
            typeDef = WmComplexType.create(typeName);
            typeDef.setOwner(this.getOwner());
            if (!((WmComplexTypeRef)typeDef).targetExists()) {
                workspace.addError("DT-100", "Unable to locate type definition");
                return false;
            }
        }
        if (typeDef.isValidlyDerivedFrom(thisName)) {
            if (typeDef.getType() == 1) {
                return ((SimpleType)((Object)typeDef)).validate(data, workspace);
            }
            ((ComplexType)((Object)typeDef)).validate(eNode, (NodeWorkspace)workspace, baseLocationPath);
            return true;
        }
        workspace.addError(baseLocationPath, "", "NV-014", typeName.getNCName() + " {" + typeName.getNamespace() + "}" + " is not validly derived from " + thisName.getNCName() + " {" + thisName.getNamespace() + "}");
        return false;
    }

    public HashSet getTypeHeirarchy() {
        Datatype datatype = this.getDatatype();
        return datatype != null ? datatype.getTypeHeirarchy() : null;
    }

    public SimpleType getTargetType() {
        return this.getDatatype();
    }
}

