/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.datatype;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.data.ValuesEmulator;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.Keys;
import com.wm.lang.schema.PatternMatcherPool;
import com.wm.lang.schema.PooledPatternMatcher;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.W3CKeys;
import com.wm.lang.schema.datatype.DatatypeKeys;
import com.wm.lang.schema.datatype.DatatypeRef;
import com.wm.lang.schema.datatype.Errors;
import com.wm.lang.schema.datatype.LegacyFacet;
import com.wm.lang.schema.datatype.WmList;
import com.wm.lang.schema.datatype.WmUnion;
import com.wm.lang.schema.datatype.resources.DatatypeMessageBundle;
import com.wm.lang.schema.datatypev2.Constraint;
import com.wm.lang.schema.dummyWorkSpace;
import com.wm.lang.schema.util.Entry;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.util.Iterator;
import com.wm.util.Destroyable;
import com.wm.util.IntEnum;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import com.wm.util.Showable;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.sort.Sortable;
import com.wm.xsd.graph.XSNode;
import com.wm.xsd.graph.XSNonTerminal;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;

public abstract class Datatype
implements SimpleType,
Errors,
W3CKeys,
Keys,
DatatypeKeys,
Entry,
Destroyable,
Showable,
ValuesCodable,
Sortable,
IDataPortable,
XSNonTerminal {
    private static String[] _typeNames = new String[]{"string", "integer", "decimal", "float", "double", "timeDuration", "recurringDuration", "binary", "boolean", "long", "int", "time", "timePeriod", "uriReference", "real (deprecated)", "ID", "IDREF", "ENTITY", "NOTATION", "QName", "urSimpleType", "anySimpleType", "list", "union", "real"};
    private static String[] _cosmeticTypeNames = new String[]{"string", "integer", "decimal", "float", "double", "timeDuration", "recurringDuration", "binary", "boolean", "long", "int", "time", "timePeriod", "uriReference", "real (deprecated)"};
    private static String[] _classNames = new String[]{"com.wm.lang.schema.datatype.WmString", "com.wm.lang.schema.datatype.WmInteger", "com.wm.lang.schema.datatype.WmDecimal", "com.wm.lang.schema.datatype.WmFloat", "com.wm.lang.schema.datatype.WmDouble", "com.wm.lang.schema.datatype.WmTimeDuration", "com.wm.lang.schema.datatype.WmRecurringDuration", "com.wm.lang.schema.datatype.WmBinary", "com.wm.lang.schema.datatype.WmBoolean", "com.wm.lang.schema.datatype.WmLong", "com.wm.lang.schema.datatype.WmInt", "com.wm.lang.schema.datatype.WmTime", "com.wm.lang.schema.datatype.WmTimePeriod", "com.wm.lang.schema.datatype.WmUriReference", "com.wm.lang.schema.datatype.WmReal", "com.wm.lang.schema.datatype.WmString", "com.wm.lang.schema.datatype.WmString", "com.wm.lang.schema.datatype.WmString", "com.wm.lang.schema.datatype.WmString", "com.wm.lang.schema.datatype.WmString", "com.wm.lang.schema.datatype.WmString", "com.wm.lang.schema.datatype.WmString", "com.wm.lang.schema.datatype.WmList", "com.wm.lang.schema.datatype.WmUnion", "com.wm.lang.schema.datatype.WmReal"};
    private int _typeIndex;
    String _ncName;
    int _internalType;
    Schema _owner;
    Datatype _base;
    boolean _isExpanded;
    static final int DATATYPE_INSTANCE = 1;
    static final int DATATYPE_REFERENCE = 2;
    static final int DATATYPE_LIST = 3;
    static final int DATATYPE_UNION = 4;
    static final int DATATYPE_UNKNOWN = 10;
    static final IntEnum internalTypeEnum = new IntEnum(0);
    public static final String KEY_DT_CLASS = "ct_class";
    public static final String KEY_DT_INTERNALTYPE = "internalType";
    public static final String KEY_DT_CONTENTTYPE = "contentType";
    public static final String KEY_DT_IS_EXPANDED = "isExpanded";
    boolean _isDestroyed = false;
    static final String VALUE_DT_CONTENTTYPE = "simple";
    protected String[] _strPatterns;
    protected static PatternCompiler _compiler;
    protected Pattern[] _patterns;
    private static final String ERR001 = "DT-004";
    HashSet _typeHeirarchy;
    boolean _isAbstract;
    public static final String KEY_DT_PARENT_ANCESTORS_HEIRARCHY = "parent-ancestors";
    Namespace _ns;
    boolean _namespaceIsAvailable;
    static final int WHITE_SPACE_PRESERVE_INT = 1;
    static final int WHITE_SPACE_REPLACE_INT = 2;
    static final int WHITE_SPACE_COLLAPSE_INT = 3;

    public String getVersion() {
        return "dtVersion1";
    }

    public IData getFacets() {
        Object[][] o = new Object[][]{{"pattern", this._strPatterns}};
        return IDataFactory.create(o);
    }

    public void setFacets(IData facets) throws NSException {
        this.setFacets(facets, Locale.getDefault());
    }

    public void setFacets(IData facets, Locale locale) throws NSException {
        if (this._base != null) {
            this.checkBoundaries(facets, locale);
        }
    }

    public Constraint[] getConstraints() {
        return null;
    }

    public void setConstraints(Constraint[] constraints) {
    }

    public void setConstraints(Constraint[] constraints, Locale locale) {
    }

    public IData getFixedFacets() {
        if (this._base == null) {
            this._base = (Datatype)this.deepClone();
            this._base._typeHeirarchy = null;
        }
        return this._base.getFacets();
    }

    public void setFixedFacets(IData facets) throws NSException {
        if (this._base != null) {
            this._base.setFacets(facets);
        }
    }

    void checkBoundaries(IData facets, Locale locale) throws NSException {
        double iniValue;
        IData baseFacets = this._base.getFacets();
        if (baseFacets == null) {
            return;
        }
        IDataCursor ic = facets.getCursor();
        int data = -1;
        int bdata = -1;
        Vector<LocalizedMessage> errors = new Vector<LocalizedMessage>();
        dummyWorkSpace context = new dummyWorkSpace();
        double durSec = iniValue = Double.MIN_VALUE;
        double peoSec = iniValue;
        double tempSec = iniValue;
        String precision = IDataUtil.getString(ic, "precision");
        String scale = IDataUtil.getString(ic, "scale");
        String minI = IDataUtil.getString(ic, "minInclusive");
        String minE = IDataUtil.getString(ic, "minExclusive");
        String maxI = IDataUtil.getString(ic, "maxInclusive");
        String maxE = IDataUtil.getString(ic, "maxExclusive");
        String length = IDataUtil.getString(ic, "length");
        String minLength = IDataUtil.getString(ic, "minLength");
        String maxLength = IDataUtil.getString(ic, "maxLength");
        String encoding = IDataUtil.getString(ic, "encoding");
        String duration = IDataUtil.getString(ic, "duration");
        String period = IDataUtil.getString(ic, "period");
        String whiteSpace = IDataUtil.getString(ic, "whiteSpace");
        String[] enumvar = (String[])IDataUtil.get(ic, "enumeration");
        ic.destroy();
        ic = baseFacets.getCursor();
        String temp = IDataUtil.getString(ic, "precision");
        if (temp != null && precision != null) {
            try {
                data = Integer.parseInt(precision);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_PRECISION, ""));
            }
            bdata = Integer.parseInt(temp);
            if (bdata > -1 && data > bdata) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.PRECISION_OUT_OF_BOUNDARY, ""));
            }
        }
        if ((temp = IDataUtil.getString(ic, "scale")) != null && scale != null) {
            try {
                data = Integer.parseInt(scale);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_SCALE, ""));
            }
            bdata = Integer.parseInt(IDataUtil.getString(ic, "scale"));
            if (bdata > -1 && data > bdata) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.SCALE_OUT_OF_BOUNDARY, ""));
            }
        }
        if ((temp = IDataUtil.getString(ic, "length")) != null && length != null) {
            try {
                data = Integer.parseInt(length);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_LENGTH, ""));
            }
            bdata = Integer.parseInt(IDataUtil.getString(ic, "length"));
            if (data > bdata) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.LENGTH_OUT_OF_BOUNDARY, ""));
            }
        }
        if ((temp = IDataUtil.getString(ic, "minLength")) != null && minLength != null) {
            try {
                data = Integer.parseInt(minLength);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MIN_LENGTH, ""));
            }
            bdata = Integer.parseInt(IDataUtil.getString(ic, "minLength"));
            if (data > bdata) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MIN_LENGTH_OUT_OF_BOUNDARY, ""));
            }
        }
        if ((temp = IDataUtil.getString(ic, "maxLength")) != null && maxLength != null) {
            try {
                data = Integer.parseInt(maxLength);
            }
            catch (NumberFormatException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_MAX_LENGTH, ""));
            }
            bdata = Integer.parseInt(IDataUtil.getString(ic, "maxLength"));
            if (data > bdata) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAX_LENGTH_OUT_OF_BOUNDARY, ""));
            }
        }
        if ((temp = IDataUtil.getString(ic, "encoding")) != null && encoding != null && temp != encoding) {
            errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENCODING_OUT_OF_BOUNDARY, ""));
        }
        if ((temp = IDataUtil.getString(ic, "minInclusive")) != null) {
            if (maxI != null && !this._base.validate(maxI, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_OUT_OF_BOUNDARY, ""));
            }
            if (minI != null && !this._base.validate(minI, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MINI_OUT_OF_BOUNDARY, ""));
            }
            if (maxE != null && !this._base.validate(maxE, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_OUT_OF_BOUNDARY, ""));
            }
            if (minE != null && !this._base.validate(minE, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MINE_OUT_OF_BOUNDARY, ""));
            }
        }
        if ((temp = IDataUtil.getString(ic, "minExclusive")) != null) {
            if (maxI != null && !this._base.validate(maxI, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_OUT_OF_BOUNDARY, ""));
            }
            if (minI != null && !this._base.validate(minI, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MINI_OUT_OF_BOUNDARY, ""));
            }
            if (maxE != null && !this._base.validate(maxE, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_OUT_OF_BOUNDARY, ""));
            }
            if (minE != null && !this._base.validate(minE, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MINE_OUT_OF_BOUNDARY, ""));
            }
        }
        if ((temp = IDataUtil.getString(ic, "maxInclusive")) != null) {
            if (maxI != null && !this._base.validate(maxI, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_OUT_OF_BOUNDARY, ""));
            }
            if (minI != null && !this._base.validate(minI, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MINI_OUT_OF_BOUNDARY, ""));
            }
            if (maxE != null && !this._base.validate(maxE, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_OUT_OF_BOUNDARY, ""));
            }
            if (minE != null && !this._base.validate(minE, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MINE_OUT_OF_BOUNDARY, ""));
            }
        }
        if ((temp = IDataUtil.getString(ic, "maxExclusive")) != null) {
            if (maxI != null && !this._base.validate(maxI, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXI_OUT_OF_BOUNDARY, ""));
            }
            if (minI != null && !this._base.validate(minI, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MINI_OUT_OF_BOUNDARY, ""));
            }
            if (maxE != null && !this._base.validate(maxE, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MAXE_OUT_OF_BOUNDARY, ""));
            }
            if (minE != null && !this._base.validate(minE, context)) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.MINE_OUT_OF_BOUNDARY, ""));
            }
        }
        if ((temp = IDataUtil.getString(ic, "duration")) != null && duration != null) {
            try {
                durSec = Datatype.convertToSeconds(duration);
            }
            catch (NSException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_DURATION, ""));
            }
            try {
                tempSec = Datatype.convertToSeconds(temp);
            }
            catch (NSException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_DURATION, ""));
            }
            if (durSec > tempSec) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.DURATION_OUT_OF_BOUNDARY, ""));
            }
        }
        if ((temp = IDataUtil.getString(ic, "period")) != null && period != null) {
            try {
                peoSec = Datatype.convertToSeconds(period);
            }
            catch (NSException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_PERIOD, ""));
            }
            try {
                tempSec = Datatype.convertToSeconds(temp);
            }
            catch (NSException e) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_PERIOD, ""));
            }
            if (peoSec > tempSec) {
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.PERIOD_OUT_OF_BOUNDARY, ""));
            }
        }
        if ((temp = IDataUtil.getString(ic, "enumeration")) != null && enumvar != null) {
            for (int i = 0; i < enumvar.length; ++i) {
                if (this._base.validate(enumvar[i], context)) continue;
                errors.addElement(new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.ENUM_OUT_OF_BOUNDARY, ""));
                break;
            }
        }
        if (errors.size() > 0) {
            StringBuffer sb = new StringBuffer();
            int size = errors.size();
            for (int i = 0; i < size; ++i) {
                sb.append(((LocalizedMessage)errors.elementAt(i)).getLocalizedMessage(locale));
                sb.append('\n');
            }
            throw new NSException(sb.toString());
        }
    }

    public static final SimpleType deriveFrom(SimpleType datatype) throws NSException {
        String[] enumvar;
        String[] pattern;
        Datatype customizedObject = (Datatype)datatype.deepClone();
        IData baseFacets = customizedObject.getFixedFacets();
        IData facets = customizedObject.getFacets();
        String[][] complicatedKeys = new String[][]{{"length", "minLength"}, {"length", "maxLength"}, {"minLength", "length"}, {"maxLength", "length"}, {"minExclusive", "minInclusive"}, {"maxExclusive", "maxInclusive"}, {"minInclusive", "minExclusive"}, {"maxInclusive", "maxExclusive"}};
        IDataCursor icf = facets.getCursor();
        IDataCursor icb = baseFacets.getCursor();
        for (int i = 0; i < complicatedKeys.length; ++i) {
            if (!icf.first(complicatedKeys[i][0]) || icf.getValue() == null || !icb.first(complicatedKeys[i][1])) continue;
            icb.delete();
        }
        String[] simpleKeys = new String[]{"precision", "scale", "minInclusive", "minExclusive", "maxInclusive", "maxExclusive", "length", "minLength", "maxLength", "encoding", "duration", "period"};
        String value = null;
        String wsValue = null;
        for (int i = 0; i < simpleKeys.length; ++i) {
            value = IDataUtil.getString(icf, simpleKeys[i]);
            if (value == null) continue;
            IDataUtil.put(icb, simpleKeys[i], value);
            IDataUtil.put(icf, simpleKeys[i], null);
        }
        value = IDataUtil.getString(icf, "whiteSpace");
        wsValue = IDataUtil.getString(icb, "whiteSpace");
        if (value != null && wsValue != null && value.equals("none") && !wsValue.equals("none")) {
            IDataUtil.put(icf, "whiteSpace", wsValue);
        }
        if (value != null && wsValue != null && !value.equals("none") && wsValue.equals("none")) {
            IDataUtil.put(icb, "whiteSpace", value);
        }
        if ((pattern = (String[])IDataUtil.get(icf, "pattern")) != null) {
            String[] basePattern = (String[])IDataUtil.get(icb, "pattern");
            if (basePattern == null) {
                IDataUtil.put(icb, "pattern", pattern);
            } else {
                int plen = pattern.length;
                int blen = basePattern.length;
                String[] combinePattern = new String[plen + blen];
                System.arraycopy(basePattern, 0, combinePattern, 0, blen);
                System.arraycopy(pattern, 0, combinePattern, blen, plen);
                IDataUtil.put(icb, "pattern", combinePattern);
            }
            IDataUtil.put(icf, "pattern", null);
        }
        if ((enumvar = (String[])IDataUtil.get(icf, "enumeration")) != null) {
            IDataUtil.put(icb, "enumeration", enumvar);
            IDataUtil.put(icf, "enumeration", null);
        }
        customizedObject.setFixedFacets(baseFacets);
        customizedObject.setFacets(facets);
        icb.destroy();
        icf.destroy();
        return customizedObject;
    }

    public abstract NSRecord getFacetsMetadata();

    public static String[] getAllTypeNames() {
        return _cosmeticTypeNames;
    }

    public String getTypeName() {
        return _typeNames[this._typeIndex];
    }

    public String getSourceName() {
        return _typeNames[this._typeIndex];
    }

    public String getName() {
        if (this._ncName != null && this._ncName.length() > 0) {
            return this._ncName;
        }
        return this.getSourceName();
    }

    public QName[] getPrimitiveQNames() {
        return null;
    }

    public int getPrimitiveType() {
        return -1;
    }

    public int getType() {
        return 1;
    }

    public Datatype getBase() {
        return this._base;
    }

    public boolean isProxy() {
        return false;
    }

    public Schema getOwner() {
        return this._owner;
    }

    public void setName(String ncName) {
        this._ncName = ncName;
    }

    public void setOwner(Schema owner) {
        this._owner = owner;
    }

    public boolean validate(String data, Object context) {
        if (this._base != null) {
            return this._base.validate(data, context);
        }
        return true;
    }

    public static Datatype create(String type) throws NSException {
        int index;
        Datatype ret = null;
        int size = _typeNames.length;
        for (index = 0; index < size && !type.equals(_typeNames[index]); ++index) {
        }
        if (index == size) {
            throw new NSException("Unknown content type: " + type);
        }
        try {
            Class<?> clazz = Class.forName(_classNames[index]);
            ret = (Datatype)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new NSException(e.toString());
        }
        catch (SecurityException e) {
            throw new NSException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new NSException(e.toString());
        }
        catch (InstantiationException e) {
            throw new NSException(e.toString());
        }
        ret._typeIndex = index;
        ret._internalType = type.equalsIgnoreCase("list") ? 3 : (type.equalsIgnoreCase("union") ? 4 : 1);
        return ret;
    }

    public static Datatype createDatatype(Values val) throws NSException {
        return Datatype.createDatatype((IData)val);
    }

    public static Datatype createDatatype(IData val) throws NSException {
        int index;
        Datatype ret = null;
        IDataCursor ic = val.getCursor();
        String clazzName = IDataUtil.getString(ic, KEY_DT_CLASS);
        ic.destroy();
        if (clazzName == null) {
            return null;
        }
        int size = _classNames.length;
        for (index = 0; index < size && !clazzName.equals(_classNames[index]); ++index) {
        }
        if (index == size) {
            throw new NSException("Unknown content type class: " + clazzName);
        }
        try {
            Class<?> clazz = Class.forName(clazzName);
            ret = (Datatype)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new NSException(e.toString());
        }
        catch (SecurityException e) {
            throw new NSException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new NSException(e.toString());
        }
        catch (InstantiationException e) {
            throw new NSException(e.toString());
        }
        ret._typeIndex = index;
        ret.setFromData(val);
        return ret;
    }

    public static final Datatype create(Values values) throws NSException {
        return Datatype.create((IData)values);
    }

    public static final Datatype create(IData values) throws NSException {
        IDataCursor ic = values.getCursor();
        int internalType = internalTypeEnum.getInt(IDataUtil.getString(ic, KEY_DT_INTERNALTYPE), 10);
        ic.destroy();
        switch (internalType) {
            case 1: {
                return Datatype.createDatatype(values);
            }
            case 2: {
                return new DatatypeRef(values);
            }
            case 3: {
                return new WmList(values);
            }
            case 4: {
                return new WmUnion(values);
            }
        }
        return null;
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{KEY_DT_CONTENTTYPE, Integer.toString(1)}, {KEY_DT_INTERNALTYPE, internalTypeEnum.getString(this._internalType, "unknown")}, {KEY_DT_CLASS, this._internalType == 1 ? _classNames[this._typeIndex] : null}, {"name", this._ncName}, {"pattern", this._strPatterns}, {KEY_DT_PARENT_ANCESTORS_HEIRARCHY, Datatype.toArray(this._typeHeirarchy)}, {"abstract", this._isAbstract ? "true" : null}, {"baseType", this._base != null ? this._base.getAsData() : null}, {KEY_DT_IS_EXPANDED, this._isExpanded ? "true" : null}};
        IData data = IDataFactory.create(o);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromData(IData data) {
        String isAbstract;
        Object[] in;
        this._ncName = ValuesEmulator.getString(data, "name");
        this._internalType = internalTypeEnum.getInt(ValuesEmulator.getString(data, KEY_DT_INTERNALTYPE), 10);
        IDataCursor ic = data.getCursor();
        Object values = IDataUtil.get(ic, "baseType");
        if (values != null && values instanceof IData) {
            try {
                this._base = Datatype.create((IData)values);
            }
            catch (NSException e) {}
        } else {
            this._base = null;
        }
        this._strPatterns = ValuesEmulator.getStringArray(data, "pattern");
        if (this._strPatterns != null) {
            this._patterns = new Pattern[this._strPatterns.length];
            for (int i = 0; i < this._strPatterns.length; ++i) {
                if (this._strPatterns[i].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        this._patterns[i] = _compiler.compile(this._strPatterns[i]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    this._patterns[i] = null;
                }
            }
        }
        if ((in = (Object[])IDataUtil.get(ic, KEY_DT_PARENT_ANCESTORS_HEIRARCHY)) != null) {
            if (this._typeHeirarchy == null) {
                this._typeHeirarchy = new HashSet();
            }
            for (int i = 0; i < in.length; ++i) {
                this._typeHeirarchy.add(QName.create((IData)in[i]));
            }
        } else {
            this._typeHeirarchy = null;
        }
        this._isAbstract = (isAbstract = IDataUtil.getString(ic, "abstract")) != null && isAbstract.equalsIgnoreCase("true");
        String isExpanded = IDataUtil.getString(ic, KEY_DT_IS_EXPANDED);
        this._isExpanded = isExpanded != null && isExpanded.equalsIgnoreCase("true");
        ic.destroy();
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_DT_CONTENTTYPE, Integer.toString(1)}, {KEY_DT_INTERNALTYPE, internalTypeEnum.getString(this._internalType, "unknown")}, {KEY_DT_CLASS, this._internalType == 1 ? _classNames[this._typeIndex] : null}, {"name", this._ncName}, {"pattern", this._strPatterns}, {KEY_DT_PARENT_ANCESTORS_HEIRARCHY, Datatype.toArray(this._typeHeirarchy)}, {"abstract", this._isAbstract ? "true" : null}, {"baseType", this._base != null ? this._base.getValues() : null}, {KEY_DT_IS_EXPANDED, this._isExpanded ? "true" : null}};
        return new Values(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(Values val) {
        Object[] in;
        this._ncName = val.getString("name");
        this._internalType = internalTypeEnum.getInt(val.getString(KEY_DT_INTERNALTYPE), 10);
        Object values = val.get("baseType");
        if (values != null && values instanceof Values) {
            try {
                this._base = Datatype.create((Values)values);
            }
            catch (NSException e) {}
        } else {
            this._base = null;
        }
        this._strPatterns = val.getStringArray("pattern");
        if (this._strPatterns != null) {
            this._patterns = new Pattern[this._strPatterns.length];
            for (int i = 0; i < this._strPatterns.length; ++i) {
                if (this._strPatterns[i].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        this._patterns[i] = _compiler.compile(this._strPatterns[i]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    this._patterns[i] = null;
                }
            }
        }
        if ((in = (Object[])val.get(KEY_DT_PARENT_ANCESTORS_HEIRARCHY)) != null) {
            if (this._typeHeirarchy == null) {
                this._typeHeirarchy = new HashSet();
            }
            for (int i = 0; i < in.length; ++i) {
                this._typeHeirarchy.add(QName.create((Values)in[i]));
            }
        } else {
            this._typeHeirarchy = null;
        }
        this._isAbstract = val.getBoolean("abstract");
        this._isExpanded = val.getBoolean(KEY_DT_IS_EXPANDED);
    }

    public void addTo(Hashtable ht) {
        if (this.getName() != null && this.getName().length() > 0) {
            ht.put(this.getName(), this);
        }
    }

    public boolean isDestroyed() {
        return this._isDestroyed;
    }

    public void setDestroyed() {
        this._isDestroyed = true;
    }

    public Values getView() {
        Object[][] o = new Object[][]{{KEY_DT_CONTENTTYPE, VALUE_DT_CONTENTTYPE}, {KEY_DT_CLASS, _classNames[this._typeIndex]}, {"name", this._ncName}, {"pattern", this._strPatterns}};
        return new Values(o);
    }

    public String[] getPatterns() {
        return this._strPatterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Pattern[] createPatterns(String[] strPatterns) {
        Pattern[] patterns = null;
        if (strPatterns != null) {
            patterns = new Pattern[strPatterns.length];
            for (int i = 0; i < strPatterns.length; ++i) {
                if (strPatterns[i].length() <= 0) continue;
                try {
                    PatternCompiler patternCompiler = _compiler;
                    synchronized (patternCompiler) {
                        patterns[i] = _compiler.compile(strPatterns[i]);
                        continue;
                    }
                }
                catch (MalformedPatternException mpe) {
                    patterns[i] = null;
                }
            }
        }
        return patterns;
    }

    protected boolean checkPattern(String s, ValidationWorkspace ws) {
        if (this._patterns != null) {
            boolean valid = this._patterns.length == 0;
            PooledPatternMatcher ppm = (PooledPatternMatcher)PatternMatcherPool.current().allocate();
            PatternMatcher matcher = ppm.getPatternMatcher();
            for (int i = 0; i < this._patterns.length; ++i) {
                if (this._patterns[i] == null || !matcher.matches(s, this._patterns[i])) continue;
                valid = true;
                break;
            }
            ppm.poolReturn();
            if (!valid) {
                ws.addError(ERR001, new LocalizedMessage(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_MATCH_PATTERN_MSG, ""));
            }
            return valid;
        }
        return true;
    }

    protected static boolean checkEnumPattern(String s, Pattern[] patterns) {
        if (patterns != null) {
            boolean valid = patterns.length == 0;
            PooledPatternMatcher ppm = (PooledPatternMatcher)PatternMatcherPool.current().allocate();
            PatternMatcher matcher = ppm.getPatternMatcher();
            for (int i = 0; i < patterns.length; ++i) {
                if (patterns[i] == null || !matcher.matches(s, patterns[i])) continue;
                valid = true;
                break;
            }
            ppm.poolReturn();
            return valid;
        }
        return true;
    }

    protected static Hashtable checkDurationPattern(String s, Pattern[] patterns) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        if (patterns != null) {
            boolean valid = patterns.length == 0;
            hash.put("valid", "false");
            PooledPatternMatcher ppm = (PooledPatternMatcher)PatternMatcherPool.current().allocate();
            PatternMatcher matcher = ppm.getPatternMatcher();
            for (int i = 0; i < patterns.length; ++i) {
                if (patterns[i] == null || !matcher.matches(s, patterns[i])) continue;
                valid = true;
                hash.put("valid", "true");
                hash.put("patternNumber", Integer.toString(i));
                break;
            }
            ppm.poolReturn();
            return hash;
        }
        hash.put("valid", "true");
        return hash;
    }

    public void setTypeHeirarchy(HashSet typeHeirarchy) {
        this._typeHeirarchy = typeHeirarchy;
    }

    public void setAbstract(boolean isAbstract) {
        this._isAbstract = isAbstract;
    }

    public HashSet getTypeHeirarchy() {
        return this._typeHeirarchy;
    }

    public boolean isAbstract() {
        return this._isAbstract;
    }

    public boolean isValidlyDerivedFrom(QName name) {
        if (this._typeHeirarchy == null) {
            return false;
        }
        return this._typeHeirarchy.contains(name);
    }

    public boolean validate(String data, Object node, Object context, String baseLocationPath) {
        return this.validate(data, context);
    }

    public Object deepClone() {
        Values values = this.getValues();
        Datatype clone = null;
        String type = null;
        String className = this.getClass().getName();
        int size = _classNames.length;
        for (int index = 0; index < size; ++index) {
            if (!className.equals(_classNames[index])) continue;
            type = _typeNames[index];
            break;
        }
        try {
            clone = Datatype.create(type);
            clone.setValues(values);
        }
        catch (NSException e) {
            // empty catch block
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static double convertToSeconds(String isoFormat) throws NSException {
        double temp;
        double sec = 0.0;
        int indexY = -1;
        int indexM = -1;
        int indexD = -1;
        int indexT = -1;
        int indexH = -1;
        int indexMin = -1;
        int indexS = -1;
        boolean negative = false;
        long secOfyear = 31536000L;
        long secOfMon = 2592000L;
        long secOfDay = 86400L;
        long secOfHour = 3600L;
        String strPattern = "(-)?P([0-9]*Y)?([0-9]*M)?([0-9]*D)?(T([0-9]*H)?([0-9]*M)?([0-9]*([0-9].[0-9][0-9]*)?S)?)?";
        Pattern[] patterns = new Pattern[1];
        try {
            PatternCompiler patternCompiler = _compiler;
            synchronized (patternCompiler) {
                patterns[0] = _compiler.compile(strPattern);
            }
        }
        catch (MalformedPatternException mpe) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_REGEX, "", strPattern);
        }
        if (!Datatype.checkEnumPattern(isoFormat, patterns)) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.NOT_MATCH_PATTERN, "", isoFormat);
        }
        if (isoFormat.startsWith("-")) {
            negative = true;
            isoFormat = isoFormat.substring(1);
        }
        if (!isoFormat.startsWith("P")) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG005, "");
        }
        if ((isoFormat = isoFormat.substring(1)).length() == 0) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.INVALID_FORMAT, "");
        }
        indexY = isoFormat.indexOf("Y");
        indexM = isoFormat.indexOf("M");
        if (indexY != -1 && indexM != -1 && indexM < indexY) {
            throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG006, "");
        }
        indexD = isoFormat.indexOf("D");
        indexT = isoFormat.indexOf("T");
        if (indexT != -1) {
            if (isoFormat.endsWith("T")) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG033, "");
            }
            indexH = isoFormat.indexOf("H");
            if (indexH != -1 && indexH < indexT) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG012, "");
            }
            if (indexM > indexT) {
                indexMin = indexM;
                indexM = -1;
            } else {
                indexMin = isoFormat.indexOf("M", indexT);
            }
            if (indexH != -1 && indexMin != -1 && indexMin < indexH) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG013, "");
            }
            indexS = isoFormat.indexOf("S");
            if (indexS != -1) {
                if (indexS < indexT) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG014, "");
                }
                if (indexH != -1 && indexS < indexH) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG015, "");
                }
                if (indexMin != -1 && indexS < indexMin) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG016, "");
                }
            }
        } else {
            indexH = isoFormat.indexOf("H");
            if (indexH != -1) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG017, "");
            }
            indexS = isoFormat.indexOf("S");
            if (indexS != -1) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG018, "");
            }
            indexMin = isoFormat.indexOf("M", indexM + 1);
            if (indexMin != -1) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG019, "");
            }
        }
        if (indexY != -1) {
            if (indexY == 0) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG020, "");
            }
            try {
                temp = Long.parseLong(isoFormat.substring(0, indexY));
            }
            catch (NumberFormatException e) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG021, "");
            }
            sec = temp * (double)secOfyear;
        }
        if (indexM != -1) {
            if (indexY != -1) {
                if (indexM == indexY + 1) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG022, "");
                }
                try {
                    temp = Long.parseLong(isoFormat.substring(indexY + 1, indexM));
                }
                catch (NumberFormatException e) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG023, "");
                }
                sec += temp * (double)secOfMon;
            } else {
                if (indexM == 0) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG022, "");
                }
                try {
                    temp = Long.parseLong(isoFormat.substring(0, indexM));
                }
                catch (NumberFormatException e) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG023, "");
                }
                sec += temp * (double)secOfMon;
            }
        }
        if (indexD != -1) {
            if (indexY != -1 && indexM != -1) {
                if (indexD == indexM + 1) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG024, "");
                }
                try {
                    temp = Long.parseLong(isoFormat.substring(indexM + 1, indexD));
                }
                catch (NumberFormatException e) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG025, "");
                }
                sec += temp * (double)secOfDay;
            }
            if (indexY != -1 && indexM == -1) {
                if (indexD == indexY + 1) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG024, "");
                }
                try {
                    temp = Long.parseLong(isoFormat.substring(indexY + 1, indexD));
                }
                catch (NumberFormatException e) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG025, "");
                }
                sec += temp * (double)secOfDay;
            }
            if (indexY == -1 && indexM != -1) {
                if (indexD == indexM + 1) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG024, "");
                }
                if (indexM < indexT) {
                    try {
                        temp = Long.parseLong(isoFormat.substring(indexM + 1, indexD));
                    }
                    catch (NumberFormatException e) {
                        throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG025, "");
                    }
                    sec += temp * (double)secOfDay;
                }
            }
            if (indexY == -1 && indexM == -1) {
                if (indexD == 0) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG026, "");
                }
                try {
                    temp = Long.parseLong(isoFormat.substring(0, indexD));
                }
                catch (NumberFormatException e) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG025, "");
                }
                sec += temp * (double)secOfDay;
            }
        }
        if (indexH != -1) {
            if (indexH == indexT + 1) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG027, "");
            }
            try {
                temp = Long.parseLong(isoFormat.substring(indexT + 1, indexH));
            }
            catch (NumberFormatException e) {
                throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG028, "");
            }
            sec += temp * 3600.0;
        }
        if (indexMin != -1) {
            if (indexH != -1) {
                if (indexMin == indexH + 1) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG029, "");
                }
                try {
                    temp = Long.parseLong(isoFormat.substring(indexH + 1, indexMin));
                }
                catch (NumberFormatException e) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG030, "");
                }
                sec += temp * 60.0;
            } else {
                if (indexH == indexT + 1) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG027, "");
                }
                try {
                    temp = Long.parseLong(isoFormat.substring(indexT + 1, indexMin));
                }
                catch (NumberFormatException e) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG030, "");
                }
                sec += temp * 60.0;
            }
        }
        if (indexS != -1) {
            if (indexMin != -1) {
                if (indexS == indexMin + 1) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG031, "");
                }
                try {
                    temp = Double.valueOf(isoFormat.substring(indexMin + 1, indexS));
                }
                catch (NumberFormatException e) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG032, "");
                }
                sec += temp;
            }
            if (indexMin == -1 && indexH != -1) {
                if (indexS == indexH + 1) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG031, "");
                }
                try {
                    temp = Double.valueOf(isoFormat.substring(indexH + 1, indexS));
                }
                catch (NumberFormatException e) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG032, "");
                }
                sec += temp;
            }
            if (indexH == -1 && indexMin == -1) {
                if (indexS == indexT + 1) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG031, "");
                }
                try {
                    temp = Double.valueOf(isoFormat.substring(indexT + 1, indexS));
                }
                catch (NumberFormatException e) {
                    throw new NSException(DatatypeMessageBundle.class, DatatypeMessageBundle.TIMEDURATION_MSG032, "");
                }
                sec += temp;
            }
        }
        if (negative) {
            sec *= -1.0;
        }
        return sec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final GregorianCalendar convertToGClender(String s) throws NSException {
        String originS = s;
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int min = -1;
        int sec = -1;
        int addhour = -1;
        int addmin = -1;
        boolean negative = false;
        int patternNumber = -1;
        int indexT = s.indexOf(84);
        int indexZ = s.indexOf(90);
        int firstCol = s.indexOf(58);
        int secondCol = -1;
        int thirdCol = -1;
        String[] strPatterns = new String[]{"(-)?\\d{2}(\\d{2})?(-\\d{2})?(-\\d{2})?(T\\d{2}(:\\d{2})?(:\\d{2})?((\\+|-)\\d{2}:\\d{2})?)?", "\\d{2}(:\\d{2})?(:\\d{2})?((\\+|-)\\d{2}:\\d{2})?", "--\\d{2}-\\d{2}", "---\\d{2}", "(-)?\\d{2}(\\d{2})?(-\\d{2})?(-\\d{2})?(T\\d{2}(:\\d{2})?(:\\d{2})?)Z", "\\d{2}(:\\d{2})?(:\\d{2})?Z"};
        Pattern[] patterns = new Pattern[strPatterns.length];
        for (int i = 0; i < strPatterns.length; ++i) {
            if (strPatterns[i].length() <= 0) continue;
            try {
                PatternCompiler patternCompiler = _compiler;
                synchronized (patternCompiler) {
                    patterns[i] = _compiler.compile(strPatterns[i]);
                    continue;
                }
            }
            catch (MalformedPatternException mpe) {
                throw new NSException("Invalid Regular Expression: " + strPatterns[i]);
            }
        }
        Hashtable hash = Datatype.checkDurationPattern(s, patterns);
        if (hash.get("valid").equals("false")) {
            throw new NSException("Does not match pattern " + s);
        }
        String numberString = (String)hash.get("patternNumber");
        patternNumber = Integer.parseInt(numberString);
        if (patternNumber == 0 || patternNumber == 4) {
            if (s.startsWith("-")) {
                negative = true;
                s = s.substring(1);
            }
            int firstMinus = s.indexOf(45);
            int secondMinus = -1;
            if (firstMinus == -1) {
                if (s.length() == 2) {
                    year = Integer.parseInt(s) * 1000;
                } else if (s.length() == 4) {
                    year = Integer.parseInt(s);
                }
                if (negative) {
                    year *= -1;
                }
            } else {
                secondMinus = s.indexOf(45, firstMinus + 1);
                year = Integer.parseInt(s.substring(0, firstMinus));
                if (negative) {
                    year *= -1;
                }
                if (secondMinus == -1) {
                    month = Integer.parseInt(s.substring(firstMinus + 1, firstMinus + 3));
                } else {
                    month = Integer.parseInt(s.substring(firstMinus + 1, firstMinus + 3));
                    day = Integer.parseInt(s.substring(secondMinus + 1, secondMinus + 3));
                }
            }
            if (indexT != -1) {
                hour = Integer.parseInt(s.substring(indexT + 1, indexT + 3));
                if (hour < 0 || hour > 24) {
                    throw new NSException("The format is invalid ");
                }
                if (firstCol != -1) {
                    min = Integer.parseInt(s.substring(firstCol + 1, firstCol + 3));
                    if (min < 0 || min > 60) {
                        throw new NSException("The format is invalid ");
                    }
                    secondCol = s.indexOf(58, firstCol + 1);
                    if (secondCol != -1) {
                        sec = Integer.parseInt(s.substring(secondCol + 1, secondCol + 3));
                    }
                }
                if (indexZ == -1) {
                    int plus = s.indexOf(43);
                    int minus = s.indexOf(45, indexT);
                    int sign = -1;
                    if (plus == -1 && minus != -1) {
                        sign = minus;
                    }
                    if (plus != -1 && minus == -1) {
                        sign = plus;
                    }
                    if (sign != -1) {
                        thirdCol = s.indexOf(58, sign);
                        String temp = s.substring(sign + 1, thirdCol);
                        addhour = Integer.parseInt(temp);
                        if (addhour < 0 || addhour > 24) {
                            throw new NSException("The format is invalid ");
                        }
                        try {
                            addmin = Integer.parseInt(s.substring(thirdCol + 1));
                        }
                        catch (NumberFormatException e) {
                            throw new NSException("Value cannot be converted to seconds ");
                        }
                        if (addmin < 0 || addmin > 60) {
                            throw new NSException("The format is invalid ");
                        }
                        if (minus != -1) {
                            addhour *= -1;
                            addmin *= -1;
                        }
                    }
                }
            }
            GregorianCalendar gcalender0 = new GregorianCalendar(year, month, day, hour, min, sec);
            if (addhour != -1 && addmin != -1) {
                gcalender0.add(10, addhour);
                gcalender0.add(12, addmin);
            }
            return gcalender0;
        }
        if (patternNumber == 1 || patternNumber == 5) {
            hour = Integer.parseInt(s.substring(0, 2));
            if (hour < 0 || hour > 24) {
                throw new NSException("The format is invalid ");
            }
            if (firstCol != -1) {
                min = Integer.parseInt(s.substring(firstCol + 1, firstCol + 3));
                if (min < 0 || min > 60) {
                    throw new NSException("The format is invalid ");
                }
                secondCol = s.indexOf(58, firstCol + 1);
                if (secondCol != -1) {
                    sec = Integer.parseInt(s.substring(secondCol + 1, secondCol + 3));
                }
            }
            if (indexZ == -1) {
                int plus = s.indexOf(43);
                int minus = s.indexOf(45);
                int sign = -1;
                if (plus == -1 && minus != -1) {
                    sign = minus;
                }
                if (plus != -1 && minus == -1) {
                    sign = plus;
                }
                if (sign != -1) {
                    thirdCol = s.indexOf(58, sign);
                    String temp = s.substring(sign + 1, thirdCol);
                    addhour = Integer.parseInt(temp);
                    if (addhour < 0 || addhour > 24) {
                        throw new NSException("The format is invalid ");
                    }
                    try {
                        addmin = Integer.parseInt(s.substring(thirdCol + 1));
                    }
                    catch (NumberFormatException e) {
                        throw new NSException("Value cannot be converted to seconds ");
                    }
                    if (addmin < 0 || addmin > 60) {
                        throw new NSException("The format is invalid ");
                    }
                    if (minus != -1) {
                        addhour *= -1;
                        addmin *= -1;
                    }
                }
            }
            GregorianCalendar gcalender1 = new GregorianCalendar(year, month, day, hour, min, sec);
            if (addhour != -1 && addmin != -1) {
                gcalender1.add(10, addhour);
                gcalender1.add(12, addmin);
            }
            return gcalender1;
        }
        if (patternNumber == 2) {
            month = Integer.parseInt(s.substring(2, 4));
            day = Integer.parseInt(s.substring(5));
            GregorianCalendar gcalender2 = new GregorianCalendar(-1, month, day, -1, -1, -1);
            return gcalender2;
        }
        if (patternNumber == 3) {
            day = Integer.parseInt(s.substring(4));
            GregorianCalendar gcalender3 = new GregorianCalendar(-1, -1, day, -1, -1, -1);
            return gcalender3;
        }
        return null;
    }

    private static final Values[] toArray(HashSet set) {
        if (set == null) {
            return null;
        }
        Values[] valArray = new Values[set.size()];
        Iterator it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            valArray[i] = ((ValuesCodable)it.next()).getValues();
            ++i;
        }
        return valArray;
    }

    public void setNamespace(Namespace ns) {
        this._ns = ns;
        this._namespaceIsAvailable = this._ns != null;
    }

    protected boolean isNamespaceAvailable() {
        return this._namespaceIsAvailable;
    }

    protected Namespace getNamespace() {
        if (this.isNamespaceAvailable()) {
            return this._ns;
        }
        return this._owner.getNamespace();
    }

    public static Datatype create(Namespace ns, String type) throws NSException {
        Datatype dt = Datatype.create(type);
        if (dt != null) {
            dt.setNamespace(ns);
        }
        return dt;
    }

    public static final Datatype create(Namespace ns, IData values) throws NSException {
        Datatype dt = Datatype.create(values);
        if (dt != null) {
            dt.setNamespace(ns);
        }
        return dt;
    }

    public static final Datatype create(Namespace ns, QName targetName) {
        DatatypeRef dt = new DatatypeRef(targetName);
        ((Datatype)dt).setNamespace(ns);
        return dt;
    }

    public int compare(Sortable compareTo, boolean reverse, int column) {
        if (compareTo instanceof TypeDef) {
            return this.getName().toLowerCase().compareTo(((TypeDef)compareTo).getName().toLowerCase());
        }
        return 0;
    }

    public abstract boolean equals(String var1, String var2);

    public static String replace(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        char[] ca = new char[length];
        s.getChars(0, length, ca, 0);
        char ch = '\u0000';
        boolean valueChanged = false;
        for (int i = 0; i < ca.length; ++i) {
            ch = ca[i];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    ca[i] = 32;
                    valueChanged = true;
                }
            }
        }
        if (valueChanged) {
            return new String(ca);
        }
        return s;
    }

    public static String collapse(String s) {
        String cs = Datatype.replace(s);
        int length = cs.length();
        StringBuffer sb = new StringBuffer(length);
        char ch = '\u0000';
        boolean prevWasSpace = false;
        boolean valueChanged = false;
        block3: for (int i = 0; i < length; ++i) {
            char prevCh = ch;
            ch = cs.charAt(i);
            switch (ch) {
                case ' ': {
                    if (prevWasSpace) continue block3;
                    prevWasSpace = true;
                    sb.append(' ');
                    valueChanged = true;
                    continue block3;
                }
                default: {
                    prevWasSpace = false;
                    sb.append(ch);
                }
            }
        }
        if (valueChanged) {
            return sb.toString().trim();
        }
        return cs;
    }

    public static String handleWhiteSpace(String s, int wsType) {
        if (s == null) {
            return null;
        }
        String hs = null;
        hs = wsType == 2 ? Datatype.replace(s) : (wsType == 3 ? Datatype.collapse(s) : s);
        return hs;
    }

    public static void throwNSException(Vector errors, Locale locale) throws NSException {
        StringBuffer sb = new StringBuffer();
        int size = errors.size();
        for (int i = 0; i < size; ++i) {
            sb.append(((LocalizedMessage)errors.elementAt(i)).getLocalizedMessage(locale));
            sb.append('\n');
        }
        throw new NSException(sb.toString());
    }

    public boolean targetExists() {
        return true;
    }

    public boolean isUnionType() {
        return false;
    }

    public boolean isListType() {
        return false;
    }

    public static void main(String[] args) {
        Datatype st = null;
        try {
            st = Datatype.create("integer");
        }
        catch (Exception ex) {
            // empty catch block
        }
        SimpleType stclone = (SimpleType)st.deepClone();
        System.out.println(st);
        System.out.println("------");
        System.out.println(stclone);
    }

    public QName getQName() {
        if (this._ncName == null || this.getOwner() == null) {
            return null;
        }
        return QName.create(this.getOwner().getTargetNamespace(), this._ncName);
    }

    public void setExpanded(boolean isExpanded) {
        this._isExpanded = isExpanded;
    }

    public boolean isExpanded() {
        return this._isExpanded;
    }

    public NSName getTargetOwnerName() {
        return null;
    }

    public void setTargetOwnerName(NSName name) {
    }

    public XSNode[] edges() {
        ArrayList<XSNode> c = new ArrayList<XSNode>();
        IData facets = this.getFacets();
        String[] keys = this.getFacetKeys();
        Datatype baseType = this.getBase();
        if (baseType != null) {
            c.add(baseType);
        }
        IDataCursor fc = facets.getCursor();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Object value = IDataUtil.get(fc, keys[i]);
            c.add(new LegacyFacet(key, value));
        }
        XSNode[] edges = new XSNode[c.size()];
        c.toArray(edges);
        return edges;
    }

    public boolean isTerminal() {
        return false;
    }

    public String[] getFacetKeys() {
        NSRecord record = this.getFacetsMetadata();
        NSField[] fields = record.getFields();
        String[] facetKeys = new String[fields.length];
        for (int i = 0; i < facetKeys.length; ++i) {
            facetKeys[i] = fields[i].getName();
        }
        return facetKeys;
    }

    static {
        internalTypeEnum.addInt("instance", 1);
        internalTypeEnum.addInt("reference", 2);
        internalTypeEnum.addInt("list", 3);
        internalTypeEnum.addInt("union", 4);
        internalTypeEnum.addInt("unknown", 10);
        _compiler = new Perl5Compiler();
    }
}

