/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.conv;

public class Profiler {
    static final int HAS_ATTRIBUTES = 0;
    static final int HAS_CHILD_ELEMENTS = 1;
    static final int HAS_OTHER_MODEL = 2;
    static final int IS_EMPTY_MODEL = 3;
    static final int IS_ANY_MODEL = 4;
    static final int IS_MIXED_MODEL = 5;
    static final int HAS_MODEL = 6;
    static final int HAS_COMPLEXTYPE = 7;
    static final int HAS_SIMPLETYPE = 8;
    static final int IS_REFERENCE = 9;
    static final int IS_ATTRIBUTE = 10;
    boolean[] _profile = new boolean[11];

    public void setAttributeFlag() {
        this._profile[10] = true;
    }

    public void setReferenceFlag() {
        this._profile[9] = true;
    }

    public void setHasSimpleType() {
        this._profile[8] = true;
    }

    public void setHasComplexType() {
        this._profile[7] = true;
    }

    public void setHasModel() {
        this._profile[6] = true;
    }

    public void setMixedModelFlag() {
        this._profile[5] = true;
    }

    public void setAnyModelFlag() {
        this._profile[4] = true;
    }

    public void setEmptyModelFlag() {
        this._profile[3] = true;
    }

    public void setOtherModelFlag() {
        this._profile[2] = true;
    }

    public void setHasChildElements() {
        this._profile[1] = true;
    }

    public void setHasAttributes() {
        this._profile[0] = true;
    }

    public void combine(Profiler profiler) {
        for (int i = 0; i < profiler._profile.length; ++i) {
            this._profile[i] = this._profile[i] || profiler._profile[i];
        }
    }

    public boolean getAnyModelFlag() {
        return this._profile[4];
    }

    public void unsetEmptyModelFlag() {
        this._profile[3] = false;
    }

    public void combine(Integer ID) {
        if (ID == null) {
            return;
        }
        String binary = Integer.toBinaryString(ID);
        int i = binary.length() - 1;
        for (int j = this._profile.length - 1; i > -1 && j > -1; --i, --j) {
            if (binary.charAt(i) == '0') {
                this._profile[j] = this._profile[j];
                continue;
            }
            this._profile[j] = true;
        }
    }

    public Integer createID() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._profile.length; ++i) {
            if (this._profile[i]) {
                sb.append(1);
                continue;
            }
            sb.append(0);
        }
        try {
            return Integer.valueOf(sb.toString(), 2);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static final Profiler create() {
        return new Profiler();
    }

    public static void main(String[] args) {
        Profiler profiler = new Profiler();
        profiler.setHasAttributes();
        profiler.setHasChildElements();
        profiler.setAnyModelFlag();
        profiler.setMixedModelFlag();
        profiler.setHasModel();
        profiler.setHasComplexType();
        Profiler refProfiler = new Profiler();
        refProfiler.setReferenceFlag();
        System.out.println(refProfiler.createID());
        refProfiler.combine(profiler.createID());
        System.out.println(refProfiler.createID());
    }
}

