/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.conv;

import com.wm.data.IData;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.Namespace;
import com.wm.lang.ns.UIDRegistry;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.DatatypeFactory;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SchemaRegistry;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.Util;
import com.wm.lang.schema.WmComplexType;
import com.wm.lang.schema.WmComplexTypeRef;
import com.wm.lang.schema.WmElement;
import com.wm.lang.schema.conv.Builder;
import com.wm.lang.schema.conv.BuilderImpl;
import com.wm.lang.schema.conv.Context;
import com.wm.lang.schema.conv.ContextImpl;
import com.wm.lang.schema.conv.Contractor;
import com.wm.lang.schema.conv.resources.ConverterMessageBundle;
import com.wm.lang.schema.gen.DTDCompiler;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.xsd.XSDCompiler;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedException;
import com.wm.util.LocalizedMessage;
import com.wm.util.NCName;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Values;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class Converter {
    static final boolean debug = false;
    static final boolean debug2 = false;
    static final boolean debug3 = false;
    static final String NODE_PREFIX = "schema_";
    static final Builder CONTRACTOR = Contractor.create();
    static final String nullString = null;
    public static final String NS_RECORDS = "NSRECORDS";
    public static boolean merge = false;
    static final QName SOAP_ARRAY = QName.create("http://schemas.xmlsoap.org/soap/encoding/", "Array");
    static final QName SOAP_ARRAY_TYPE = QName.create("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");

    public static final Values convert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String attrPrefix, IData[] xsdArray, QName rootElement, boolean verbose, Locale locale) throws WMDocumentException, IOException, Exception {
        return Converter.convert(ns, pkg, ifcName, recordName, nullString, attrPrefix, xsdArray, rootElement, verbose, locale, false, false, null, false);
    }

    public static final Values convert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String attrPrefix, IData[] xsdArray, QName rootElement, boolean verbose, Locale locale, boolean typesAsRecs, QName[] roots, boolean genAllElementRefs) throws WMDocumentException, IOException, Exception {
        return Converter.convert(ns, pkg, ifcName, recordName, nullString, attrPrefix, xsdArray, rootElement, verbose, locale, false, typesAsRecs, roots, genAllElementRefs);
    }

    public static final Values convert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String attrPrefix, IData[] xsdArray, QName rootElement, boolean verbose, Locale locale, boolean typesAsRecs, boolean merge, QName[] roots, boolean genAllElementRefs) throws WMDocumentException, IOException, Exception {
        Values result = XSDCompiler.compile(ns, pkg, NSName.create(ifcName, NODE_PREFIX + recordName), xsdArray, false, verbose, true, locale);
        boolean successful = result.getBoolean("isSuccessful");
        if (!successful) {
            result.remove("schemaArray");
            return result;
        }
        NSSchema[] schemas = (NSSchema[])result.get("schemaArray");
        result.remove("schemaArray");
        Values convResult = Converter._internalConvert(ns, pkg, ifcName, recordName, nullString, attrPrefix, schemas, rootElement, locale, false, false, merge, typesAsRecs, null, roots, genAllElementRefs);
        result.copyFrom(convResult);
        return result;
    }

    public static final Values convert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String attrPrefix, IData[] xsdArray, QName rootElement, boolean verbose) throws WMDocumentException, IOException, Exception {
        return Converter.convert(ns, pkg, ifcName, recordName, nullString, attrPrefix, xsdArray, rootElement, verbose, Locale.getDefault(), false, false, null, false);
    }

    public static final Values convert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String partName, String attrPrefix, IData[] xsdArray, QName rootElement, boolean verbose, Locale locale, boolean useNCName, boolean typesAsRecs, QName[] roots, boolean genAllElementRefs) throws WMDocumentException, IOException, Exception {
        Values result = XSDCompiler.compile(ns, pkg, NSName.create(ifcName, NODE_PREFIX + recordName), xsdArray, false, verbose, true, locale);
        boolean successful = result.getBoolean("isSuccessful");
        if (!successful) {
            result.remove("schemaArray");
            return result;
        }
        NSSchema[] schemas = (NSSchema[])result.get("schemaArray");
        result.remove("schemaArray");
        Values convResult = Converter._convert(ns, pkg, ifcName, recordName, partName, attrPrefix, schemas, rootElement, locale, useNCName, typesAsRecs, roots, genAllElementRefs);
        result.copyFrom(convResult);
        return result;
    }

    public static final Values convert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String partName, String attrPrefix, NSSchema[] schemas, QName rootElement, boolean verbose, Locale locale, boolean useNCName) throws WMDocumentException, IOException, Exception {
        return Converter._convert(ns, pkg, ifcName, recordName, partName, attrPrefix, schemas, rootElement, locale, useNCName, false, null, false);
    }

    public static final Values wsdlConvert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String partName, String attrPrefix, NSSchema[] schemas, QName rootElement, boolean verbose, Locale locale, boolean useNCName, String universalNs) throws WMDocumentException, IOException, Exception {
        return Converter._wsdlConvert(ns, pkg, ifcName, recordName, partName, attrPrefix, schemas, rootElement, locale, false, useNCName, universalNs);
    }

    public static final Values convertFromType(Namespace ns, NSPackage pkg, String ifcName, String recordName, String attrPrefix, IData[] xsdArray, QName rootElement, boolean verbose, Locale locale) throws WMDocumentException, IOException, Exception {
        return Converter.convertFromType(ns, pkg, ifcName, recordName, attrPrefix, xsdArray, rootElement, verbose, locale);
    }

    public static final Values convertFromType(Namespace ns, NSPackage pkg, String ifcName, String recordName, String partName, String attrPrefix, IData[] xsdArray, QName rootElement, boolean verbose, Locale locale, boolean useNCName) throws WMDocumentException, IOException, Exception {
        Values result = XSDCompiler.compile(ns, pkg, NSName.create(ifcName, NODE_PREFIX + recordName), xsdArray, false, verbose, true, locale);
        boolean successful = result.getBoolean("isSuccessful");
        if (!successful) {
            result.remove("schemaArray");
            return result;
        }
        NSSchema[] schemas = (NSSchema[])result.get("schemaArray");
        result.remove("schemaArray");
        Values convResult = Converter._convert(ns, pkg, ifcName, recordName, partName, attrPrefix, schemas, rootElement, locale, true, useNCName, false, null, false);
        result.copyFrom(convResult);
        return result;
    }

    public static final Values convertFromType(Namespace ns, NSPackage pkg, String ifcName, String recordName, String partName, String attrPrefix, NSSchema[] schemas, QName rootElement, boolean verbose, Locale locale, boolean useNCName) throws WMDocumentException, IOException, Exception {
        return Converter._convert(ns, pkg, ifcName, recordName, partName, attrPrefix, schemas, rootElement, locale, true, useNCName, false, null, false);
    }

    public static final Values wsdlConvertFromType(Namespace ns, NSPackage pkg, String ifcName, String recordName, String partName, String attrPrefix, NSSchema[] schemas, QName rootElement, boolean verbose, Locale locale, boolean useNCName, String universalNs) throws WMDocumentException, IOException, Exception {
        return Converter._wsdlConvert(ns, pkg, ifcName, recordName, partName, attrPrefix, schemas, rootElement, locale, true, useNCName, universalNs);
    }

    public static final Values convert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String attrPrefix, String dtdString, QName rootElement) throws IOException, WMDocumentException, Exception {
        return Converter.convert(ns, pkg, ifcName, recordName, attrPrefix, dtdString, rootElement, Locale.getDefault());
    }

    public static final Values convert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String attrPrefix, String dtdString, QName rootElement, boolean mergeAtRuntime) throws IOException, WMDocumentException, Exception {
        boolean prevMerge = merge;
        merge = mergeAtRuntime;
        Values result = Converter.convert(ns, pkg, ifcName, recordName, attrPrefix, dtdString, rootElement, Locale.getDefault());
        merge = prevMerge;
        return result;
    }

    public static final Values convert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String attrPrefix, String dtdString, QName rootElement, Locale locale) throws IOException, WMDocumentException, Exception {
        Values result = DTDCompiler.compile(ns, pkg, NSName.create(ifcName, NODE_PREFIX + recordName), nullString, dtdString, false, true, locale);
        boolean successful = result.getBoolean("isSuccessful");
        if (!successful) {
            result.remove("schemaArray");
            return result;
        }
        NSSchema[] schemas = (NSSchema[])result.get("schemaArray");
        result.remove("schemaArray");
        Values convResult = Converter._convert(ns, pkg, ifcName, recordName, nullString, attrPrefix, schemas, rootElement, locale, false, false, null, false);
        result.copyFrom(convResult);
        return result;
    }

    public static final Values convert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String attrPrefix, NSSchema[] schemas, QName rootElement, Locale locale) throws Exception {
        return Converter._convert(ns, pkg, ifcName, recordName, nullString, attrPrefix, schemas, rootElement, locale, false, false, null, false);
    }

    private static final Values _convert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String partName, String attrPrefix, NSSchema[] schemas, QName rootElement, Locale locale, boolean useNCName, boolean typesAsRecs, QName[] roots, boolean genAllElementRefs) throws Exception {
        return Converter._convert(ns, pkg, ifcName, recordName, partName, attrPrefix, schemas, rootElement, locale, false, useNCName, typesAsRecs, roots, genAllElementRefs);
    }

    private static final Values _convert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String partName, String attrPrefix, NSSchema[] schemas, QName rootElement, Locale locale, boolean genFromType, boolean useNCName, boolean typesAsRecs, QName[] roots, boolean genAllElementRefs) throws Exception {
        return Converter._internalConvert(ns, pkg, ifcName, recordName, partName, attrPrefix, schemas, rootElement, locale, genFromType, useNCName, merge, typesAsRecs, null, roots, genAllElementRefs);
    }

    private static final Values _wsdlConvert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String partName, String attrPrefix, NSSchema[] schemas, QName rootElement, Locale locale, boolean genFromType, boolean useNCName, String universalNs) throws Exception {
        return Converter._internalConvert(ns, pkg, ifcName, recordName, partName, attrPrefix, schemas, rootElement, locale, genFromType, useNCName, true, true, universalNs, null, false);
    }

    private static final Values _internalConvert(Namespace ns, NSPackage pkg, String ifcName, String recordName, String partName, String attrPrefix, NSSchema[] schemas, QName rootElement, Locale locale, boolean genFromType, boolean useNCName, boolean merge, boolean createDocsForTypes, String universalNs, QName[] roots, boolean genAllEltRefs) throws Exception {
        Values result = new Values();
        ContextImpl context = new ContextImpl();
        try {
            context.setInterfaceName(ifcName);
            context.setRecordName(recordName);
            context.setNamespace(ns);
            context.setNSPackage(pkg);
            context.setAttributePrefix(attrPrefix);
            context.setLocale(locale);
            context.setSchemas(schemas);
            context.setUseNCNameDecoder(useNCName);
            context.setCreateDocsForTypes(createDocsForTypes);
            context.setCreateAllElementRefsAsDocs(genAllEltRefs);
            NSRecord top = new NSRecord(ns);
            top.setNSName(NSName.create(ifcName, recordName));
            top.setPackage(pkg);
            context.addNamespaceRecord(top);
            top.setClosed(false);
            top.setNillable(true);
            if (top.getUniversalName() == null && universalNs != null) {
                QName univName = QName.create(universalNs, recordName);
                if (UIDRegistry.find(univName) != null) {
                    System.out.println("!!!!!!!!!!!! Duplicate UniversalName " + univName + " !!!!!!!!!!!!!!");
                    context.addError("CONV-006", new LocalizedMessage(ConverterMessageBundle.class, ConverterMessageBundle.MESSAGE_DUPLICATE_UNIVERSALNAME, "", univName.toString()));
                } else {
                    top.setUniversalName(univName);
                }
            }
            if (useNCName && partName != null) {
                partName = NCName.decode(partName);
            }
            WmElement element = null;
            HashSet repeatingQNames = new HashSet();
            context.buildTypeDerivationMap();
            if (genFromType) {
                WmComplexType complexType;
                element = context.retrieveElement(rootElement);
                if (element == null && universalNs != null) {
                    element = context.retrieveElement(QName.create(universalNs, rootElement.getNCName()));
                }
                if ((complexType = Converter.retrieveComplexType(ns, rootElement, schemas, context)) != null) {
                    complexType.setSchemas(schemas);
                    boolean useSoapArray = false;
                    HashSet typeHierarchy = complexType.getTypeHeirarchy();
                    if (typeHierarchy == null) {
                        useSoapArray = complexType.getAttribute(SOAP_ARRAY_TYPE) != null;
                    }
                    Object[] hierarchy = typeHierarchy.toArray();
                    for (int i = hierarchy.length - 1; i > -1; --i) {
                        QName baseType = (QName)hierarchy[i];
                        if (baseType != SOAP_ARRAY) continue;
                        useSoapArray = true;
                    }
                    NSField nsf = null;
                    WmElement wme = null;
                    String fieldName = null;
                    if (useSoapArray) {
                        ContentType ct = null;
                        Enumeration en = complexType.elements();
                        if (en.hasMoreElements()) {
                            wme = (WmElement)en.nextElement();
                            fieldName = wme.getName();
                            if (partName != null) {
                                fieldName = partName;
                            }
                            if ((ct = wme.getType()).getType() == 1) {
                                int dim = Util.getDimensions(wme.getDefaultValue());
                                nsf = new NSField(ns, NSRecord.TYPE, fieldName, BuilderImpl.xsdTypeToFieldType(wme.getQName()), dim);
                                nsf.setContentType(ct);
                                Util.setDimensions(nsf, wme.getDefaultValue());
                            } else {
                                WmComplexType cct = (WmComplexType)ct;
                                int itype = cct.getInternalType();
                                cct.setInternalType(10);
                                wme.collectRepeatingQNames(context, new HashSet(), repeatingQNames, schemas, new HashSet());
                                context.setRepeatingQNames(repeatingQNames);
                                nsf = wme.createRecord(CONTRACTOR, context);
                                Util.setDimensions(nsf, wme.getDefaultValue());
                                Util.setSchemaTypeName(nsf, cct.getQName());
                            }
                            Util.setXmlNamespace(nsf, rootElement.getNamespaceName());
                            if (nsf.getDimensions() != 0) {
                                nsf.setSoapArrayEncodingUsed(true);
                            }
                        }
                    } else {
                        SimpleType simple = complexType.getSimpleType();
                        Enumeration attributes = complexType.attributes();
                        if (!(simple == null || attributes != null && attributes.hasMoreElements())) {
                            fieldName = complexType.getName();
                            if (partName != null) {
                                fieldName = partName;
                            }
                            nsf = new NSField(ns, NSRecord.TYPE, fieldName, BuilderImpl.xsdTypeToFieldType(complexType.getQName()), 0);
                            nsf.setContentType(simple);
                        } else {
                            complexType.collectRepeatingQNames(context, repeatingQNames, schemas);
                            context.setRepeatingQNames(repeatingQNames);
                            nsf = complexType.createRecord(CONTRACTOR, context);
                            Util.setSchemaTypeName(nsf, complexType.getQName());
                        }
                        nsf.setSoapArrayEncodingUsed(false);
                    }
                    if (partName != null) {
                        nsf.setName(partName);
                    }
                    top.addField(nsf);
                } else {
                    SimpleType simpleType = Converter.retrieveSimpleType(ns, rootElement, schemas, context);
                    if (simpleType != null) {
                        String fieldName = partName != null ? partName : simpleType.getName();
                        NSField nsf = new NSField(ns, NSRecord.TYPE, fieldName, BuilderImpl.xsdTypeToFieldType(simpleType.getQName()), 0);
                        nsf.setContentType(simpleType);
                        top.addField(nsf);
                    }
                }
                if (context.createDocsForTypes()) {
                    if (context.genAllTypes()) {
                        Converter.genAll(context, ns, schemas);
                    } else {
                        Converter.genExtended(context, ns, schemas);
                    }
                }
            } else {
                if (roots == null) {
                    roots = new QName[]{rootElement};
                }
                for (int i = 0; i < roots.length; ++i) {
                    Set<WmElement> substitutableElements;
                    rootElement = roots[i];
                    element = context.retrieveElement(rootElement);
                    if (element == null && universalNs != null) {
                        element = context.retrieveElement(QName.create(universalNs, rootElement.getNCName()));
                    }
                    if (element == null) {
                        context.addError("CONV-004", new LocalizedMessage(ConverterMessageBundle.class, ConverterMessageBundle.MESSAGE_MISSING_ROOT_ELEMENT, "", rootElement.toDisplayString()));
                        continue;
                    }
                    element.collectRepeatingQNames(context, new HashSet(), repeatingQNames, schemas, new HashSet());
                    if (!context.isSuccessful()) continue;
                    context.setRepeatingQNames(repeatingQNames);
                    NSField nsf = null;
                    if (!element.isAbstract()) {
                        nsf = element.createRecord(CONTRACTOR, context);
                        Util.setXmlNamespace(nsf, element.getQName().getNamespaceName());
                        top.addField(nsf);
                    }
                    if (!context.subsGroupsEnabled() || (substitutableElements = context.getElementsSubstitutableFor(element.getQName())) == null || substitutableElements.isEmpty()) continue;
                    if (nsf != null) {
                        nsf.setOptional(true);
                        nsf.setSubstitutionGroupName(context.computeSubstitutionGroupName(element));
                    }
                    for (WmElement substitutableElement : substitutableElements) {
                        if (substitutableElement.isAbstract()) continue;
                        nsf = substitutableElement.createRecord(CONTRACTOR, context);
                        nsf.setOptional(true);
                        nsf.setSubstitutionGroupName(context.computeSubstitutionGroupName(substitutableElement));
                        Util.setXmlNamespace(nsf, substitutableElement.getQName().getNamespaceName());
                        top.addField(nsf);
                    }
                }
                if (context.createDocsForTypes()) {
                    if (context.genAllTypes()) {
                        Converter.genAll(context, ns, schemas);
                    } else {
                        Converter.genExtended(context, ns, schemas);
                    }
                }
            }
            if (context.isSuccessful()) {
                result.put("prefixURIReferencePairs", context.getPrefixURIReferencePairs());
                result.put("usedPrefixURIPairs", context.getUsedPrefixURIPairs());
                result.put(NS_RECORDS, context.namespaceRecords());
                Converter.formalize(ns, context.namespaceRecords(), context, merge);
                if (!context.isSuccessful()) {
                    Converter.delete(ns, schemas);
                }
            } else {
                Converter.delete(ns, schemas);
            }
        }
        catch (LocalizedException ex) {
            context.addError(ConverterMessageBundle.CONTENT_TYPE_RECURSION, ex.getLocalizedMessage());
            Converter.delete(ns, schemas);
            throw ex;
        }
        catch (Exception ex) {
            Converter.delete(ns, schemas);
            throw ex;
        }
        finally {
            IData[] errors = context.getErrors();
            if (errors != null) {
                result.put("isSuccessful", "false");
                result.put("errors", errors);
            } else {
                result.put("isSuccessful", "true");
            }
        }
        return result;
    }

    private static void genExtended(Context context, Namespace ns, NSSchema[] schemas) {
        java.util.HashSet<QName> added = null;
        java.util.HashSet<QName> failed = null;
        do {
            java.util.HashSet alreadyGen = (java.util.HashSet)context.getGeneratedTypes().clone();
            Iterator agqn = alreadyGen.iterator();
            added = new java.util.HashSet<QName>();
            failed = new java.util.HashSet<QName>();
            while (agqn.hasNext()) {
                QName type = (QName)agqn.next();
                java.util.HashSet<QName> extended = context.getExtended(type);
                if (extended == null) continue;
                for (QName extype : extended) {
                    if (alreadyGen.contains(extype) || added.contains(extype) || failed.contains(extype)) continue;
                    WmComplexType complexType = Converter.retrieveComplexType(ns, extype, schemas, context);
                    WmComplexTypeRef tr = new WmComplexTypeRef(null, extype);
                    WmElement dummy = new WmElement("dummy");
                    tr.setSchemas(schemas);
                    tr.setOwner(complexType.getOwner());
                    dummy.setOwner(complexType.getOwner());
                    dummy.setType(tr);
                    NSField nsf = dummy.createRecord(CONTRACTOR, context);
                    if (nsf.getType() == 2) {
                        added.add(extype);
                        continue;
                    }
                    failed.add(extype);
                }
            }
        } while (added.size() != 0);
    }

    private static void genAll(Context context, Namespace ns, NSSchema[] schemas) {
        Name ANY_TYPE = Name.create("anyType");
        for (int i = 0; i < context.getSchemas().length; ++i) {
            Schema s = context.getSchemas()[i];
            Enumeration e = s.types();
            while (e.hasMoreElements()) {
                ContentType ct = (ContentType)e.nextElement();
                if (ct.getType() != 2) continue;
                WmComplexType wmct = (WmComplexType)ct;
                QName us = wmct.getQName();
                if (context.getGeneratedTypes().contains(us)) continue;
                WmComplexTypeRef tr = new WmComplexTypeRef(null, us);
                WmElement dummy = new WmElement("dummy");
                tr.setSchemas(schemas);
                tr.setOwner(wmct.getOwner());
                dummy.setOwner(wmct.getOwner());
                dummy.setType(tr);
                NSField nsf = dummy.createRecord(CONTRACTOR, context);
            }
        }
    }

    private static final WmComplexType retrieveComplexType(Namespace ns, QName rootElement, NSSchema[] schemaArray, Context context) {
        String xmlns = rootElement.getNamespace();
        WmComplexType conplexType = null;
        NSSchema schema = null;
        Name nsn = rootElement.getNamespaceName();
        if (nsn == XSDCompiler.WEBM_DEFAULT_NAMESPACE) {
            xmlns = null;
        }
        if (xmlns != null) {
            NSName[] qnames = SchemaRegistry.resolve(xmlns);
            if (qnames != null) {
                NSNode node;
                for (int index = 0; !(index >= qnames.length || (node = ns.getNode(qnames[index])) != null && node.getNodeTypeObj().equals(NSSchema.TYPE) && (conplexType = (WmComplexType)(schema = (NSSchema)node).getComplexType(rootElement.getNCName())) != null); ++index) {
                }
            }
        } else if (schemaArray != null) {
            for (int i = 0; i < schemaArray.length; ++i) {
                if (schemaArray[i].getTargetNamespace() != null || (conplexType = (WmComplexType)schemaArray[i].getComplexType(rootElement.getNCName())) == null) continue;
                schema = schemaArray[i];
                break;
            }
        }
        if (conplexType != null) {
            context.setURIReferencePrefixPairs(schema.getURIReferencePrefixPairs());
        }
        return conplexType;
    }

    private static final SimpleType retrieveSimpleType(Namespace ns, QName typeName, NSSchema[] schemaArray, Context context) {
        String xmlns = typeName.getNamespace();
        SimpleType simpleType = null;
        NSSchema schema = null;
        Name nsn = typeName.getNamespaceName();
        if (nsn == XSDCompiler.WEBM_DEFAULT_NAMESPACE) {
            xmlns = null;
        }
        if (xmlns != null) {
            NSName[] qnames = SchemaRegistry.resolve(xmlns);
            if (qnames != null) {
                for (int index = 0; index < qnames.length; ++index) {
                    NSNode node = ns.getNode(qnames[index]);
                    if (node == null || !node.getNodeTypeObj().equals(NSSchema.TYPE) || (simpleType = (schema = (NSSchema)node).getSimpleType(typeName.getNCName())) == null) continue;
                    simpleType = DatatypeFactory.createReference(ns, simpleType.getQName(), qnames[index]);
                    break;
                }
            }
        } else if (schemaArray != null) {
            for (int i = 0; i < schemaArray.length; ++i) {
                if (schemaArray[i].getTargetNamespace() != null || (simpleType = schemaArray[i].getSimpleType(typeName.getNCName())) == null) continue;
                schema = schemaArray[i];
                break;
            }
        }
        if (simpleType != null) {
            context.setURIReferencePrefixPairs(schema.getURIReferencePrefixPairs());
        }
        return simpleType;
    }

    private static final void formalize(Namespace ns, NSRecord[] recordArray, Context context, boolean merge) {
        ArrayList<NSRecord> list = new ArrayList<NSRecord>();
        boolean cleanup = false;
        for (int i = 0; i < recordArray.length; ++i) {
            try {
                boolean successful = ns.registerRecord(recordArray[i]);
                if (successful) {
                    list.add(recordArray[i]);
                } else if (merge) {
                    successful = Converter.mergeRecords(ns, recordArray[i], context);
                } else {
                    cleanup = true;
                }
                if (!successful) {
                    context.addError("CONV-002", new LocalizedMessage(ConverterMessageBundle.class, ConverterMessageBundle.MESSAGE_DUPLICATE_RECORD, "", recordArray[i].getNSName().toString()));
                }
                if (successful) {
                    // empty if block
                }
                if (!cleanup) continue;
                break;
            }
            catch (NSException nse) {
                context.addError("CONV-003", new LocalizedMessage(ConverterMessageBundle.class, ConverterMessageBundle.MESSAGE_ANGRY_SERVER, "", nse.getLocalizedMessage(context.getLocale())));
                continue;
            }
            catch (Throwable t) {
                context.addError("CONV-003", new LocalizedMessage(ConverterMessageBundle.class, ConverterMessageBundle.MESSAGE_ANGRY_SERVER, "", t.getLocalizedMessage()));
            }
        }
        if (cleanup) {
            for (NSRecord rec : list) {
                try {
                    ns.deleteNode(rec);
                }
                catch (NSException nse) {
                    context.addError("CONV-003", new LocalizedMessage(ConverterMessageBundle.class, ConverterMessageBundle.MESSAGE_ANGRY_SERVER, "", nse.getLocalizedMessage(context.getLocale())));
                }
            }
        }
    }

    private static final boolean mergeRecords(Namespace ns, NSRecord record, Context context) {
        NSNode node = ns.getNode(record.getNSName());
        if (!node.getNodeTypeObj().equals(NSRecord.TYPE)) {
            return false;
        }
        NSRecord existingRecord = (NSRecord)node;
        existingRecord.mergeRecord(record);
        ns.putNode(existingRecord, true);
        return true;
    }

    private static final void put(Namespace ns, NSSchema[] schemaArray) {
        for (int i = 0; i < schemaArray.length; ++i) {
            try {
                ns.makeNode(schemaArray[i]);
                continue;
            }
            catch (NSException nSException) {
                // empty catch block
            }
        }
    }

    private static final void delete(Namespace ns, NSSchema[] schemaArray) {
        if (schemaArray == null) {
            return;
        }
        for (int i = 0; i < schemaArray.length; ++i) {
            try {
                ns.deleteNode(schemaArray[i]);
                continue;
            }
            catch (NSException nSException) {
                // empty catch block
            }
        }
    }
}

