/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.conv;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.Flat;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SchemaRegistry;
import com.wm.lang.schema.WmComplexType;
import com.wm.lang.schema.WmComplexTypeRef;
import com.wm.lang.schema.WmElement;
import com.wm.lang.schema.conv.Context;
import com.wm.lang.schema.util.HashSet;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Values;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextImpl
implements Context {
    private static final boolean debug = false;
    static final Hashtable _defaultURIReferencePrefixPairs = ContextImpl.createDefaultURIReferencePrefixPairs();
    private static final String PROPERTY_ENABLE_SUBS_GROUPS = "watt.core.schema.generateSubstitutionGroups";
    private static final String PROPERTY_GEN_ALL_TYPES = "watt.core.schema.generateAllTypeDocuments";
    String _ifcName;
    String _recordName;
    String _attrPrefix;
    Namespace _ns;
    NSPackage _pkg;
    HashSet _repeatingQNames;
    Locale _locale;
    Schema[] _schemas;
    boolean _useNCNameDecoder;
    boolean _createDocsForTypes;
    boolean _genSubs;
    boolean _genAllTypes;
    boolean _genAllElementRefs;
    Vector _records = new Vector();
    Hashtable _uriReferencePrefixPairs = new Hashtable();
    IData _usedUriPrefixPairs = IDataFactory.create();
    Hashtable _remoteRecords = new Hashtable();
    Hashtable _typeRecords = new Hashtable();
    java.util.HashSet<QName> _extendedTypes = new java.util.HashSet();
    Vector _errors;
    Map<QName, Set<WmElement>> _substitutionGroups = null;
    HashMap<QName, java.util.HashSet<QName>> _derivedTypeIndex = new HashMap();
    Flat _currentFlatModel;
    boolean _creatingRemoteRecord;

    ContextImpl() {
        this._errors = new Vector();
        this._genSubs = new Boolean(System.getProperty(PROPERTY_ENABLE_SUBS_GROUPS, "false"));
        this._genAllTypes = new Boolean(System.getProperty(PROPERTY_GEN_ALL_TYPES));
    }

    @Override
    public void setNamespace(Namespace ns) {
        this._ns = ns;
    }

    @Override
    public void setNSPackage(NSPackage pkg) {
        this._pkg = pkg;
    }

    @Override
    public void setInterfaceName(String ifcName) {
        this._ifcName = ifcName;
    }

    @Override
    public void setRecordName(String recordName) {
        this._recordName = recordName;
    }

    @Override
    public void setAttributePrefix(String attrPrefix) {
        this._attrPrefix = attrPrefix;
    }

    @Override
    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    @Override
    public void setSchemas(Schema[] schemas) {
        this._schemas = schemas;
    }

    @Override
    public void setUseNCNameDecoder(boolean use) {
        this._useNCNameDecoder = use;
    }

    @Override
    public void setCreateDocsForTypes(boolean create) {
        this._createDocsForTypes = create;
    }

    @Override
    public boolean subsGroupsEnabled() {
        return this._genSubs;
    }

    @Override
    public boolean genAllTypes() {
        return this._genAllTypes;
    }

    @Override
    public void setCreateAllElementRefsAsDocs(boolean flag) {
        this._genAllElementRefs = flag;
    }

    @Override
    public void setURIReferencePrefixPairs(IData idata) {
        if (idata == null) {
            return;
        }
        this._uriReferencePrefixPairs.clear();
        IDataCursor cursor = idata.getCursor();
        while (cursor.next()) {
            this._uriReferencePrefixPairs.put(cursor.getKey(), cursor.getValue());
        }
    }

    @Override
    public void setRepeatingQNames(HashSet repeatingQNames) {
        this._repeatingQNames = repeatingQNames;
    }

    @Override
    public Namespace getNamespace() {
        return this._ns;
    }

    @Override
    public NSPackage getNSPackage() {
        return this._pkg;
    }

    @Override
    public String getInterfaceName() {
        return this._ifcName;
    }

    @Override
    public String getRecordName() {
        return this._recordName;
    }

    @Override
    public String getAttributePrefix() {
        if (this._attrPrefix != null) {
            return this._attrPrefix;
        }
        return "@";
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    @Override
    public Schema[] getSchemas() {
        return this._schemas;
    }

    @Override
    public boolean useNCNameDecoder() {
        return this._useNCNameDecoder;
    }

    @Override
    public boolean createDocsForTypes() {
        return this._createDocsForTypes;
    }

    @Override
    public boolean createAllElementRefsAsDocs() {
        return this._genAllElementRefs;
    }

    @Override
    public String resolveURIReferenceToPrefix(String xmlns) {
        if (xmlns != null) {
            String prefix = (String)this._uriReferencePrefixPairs.get(xmlns);
            if (prefix == null) {
                prefix = (String)_defaultURIReferencePrefixPairs.get(xmlns);
            }
            return prefix;
        }
        return null;
    }

    @Override
    public IData getPrefixURIReferencePairs() {
        Object uri;
        Object[][] table = new Object[this._uriReferencePrefixPairs.size() + _defaultURIReferencePrefixPairs.size()][2];
        Enumeration uris = this._uriReferencePrefixPairs.keys();
        int i = 0;
        while (uris.hasMoreElements()) {
            uri = uris.nextElement();
            table[i][0] = this._uriReferencePrefixPairs.get(uri);
            table[i++][1] = uri;
        }
        uris = _defaultURIReferencePrefixPairs.keys();
        while (uris.hasMoreElements()) {
            uri = uris.nextElement();
            table[i][0] = _defaultURIReferencePrefixPairs.get(uri);
            table[i++][1] = uri;
        }
        return IDataFactory.create(table);
    }

    @Override
    public void addUsedPrefixURIPair(String prefix, String uri) {
        IDataCursor idc = this._usedUriPrefixPairs.getCursor();
        IDataUtil.put(idc, prefix, uri);
    }

    @Override
    public IData getUsedPrefixURIPairs() {
        return this._usedUriPrefixPairs;
    }

    @Override
    public boolean isRepeatingQName(QName name) {
        if (this._repeatingQNames != null) {
            return this._repeatingQNames.contains(name);
        }
        return false;
    }

    @Override
    public Flat getCurrentFlatModel() {
        return this._currentFlatModel;
    }

    @Override
    public void setCurrentFlatModel(Flat flat) {
        this._currentFlatModel = flat;
    }

    @Override
    public NSRecord[] namespaceRecords() {
        Object[] recordArray = new NSRecord[this._records.size()];
        this._records.copyInto(recordArray);
        return recordArray;
    }

    @Override
    public void addNamespaceRecord(NSRecord record) {
        this._records.addElement(record);
    }

    @Override
    public boolean containsRemoteRecord(String remoteRecordName) {
        return this._remoteRecords.containsKey(remoteRecordName);
    }

    @Override
    public void putRemoteRecord(String name, NSRecord remoteRecord) {
        this._remoteRecords.put(name, remoteRecord);
    }

    @Override
    public NSRecord getRemoteRecord(String name) {
        return (NSRecord)this._remoteRecords.get(name);
    }

    @Override
    public boolean containsTypeRecord(String remoteRecordName) {
        return this._typeRecords.containsKey(remoteRecordName);
    }

    @Override
    public void putTypeRecord(String name, NSRecord remoteRecord) {
        this._typeRecords.put(name, remoteRecord);
    }

    @Override
    public NSRecord getTypeRecord(String name) {
        return (NSRecord)this._typeRecords.get(name);
    }

    @Override
    public void updateExtended(WmComplexTypeRef type) {
        QName typeName = type.getQName();
        this._extendedTypes.add(typeName);
    }

    @Override
    public java.util.HashSet<QName> getGeneratedTypes() {
        return this._extendedTypes;
    }

    @Override
    public java.util.HashSet<QName> getExtended(QName type) {
        return this._derivedTypeIndex.get(type);
    }

    @Override
    public void setCreatingRemoteRecord() {
        this._creatingRemoteRecord = true;
    }

    @Override
    public void resetCreatingRemoteRecord() {
        this._creatingRemoteRecord = false;
    }

    @Override
    public boolean isCreatingRemoteRecord() {
        return this._creatingRemoteRecord;
    }

    @Override
    public void buildTypeDerivationMap() {
        if (!this._createDocsForTypes) {
            return;
        }
        if (this._genAllTypes) {
            return;
        }
        Name ANY_TYPE = Name.create("anyType");
        for (int i = 0; i < this._schemas.length; ++i) {
            Schema s = this._schemas[i];
            Enumeration e = s.types();
            while (e.hasMoreElements()) {
                ContentType ct = (ContentType)e.nextElement();
                if (ct.getType() != 2) continue;
                WmComplexType wmct = (WmComplexType)ct;
                HashSet hs = wmct.getTypeHeirarchy();
                QName us = wmct.getQName();
                if (hs == null) continue;
                com.wm.lang.schema.util.Iterator hsi = hs.iterator();
                while (hsi.hasNext()) {
                    QName superType = (QName)hsi.next();
                    if (superType == us || superType.getLocalName() == ANY_TYPE) continue;
                    java.util.HashSet<QName> sths = this._derivedTypeIndex.get(superType);
                    if (sths == null) {
                        sths = new java.util.HashSet();
                        this._derivedTypeIndex.put(superType, sths);
                    }
                    sths.add(us);
                }
            }
        }
    }

    @Override
    public Set<WmElement> getElementsSubstitutableFor(QName headElementName) {
        if (this._substitutionGroups == null) {
            this._substitutionGroups = new HashMap<QName, Set<WmElement>>();
            for (Schema eachSchema : this._schemas) {
                for (WmElement eachElement : eachSchema.getElements()) {
                    if (eachElement.getSubstitutableFor() == null) continue;
                    com.wm.lang.schema.util.Iterator it = eachElement.getSubstitutableFor().iterator();
                    while (it.hasNext()) {
                        QName substitutableElementName = (QName)it.next();
                        Set<WmElement> substitutingElements = this._substitutionGroups.get(substitutableElementName);
                        if (substitutingElements == null) {
                            substitutingElements = new java.util.HashSet<WmElement>();
                            this._substitutionGroups.put(substitutableElementName, substitutingElements);
                        }
                        substitutingElements.add(eachElement);
                        if (!this.isRepeatingQName(substitutableElementName)) continue;
                        this._repeatingQNames.add(eachElement.getQName());
                    }
                }
            }
        }
        return this._substitutionGroups.get(headElementName);
    }

    @Override
    public String computeSubstitutionGroupName(WmElement element) {
        if (element.getSubstitutableFor() == null || element.getSubstitutableFor().size() == 0) {
            return null;
        }
        if (element.getSubstitutableFor().size() == 1) {
            return ((QName)element.getSubstitutableFor().iterator().next()).toDisplayString();
        }
        com.wm.lang.schema.util.Iterator it1 = element.getSubstitutableFor().iterator();
        while (it1.hasNext()) {
            QName substitutableElementName = (QName)it1.next();
            WmElement substitutableElement = this.retrieveElement(substitutableElementName);
            if (substitutableElement.getSubstitutableFor() == null || substitutableElement.getSubstitutableFor().size() != element.getSubstitutableFor().size() - 1) continue;
            return substitutableElementName.toDisplayString();
        }
        return null;
    }

    @Override
    public WmElement retrieveElement(QName elementName) {
        Namespace ns = this.getNamespace();
        Schema[] schemaArray = this.getSchemas();
        String xmlns = elementName.getNamespace();
        WmElement element = null;
        NSSchema schema = null;
        if (xmlns != null) {
            NSName[] qnames = SchemaRegistry.resolve(xmlns);
            if (qnames != null) {
                NSNode node;
                for (int index = 0; !(index >= qnames.length || (node = ns.getNode(qnames[index])) != null && node.getNodeTypeObj().equals(NSSchema.TYPE) && (element = (schema = (NSSchema)node).getElement(elementName.getNCName())) != null); ++index) {
                }
            }
        } else if (schemaArray != null) {
            for (int i = 0; i < schemaArray.length; ++i) {
                if (schemaArray[i].getTargetNamespace() != null || (element = schemaArray[i].getElement(elementName.getNCName())) == null) continue;
                schema = (NSSchema)schemaArray[i];
                break;
            }
        }
        if (element != null) {
            this.setURIReferencePrefixPairs(schema.getURIReferencePrefixPairs());
        }
        return element;
    }

    private static final Hashtable createDefaultURIReferencePrefixPairs() {
        Hashtable<String, String> _default = new Hashtable<String, String>();
        _default.put("http://www.w3.org/XML/1998/namespace", "xml");
        _default.put("urn:uuid:C2F41010-65B3-11d1-A29F-00AA00C14882/", "dt");
        return _default;
    }

    @Override
    public void addError(String errorCode, String errorMessage) {
        Object[][] o = new Object[][]{{"errorCode", errorCode}, {"errorMessage", errorMessage}};
        Values error = new Values(o);
        this._errors.addElement(error);
    }

    @Override
    public void addError(String errorCode, LocalizedMessage errorMessage) {
        Object[][] o = new Object[][]{{"errorCode", errorCode}, {"errorMessage", errorMessage.getLocalizedMessage(this._locale)}};
        Values error = new Values(o);
        this._errors.addElement(error);
    }

    @Override
    public IData[] getErrors() {
        if (this._errors.isEmpty()) {
            return null;
        }
        Object[] idataArray = new IData[this._errors.size()];
        this._errors.copyInto(idataArray);
        return idataArray;
    }

    @Override
    public boolean isSuccessful() {
        return this._errors.isEmpty();
    }

    public void dumpExtended() {
        Iterator<QName> i = this._extendedTypes.iterator();
        while (i.hasNext()) {
            System.out.println("init gen: " + i.next());
        }
    }
}

