/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.conv;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.Flat;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.SimpleTypeUtil;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.Util;
import com.wm.lang.schema.WmElement;
import com.wm.lang.schema.WmTag;
import com.wm.lang.schema.conv.Builder;
import com.wm.lang.schema.conv.Context;
import com.wm.util.NCName;
import com.wm.util.Name;
import com.wm.util.QName;
import java.util.Enumeration;

abstract class BuilderImpl
implements Builder {
    private static final boolean debug = false;
    protected static final String STAR_BODY = "*body";
    protected static final String DOCTYPE_PREFIX = "docType_";
    private static final QName QNAME_OF_URSIMPLETYPE = QName.create("http://www.w3.org/1999/XMLSchema", "urSimpleType");

    BuilderImpl() {
    }

    public void setUsingBuilder(Builder builder) {
    }

    protected NSRecord createRecord(Namespace ns, WmTag tag, String name) {
        NSRecord nsr = new NSRecord(ns);
        nsr.setName(name);
        QName qname = tag.getQName();
        Name xmlns = qname.getNamespaceName();
        Util.setXmlNamespace(nsr, xmlns);
        nsr.setClosed(true);
        Util.setSchemaTypeName(nsr, this.getTypeQName(tag));
        return nsr;
    }

    protected NSField createField(Namespace ns, WmTag tag, String name) {
        NSField field = new NSField(ns, name, 1, 0);
        QName qname = tag.getQName();
        Name xmlns = qname.getNamespaceName();
        Util.setXmlNamespace(field, xmlns);
        return field;
    }

    private QName getTypeQName(WmTag tag) {
        TypeDef st;
        ContentType ct = tag.getType();
        if (tag.useSoapArray()) {
            QName typeQ = null;
            try {
                ComplexType ctype = (ComplexType)ct;
                Enumeration elements = ctype.elements();
                WmElement element = (WmElement)elements.nextElement();
                ComplexType ctype2 = (ComplexType)element.getType();
                typeQ = ctype2.getQName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (typeQ != null) {
                return typeQ;
            }
            System.out.println("########################");
            System.out.println("########################");
            System.out.println("getTypeQName : useSoapArray");
            System.out.println("COULD NOT GET ENCODING TYPE NAME");
            System.out.println("########################");
            System.out.println("########################");
        }
        if (ct != null && ct.getType() == 1) {
            st = (SimpleType)ct;
            return st.getQName();
        }
        if (ct != null && ct.getType() == 2) {
            st = (TypeDef)ct;
            return st.getQName();
        }
        return null;
    }

    public static int xsdTypeToFieldType(QName schemaTypeName) {
        return 1;
    }

    protected NSRecordRef createRecordRef(Namespace ns, WmTag tag, String name, NSRecord target) {
        NSRecordRef rec = new NSRecordRef(ns, name, target, 0);
        QName qname = tag.getQName();
        Name xmlns = qname.getNamespaceName();
        Util.setXmlNamespace(rec, xmlns);
        return rec;
    }

    protected String computeName(WmTag tag, Context context) {
        String prefix;
        String xmlns;
        boolean isAttribute = tag.getTagType() == 2;
        QName name = tag.getQName();
        StringBuffer sb = new StringBuffer();
        if (isAttribute) {
            sb.append(context.getAttributePrefix());
        }
        if ((xmlns = name.getNamespace()) != null && (prefix = context.resolveURIReferenceToPrefix(xmlns)) != null) {
            sb.append(prefix);
            context.addUsedPrefixURIPair(prefix, xmlns);
            sb.append(':');
        }
        sb.append(context.useNCNameDecoder() ? NCName.decode(name.getNCName()) : name.getNCName());
        return sb.toString();
    }

    protected String computeNamespaceName(WmTag tag, Context context) {
        String name = this.computeName(tag, context);
        name = name.replace(':', '_');
        return name;
    }

    protected void applyFlatModel(NSField nsf, Context context) {
        Flat flatModel = context.getCurrentFlatModel();
        if (flatModel == null) {
            return;
        }
        if (!flatModel.isRequired()) {
            nsf.setOptional(true);
        }
        if (flatModel.isRepeatable()) {
            nsf.setDimensions(1);
        }
    }

    protected void applyNillable(WmTag tag, NSField nsf) {
        if (tag.getTagType() == 2) {
            return;
        }
        WmElement element = (WmElement)tag;
        nsf.setNillable(element.isNullable());
    }

    protected SimpleType createSimpleType(WmTag tag, Context context) {
        ContentType type = tag.getType();
        SimpleType simpleType = null;
        if (type != null) {
            if (type.getType() == 1) {
                simpleType = (SimpleType)type;
            } else {
                ComplexType complexType = (ComplexType)type;
                simpleType = complexType.getSimpleType();
            }
        }
        if (simpleType != null) {
            try {
                simpleType = SimpleTypeUtil.cloneSmartly(context.getNamespace(), simpleType);
                String fixedValue = tag.getFixedValue();
                if (fixedValue != null) {
                    String[] enumvar = new String[]{fixedValue};
                    IData facets = simpleType.getFacets();
                    IDataCursor ic = facets.getCursor();
                    IDataUtil.put(ic, "enumeration", enumvar);
                    ic.destroy();
                    simpleType.setFacets(facets, context.getLocale());
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return simpleType;
    }
}

