/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.DatatypeFactory;
import com.wm.lang.schema.NodeWorkspace;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.W3CKeys;
import com.wm.lang.schema.WmAttribute;
import com.wm.lang.schema.WmComplexType;
import com.wm.lang.schema.WmElement;
import com.wm.lang.schema.conv.Builder;
import com.wm.lang.schema.conv.Context;
import com.wm.lang.schema.util.Entry;
import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.util.Destroyable;
import com.wm.util.IntEnum;
import com.wm.util.QName;
import com.wm.util.Showable;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.sort.Sortable;
import java.util.Hashtable;

public abstract class WmTag
implements IDataPortable,
ValuesCodable,
W3CKeys,
Entry,
Sortable,
Showable,
Destroyable {
    String _ncName;
    ContentType _type;
    String _default;
    String _fixed;
    int _tagType;
    boolean _isExpanded;
    String _xmlns;
    Schema _owner;
    Schema[] _schemas;
    boolean _isInTopSymbolSpace;
    boolean _isAugmentable;
    String _CII;
    boolean _urType;
    boolean _formQualified;
    boolean _isGlobal = false;
    public static final int TAGTYPE_ELEMENT = 1;
    public static final int TAGTYPE_ATTRIBUTE = 2;
    public static final int TAGTYPE_UNKNOWN = 3;
    static final IntEnum _tagTypeEnum = new IntEnum(0);
    public static final String KEY_TAGTYPE = "tagType";
    public static final String KEY_XMLNS = "xmlns";
    public static final String KEY_IS_EXPANDED = "isExpanded";
    boolean _isDestroyed = false;

    WmTag(Schema owner, IData values) {
        this._owner = owner;
        this.setFromData(values);
    }

    WmTag() {
        this._tagType = 1;
    }

    WmTag(String ncName) {
        this._ncName = ncName;
        this._tagType = 1;
    }

    protected WmTag(String ncName, int tagType, String defaultValue, String fixedValue, ContentType type) {
        this._ncName = ncName;
        this._tagType = tagType;
        this.setDefaultValue(defaultValue);
        this.setFixedValue(fixedValue);
        this.setType(type);
    }

    public String getName() {
        return this._ncName;
    }

    public QName getQName() {
        if (this._xmlns != null) {
            return QName.create(this._xmlns, this.getName());
        }
        if (this._isInTopSymbolSpace) {
            return QName.create(this._owner.getTargetNamespace(), this.getName());
        }
        return QName.create(null, this.getName());
    }

    public Schema getOwner() {
        return this._owner;
    }

    public ContentType getType() {
        return this._type;
    }

    public String getDefaultValue() {
        return this._default;
    }

    public String getFixedValue() {
        return this._fixed;
    }

    public int getTagType() {
        return this._tagType;
    }

    public boolean isAugmentable() {
        return this._isAugmentable;
    }

    public String getCII() {
        return this._CII;
    }

    public Schema[] getSchemas() {
        return this._schemas;
    }

    public void setName(String ncName) {
        this._ncName = ncName;
    }

    public void setSchemas(Schema[] schemas) {
        this._schemas = schemas;
    }

    public void setType(ContentType type) {
        if (type != null) {
            switch (type.getType()) {
                case 3: {
                    return;
                }
                case 1: {
                    ((SimpleType)type).setOwner(this._owner);
                    break;
                }
                case 2: {
                    ((ComplexType)type).setOwner(this._owner);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (this._type != null) {
            if (this._type.getType() == 1) {
                ((SimpleType)this._type).setOwner(null);
            } else {
                ((ComplexType)this._type).setOwner(null);
            }
            if (this._type instanceof Destroyable) {
                ((Destroyable)((Object)this._type)).setDestroyed();
            }
        }
        this._type = type;
    }

    public void setDefaultValue(String defaultValue) {
        this._default = defaultValue;
        this.computeAugmentation();
    }

    public void setFixedValue(String fixedValue) {
        this._fixed = fixedValue;
        this.computeAugmentation();
    }

    private void computeAugmentation() {
        if (this._default != null || this._fixed != null) {
            this._isAugmentable = true;
            this._CII = this._default != null ? this._default : this._fixed;
        } else {
            this._isAugmentable = false;
        }
    }

    protected void setTagType(int tagType) {
        this._tagType = tagType;
    }

    public void setOwner(Schema owner) {
        this._owner = owner;
        if (this._type != null) {
            int contentType = this._type.getType();
            if (contentType == 2) {
                ((ComplexType)this._type).setOwner(this._owner);
            } else if (contentType == 1) {
                ((SimpleType)this._type).setOwner(this._owner);
            }
        }
    }

    public boolean isFormQualified() {
        return this._formQualified;
    }

    public void setFormQualified(boolean formQualified) {
        this._formQualified = formQualified;
    }

    public boolean isGlobal() {
        return this._isGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        this._isGlobal = isGlobal;
    }

    public int compare(Sortable compareTo, boolean reverse, int column) {
        if (compareTo instanceof WmTag) {
            return this._ncName.toLowerCase().compareTo(((WmTag)compareTo).getName().toLowerCase());
        }
        return 0;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_TAGTYPE, _tagTypeEnum.getString(this._tagType, "unknown")}, {KEY_XMLNS, this._xmlns}, {"name", this._ncName}, {"type", this._type != null ? this._type.getValues() : null}, {"default", this._default}, {"fixed", this._fixed}, {KEY_IS_EXPANDED, this._isExpanded ? "true" : null}, {"form", this._formQualified ? "true" : null}};
        return new Values(o);
    }

    public void setValues(Values values) {
        this._tagType = _tagTypeEnum.getInt(values.getString(KEY_TAGTYPE), 3);
        this._xmlns = values.getString(KEY_XMLNS);
        this._ncName = values.getString("name");
        Object in = values.get("type");
        if (in != null && in instanceof Values) {
            this.setType(WmTag.createContentType(this._owner, (Values)in));
        } else {
            this._type = null;
        }
        this.setDefaultValue(values.getString("default"));
        this._fixed = values.getString("fixed");
        this.setFixedValue(this._fixed);
        this._isExpanded = values.getBoolean(KEY_IS_EXPANDED);
        this._formQualified = values.getBoolean("form");
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{KEY_TAGTYPE, _tagTypeEnum.getString(this._tagType, "unknown")}, {KEY_XMLNS, this._xmlns}, {"name", this._ncName}, {"type", this._type != null ? this._type.getValues() : null}, {"default", this._default}, {"fixed", this._fixed}, {KEY_IS_EXPANDED, this._isExpanded ? "true" : null}, {"form", this._formQualified ? "true" : null}};
        return IDataFactory.create(o);
    }

    public void setFromData(IData values) {
        IDataCursor ic = values.getCursor();
        this._tagType = _tagTypeEnum.getInt(IDataUtil.getString(ic, KEY_TAGTYPE), 3);
        this._xmlns = IDataUtil.getString(ic, KEY_XMLNS);
        this._ncName = IDataUtil.getString(ic, "name");
        Object in = IDataUtil.get(ic, "type");
        if (in != null && in instanceof Values) {
            this.setType(WmTag.createContentType(this._owner, (IData)in));
        } else {
            this._type = null;
        }
        this.setDefaultValue(IDataUtil.getString(ic, "default"));
        this._fixed = IDataUtil.getString(ic, "fixed");
        this.setFixedValue(this._fixed);
        String isExpanded = IDataUtil.getString(ic, KEY_IS_EXPANDED);
        this._isExpanded = isExpanded != null && isExpanded.equalsIgnoreCase("true");
        this._formQualified = ic.first("form") ? IDataUtil.getBoolean(ic) : false;
        ic.destroy();
    }

    private static final ContentType createContentType(Schema owner, IData values) {
        IDataCursor ic = values.getCursor();
        int contentType = IDataUtil.getInt(ic, "contentType", -1);
        ic.destroy();
        switch (contentType) {
            case 2: {
                return WmComplexType.create(owner, values);
            }
            case 1: {
                try {
                    SimpleType sType = DatatypeFactory.create(values);
                    sType.setOwner(owner);
                    return sType;
                }
                catch (NSException ne) {
                    return null;
                }
            }
        }
        return null;
    }

    public void addTo(Hashtable ht) {
        String ncName = this.getName();
        if (ncName != null && ncName.length() > 0) {
            ht.put(ncName, this);
        }
    }

    public abstract void validate(ElementNodeBase var1, NodeWorkspace var2, String var3);

    public abstract void validate(Attribute var1, NodeWorkspace var2, String var3);

    public abstract void augment(ElementNodeBase var1, NodeWorkspace var2);

    public static final WmTag createTag(Schema owner, IData values) {
        IDataCursor ic = values.getCursor();
        int tagType = _tagTypeEnum.getInt(IDataUtil.getString(ic, "type"), 3);
        ic.destroy();
        switch (tagType) {
            case 1: {
                return WmElement.create(owner, values);
            }
            case 2: {
                return WmAttribute.create(owner, values);
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(":");
        sb.append(" ncName = " + this._ncName + ';');
        sb.append(" tagType = " + _tagTypeEnum.getString(this._tagType, "unknown") + ';');
        sb.append(" type = [" + this._type + "];");
        sb.append(" default = " + this._default + ';');
        sb.append(" fixed = " + this._fixed + ';');
        return sb.toString();
    }

    public Values getView() {
        Object[][] o = new Object[][]{{"name", this._ncName}, {"type", this._type != null ? ((Showable)((Object)this._type)).getView() : null}, {"default", this._default}, {"fixed", this._fixed}};
        return new Values(o);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof QName) {
            return this.getQName().equals(obj);
        }
        return false;
    }

    public boolean isDestroyed() {
        return this._isDestroyed;
    }

    public void setDestroyed() {
        this._isDestroyed = true;
    }

    public Object deepClone() {
        IData values = this.getAsData();
        WmTag clone = WmTag.createTag(this.getOwner(), values);
        return clone;
    }

    public void setURTypeFlag() {
        this._urType = true;
    }

    public boolean isURType() {
        return this._urType;
    }

    public boolean isProxy() {
        return false;
    }

    public abstract NSField createRecord(Builder var1, Context var2);

    public abstract Integer createID();

    public void setIsInTopSymbolSpace() {
        this._isInTopSymbolSpace = true;
    }

    public void resetIsInTopSymbolSpace() {
        this._isInTopSymbolSpace = false;
    }

    protected boolean isInTopSymbolSpace() {
        return this._isInTopSymbolSpace;
    }

    public void setNamespaceURI(String xmlns) {
        this._xmlns = xmlns;
    }

    public String getNamespaceURI() {
        return this._xmlns;
    }

    public void setExpanded(boolean isExpanded) {
        this._isExpanded = isExpanded;
    }

    public boolean isExpanded() {
        return this._isExpanded;
    }

    public boolean useSoapArray() {
        return false;
    }

    static {
        _tagTypeEnum.addInt("element", 1);
        _tagTypeEnum.addInt("attribute", 2);
        _tagTypeEnum.addInt("unknown", 3);
    }
}

