/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.DatatypeFactory;
import com.wm.lang.schema.Flat;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.NodeWorkspace;
import com.wm.lang.schema.Reserve;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.SimpleTypeUtil;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.Util;
import com.wm.lang.schema.WmAttribute;
import com.wm.lang.schema.WmComplexType;
import com.wm.lang.schema.WmComplexTypeRef;
import com.wm.lang.schema.WmElementRef;
import com.wm.lang.schema.WmTag;
import com.wm.lang.schema.conv.Builder;
import com.wm.lang.schema.conv.Context;
import com.wm.lang.schema.conv.FieldBuilder;
import com.wm.lang.schema.conv.ObjectBuilder;
import com.wm.lang.schema.conv.Profiler;
import com.wm.lang.schema.conv.resources.ConverterMessageBundle;
import com.wm.lang.schema.resources.ValidationMessageBundle;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.util.Iterator;
import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.lang.xml.TextNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.Destroyable;
import com.wm.util.IntEnum;
import com.wm.util.LocalizedException;
import com.wm.util.LocalizedMessage;
import com.wm.util.NCName;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Enumeration;
import java.util.Set;

public class WmElement
extends WmTag
implements ValuesCodable,
Destroyable {
    int _internalType;
    boolean _isAbstract;
    HashSet _substitutableFor;
    boolean _nullable;
    boolean _nillable;
    static final boolean DEBUG = false;
    boolean _isSimpleType;
    static final int ELEMENT_INSTANCE = 1;
    static final int ELEMENT_REFERENCE = 2;
    static final int ELEMENT_UNKNOWN = 10;
    public static final String TYPEREF_PREFIX = "docTypeRef_";
    static final IntEnum _internalTypeEnum = new IntEnum(0);
    public static final String KEY_ELEMENT_INTERNALTYPE = "internalType";
    static final QName ANYTYPE_2001;
    static final QName ANYTYPE_2000;
    static final QName SOAP_ARRAY;
    static final QName SOAP_ARRAY_TYPE;

    public WmElement(Schema owner, IData values) {
        super(owner, values);
    }

    public WmElement() {
        this._internalType = 1;
    }

    public WmElement(String ncName) {
        super(ncName);
        this._internalType = 1;
    }

    protected WmElement(String ncName, int internalType) {
        this(ncName);
        this._internalType = internalType;
    }

    public boolean isAbstract() {
        return this._isAbstract;
    }

    public HashSet getSubstitutableFor() {
        return this._substitutableFor;
    }

    public boolean isNullable() {
        return this._nullable;
    }

    public void setAbstract(boolean isAbstract) {
        this._isAbstract = isAbstract;
    }

    public void setSubstitutableFor(HashSet substitutableFor) {
        this._substitutableFor = substitutableFor;
    }

    public void setNullable(boolean nullable) {
        this._nullable = nullable;
    }

    public void setType(ContentType type) {
        super.setType(type);
        this._isSimpleType = this._type != null && this._type.getType() == 1;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_ELEMENT_INTERNALTYPE, _internalTypeEnum.getString(this._internalType, "unknown")}, {"abstract", this._isAbstract ? "true" : null}, {"equivClass", WmElement.toArray(this._substitutableFor)}, {"nullable", this._nullable ? "true" : null}, {"nillable", this._nullable ? "true" : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values values) {
        super.setValues(values);
        this._internalType = _internalTypeEnum.getInt(values.getString(KEY_ELEMENT_INTERNALTYPE), 10);
        this._isAbstract = values.getBoolean("abstract");
        this._nullable = values.getBoolean("nullable");
        this._nillable = values.getBoolean("nillable");
        Object in = values.get("equivClass");
        if (in != null) {
            if (this._substitutableFor == null) {
                this._substitutableFor = new HashSet();
            }
            if (in instanceof Object[]) {
                Object[] inArray = (Object[])in;
                for (int i = 0; i < inArray.length; ++i) {
                    this._substitutableFor.add(QName.create((Values)inArray[i]));
                }
            } else {
                this._substitutableFor.add(QName.create((Values)in));
            }
        } else {
            this._substitutableFor = null;
        }
    }

    public IData getAsData() {
        IData val = super.getAsData();
        IDataCursor ic = val.getCursor();
        ic.insertAfter(KEY_ELEMENT_INTERNALTYPE, _internalTypeEnum.getString(this._internalType, "unknown"));
        if (this._isAbstract) {
            ic.insertAfter("abstract", "true");
        }
        ic.insertAfter("equivClass", WmElement.toIDataArray(this._substitutableFor));
        if (this._nullable) {
            ic.insertAfter("nullable", "true");
        }
        if (this._nillable) {
            ic.insertAfter("nillable", "true");
        }
        ic.destroy();
        return val;
    }

    public void setFromData(IData values) {
        super.setFromData(values);
        IDataCursor ic = values.getCursor();
        this._internalType = _internalTypeEnum.getInt(IDataUtil.getString(ic, KEY_ELEMENT_INTERNALTYPE), 10);
        this._isAbstract = ic.first("abstract") ? IDataUtil.getBoolean(ic) : false;
        this._nullable = ic.first("nullable") ? IDataUtil.getBoolean(ic) : false;
        this._nillable = ic.first("nillable") ? IDataUtil.getBoolean(ic) : false;
        Object in = IDataUtil.get(ic, "equivClass");
        if (in != null) {
            if (this._substitutableFor == null) {
                this._substitutableFor = new HashSet();
            }
            if (in instanceof Object[]) {
                Object[] inArray = (Object[])in;
                for (int i = 0; i < inArray.length; ++i) {
                    this._substitutableFor.add(QName.create((IData)inArray[i]));
                }
            } else {
                this._substitutableFor.add(QName.create((IData)in));
            }
        } else {
            this._substitutableFor = null;
        }
        ic.destroy();
    }

    public void validate(ElementNodeBase node, NodeWorkspace workspace, String baseLocationPath) {
        if (workspace.completed) {
            return;
        }
        if (this.isAbstract()) {
            workspace.addError(baseLocationPath, this._ncName, "NV-016", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_ABSTRACT_ELEMENT, null, this.getName()));
            return;
        }
        if (workspace.verbose) {
            workspace.bookmark();
            WmElement.startSpittingOut(node, workspace);
        }
        this.validateNillable(node, workspace, baseLocationPath);
        if (workspace.verbose) {
            WmElement.finishSpittingOut(workspace);
        }
        if (this._isSimpleType) {
            this.validateUsingSimpleType(node, workspace, baseLocationPath);
        } else if (this._type != null) {
            ((ComplexType)this._type).validate(node, workspace, baseLocationPath + "/" + this._ncName);
        }
        if (workspace.verbose) {
            WmElement.finishSpittingOut(workspace);
        }
    }

    private void validateUsingSimpleType(ElementNodeBase node, NodeWorkspace workspace, String baseLocationPath) {
        String typeRef = Util.retrieveXSIType(node);
        TypeDef nominatedType = null;
        SimpleType declaredType = (SimpleType)this.getType();
        if (typeRef != null) {
            if (!declaredType.isProxy()) {
                workspace.addError(baseLocationPath, this.getName(), "NV-017", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_INCORRECT_XSITYPE, null, typeRef));
                return;
            }
            QName typeName = null;
            try {
                typeName = QName.computeQName(typeRef, node);
            }
            catch (Exception ex) {
                workspace.addError(baseLocationPath, this.getName(), "NV-013", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_UNABLE_TO_RESOLVE, null, typeRef));
                return;
            }
            QName declaredTypeName = declaredType.getQName();
            if (declaredTypeName.equals(typeName)) {
                this.validateUsingSimpleType(node, workspace, baseLocationPath, declaredType);
                return;
            }
            Name nsuri = node.getNamespaceUri();
            if (nsuri == null) {
                nsuri = typeName.getNamespaceName();
            }
            nominatedType = DatatypeFactory.createReference(nsuri, typeName);
            nominatedType.setOwner(this._owner);
            if (!nominatedType.targetExists()) {
                nominatedType = WmComplexType.create(typeName);
                nominatedType.setOwner(this.getOwner());
                if (!((WmComplexTypeRef)nominatedType).targetExists()) {
                    workspace.addError(baseLocationPath, this.getName(), "NV-011", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_LOST_TYPE_DEF, null));
                    return;
                }
            }
            if (nominatedType.isValidlyDerivedFrom(declaredTypeName)) {
                if (nominatedType.getType() == 1) {
                    this.validateUsingSimpleType(node, workspace, baseLocationPath, (SimpleType)nominatedType);
                } else {
                    ((ComplexType)nominatedType).validate(node, workspace, baseLocationPath + "/" + this._ncName);
                }
            } else {
                String sub1 = typeName.getNCName() + " {" + typeName.getNamespace() + "}";
                String sub2 = declaredTypeName.getNCName() + " {" + declaredTypeName.getNamespace() + "}";
                Object[] subs = new Object[]{sub1, sub2};
                workspace.addError(baseLocationPath, this.getName(), "NV-014", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_TYPE_DERIVATION_NOK, null, subs));
            }
        } else {
            this.validateUsingSimpleType(node, workspace, baseLocationPath, declaredType);
        }
    }

    private void validateUsingSimpleType(ElementNodeBase node, NodeWorkspace workspace, String baseLocationPath, SimpleType type) {
        TextNode[] tNodes;
        if (workspace.childNames != null && workspace.childNames.length > 1) {
            workspace.addError(baseLocationPath, this.getName(), "NV-005", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_EIIS_FOUND, null));
        }
        if ((tNodes = workspace.tNodes) == null) {
            if (!workspace.ignoreNilValue && !workspace.ignoreContent) {
                workspace.baseLocationPath = baseLocationPath;
                workspace.relativeLocationPath = this.getName();
                type.validate("", workspace);
            }
        } else {
            String data = Util.compose(tNodes);
            if (data.length() > 0) {
                if (this._fixed != null && !data.equals(this._fixed)) {
                    workspace.addError(baseLocationPath, this.getName(), "NV-008", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_INVALID_CII, null));
                } else if (!workspace.ignoreContent) {
                    workspace.baseLocationPath = baseLocationPath;
                    workspace.relativeLocationPath = this.getName();
                    type.validate(data, workspace);
                }
            } else if (this.isAugmentable()) {
                this.augment(node, workspace);
            }
        }
        if (workspace.completed) {
            return;
        }
        if (workspace.childNames != null && workspace.childNames.length > 1) {
            workspace.addError(baseLocationPath, this._ncName, "NV-005", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_EIIS_FOUND, null));
        }
        if (workspace.completed) {
            return;
        }
        for (Attribute attribute = node.getFirstAttribute(); attribute != null && !workspace.completed; attribute = attribute.getNext()) {
            QName name = QName.create(attribute.getNamespaceUri(), attribute.getLocalNameWm());
            if (Reserve.current().contains(name)) continue;
            workspace.addError(baseLocationPath, this._ncName, "NV-004", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_AIIS_FOUND, null));
            break;
        }
    }

    private static final void startSpittingOut(ElementNodeBase node, NodeWorkspace workspace) {
        StringBuffer sb = workspace.sb;
        sb.append("### -- EII Visit -- \n");
        sb.append("{" + node.getNamespaceUri() + "} " + node.getLocalNameWm() + '\n');
        sb.append('\n');
        if (workspace.childNames != null && workspace.childNames.length > 1) {
            sb.append("QNames of EIIs in [children]: ");
            for (int i = 0; i < workspace.childNames.length; ++i) {
                sb.append("[" + i + "] {" + workspace.childNames[i].getNamespace() + "} " + workspace.childNames[i].getNCName() + ' ');
            }
            sb.append('\n');
            sb.append('\n');
        }
        if (workspace.tNodes != null) {
            sb.append("Chunks of CII: ");
            for (int j = 0; j < workspace.tNodes.length; ++j) {
                sb.append("[" + j + "]" + workspace.tNodes[j].getText() + ' ');
            }
            sb.append('\n');
            sb.append('\n');
        }
    }

    private static final void finishSpittingOut(NodeWorkspace workspace) {
        StringBuffer sb = workspace.sb;
        if (workspace.attrNames != null) {
            sb.append("QNames of AIIs in [attributes]: ");
            for (int i = 0; i < workspace.attrNames.length; ++i) {
                sb.append("[" + i + "] {" + workspace.attrNames[i].getNamespace() + "} " + workspace.attrNames[i].getNCName() + ' ');
            }
            sb.append('\n');
            sb.append('\n');
        }
        boolean valid = true;
        Values[] errors = workspace.retrieveErrorSnapshot();
        if (errors != null) {
            valid = false;
            sb.append("x-x-x-x-x-x-errors\n");
            for (int i = 0; i < errors.length; ++i) {
                sb.append(((Object)errors[i]).toString() + '\n');
            }
            sb.append('\n');
            sb.append('\n');
        }
        sb.append("=== " + (valid ? "VALID" : "INVALID") + '\n');
        sb.append("### -- END EII Visit -- \n\n\n");
    }

    private void validateNillable(ElementNodeBase node, NodeWorkspace workspace, String baseLocationPath) {
        String nil = node.getAttributeValue(Name.create("http://www.w3.org/2001/XMLSchema-instance"), Name.create("nil"));
        if (nil == null) {
            nil = node.getAttributeValue(Name.create("http://www.w3.org/2000/10/XMLSchema-instance"), Name.create("null"));
        }
        boolean ignoreNilValue = false;
        if (this.isNullable()) {
            if (nil != null) {
                if (nil.equals("true") || nil.equals("1")) {
                    String text = null;
                    try {
                        text = node.getText();
                    }
                    catch (WMDocumentException e) {
                        // empty catch block
                    }
                    if (text != null && !text.equals("")) {
                        workspace.addError(baseLocationPath, this._ncName, "NV-021", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_NO_CHAR_OR_CHILD, null, this.getName()));
                    } else if (workspace.childNames != null && workspace.childNames.length > 1) {
                        workspace.addError(baseLocationPath, this._ncName, "NV-021", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_NO_CHAR_OR_CHILD, null, this.getName()));
                    }
                    ignoreNilValue = true;
                } else if (!nil.equals("false") && !nil.equals("0")) {
                    workspace.addError(baseLocationPath, this._ncName, "NV-020", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_INVALID_NIL_VALUE, null, this.getName()));
                }
            }
        } else if (nil != null) {
            workspace.addError(baseLocationPath, this._ncName, "NV-019", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_NIL_SHOULD_NOT_EXIST, null, this.getName()));
        }
        workspace.ignoreNilValue = ignoreNilValue;
    }

    public void validate(Attribute attr, NodeWorkspace workspace, String baseLocationPath) {
    }

    public void augment(ElementNodeBase node, NodeWorkspace workspace) {
        TextNode[] tNodes = workspace.tNodes;
        if (tNodes != null && tNodes.length > 0) {
            TextNode tNode = tNodes[0];
            node.removeChild(tNode);
            tNode = TextNode.create(node.getDocument(), this._CII);
            node.addChild(tNode);
        }
    }

    public static final WmElement create(Schema owner, IData values) {
        IDataCursor ic = values.getCursor();
        int internalType = _internalTypeEnum.getInt(IDataUtil.getString(ic, KEY_ELEMENT_INTERNALTYPE), 10);
        ic.destroy();
        switch (internalType) {
            case 1: {
                return new WmElement(owner, values);
            }
            case 2: {
                return new WmElementRef(owner, values);
            }
        }
        return null;
    }

    public static final WmElement create(String ncName) {
        return new WmElement(ncName);
    }

    public static final WmElement create(String targetNS, String targetNCName) {
        return new WmElementRef(QName.create(targetNS, targetNCName));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" internalType = " + _internalTypeEnum.getString(this._internalType, "unknown") + ';');
        return sb.toString();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NSField createRecord(Builder builder, Context context) {
        NSField nsf;
        block23: {
            this.setSchemas(context.getSchemas());
            if (this.useSoapArray()) {
                return this.createSoapArrayRecord(builder, context);
            }
            nsf = builder.build(this, context);
            if (nsf == null || nsf.getType() != 2) break block23;
            NSRecord nsr = (NSRecord)nsf;
            ContentType type = this.getType();
            if (type == null || type.getType() != 2) break block23;
            NSRecord typeRec = null;
            boolean populateTypeRec = false;
            ComplexType complexType = (ComplexType)type;
            if (context.createDocsForTypes() && type instanceof WmComplexTypeRef) {
                WmComplexTypeRef ctref = (WmComplexTypeRef)type;
                QName target = ctref.getQName();
                String typeRecordName = TYPEREF_PREFIX + this.computeNamespaceName(target, context);
                if (context.containsTypeRecord(typeRecordName)) {
                    typeRec = context.getTypeRecord(typeRecordName);
                } else {
                    typeRec = (NSRecord)this.createTypeRecord(context);
                    populateTypeRec = true;
                    context.updateExtended(ctref);
                }
            }
            boolean bl = true;
            while (true) {
                int i;
                block26: {
                    java.util.Iterator<WmElement> it;
                    boolean isHeadAnElementReference;
                    boolean isSubstitutableElement;
                    WmElement element;
                    Flat[] flatModel;
                    block27: {
                        block25: {
                            block24: {
                                if (!bl || (bl = false)) break block24;
                                if (typeRec != null && !populateTypeRec) break block25;
                                Enumeration attributes = complexType.attributes();
                                while (attributes.hasMoreElements()) {
                                    WmAttribute oneAttr = (WmAttribute)attributes.nextElement();
                                    nsr.addField(oneAttr.createRecord(builder, context));
                                }
                                Model model = complexType.getContentModel();
                                if (model == null || (flatModel = model.getFlattenedModel()) == null) break block25;
                                i = 0;
                            }
                            if (i >= flatModel.length) break block25;
                            if (flatModel[i].isAny() || (element = complexType.getElement(flatModel[i].getSymbol())) == null) break block26;
                            isSubstitutableElement = false;
                            isHeadAnElementReference = false;
                            WmElement headElement = element;
                            Set<WmElement> substitutableElements = null;
                            it = null;
                            if (!context.subsGroupsEnabled() || (substitutableElements = context.getElementsSubstitutableFor(headElement.getQName())) == null || substitutableElements.isEmpty()) break block27;
                            isSubstitutableElement = true;
                            it = substitutableElements.iterator();
                            if (headElement._internalType != 2) break block27;
                            isHeadAnElementReference = true;
                            break block27;
                        }
                        if (typeRec == null) break;
                        if (populateTypeRec) {
                            int fnum = nsr.getFieldCount();
                            for (int i2 = 0; i2 < fnum; ++i2) {
                                NSField f = nsr.getField(i2);
                                typeRec.addField(f);
                            }
                        }
                        String name = nsf.getName();
                        NSRecordRef rec = new NSRecordRef(context.getNamespace(), name, typeRec, 0);
                        Name xmlns = this.getQName().getNamespaceName();
                        Util.setXmlNamespace(rec, xmlns);
                        rec.setUniversalName(this.getQName());
                        rec.setNillable(nsf.isNillable());
                        rec.setOptional(nsf.isOptional());
                        rec.setDimensions(nsf.getDimensions());
                        rec.setFormQualified(nsf.isFormQualified());
                        rec.setGlobal(nsf.isGlobal());
                        rec.setClosed(nsr.isClosed());
                        nsf = rec;
                        break;
                    }
                    do {
                        if (element.isAbstract()) continue;
                        context.setCurrentFlatModel(flatModel[i]);
                        ContentType ct = element.getType();
                        if (ct == null) {
                            NSField fld = new NSField(nsr.getNamespace(), NSRecord.TYPE, element.getName(), 1, 0);
                            if (flatModel[i].isRepeatable()) {
                                fld.setDimensions(1);
                            }
                            if (!flatModel[i].isRequired()) {
                                fld.setOptional(true);
                            }
                            if (context.subsGroupsEnabled() && isSubstitutableElement) {
                                fld.setOptional(true);
                                fld.setSubstitutionGroupName(context.computeSubstitutionGroupName(element));
                            }
                            nsr.addField(fld);
                            continue;
                        }
                        if ((ct = Util.mapSoapEncDataTypeToXsdDataType(context, ct)).getType() == 1) {
                            String prefix;
                            String fn = context.useNCNameDecoder() ? NCName.decode(element.getName()) : element.getName();
                            Name tns = element.getQName().getNamespaceName();
                            if (tns != null && (prefix = context.resolveURIReferenceToPrefix(tns.toString())) != null) {
                                fn = prefix + ":" + element.getName();
                                context.addUsedPrefixURIPair(prefix, tns.toString());
                            }
                            NSField fld = new NSField(nsr.getNamespace(), NSRecord.TYPE, fn, 1, 0);
                            SimpleType st = null;
                            try {
                                st = SimpleTypeUtil.cloneSmartly(context.getNamespace(), (SimpleType)ct);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            if (flatModel[i].isRepeatable()) {
                                fld.setDimensions(1);
                            }
                            if (!flatModel[i].isRequired()) {
                                fld.setOptional(true);
                            } else {
                                fld.setOptional(false);
                            }
                            fld.setNillable(element.isNullable());
                            fld.setContentType(st);
                            Util.setXmlNamespace(fld, tns);
                            if (context.subsGroupsEnabled() && isSubstitutableElement) {
                                fld.setOptional(true);
                                fld.setSubstitutionGroupName(context.computeSubstitutionGroupName(element));
                            }
                            fld.setFormQualified(element.isFormQualified());
                            fld.setGlobal(element.isGlobal());
                            nsr.addField(fld);
                            continue;
                        }
                        if (isHeadAnElementReference && element._internalType != 2) {
                            WmElementRef elementRef = new WmElementRef(element.getQName());
                            elementRef.setOwner(element.getOwner());
                            elementRef.setSchemas(element.getSchemas());
                            element = elementRef;
                        }
                        NSField record = element.createRecord(builder, context);
                        if (context.subsGroupsEnabled() && isSubstitutableElement) {
                            record.setOptional(true);
                            record.setSubstitutionGroupName(context.computeSubstitutionGroupName(element));
                        }
                        record.setFormQualified(element.isFormQualified());
                        record.setGlobal(element.isGlobal());
                        nsr.addField(record);
                    } while (it != null && it.hasNext() && (element = (WmElement)it.next()) != null);
                }
                ++i;
            }
        }
        nsf.setSoapArrayEncodingUsed(false);
        nsf.setFormQualified(this.isFormQualified());
        nsf.setGlobal(this.isGlobal());
        return nsf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NSField createSoapArrayRecord(Builder builder, Context context) {
        NSField nsf = null;
        NSRecord nsr = null;
        ContentType type = null;
        ComplexType complexType = (ComplexType)this.getType();
        WmAttribute attr = null;
        int dim = 1;
        int count = 1;
        int bracketCount = 0;
        Enumeration attributes = complexType.attributes();
        String defaultValue = null;
        while (attributes.hasMoreElements()) {
            attr = (WmAttribute)attributes.nextElement();
            if (attr == null || !attr.isProxy() || (defaultValue = attr.getDefaultValue()) == null) continue;
            char[] ca = defaultValue.toCharArray();
            for (int i = 0; i < ca.length; ++i) {
                if (ca[i] == ',') {
                    ++count;
                    continue;
                }
                if (ca[i] != ']') continue;
                ++bracketCount;
            }
        }
        if (count > 2 || bracketCount > 2) {
            context.addError(ConverterMessageBundle.DIMENSION_OVER_FLOW, new LocalizedMessage(ConverterMessageBundle.class, ConverterMessageBundle.DIMENSION_OVER_FLOW, "", defaultValue));
        } else if (count == 2 || bracketCount == 2) {
            dim = 2;
        }
        WmElement element = null;
        Enumeration elements = complexType.elements();
        if (defaultValue == null && !elements.hasMoreElements()) {
            ObjectBuilder obuilder = new ObjectBuilder();
            nsf = obuilder.build(this, context);
            nsf.setDimensions(dim);
        }
        while (elements.hasMoreElements()) {
            boolean populateTypeRec;
            NSRecord typeRec;
            block28: {
                Flat[] flatModel;
                ComplexType cType;
                block29: {
                    block27: {
                        element = (WmElement)elements.nextElement();
                        type = Util.mapSoapEncDataTypeToXsdDataType(context, element.getType());
                        if (type.getType() != 2) break block27;
                        cType = (ComplexType)type;
                        typeRec = null;
                        populateTypeRec = false;
                        if (context.createDocsForTypes() && type instanceof WmComplexTypeRef) {
                            WmComplexTypeRef ctref = (WmComplexTypeRef)type;
                            QName target = ctref.getQName();
                            String typeRecordName = TYPEREF_PREFIX + element.computeNamespaceName(target, context);
                            if (context.containsTypeRecord(typeRecordName)) {
                                typeRec = context.getTypeRecord(typeRecordName);
                            } else {
                                typeRec = (NSRecord)element.createTypeRecord(context);
                                populateTypeRec = true;
                                context.updateExtended(ctref);
                            }
                        }
                        String tagTypeName = null;
                        if (cType.getQName() != null) {
                            tagTypeName = cType.getQName().getNCName();
                        }
                        if (tagTypeName != null && tagTypeName.equals("anyType")) {
                            ObjectBuilder obuilder = new ObjectBuilder();
                            nsf = obuilder.build(this, context);
                            nsf.setDimensions(dim);
                            break;
                        }
                        nsf = builder.build(this, context);
                        nsf.setDimensions(dim);
                        nsr = (NSRecord)nsf;
                        if (typeRec != null && !populateTypeRec) break block28;
                        attributes = cType.attributes();
                        while (attributes.hasMoreElements()) {
                            WmAttribute oneAttr = (WmAttribute)attributes.nextElement();
                            nsr.addField(oneAttr.createRecord(builder, context));
                        }
                        Model model = cType.getContentModel();
                        if (model == null || (flatModel = model.getFlattenedModel()) == null) break block28;
                        break block29;
                    }
                    if (type.getType() != 1) continue;
                    builder = new FieldBuilder();
                    nsf = builder.build(this, context);
                    QName qName = ((SimpleType)type).getQName();
                    if (qName == ANYTYPE_2001 || qName == ANYTYPE_2000) {
                        nsf.setType(3);
                        if (dim == 2) {
                            dim = 1;
                        }
                        nsf.setDimensions(dim);
                        continue;
                    }
                    nsf.setContentType(type);
                    nsf.setDimensions(dim);
                    continue;
                }
                for (int i = 0; i < flatModel.length; ++i) {
                    WmElement we;
                    if (flatModel[i].isAny() || (we = cType.getElement(flatModel[i].getSymbol())) == null) continue;
                    context.setCurrentFlatModel(flatModel[i]);
                    ContentType ct = Util.mapSoapEncDataTypeToXsdDataType(context, we.getType());
                    if (ct.getType() == 1) {
                        String prefix;
                        Name tns;
                        String fieldName = we.getName();
                        if (context.useNCNameDecoder()) {
                            fieldName = NCName.decode(fieldName);
                        }
                        if ((tns = we.getQName().getNamespaceName()) != null && (prefix = context.resolveURIReferenceToPrefix(tns.toString())) != null) {
                            fieldName = prefix + ":" + fieldName;
                            context.addUsedPrefixURIPair(prefix, tns.toString());
                        }
                        NSField fld = new NSField(nsr.getNamespace(), NSRecord.TYPE, fieldName, 1, 0);
                        SimpleType st = null;
                        try {
                            st = SimpleTypeUtil.cloneSmartly(context.getNamespace(), (SimpleType)ct);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        Util.setXmlNamespace(fld, we.getQName().getNamespaceName());
                        fld.setContentType(st);
                        if (!flatModel[i].isRequired()) {
                            fld.setOptional(true);
                        } else {
                            fld.setOptional(false);
                        }
                        fld.setNillable(we.isNullable());
                        fld.setFormQualified(we.isFormQualified());
                        fld.setGlobal(we.isGlobal());
                        nsr.addField(fld);
                        continue;
                    }
                    nsr.addField(we.createRecord(builder, context));
                }
            }
            if (typeRec == null) continue;
            if (populateTypeRec) {
                int fnum = nsr.getFieldCount();
                for (int i = 0; i < fnum; ++i) {
                    NSField f = nsr.getField(i);
                    typeRec.addField(f);
                }
            }
            String name = nsf.getName();
            NSRecordRef rec = new NSRecordRef(context.getNamespace(), name, typeRec, dim);
            Name xmlns = this.getQName().getNamespaceName();
            Util.setXmlNamespace(rec, xmlns);
            rec.setUniversalName(this.getQName());
            rec.setNillable(nsf.isNillable());
            rec.setOptional(nsf.isOptional());
            rec.setDimensions(nsf.getDimensions());
            rec.setFormQualified(nsf.isFormQualified());
            rec.setGlobal(nsf.isGlobal());
            rec.setClosed(nsr.isClosed());
            nsf = rec;
        }
        if (nsf.getDimensions() != 0) {
            nsf.setSoapArrayEncodingUsed(true);
        }
        nsf.setFormQualified(this.isFormQualified());
        nsf.setGlobal(this.isGlobal());
        return nsf;
    }

    public Integer createID() {
        WmComplexType complexType;
        Profiler p;
        ContentType type;
        Profiler profiler = Profiler.create();
        if (this._isSimpleType) {
            profiler.setHasSimpleType();
        }
        if ((type = this.getType()) != null && type.getType() == 2 && (p = (complexType = (WmComplexType)type).createProfile()) != null) {
            profiler.combine(p);
        }
        return profiler.createID();
    }

    protected void populate(NSRecord nsr, Builder builder, Context context) {
        ContentType type = this.getType();
        if (type != null && type.getType() == 2) {
            Flat[] flatModel;
            ComplexType complexType = (ComplexType)type;
            Enumeration attributes = complexType.attributes();
            while (attributes.hasMoreElements()) {
                WmAttribute oneAttr = (WmAttribute)attributes.nextElement();
                nsr.addField(oneAttr.createRecord(builder, context));
            }
            Model model = complexType.getContentModel();
            if (model != null && (flatModel = model.getFlattenedModel()) != null) {
                for (int i = 0; i < flatModel.length; ++i) {
                    WmElement element;
                    if (flatModel[i].isAny() || (element = complexType.getElement(flatModel[i].getSymbol())) == null) continue;
                    boolean isSubstitutableElement = false;
                    boolean isHeadAnElementReference = false;
                    WmElement headElement = element;
                    Set<WmElement> substitutableElements = null;
                    java.util.Iterator<WmElement> it = null;
                    if (context.subsGroupsEnabled() && (substitutableElements = context.getElementsSubstitutableFor(headElement.getQName())) != null && !substitutableElements.isEmpty()) {
                        isSubstitutableElement = true;
                        it = substitutableElements.iterator();
                        if (headElement._internalType == 2) {
                            isHeadAnElementReference = true;
                        }
                    }
                    do {
                        if (element.isAbstract()) continue;
                        context.setCurrentFlatModel(flatModel[i]);
                        if (isHeadAnElementReference && element._internalType != 2) {
                            WmElementRef elementRef = new WmElementRef(element.getQName());
                            elementRef.setOwner(element.getOwner());
                            elementRef.setSchemas(element.getSchemas());
                            element = elementRef;
                        }
                        NSField record = element.createRecord(builder, context);
                        if (context.subsGroupsEnabled() && isSubstitutableElement) {
                            record.setOptional(true);
                            record.setSubstitutionGroupName(context.computeSubstitutionGroupName(element));
                        }
                        nsr.addField(record);
                    } while (it != null && it.hasNext() && (element = (WmElement)it.next()) != null);
                }
            }
        }
    }

    public void collectRepeatingQNames(Context context, HashSet repeatableQNames, HashSet repeatingQNames, Schema[] schemas, HashSet repeatableCTypes) throws LocalizedException {
        if (this.isInTopSymbolSpace()) {
            QName name = this.getQName();
            if (repeatableQNames.contains(name)) {
                repeatingQNames.add(name);
                return;
            }
            repeatableQNames.add(this.getQName());
            if (context.subsGroupsEnabled() && this.getSubstitutableFor() != null && this.getSubstitutableFor().size() > 0) {
                Iterator it = this.getSubstitutableFor().iterator();
                while (it.hasNext()) {
                    if (!repeatableQNames.contains(it.next())) continue;
                    repeatingQNames.add(name);
                }
            }
        }
        ContentType type = this.getType();
        ComplexType complexType = null;
        if (type != null && type.getType() == 2) {
            complexType = (ComplexType)type;
            if (complexType instanceof WmComplexTypeRef) {
                complexType = ((WmComplexTypeRef)complexType).getComplexType(schemas);
            }
            QName name = null;
            if (complexType != null) {
                name = complexType.getQName();
            }
            if (name != null && repeatableCTypes.contains(name)) {
                if (context.createDocsForTypes()) {
                    return;
                }
                context.addError("CONV-005", new LocalizedMessage(ConverterMessageBundle.class, ConverterMessageBundle.CONTENT_TYPE_RECURSION, "", name.toDisplayString()));
                return;
            }
            if (name != null) {
                repeatableCTypes.add(name);
            }
            Enumeration elements = null;
            if (complexType != null) {
                elements = complexType.elements();
            }
            if (elements != null) {
                while (elements.hasMoreElements()) {
                    WmElement el = (WmElement)elements.nextElement();
                    el.collectRepeatingQNames(context, repeatableQNames, repeatingQNames, schemas, repeatableCTypes);
                    if (context.isSuccessful()) continue;
                    return;
                }
                if (!context.createDocsForTypes()) {
                    repeatableCTypes.remove(name);
                }
            } else {
                repeatableCTypes.remove(name);
            }
        }
    }

    private static final Values[] toArray(HashSet set) {
        if (set == null) {
            return null;
        }
        Values[] valArray = new Values[set.size()];
        Iterator it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            valArray[i] = ((ValuesCodable)it.next()).getValues();
            ++i;
        }
        return valArray;
    }

    private static final IData[] toIDataArray(HashSet set) {
        if (set == null) {
            return null;
        }
        IData[] valArray = new IData[set.size()];
        Iterator it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            valArray[i] = ((IDataPortable)it.next()).getAsData();
            ++i;
        }
        return valArray;
    }

    public final boolean useSoapArray() {
        ContentType type = this.getType();
        if (type != null && type.getType() == 2) {
            ComplexType ct = (ComplexType)type;
            HashSet typeHeirarchy = ct.getTypeHeirarchy();
            if (typeHeirarchy == null) {
                return ct.getAttribute(SOAP_ARRAY_TYPE) != null;
            }
            Object[] heirarchy = typeHeirarchy.toArray();
            for (int i = heirarchy.length - 1; i > -1; --i) {
                QName baseType = (QName)heirarchy[i];
                if (baseType != SOAP_ARRAY) continue;
                return true;
            }
        }
        return false;
    }

    public NSField createTypeRecord(Context context) {
        QName target = ((WmComplexTypeRef)this.getType()).getQName();
        String typeRecordName = TYPEREF_PREFIX + this.computeNamespaceName(target, context);
        NSRecord rec = new NSRecord(context.getNamespace());
        rec.setNSName(NSName.create(context.getInterfaceName(), typeRecordName));
        rec.setPackage(context.getNSPackage());
        rec.setUniversalName(QName.create(target.getNamespaceName(), Name.create(target.getNCName() + "Ref")));
        rec.setSchemaTypeName(target);
        context.addNamespaceRecord(rec);
        context.putTypeRecord(typeRecordName, rec);
        return rec;
    }

    protected String computeName(QName name, Context context) {
        String prefix;
        StringBuffer sb = new StringBuffer();
        String xmlns = name.getNamespace();
        if (xmlns != null && (prefix = context.resolveURIReferenceToPrefix(xmlns)) != null) {
            sb.append(prefix);
            context.addUsedPrefixURIPair(prefix, xmlns);
            sb.append(':');
        }
        sb.append(context.useNCNameDecoder() ? NCName.decode(name.getNCName()) : name.getNCName());
        return sb.toString();
    }

    protected String computeNamespaceName(QName qname, Context context) {
        String name = this.computeName(qname, context);
        name = name.replace(':', '_');
        return name;
    }

    static {
        _internalTypeEnum.addInt("instance", 1);
        _internalTypeEnum.addInt("reference", 2);
        _internalTypeEnum.addInt("unknown", 10);
        ANYTYPE_2001 = QName.create("http://www.w3.org/2001/XMLSchema", "anyType");
        ANYTYPE_2000 = QName.create("http://www.w3.org/2000/10/XMLSchema", "anyType");
        SOAP_ARRAY = QName.create("http://schemas.xmlsoap.org/soap/encoding/", "Array");
        SOAP_ARRAY_TYPE = QName.create("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
    }
}

