/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.DatatypeFactory;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.NodeWorkspace;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SchemaRegistry;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.Util;
import com.wm.lang.schema.WmAttribute;
import com.wm.lang.schema.WmComplexType;
import com.wm.lang.schema.WmElement;
import com.wm.lang.schema.WmTag;
import com.wm.lang.schema.conv.Profiler;
import com.wm.lang.schema.resources.ValidationMessageBundle;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Showable;
import com.wm.util.Values;
import java.util.Enumeration;

public class WmComplexTypeRef
extends WmComplexType
implements Showable {
    static final boolean debug = false;
    QName _targetName;
    WmComplexType _target;
    public static final String KEY_TYPE_TARGETNAME = "targetName";

    public WmComplexTypeRef(String ncName, QName targetName) {
        super(ncName, 2);
        this._targetName = targetName;
        this._target = null;
    }

    public WmComplexTypeRef(Schema owner, IData values) {
        super(owner, values);
    }

    WmComplexType getComplexType() {
        return this.getComplexType(null);
    }

    WmComplexType getComplexType(Schema[] schemas) {
        block5: {
            block6: {
                if (this._target != null && this._target.isDestroyed()) {
                    this._target = null;
                }
                if (this._target != null) break block5;
                if (this._targetName.getNamespace() != null) break block6;
                ComplexType target = this._owner.getComplexType(this._targetName.getNCName());
                if (target == null && schemas != null) {
                    for (int i = 0; i < schemas.length && (schemas[i].getTargetNamespace() != null || (target = schemas[i].getComplexType(this._targetName.getNCName())) == null); ++i) {
                    }
                }
                if (target == null || !(target instanceof WmComplexType)) break block5;
                this._target = (WmComplexType)target;
                break block5;
            }
            NSName[] qnames = SchemaRegistry.resolve(this._targetName.getNamespace());
            if (qnames != null) {
                for (int index = 0; index < qnames.length; ++index) {
                    Schema schema;
                    ComplexType target;
                    NSNode node = this._owner.getNamespace().getNode(qnames[index]);
                    if (node == null || !node.getNodeTypeObj().equals(NSSchema.TYPE) || (target = (schema = (Schema)((Object)node)).getComplexType(this._targetName.getNCName())) == null || !(target instanceof WmComplexType)) continue;
                    this._target = (WmComplexType)target;
                    break;
                }
            }
        }
        return this._target;
    }

    public WmAttribute getAttribute(QName name) {
        WmComplexType type = this.getComplexType(this.getSchemas());
        return type != null ? type.getAttribute(name) : null;
    }

    public WmElement getElement(QName name) {
        WmComplexType type = this.getComplexType(this.getSchemas());
        return type != null ? type.getElement(name) : null;
    }

    public Model getContentModel() {
        WmComplexType type = this.getComplexType(this.getSchemas());
        return type != null ? type.getContentModel() : null;
    }

    public int getContentModelType() {
        WmComplexType type = this.getComplexType(this.getSchemas());
        return type != null ? type.getContentModelType() : 20;
    }

    public SimpleType getSimpleType() {
        WmComplexType type = this.getComplexType(this.getSchemas());
        return type != null ? type.getSimpleType() : null;
    }

    public HashSet getTypeHeirarchy() {
        WmComplexType type = this.getComplexType(this.getSchemas());
        return type != null ? type.getTypeHeirarchy() : null;
    }

    public Enumeration elements() {
        WmComplexType type = this.getComplexType(this.getSchemas());
        return type != null ? type.elements() : null;
    }

    public Enumeration attributes() {
        WmComplexType type = this.getComplexType(this.getSchemas());
        return type != null ? type.attributes() : null;
    }

    public boolean isAbstract() {
        WmComplexType type = this.getComplexType(this.getSchemas());
        return type != null ? type.isAbstract() : false;
    }

    QName getTargetName() {
        return this._targetName;
    }

    public void addAttribute(WmAttribute attr) {
    }

    public WmAttribute removeAttribute(QName name) {
        return null;
    }

    public void addElement(WmElement element) {
    }

    public WmElement removeElement(QName name) {
        return null;
    }

    public void removeAllElements() {
    }

    public void addTag(WmTag tag) {
    }

    public void setModel(Model model) {
    }

    public void setSimpleType(SimpleType simpleType) {
    }

    public void setAbstract(boolean isAbstract) {
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_TYPE_TARGETNAME, this._targetName != null ? this._targetName.getValues() : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values values) {
        super.setValues(values);
        this._targetName = QName.create(values.getValues(KEY_TYPE_TARGETNAME));
    }

    public IData getAsData() {
        IData values = super.getAsData();
        IDataCursor ic = values.getCursor();
        if (this._targetName != null) {
            ic.insertAfter(KEY_TYPE_TARGETNAME, this._targetName.getAsData());
        }
        ic.destroy();
        return values;
    }

    public void setFromData(IData values) {
        super.setFromData(values);
        IDataCursor ic = values.getCursor();
        this._targetName = QName.create((IData)IDataUtil.get(ic, KEY_TYPE_TARGETNAME));
        ic.destroy();
    }

    public boolean targetExists() {
        return this.getComplexType(this.getSchemas()) != null;
    }

    public void validate(ElementNodeBase node, NodeWorkspace workspace, String baseLocationPath) {
        String typeRef = Util.retrieveXSIType(node);
        if (typeRef == null) {
            this._validate(node, workspace, baseLocationPath);
            return;
        }
        QName typeName = null;
        try {
            typeName = QName.computeQName(typeRef, node);
        }
        catch (Exception ex) {
            workspace.addError(baseLocationPath, "", "NV-013", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_UNABLE_TO_RESOLVE, null, typeRef));
            return;
        }
        QName thisName = this.getTargetName();
        if (thisName.equals(typeName)) {
            this._validate(node, workspace, baseLocationPath);
            return;
        }
        TypeDef typeDef = WmComplexType.create(typeName);
        typeDef.setOwner(this.getOwner());
        if (!((WmComplexTypeRef)typeDef).targetExists()) {
            boolean error = false;
            if (Util.isAnyTypeName(thisName)) {
                Name nsuri = node.getNamespaceUri();
                if (nsuri == null) {
                    nsuri = typeName.getNamespaceName();
                }
                typeDef = DatatypeFactory.createReference(nsuri, typeName);
                typeDef.setOwner(this._owner);
                if (!typeDef.targetExists()) {
                    error = true;
                }
            } else {
                error = true;
            }
            if (error) {
                String ns = typeName.getNamespace();
                if (ns == null) {
                    ns = "";
                }
                String sName = typeName.getNCName() + " {" + ns + "}";
                workspace.addError(baseLocationPath, "", "NV-011", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_LOST_TYPE_DEF2, null, sName));
                return;
            }
        }
        if (typeDef.isValidlyDerivedFrom(thisName)) {
            if (typeDef.getType() == 1) {
                if (!workspace.ignoreContent) {
                    workspace.baseLocationPath = baseLocationPath;
                    workspace.relativeLocationPath = new String();
                    ((SimpleType)typeDef).validate(Util.compose(workspace.tNodes), workspace);
                }
            } else {
                ((ComplexType)typeDef).validate(node, workspace, baseLocationPath);
            }
        } else {
            String sub1 = typeName.getNCName() + " {" + typeName.getNamespace() + "}";
            String sub2 = thisName.getNCName() + " {" + thisName.getNamespace() + "}";
            Object[] subs = new Object[]{sub1, sub2};
            workspace.addError(baseLocationPath, "", "NV-014", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_TYPE_DERIVATION_NOK, null, subs));
        }
    }

    void _validate(ElementNodeBase node, NodeWorkspace workspace, String baseLocationPath) {
        WmComplexType type = this.getComplexType(this.getSchemas());
        if (type != null) {
            type.validate(node, workspace, baseLocationPath);
        } else {
            workspace.addError(baseLocationPath, "", "NV-011", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_LOST_TYPE_DEF, null));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString() + ';');
        sb.append(" targetName = [" + this._targetName + ']');
        return sb.toString();
    }

    public Values getView() {
        Object[][] o = new Object[][]{{KEY_TYPE_TARGETNAME, this._targetName != null ? this._targetName.getView() : null}};
        return super.getView().copyFrom(new Values(o));
    }

    public Profiler createProfile() {
        WmComplexType type = this.getComplexType(this.getSchemas());
        return type != null ? type.createProfile() : null;
    }

    public boolean isValidlyDerivedFrom(QName name) {
        WmComplexType type = this.getComplexType(this.getSchemas());
        return type != null ? type.isValidlyDerivedFrom(name) : false;
    }

    public boolean isProxy() {
        return true;
    }

    public void rearrangeAttributes() {
    }

    public QName getQName() {
        return this.getTargetName();
    }
}

